/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.panels.HQSPacksPanelAutomationHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.n3.nanoxml.XMLElement;

public class HQSPacksPanel
extends IzPanel
implements ActionListener,
ListSelectionListener {
    private JLabel spaceLabel;
    private JTextArea descriptionArea;
    private JScrollPane tableScroller;
    protected int bytes = 0;
    private JTable packsTable;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public HQSPacksPanel(InstallerFrame parent, InstallData idata) {
        super(parent, idata);
        if (idata.getVariable("HOSTNAME") == null) {
            try {
                idata.setVariable("HOSTNAME", InetAddress.getLocalHost().getHostName());
            }
            catch (Throwable t) {
                idata.setVariable("HOSTNAME", "localhost");
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        JLabel infoLabel = new JLabel(parent.langpack.getString("PacksPanel.info"), parent.icons.getImageIcon("preferences"), 11);
        this.add(infoLabel);
        this.add(Box.createRigidArea(new Dimension(0, 3)));
        JLabel tipLabel = new JLabel(parent.langpack.getString("PacksPanel.tip"), parent.icons.getImageIcon("tip"), 11);
        this.add(tipLabel);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.packsTable = new JTable();
        this.packsTable.setIntercellSpacing(new Dimension(0, 0));
        this.packsTable.setBackground(Color.white);
        this.packsTable.setSelectionMode(0);
        this.packsTable.getSelectionModel().addListSelectionListener(this);
        this.packsTable.setShowGrid(false);
        this.tableScroller = new JScrollPane(this.packsTable);
        this.tableScroller.setAlignmentX(0.0f);
        this.tableScroller.getViewport().setBackground(Color.white);
        this.tableScroller.setPreferredSize(new Dimension(300, idata.guiPrefs.height / 3 + 30));
        this.add(this.tableScroller);
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setMargin(new Insets(2, 2, 2, 2));
        this.descriptionArea.setAlignmentX(0.0f);
        this.descriptionArea.setCaretPosition(0);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setOpaque(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionArea.setBorder(BorderFactory.createTitledBorder(parent.langpack.getString("PacksPanel.description")));
        this.add(this.descriptionArea);
        JPanel spacePanel = new JPanel();
        spacePanel.setAlignmentX(0.0f);
        spacePanel.setLayout(new BoxLayout(spacePanel, 0));
        spacePanel.add(new JLabel(parent.langpack.getString("PacksPanel.space")));
        spacePanel.add(Box.createHorizontalGlue());
        this.spaceLabel = new JLabel("");
        spacePanel.add(this.spaceLabel);
        this.add(spacePanel);
    }

    public void panelActivate() {
        try {
            this.packsTable.setModel(new PacksModel(this.idata.availablePacks, this.idata.selectedPacks));
            CheckBoxEditorRenderer packSelectedRenderer = new CheckBoxEditorRenderer(false);
            this.packsTable.getColumnModel().getColumn(0).setCellRenderer(packSelectedRenderer);
            CheckBoxEditorRenderer packSelectedEditor = new CheckBoxEditorRenderer(true);
            this.packsTable.getColumnModel().getColumn(0).setCellEditor(packSelectedEditor);
            this.packsTable.getColumnModel().getColumn(0).setMaxWidth(40);
            DefaultTableCellRenderer renderer1 = new DefaultTableCellRenderer(){

                public void setBorder(Border b) {
                }
            };
            this.packsTable.getColumnModel().getColumn(1).setCellRenderer(renderer1);
            DefaultTableCellRenderer renderer2 = new DefaultTableCellRenderer(){

                public void setBorder(Border b) {
                }
            };
            renderer2.setHorizontalAlignment(4);
            this.packsTable.getColumnModel().getColumn(2).setCellRenderer(renderer2);
            this.packsTable.getColumnModel().getColumn(2).setMaxWidth(100);
            this.tableScroller.remove(this.packsTable.getTableHeader());
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            Iterator iter = this.idata.availablePacks.iterator();
            this.bytes = 0;
            while (iter.hasNext()) {
                Pack p = (Pack)iter.next();
                if (p.required) {
                    this.bytes = (int)((long)this.bytes + p.nbytes);
                    continue;
                }
                if (!this.idata.selectedPacks.contains(p)) continue;
                this.bytes = (int)((long)this.bytes + p.nbytes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showSpaceRequired();
    }

    protected void showSpaceRequired() {
        this.spaceLabel.setText(Pack.toByteUnitsString(this.bytes));
    }

    public void actionPerformed(ActionEvent e) {
    }

    public boolean isValidated() {
        return true;
    }

    public void makeXMLData(XMLElement panelRoot) {
        new HQSPacksPanelAutomationHelper().makeXMLData(this.idata, panelRoot);
    }

    public void valueChanged(ListSelectionEvent e) {
        int i = this.packsTable.getSelectedRow();
        if (i >= 0) {
            String description;
            Pack pack;
            block4: {
                pack = (Pack)this.idata.availablePacks.get(i);
                description = null;
                try {
                    description = ResourceManager.getInstance().getTextResource(pack.description);
                }
                catch (Exception err) {
                    description = this.idata.getVariable(pack.description);
                    if (description != null || (description = this.idata.getVariable(pack.description + "_" + this.idata.localeISO3)) != null) break block4;
                    description = this.idata.getVariable(pack.description);
                }
            }
            if (description == null) {
                description = pack.description;
            }
            this.descriptionArea.setText(description);
        }
    }

    static class CheckBoxEditorRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor,
    ActionListener {
        private JCheckBox display = new JCheckBox();

        public CheckBoxEditorRenderer(boolean useAsEditor) {
            this.display.setHorizontalAlignment(0);
            if (useAsEditor) {
                this.display.addActionListener(this);
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.display.setForeground(table.getSelectionForeground());
                this.display.setBackground(table.getSelectionBackground());
            } else {
                this.display.setForeground(table.getForeground());
                this.display.setBackground(table.getBackground());
            }
            int state = (Integer)value;
            this.display.setSelected(value != null && Math.abs(state) == 1);
            this.display.setEnabled(state >= 0);
            return this.display;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        public Object getCellEditorValue() {
            return new Integer(this.display.isSelected() ? 1 : 0);
        }

        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }
    }

    private class PacksModel
    extends AbstractTableModel {
        private List packs;
        private List packsToInstall;

        public PacksModel(List packs, List packsToInstall) {
            this.packs = packs;
            this.packsToInstall = packsToInstall;
        }

        public int getRowCount() {
            return this.packs.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = HQSPacksPanel.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = HQSPacksPanel.class$("java.lang.String")) : class$java$lang$String;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            Pack pack = (Pack)this.packs.get(rowIndex);
            if (pack.required) {
                return false;
            }
            return columnIndex == 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Pack pack = (Pack)this.packs.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    int val = 0;
                    val = pack.required ? -1 : (this.packsToInstall.contains(pack) ? 1 : 0);
                    return new Integer(val);
                }
                case 1: {
                    return pack.name;
                }
                case 2: {
                    return Pack.toByteUnitsString((int)pack.nbytes);
                }
            }
            return null;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0 && aValue instanceof Integer) {
                Pack pack = (Pack)this.packs.get(rowIndex);
                if ((Integer)aValue == 1) {
                    this.packsToInstall.add(pack);
                    HQSPacksPanel.this.bytes = (int)((long)HQSPacksPanel.this.bytes + pack.nbytes);
                } else {
                    this.packsToInstall.remove(pack);
                    HQSPacksPanel.this.bytes = (int)((long)HQSPacksPanel.this.bytes - pack.nbytes);
                }
                HQSPacksPanel.this.showSpaceRequired();
            }
        }
    }
}

