/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAutomation;
import java.util.Iterator;
import java.util.Vector;
import net.n3.nanoxml.XMLElement;

public class HQSPacksPanelAutomationHelper
implements PanelAutomation {
    public void makeXMLData(AutomatedInstallData idata, XMLElement panelRoot) {
        for (int i = 0; i < idata.availablePacks.size(); ++i) {
            Pack pack = (Pack)idata.availablePacks.get(i);
            XMLElement el = new XMLElement("pack");
            el.setAttribute("index", new Integer(i).toString());
            el.setAttribute("name", pack.name);
            Boolean selected = new Boolean(idata.selectedPacks.contains(pack));
            el.setAttribute("selected", selected.toString());
            panelRoot.addChild(el);
        }
    }

    public void runAutomated(AutomatedInstallData idata, XMLElement panelRoot) {
        Vector pm = panelRoot.getChildrenNamed("pack");
        int size = pm.size();
        idata.selectedPacks.clear();
        for (int i = 0; i < size; ++i) {
            XMLElement el = (XMLElement)pm.get(i);
            Boolean selected = new Boolean(el.getAttribute("selected"));
            if (!selected.booleanValue()) continue;
            String index_str = el.getAttribute("index");
            if (index_str != null) {
                try {
                    int index = Integer.parseInt(index_str);
                    if (index >= 0 && index < idata.availablePacks.size()) {
                        idata.selectedPacks.add(idata.availablePacks.get(index));
                        continue;
                    }
                    System.err.println("Invalid pack index \"" + index_str + "\" in line " + el.getLineNr());
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid pack index \"" + index_str + "\" in line " + el.getLineNr());
                }
                continue;
            }
            String name = el.getAttribute("name");
            if (name == null) continue;
            Iterator pack_it = idata.availablePacks.iterator();
            boolean found = false;
            while (!found && pack_it.hasNext()) {
                Pack pack = (Pack)pack_it.next();
                if (!pack.name.equals(name)) continue;
                idata.selectedPacks.add(pack);
                found = true;
            }
            if (found) continue;
            System.err.println("Could not find selected pack named \"" + name + "\" in line " + el.getLineNr());
        }
    }
}

