/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkServiceProvider;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.odsx.OdsxApplElemChildrenSelectorInterface;
import com.highqsoft.interfaces.odsx.OdsxApplElemCustomizerInterface;
import com.highqsoft.interfaces.odsx.OdsxApplElemMenuInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.odsx.OdsxApplElemDefaultChildrenSelector;
import com.highqsoft.odsx.OdsxColumn;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxInstanceElement;
import com.highqsoft.odsx.OdsxPresentableElement;
import com.highqsoft.odsx.OdsxRecursiveApplicationElement;
import com.highqsoft.odsx.OdsxSelectHelper;
import com.highqsoft.odsx.command.AddNewInstanceElementCommand;
import com.highqsoft.odsx.command.OdsxEnablePresentableCommand;
import com.highqsoft.odsx.command.OdsxTranslatePresentableCommand;
import com.highqsoft.odsx.command.OdsxVisiblePresentableCommand;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import com.highqsoft.util.StringFormat;
import java.awt.Container;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.infobus.InvalidDataException;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.BaseAttribute;
import org.asam.ods.DataType;
import org.asam.ods.EnumerationDefinition;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.Relationship;
import org.asam.ods.T_LONGLONG;
import org.omg.CORBA.Object;

public class OdsxApplicationElement
extends OdsxPresentableElement
implements OdsxApplicationElementInterface {
    public static final String version = "$Revision: 1.19 $";
    protected OdsxApplElemChildrenSelectorInterface childrenSelector = null;
    protected String ident = null;
    protected String shortName = null;
    protected T_LONGLONG aeId;
    protected boolean hasSelfRef = false;
    protected boolean hasSelfRefInitialized = false;
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    boolean isTopLevelElement;
    String baseName;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    protected OdsxApplicationElement() {
        this.setDescriptor(descriptor);
        this.isTopLevelElement = false;
        this.aeId = null;
    }

    public OdsxApplicationElement(ApplicationElement ae) {
        this();
        try {
            this.aeId = ae.getId();
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.setValueAsObject(ae);
        this.baseName = null;
        try {
            this.baseName = "???";
            String name = "???";
            try {
                this.baseName = ae.getBaseElement().getType();
                name = this.getIdentificationString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setName(name);
            this.setIcon(FwkIconFile.getIcon((String)this.baseName));
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxApplicationElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "ODS Error", (java.lang.Object)this, t);
        }
    }

    public boolean isValid() {
        boolean ret = false;
        try {
            ApplicationElement aeObj = (ApplicationElement)this.getValueAsObject();
            if (aeObj != null) {
                aeObj.getName();
                ret = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public boolean isTheSame(ApplicationElement aeElem) {
        ApplicationElement aeObj;
        boolean ret = false;
        if (this.aeId != null) {
            try {
                ret = this.aeId.low == aeElem.getId().low;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (!ret && !(ret = (aeObj = this.getApplicationElement()).equals(aeElem)) && aeElem instanceof Object && aeObj instanceof Object) {
            try {
                String thisName = aeObj.getName();
                String elemName = aeElem.getName();
                ret = thisName.compareTo(elemName) == 0;
            }
            catch (Throwable tNoName) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean isTheSame(OdsxPresentableElementInterface elem) {
        boolean ret = elem instanceof OdsxApplicationElementInterface;
        if (ret) {
            boolean bl = ret = this.baseName.compareTo(((OdsxApplicationElementInterface)elem).getBaseName()) == 0;
            if (ret) {
                ret = this.isTheSame(((OdsxApplicationElementInterface)elem).getApplicationElement());
            }
        }
        return ret;
    }

    public T_LONGLONG getApplicationElementId() {
        if (this.aeId == null) {
            try {
                this.aeId = this.getApplicationElement().getId();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.aeId;
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            java.lang.Object[] menu = FwkServiceProvider.getInstance().lookup(OdsxApplElemMenuInterface.class);
            if (menu != null) {
                int size = menu.length;
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        OdsxApplElemMenuInterface m = (OdsxApplElemMenuInterface)menu[i];
                        m.setApplicationElement(this);
                        FwkCommandInterface[] cmds = m.getCommands();
                        int c = cmds.length;
                        for (int j = 0; j < c; ++j) {
                            this.addCommand(cmds[j]);
                        }
                    }
                }
            } else {
                super.getCommands();
                FwkCommandInterface parent = this.getCommand("View");
                if (parent == null) {
                    parent = new FwkCommand();
                    parent.setTextKey("Text.View");
                    parent.setCommandName("View");
                    parent.setIconKey("Icon.View");
                    this.addCommand(0, parent);
                }
                java.lang.Object cmd = new OdsxVisiblePresentableCommand((FwkControllerInterface)this);
                parent.addCommand(0, (FwkCommandInterface)cmd);
                cmd = new OdsxEnablePresentableCommand((FwkControllerInterface)this);
                parent.addCommand(0, (FwkCommandInterface)cmd);
                cmd = new OdsxTranslatePresentableCommand((FwkControllerInterface)this);
                parent.addCommand(0, (FwkCommandInterface)cmd);
                java.lang.Object[] customizer = FwkServiceProvider.getInstance().lookup(OdsxApplElemCustomizerInterface.class);
                if (customizer != null && customizer.length > 0) {
                    int size = customizer.length;
                    for (int i = 0; i < size; ++i) {
                        OdsxApplElemCustomizerInterface c = (OdsxApplElemCustomizerInterface)customizer[i];
                        c.setApplicationElement(this);
                        if (!c.isUseable()) continue;
                        this.addCommand(c);
                    }
                }
                if (this.getBaseName().compareToIgnoreCase("aoenvironment") != 0) {
                    this.addCommand((FwkCommandInterface)new AddNewInstanceElementCommand((FwkControllerInterface)this));
                }
                if (this.childrenSelector != null && this.childrenSelector.isExecutable()) {
                    this.addCommand(this.childrenSelector);
                }
            }
        }
        return super.getCommands();
    }

    public boolean hasSelfReference() throws AoException {
        if (!this.hasSelfRefInitialized) {
            this.hasSelfRef = OdsxHelper.hasSelfReference(this.getApplicationElement());
        }
        return this.hasSelfRef;
    }

    public ApplicationElement getApplicationElement() {
        ApplicationElement ret = (ApplicationElement)this.getValueAsObject();
        return ret;
    }

    public String getBaseName() {
        if (this.baseName == null) {
            try {
                ApplicationElement ae = this.getApplicationElement();
                this.baseName = ae.getBaseElement().getType();
            }
            catch (Throwable t) {
                return "AoAny";
            }
        }
        return this.baseName;
    }

    public void setItemByCoordinates(int[] coord, java.lang.Object item) throws FwkException {
        if (!(item instanceof ApplicationElement)) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxApplicationElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "Class cast exception", (java.lang.Object)this, (Throwable)new InvalidDataException("Item is not of the type ApplicationElement."));
        }
        super.setItemByCoordinates(coord, item);
    }

    public void setValueAsObject(java.lang.Object item) throws FwkException {
        if (!(item instanceof ApplicationElement)) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxApplicationElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "Class cast exception", (java.lang.Object)this, (Throwable)new InvalidDataException("Item is not of the type ApplicationElement."));
        }
        super.setValueAsObject(item);
        java.lang.Object[] selector = FwkServiceProvider.getInstance().lookup(OdsxApplElemChildrenSelectorInterface.class);
        if (selector == null || selector.length == 0) {
            selector = new java.lang.Object[]{new OdsxApplElemDefaultChildrenSelector()};
        }
        if (selector.length > 0) {
            this.childrenSelector = (OdsxApplElemChildrenSelectorInterface)selector[0];
            this.childrenSelector.setApplicationElement(this);
            if (!this.childrenSelector.isUseable()) {
                this.childrenSelector = null;
            }
        }
    }

    public void getPresentationString(Writer w, String spec, Locale locale, OdsxFilterInterface filter) throws IOException {
        block29: {
            try {
                boolean all;
                boolean bl = all = spec == null || spec.compareTo("Header only") != 0;
                if (locale == null) {
                    locale = FwkContainer.getLocale();
                }
                boolean deLang = locale.getLanguage().compareTo("de") == 0;
                ApplicationElement ae = this.getApplicationElement();
                try {
                    if (ae == null) break block29;
                    if (all) {
                        if (filter != null) {
                            String aeName = ae.getName();
                            String beType = this.getBaseName();
                            if (deLang) {
                                w.write("Applikationselement:\t" + aeName + " (" + OdsxHelper.t_longlongToString(ae.getId()) + ")\n");
                                w.write("benutzerdefiniert:  \t" + filter.getTranslatedKey(aeName, aeName) + "\n");
                                w.write("Basiselement:       \t" + filter.getTranslatedKey(beType, beType) + "\n");
                                w.write("Asam-Pfad:          \t" + this.getIdentificationString());
                                w.write("\n==================================================================================\n");
                            } else {
                                w.write("Application Element:\t" + aeName + " (" + OdsxHelper.t_longlongToString(ae.getId()) + ")\n");
                                w.write("User defined:       \t" + filter.getTranslatedKey(aeName, aeName) + "\n");
                                w.write("Base Element:       \t" + filter.getTranslatedKey(beType, beType) + "\n");
                                w.write("AsamPath:           \t" + this.getIdentificationString());
                                w.write("\n==================================================================================\n");
                            }
                        } else if (deLang) {
                            w.write("Applikationselement:\t" + ae.getName() + " (" + OdsxHelper.t_longlongToString(ae.getId()) + ")\n");
                            w.write("Basiselement:       \t" + this.getBaseName() + "\n");
                            w.write("Asam-Pfad:          \t" + this.getIdentificationString());
                            w.write("\n==================================================================================\n");
                        } else {
                            w.write("Application Element:\t" + ae.getName() + " (" + OdsxHelper.t_longlongToString(ae.getId()) + ")\n");
                            w.write("Base Element:       \t" + this.getBaseName() + "\n");
                            w.write("AsamPath:           \t" + this.getIdentificationString());
                            w.write("\n==================================================================================\n");
                        }
                    }
                    ApplicationAttribute[] attrList = ae.getAttributes("*");
                    int size = attrList.length;
                    for (int i = 0; i < size; ++i) {
                        int length;
                        ApplicationAttribute aa = attrList[i];
                        String aaName = aa.getName();
                        try {
                            length = aa.getLength();
                        }
                        catch (Throwable tLength) {
                            length = -1;
                        }
                        boolean visible = true;
                        if (filter != null) {
                            if (visible = filter.isVisible(aaName, visible)) {
                                w.write("\n" + StringFormat.printf((String)"%-30.30s", (String)filter.getTranslatedKey(aaName, aaName)));
                            }
                        } else {
                            w.write("\n" + StringFormat.printf((String)"%-30.30s", (String)aaName));
                        }
                        if (!visible) continue;
                        try {
                            BaseAttribute ba = aa.getBaseAttribute();
                            String baName = ba != null ? ba.getName() : "";
                            DataType dt = aa.getDataType();
                            char[] attrFlags = new char[3];
                            Arrays.fill(attrFlags, ' ');
                            if (aa.isAutogenerated()) {
                                attrFlags[0] = 97;
                            }
                            if (aa.isObligatory()) {
                                attrFlags[1] = 111;
                            }
                            if (aa.isUnique()) {
                                attrFlags[2] = 117;
                            }
                            if (filter != null) {
                                w.write("\t" + StringFormat.printf((String)"[%17.17s]", (String)filter.getTranslatedKey(baName, baName)) + StringFormat.printf((String)" (%6.6s) ", (String)("" + length)) + new String(attrFlags) + StringFormat.printf((String)" %12.12s", (String)OdsxHelper.datatypeToString(dt)));
                            } else {
                                w.write("\t" + StringFormat.printf((String)"[%17.17s]", (String)baName) + StringFormat.printf((String)" (%6.6s) ", (String)("" + length)) + new String(attrFlags) + StringFormat.printf((String)" %12.12s", (String)OdsxHelper.datatypeToString(dt)));
                            }
                            if (dt.value() != 30) continue;
                            try {
                                EnumerationDefinition enumDef = aa.getEnumerationDefinition();
                                w.write(" (" + enumDef.getName() + ")");
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException ioException) {
                    throw ioException;
                }
                catch (Throwable th) {
                    FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, null, (Throwable)th);
                }
            }
            catch (IOException ioException) {
                throw ioException;
            }
            catch (Throwable t) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, null, (Throwable)t);
            }
        }
    }

    public Vector getElements() {
        Vector ret;
        block22: {
            ret = null;
            if (this.childrenSelector != null && this.childrenSelector.isUseable()) {
                ret = this.childrenSelector.getElements();
            } else {
                ret = new Vector();
                try {
                    OdsxPresentableElement elem;
                    ApplicationElement ae = this.getApplicationElement();
                    if (ae == null) break block22;
                    ApplicationElement[] aeArray = ae.getRelatedElementsByRelationship(Relationship.CHILD);
                    if (aeArray != null) {
                        int j;
                        int size = aeArray.length;
                        if (this.odsFilter != null && this.odsFilter.getRecursiveApplStructEnabled()) {
                            for (j = 0; j < size; ++j) {
                                elem = new OdsxApplicationElement(aeArray[j]);
                                elem.setOdsxFilter(this.odsFilter);
                                ret.add(elem);
                            }
                        } else {
                            for (j = 0; j < size; ++j) {
                                elem = aeArray[j].equals(ae) ? new OdsxRecursiveApplicationElement(aeArray[j]) : new OdsxApplicationElement(aeArray[j]);
                                elem.setOdsxFilter(this.odsFilter);
                                ret.add(elem);
                            }
                        }
                    }
                    boolean loadInstances = true;
                    if (this.odsFilter != null && !this.odsFilter.getEnableInstanceElements()) {
                        loadInstances = false;
                    }
                    if (!loadInstances) break block22;
                    OdsxSelectHelper.NameId[] arr = null;
                    String type = this.getBaseName();
                    AoSession aoSession = this.getSession();
                    T_LONGLONG aeId = this.getApplicationElementId();
                    try {
                        arr = OdsxSelectHelper.getInstanceIds(ae, "*");
                        if (arr != null && arr.length > 0) {
                            int count = arr.length;
                            if (type.compareTo("AoLocalColumn") == 0) {
                                for (int j = 0; j < count; ++j) {
                                    elem = new OdsxColumn(arr[j].id, arr[j].name, aoSession, ae, aeId, type, arr[j].version);
                                    elem.setOdsxFilter(this.odsFilter);
                                    ret.add(elem);
                                }
                            } else {
                                for (int j = 0; j < count; ++j) {
                                    elem = new OdsxInstanceElement(arr[j].id, arr[j].name, aoSession, ae, aeId, type, arr[j].version);
                                    elem.setOdsxFilter(this.odsFilter);
                                    ret.add(elem);
                                }
                            }
                        }
                    }
                    catch (Throwable tJunk) {
                        InstanceElementIterator children = ae.getInstances("*");
                        if (children != null) {
                            int count = children.getCount();
                            if (count > 0 && type.compareTo("AoLocalColumn") == 0) {
                                for (int j = 0; j < count; ++j) {
                                    elem = new OdsxColumn(children.nextOne());
                                    elem.setOdsxFilter(this.odsFilter);
                                    ret.add(elem);
                                }
                            } else {
                                for (int j = 0; j < count; ++j) {
                                    InstanceElement ieObj = children.nextOne();
                                    elem = new OdsxInstanceElement(ieObj, ae, type, OdsxHelper.getVersion(ieObj));
                                    elem.setOdsxFilter(this.odsFilter);
                                    ret.add(elem);
                                }
                            }
                        }
                        children.destroy();
                    }
                }
                catch (AoException aoException) {
                    throw new FwkException(-1073676289, "$RCSfile: OdsxApplicationElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "Failed to load children of <" + this.getName() + ">.", (java.lang.Object)this, (Throwable)aoException);
                }
            }
        }
        return ret == null || ret.size() > 0 ? ret : null;
    }

    public void setTopLevelElement(boolean flag) {
        this.isTopLevelElement = flag;
    }

    public boolean getTopLevelElement() {
        return this.isTopLevelElement;
    }

    public Vector getRelatedElements() {
        Vector<OdsxApplicationElement> ret = new Vector<OdsxApplicationElement>();
        try {
            ApplicationElement ae = this.getApplicationElement();
            ApplicationElement[] aeArray = ae.getAllRelatedElements();
            if (aeArray != null) {
                int size = aeArray.length;
                for (int j = 0; j < size; ++j) {
                    OdsxApplicationElement elem = new OdsxApplicationElement(aeArray[j]);
                    if (this.odsFilter != null) {
                        elem.setOdsxFilter(this.odsFilter);
                        if (!this.odsFilter.isVisible(elem)) continue;
                        ret.add(elem);
                        continue;
                    }
                    ret.add(elem);
                }
            }
        }
        catch (AoException aoException) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxApplicationElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "Failed to load children of <" + this.getName() + ">.", (java.lang.Object)this, (Throwable)aoException);
        }
        return ret.size() > 0 ? ret : null;
    }

    public String getShortName() {
        if (this.shortName == null) {
            this.getIdentificationString();
        }
        return this.shortName;
    }

    public String getIdentificationString() {
        ApplicationElement ae = null;
        if (this.ident == null) {
            HashMap<String, String> cache = new HashMap<String, String>();
            String asamPath = "";
            try {
                String aeName;
                ae = this.getApplicationElement();
                this.shortName = aeName = ae.getName();
                cache.put(aeName, aeName);
                asamPath = "[" + aeName + "]";
                boolean stop = false;
                while (ae != null && !stop) {
                    try {
                        ae = ae.getRelatedElementsByRelationship(Relationship.FATHER)[0];
                    }
                    catch (ArrayIndexOutOfBoundsException aiob) {
                        ae = null;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        ae = null;
                    }
                    if (ae == null) continue;
                    aeName = ae.getName();
                    if (cache.get(aeName) == null) {
                        asamPath = "[" + aeName + "]/" + asamPath;
                        cache.put(aeName, aeName);
                        continue;
                    }
                    stop = true;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            String envName = null;
            try {
                envName = "[" + this.getApplicationElement().getApplicationStructure().getSession().getName() + "]/";
            }
            catch (Throwable tName) {
                envName = "[Environment]/";
            }
            return envName + asamPath;
        }
        return this.ident;
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("An ASAM-ODS Application Element");
        descriptor.setTitleName("OdsxApplicationElement");
        descriptor.setName(OdsxApplicationElement.class.getName());
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:09 $", null);
    }
}

