/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemRequestedEvent;

public class OdsxApplicationElementProducer
extends FwkInfoBusProducer {
    public static final String version = "$Revision: 1.2 $";
    private static OdsxApplicationElementProducer singleInstance;
    private Hashtable elementHash = new Hashtable();

    public String getVersion() {
        return version;
    }

    private OdsxApplicationElementProducer() {
        super("OdsxApplicationElementProducer@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeTypes((Class)OdsxApplicationElementInterface.class));
    }

    public static synchronized OdsxApplicationElementProducer getInstance() {
        if (singleInstance == null) {
            singleInstance = new OdsxApplicationElementProducer();
        }
        return singleInstance;
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (itemName == null) {
            return true;
        }
        if (this.isAssignable(flavor)) {
            if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                this.fireItemRevoked((DataItem)this.elementHash.remove(itemName));
            } else {
                Object[] arr = this.findMultipleDataItems(itemName, flavor);
                if (arr != null && arr.length != 0) {
                    for (int i = arr.length; i >= 0; --i) {
                        try {
                            OdsxApplicationElementInterface elem = (OdsxApplicationElementInterface)arr[i];
                            String name = elem.getName();
                            this.fireItemRevoked((DataItem)this.elementHash.remove(name));
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return true;
    }

    public void add(OdsxApplicationElementInterface ae) {
        InfoBus ib = this.getInfoBus();
        if (ib != null && ae != null) {
            this.elementHash.put(ae.getName(), ae);
            ib.fireItemAvailable(ae.getName(), FwkContainer.getDataFlavors((Class)OdsxApplicationElementInterface.class), (InfoBusDataProducer)this);
        }
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        super.dataItemRequested(ev);
        if (ev.getDataItem() == null) {
            String dataItemName = ev.getDataItemName();
            if (dataItemName != null) {
                DataFlavor[] dataFlavors = ev.getDataFlavors();
                int size = dataFlavors.length;
                int i = 0;
                boolean assignable = false;
                while (i < size && !assignable) {
                    assignable = dataFlavors[i++].getRepresentationClass().isAssignableFrom(class$com$highqsoft$interfaces$odsx$OdsxApplicationElementInterface == null ? OdsxApplicationElementProducer.class$("com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface") : class$com$highqsoft$interfaces$odsx$OdsxApplicationElementInterface);
                }
                if (assignable) {
                    if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                        FwkArray dataItemArray = new FwkArray();
                        Enumeration asamPathes = this.elementHash.keys();
                        while (asamPathes.hasMoreElements()) {
                            String itemName = (String)asamPathes.nextElement();
                            if (!Pattern.match((String)itemName, (String)dataItemName, (boolean)true)) continue;
                            Object dataItem = this.elementHash.get(itemName);
                            if (dataItem != null) {
                                dataItemArray.add(dataItem);
                                continue;
                            }
                            FwkContainer.debug((int)5, (String)("   OdsxApplicationElementProducer: Requested data item not found: " + dataItemName));
                        }
                        if (dataItemArray.size() > 0) {
                            ev.setDataItem((Object)dataItemArray.toArray((Object[])new OdsxApplicationElementInterface[dataItemArray.size()]));
                        }
                    } else {
                        Object dataItem = this.elementHash.get(dataItemName);
                        if (dataItem != null) {
                            ev.setDataItem(dataItem);
                        } else {
                            FwkContainer.debug((int)5, (String)("   OdsxApplicationElementProducer: Requested data item not found: " + dataItemName));
                        }
                    }
                } else {
                    FwkContainer.debug((int)5, (String)"   OdsxApplicationElementProducer: Requested DataFlavor is not assignable.");
                }
            } else {
                FwkContainer.debug((int)5, (String)"   OdsxApplicationElementProducer: Data Item Name == null");
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        System.out.println("%OdsxApplicationElementProducer: propertyChange(PropertyChangeEvent ev)");
        System.out.println(ev.toString());
    }

    public void remove(String asamPath) {
        this.fireItemRevoked((DataItem)this.elementHash.remove(asamPath));
    }
}

