/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkColumnDataObserverDate;
import com.highqsoft.fwk.FwkColumnDataObserverDouble;
import com.highqsoft.fwk.FwkColumnDataObserverFloat;
import com.highqsoft.fwk.FwkColumnDataObserverInt;
import com.highqsoft.fwk.FwkColumnDataObserverShort;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxInstanceElement;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.awt.Container;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.Column;
import org.asam.ods.DataType;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.Measurement;
import org.asam.ods.NameValueUnit;
import org.asam.ods.Relationship;
import org.asam.ods.SubMatrix;
import org.asam.ods.TS_Union;
import org.asam.ods.T_LONGLONG;

public class OdsxColumn
extends OdsxInstanceElement
implements OdsxColumnInterface {
    public static final String version = "$Revision: 1.10 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected NameValueUnit data = null;
    protected NameValueUnit flags = null;
    protected String unitString = null;
    protected int independent = -1;
    protected int implicit = -1;
    protected Measurement meaIe = null;
    protected SubMatrix subIe = null;
    protected String[] dependsOn = null;
    protected short globalFlag = (short)-1;
    protected Object LOCK = new Object();

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    protected OdsxColumn() {
        this.setDescriptor(descriptor);
    }

    public OdsxColumn(InstanceElement ie, ApplicationElement aeObj, String type) {
        super(ie, aeObj, type, OdsxHelper.getVersion(ie));
        try {
            if (this.baseName.compareTo("AoLocalColumn") != 0) {
                new FwkException(-1073676289, "$RCSfile: OdsxColumn.java,v $", this.getVersion(), "AH 2000-06-26 10:41", "Instance is not of type AoLocaleColumn.", (Object)this, null);
            }
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, null, (Throwable)t);
        }
    }

    public OdsxColumn(InstanceElement ie) {
        super(ie, "AoLocalColumn");
        try {
            if (this.baseName.compareTo("AoLocalColumn") != 0) {
                new FwkException(-1073676289, "$RCSfile: OdsxColumn.java,v $", this.getVersion(), "AH 2000-06-26 10:41", "Instance is not of type AoLocaleColumn.", (Object)this, null);
            }
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, null, (Throwable)t);
        }
    }

    public OdsxColumn(T_LONGLONG id, String name, AoSession aoSession, ApplicationElement aeObj, String type, String version) {
        super(id, name, aoSession, aeObj, type, version);
        try {
            if (this.baseName.compareTo("AoLocalColumn") != 0) {
                new FwkException(-1073676289, "$RCSfile: OdsxColumn.java,v $", this.getVersion(), "AH 2000-06-26 10:41", "Instance is not of type AoLocaleColumn.", (Object)this, null);
            }
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, null, (Throwable)t);
        }
    }

    public OdsxColumn(T_LONGLONG id, String name, AoSession aoSession, ApplicationElement aeObj, T_LONGLONG aeId, String type, String version) {
        super(id, name, aoSession, aeObj, aeId, type, version);
        try {
            if (this.baseName.compareTo("AoLocalColumn") != 0) {
                new FwkException(-1073676289, "$RCSfile: OdsxColumn.java,v $", this.getVersion(), "AH 2000-06-26 10:41", "Instance is not of type AoLocaleColumn.", (Object)this, null);
            }
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, null, (Throwable)t);
        }
    }

    public InstanceElement getColumn() {
        return this.getInstanceElement();
    }

    public void release() {
        this.data = null;
        this.flags = null;
        this.meaIe = null;
        this.subIe = null;
        this.dependsOn = null;
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnName() {
        Object object = this.LOCK;
        synchronized (object) {
            try {
                return this.getColumn().getName();
            }
            catch (Throwable t) {
                return this.getName();
            }
        }
    }

    public int getCount() {
        this.initializeObserver();
        return this.observer == null ? 0 : this.observer.getCount();
    }

    public double[] getValues() {
        this.initializeObserver();
        return super.getValues();
    }

    public boolean isGlobalFlagAvailable() {
        this.initializeObserver();
        return this.globalFlag >= 0;
    }

    public short getGlobalFlag() {
        this.initializeObserver();
        return this.isGlobalFlagAvailable() ? (short)this.globalFlag : (short)15;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeObserver() {
        if (this.observer != null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.observer == null) {
                try {
                    this.getData();
                }
                catch (Throwable t) {
                    FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, (String)FwkPropertyBus.getProperty((String)"ODS.Error.Unabele_To_Load_Data"), (Throwable)t);
                    return;
                }
            }
            if (this.data.value == null) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, (String)FwkPropertyBus.getProperty((String)"ODS.Error.No_Data_TS_Value"), (String)null);
                return;
            }
            if (this.data.value.u == null) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, (String)FwkPropertyBus.getProperty((String)"ODS.Error.No_Data_TS_Union"), (String)null);
                return;
            }
            DataType dt = this.data.value.u.discriminator();
            if (dt == null) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, (String)FwkPropertyBus.getProperty((String)"ODS.Error.No_Data_DataType"), (String)null);
                return;
            }
            try {
                InstanceElement ieObj = this.getInstanceElement();
                short[] tmpFlags = null;
                try {
                    NameValueUnit nvu = ieObj.getValueByBaseName("global_flag");
                    if ((nvu.value.flag & 1) != 0) {
                        this.globalFlag = nvu.value.u.shortVal();
                    } else {
                        tmpFlags = this.flags.value.u.shortSeq();
                    }
                }
                catch (Throwable tgf) {
                    tmpFlags = this.flags.value.u.shortSeq();
                }
                switch (dt.value()) {
                    case 6: 
                    case 20: {
                        Object[] tmpData = this.data.value.u.longSeq();
                        if (tmpFlags == null) {
                            this.observer = new FwkColumnDataObserverInt(tmpData, this.globalFlag);
                            break;
                        }
                        this.observer = new FwkColumnDataObserverInt(tmpData, tmpFlags);
                        break;
                    }
                    case 3: 
                    case 17: {
                        Object[] tmpData = this.data.value.u.floatSeq();
                        this.observer = new FwkColumnDataObserverFloat((float[])tmpData, tmpFlags);
                        break;
                    }
                    case 2: 
                    case 16: {
                        Object[] tmpData = this.data.value.u.shortSeq();
                        this.observer = new FwkColumnDataObserverShort((short[])tmpData, tmpFlags);
                        break;
                    }
                    case 7: 
                    case 21: {
                        Object[] tmpData = this.data.value.u.doubleSeq();
                        this.observer = new FwkColumnDataObserverDouble((double[])tmpData, tmpFlags);
                        break;
                    }
                    case 10: 
                    case 26: {
                        Object[] tmpData = this.data.value.u.dateSeq();
                        Date[] values = new Date[tmpData.length];
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
                        ParsePosition pos = new ParsePosition(0);
                        for (int j = 0; j < tmpData.length; ++j) {
                            pos.setIndex(0);
                            try {
                                values[j] = formatter.parse((String)tmpData[j], pos);
                                continue;
                            }
                            catch (NullPointerException tNull) {
                                values[j] = new Date();
                            }
                        }
                        this.observer = new FwkColumnDataObserverDate(values, tmpFlags);
                        this.unitString = ((FwkColumnDataObserverDate)this.observer).getUnitString();
                        break;
                    }
                    default: {
                        throw new FwkException(-1073676289, "$RCSfile: OdsxColumn.java,v $", version, "AH 2000-06-27 13:25", "The support of the datatype <" + OdsxHelper.datatypeToString(dt) + "> is not yet implemented.", (Object)this, null);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.data = null;
            this.flags = null;
        }
    }

    public short[] getFlags() {
        this.initializeObserver();
        return super.getFlags();
    }

    public double getValueAt(int index) throws FwkException {
        this.initializeObserver();
        return super.getValueAt(index);
    }

    public short getFlagAt(int index) throws FwkException {
        this.initializeObserver();
        return super.getFlagAt(index);
    }

    public double getMinimum() {
        if (!this.rangeIsValid) {
            this.initializeObserver();
            this.determineRange();
        }
        return super.getMinimum();
    }

    public double getMaximum() {
        if (!this.rangeIsValid) {
            this.initializeObserver();
            this.determineRange();
        }
        return super.getMaximum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUnitString() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.observer == null) {
                this.initializeObserver();
            }
            if (this.unitString == null) {
                if (this.data == null) {
                    try {
                        this.getData();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.unitString = this.data == null ? "1" : this.data.unit;
            }
        }
        return this.unitString;
    }

    protected SubMatrix getSubMatrix() {
        if (this.subIe == null) {
            SubMatrix ret = null;
            try {
                InstanceElement ie = this.getColumn();
                InstanceElementIterator iei = ie.getRelatedInstancesByRelationship(Relationship.FATHER, "*");
                int count = iei.getCount();
                if (count != 0) {
                    while (ret == null && count-- > 0) {
                        InstanceElement father = iei.nextOne();
                        if (!(father instanceof SubMatrix)) continue;
                        ret = (SubMatrix)father;
                    }
                }
                iei.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.subIe = ret;
            return ret;
        }
        return this.subIe;
    }

    protected Measurement getMeasurement() {
        if (this.meaIe == null) {
            Measurement ret = null;
            try {
                SubMatrix ie = this.getSubMatrix();
                if (ie != null) {
                    InstanceElementIterator iei = ie.getRelatedInstancesByRelationship(Relationship.FATHER, "*");
                    int count = iei.getCount();
                    if (count != 0) {
                        while (ret == null && count-- > 0) {
                            InstanceElement father = iei.nextOne();
                            try {
                                ret = father.upcastMeasurement();
                            }
                            catch (Throwable t) {}
                        }
                    }
                    iei.destroy();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.meaIe = ret;
            return ret;
        }
        return this.meaIe;
    }

    public String[] dependsOn() {
        if (this.dependsOn == null) {
            String[] ret = null;
            if (!this.isIndependent()) {
                try {
                    Measurement meaIe = this.getMeasurement();
                    Column[] arr = meaIe.getValueMatrix().getIndependentColumns("*");
                    if (arr != null && arr.length != 0) {
                        int size = arr.length;
                        ret = new String[size];
                        for (int i = 0; i < size; ++i) {
                            ret[i] = arr[i].getName();
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.dependsOn = ret == null ? new String[0] : ret;
            return ret;
        }
        if (this.dependsOn.length == 0) {
            return null;
        }
        return this.dependsOn;
    }

    public boolean isIndependent() {
        if (this.independent == -1) {
            try {
                String s;
                TS_Union u;
                DataType dt;
                InstanceElement ie = this.getColumn();
                ApplicationElement ae = ie.getApplicationElement();
                ApplicationAttribute aa = ae.getAttributeByBaseName("independent");
                short flag = ie.getValue((String)aa.getName()).value.flag;
                this.independent = (flag & 1) == 0 ? 0 : ((dt = (u = ie.getValue((String)aa.getName()).value.u).discriminator()).value() == 2 ? (u.shortVal() != 0 ? 1 : 0) : (dt.value() == 4 ? (u.booleanVal() ? 1 : 0) : (Integer.parseInt(s = OdsxHelper.ts_unionToString(u)) != 0 ? 1 : 0)));
            }
            catch (Throwable t) {
                this.independent = 0;
            }
        }
        return this.independent == 1;
    }

    public boolean isImplicit() {
        if (this.implicit == -1) {
            try {
                TS_Union u;
                DataType dt;
                InstanceElement ie = this.getColumn();
                ApplicationElement ae = ie.getApplicationElement();
                ApplicationAttribute aa = ae.getAttributeByBaseName("sequence_representation");
                short flag = ie.getValue((String)aa.getName()).value.flag;
                this.implicit = (flag & 1) == 0 ? 0 : ((dt = (u = ie.getValue((String)aa.getName()).value.u).discriminator()).value() == 6 ? u.longVal() : 0);
            }
            catch (Throwable t) {
                this.implicit = 0;
            }
        }
        return this.implicit > 0 && this.implicit != 7;
    }

    public double getAverage() {
        if (!this.rangeIsValid) {
            this.determineRange();
        }
        return this.average;
    }

    public double getStandardDeviation() {
        if (!this.rangeIsValid) {
            this.determineRange();
        }
        return this.standardDeviation;
    }

    public short getAverageFlag() {
        if (!this.rangeIsValid) {
            this.determineRange();
        }
        return this.averageIsValid ? (short)15 : 0;
    }

    public short getStandardDeviationFlag() {
        if (!this.rangeIsValid) {
            this.determineRange();
        }
        return this.standardDeviationIsValid ? (short)15 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getData() throws FwkException {
        Object object = this.LOCK;
        synchronized (object) {
            block12: {
                try {
                    FwkContainer.debug((int)1, (String)("getting data from <" + this.getColumn().getName() + ">"));
                }
                catch (Throwable t) {
                    FwkContainer.debug((int)1, (String)"getting data from <???>.");
                }
                if (this.data == null) {
                    try {
                        NameValueUnit tmpData = this.getColumn().getValueByBaseName("values");
                        if (tmpData == null) {
                            throw new FwkException(-1073676289, "$RCSfile: OdsxColumn.java,v $", version, "AH 2001-01-17 16:27", "Cannot load data.", (Object)this, null);
                        }
                        this.data = tmpData;
                        try {
                            NameValueUnit tmpFlags = this.getColumn().getValueByBaseName("flags");
                            if (tmpFlags != null) {
                                this.flags = tmpFlags;
                                break block12;
                            }
                            System.err.println("Cannot read flags from base attribute.");
                        }
                        catch (Throwable tFlags) {
                            System.err.println("Cannot read flags from base attribute.");
                        }
                    }
                    catch (AoException t) {
                        throw new FwkException(1073743324, "$RCSfile: OdsxColumn.java,v $", version, "AH 2000-06-27 16:32", "Cannot restore data. " + t.reason, (Object)this, (Throwable)t);
                    }
                }
            }
        }
    }

    protected void determineRange() {
        this.initializeObserver();
        super.determineRange();
    }

    public void reload() {
        this.data = null;
        this.flags = null;
        this.observer = null;
        this.rangeIsValid = false;
        this.averageIsValid = false;
        this.standardDeviationIsValid = false;
        this.changeManager.fireItemValueChanged((Object)this, null);
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("An ASAM-ODS Column");
        descriptor.setTitleName("OdsxColumn");
        descriptor.setName(OdsxColumn.class.getName());
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:09 $", null);
    }

    public class DataThread
    extends FwkThread {
        public void run() {
            try {
                OdsxColumn.this.getValues();
                OdsxColumn.this.getFlags();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

