/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkColumnAccess;
import com.highqsoft.fwk.FwkColumnDataObserverDate;
import com.highqsoft.fwk.FwkColumnDataObserverDouble;
import com.highqsoft.fwk.FwkColumnDataObserverFloat;
import com.highqsoft.fwk.FwkColumnDataObserverInt;
import com.highqsoft.fwk.FwkColumnDataObserverShort;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.odsx.OdsxColumnProducer;
import com.highqsoft.odsx.OdsxHelper;
import java.awt.datatransfer.DataFlavor;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.infobus.InfoBusDataProducer;
import org.asam.ods.AoException;
import org.asam.ods.Column;
import org.asam.ods.DataType;
import org.asam.ods.TS_ValueSeq;
import org.asam.ods.ValueMatrix;

public class OdsxColumnAccess
extends FwkColumnAccess
implements FwkColumnAccessInterface {
    public static final String version = "$Revision: 1.5 $";
    protected String unitString = null;
    protected Column column;
    protected ValueMatrix vm;
    protected boolean independent;
    protected String shortName;
    protected InfoBusDataProducer producer;
    protected static FwkIconInterface icon = FwkIconFile.getIcon((String)"AoColumn");

    public String getVersion() {
        return version;
    }

    public void release() {
        if (this.observer != null) {
            this.observer.release();
        }
        this.observer = null;
        this.column = null;
        this.vm = null;
        this.averageIsValid = false;
        this.standardDeviationIsValid = false;
        this.columnName = null;
        this.shortName = null;
        this.setProperty("InfoBusSource", null);
        super.release();
    }

    protected OdsxColumnAccess() {
        this.shortName = null;
        this.setTitleName(((Object)((Object)this)).getClass().getName());
    }

    public OdsxColumnAccess(InfoBusDataProducer producer, ValueMatrix vm, String name, String columnName) {
        this.setName(name);
        this.setTitleName(((Object)((Object)this)).getClass().getName());
        this.columnName = columnName;
        this.rangeIsValid = false;
        this.independent = false;
        this.lower = 0.0;
        this.upper = 0.0;
        this.setProperty("InfoBusSource", producer);
        this.vm = vm;
        try {
            Column[] columnSeq = vm.getColumns(OdsxHelper.escapePattern(columnName));
            if (columnSeq.length > 0) {
                this.column = columnSeq[0];
            }
        }
        catch (AoException aoex) {
            throw new FwkException(1073743324, "$RCSfile: OdsxColumnAccess.java,v $", "Revision$", "AH 1999-14-04 09:03", name, (Object)this, (Throwable)aoex);
        }
    }

    public OdsxColumnAccess(InfoBusDataProducer producer, String asamPath, ValueMatrix vm, Column col) {
        try {
            this.setName(OdsxColumnProducer.createDataItemName(asamPath, col.getName()));
            this.setTitleName(((Object)((Object)this)).getClass().getName());
            this.rangeIsValid = false;
            this.lower = 0.0;
            this.upper = 0.0;
            if (producer != null) {
                this.setProperty("InfoBusSource", producer);
            }
            this.vm = vm;
            this.column = col;
            this.columnName = col.getName();
        }
        catch (Throwable t) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxColumnAccess.java,v $", this.getVersion(), "AH 2000-03-07 14:29", "Cannot create column.", (Object)this, t);
        }
    }

    public String getShortName() {
        if (this.shortName == null) {
            this.shortName = OdsxColumnProducer.getItemShortName(this.getName());
        }
        return this.shortName;
    }

    public FwkIconInterface getIcon() {
        return icon;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        boolean ret;
        boolean bl = ret = !super.isDataFlavorSupported(dataFlavor);
        if (!ret) {
            DataFlavor[] flavor = FwkContainer.getDataFlavor((Class)OdsxColumnAccess.class);
            for (int i = flavor.length - 1; !ret && i >= 0; --i) {
                if (!flavor[i].equals(dataFlavor)) continue;
                ret = true;
            }
        }
        return ret;
    }

    public Object getValueAsObject() {
        return this.column;
    }

    public double[] getValues() throws FwkException {
        this.initializeObserver();
        return super.getValues();
    }

    public double getValueAt(int index) throws FwkException {
        this.initializeObserver();
        return super.getValueAt(index);
    }

    protected void initializeObserver() {
        if (this.observer == null) {
            TS_ValueSeq columnValues = null;
            short[] valueFlags = null;
            int startPoint = 0;
            int count = 0;
            try {
                columnValues = this.vm.getValueVector(this.column, startPoint, count);
                if (columnValues != null) {
                    valueFlags = columnValues.flag;
                    DataType dataType = columnValues.u.discriminator();
                    switch (dataType.value()) {
                        case 6: {
                            this.observer = new FwkColumnDataObserverInt(columnValues.u.longVal(), valueFlags);
                            break;
                        }
                        case 3: {
                            this.observer = new FwkColumnDataObserverFloat(columnValues.u.floatVal(), valueFlags);
                            break;
                        }
                        case 2: {
                            this.observer = new FwkColumnDataObserverShort(columnValues.u.shortVal(), valueFlags);
                            break;
                        }
                        case 7: {
                            this.observer = new FwkColumnDataObserverDouble(columnValues.u.doubleVal(), valueFlags);
                            break;
                        }
                        case 10: {
                            String[] tmpData = columnValues.u.dateVal();
                            Date[] values = new Date[tmpData.length];
                            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
                            ParsePosition pos = new ParsePosition(0);
                            for (int i = 0; i < tmpData.length; ++i) {
                                pos.setIndex(0);
                                try {
                                    values[i] = formatter.parse(tmpData[i], pos);
                                    continue;
                                }
                                catch (NullPointerException tNull) {
                                    values[i] = new Date();
                                }
                            }
                            this.observer = new FwkColumnDataObserverDate(values, valueFlags);
                            this.unitString = ((FwkColumnDataObserverDate)this.observer).getUnitString();
                            break;
                        }
                        default: {
                            throw new FwkException(-2147483605, "$RCSfile: OdsxColumnAccess.java,v $", "Revision$", "AH 1999-14-04 10:13", "The support of the datatype <" + OdsxHelper.datatypeToString(dataType) + "> is not yet implemented.", null, null);
                        }
                    }
                }
            }
            catch (Throwable e) {
                throw new FwkException(1073743324, "$RCSfile: OdsxColumnAccess.java,v $", version, "AH 1999-14-04 10:14", "getValues(vm, column, " + startPoint + ", " + count + ")", null, e);
            }
        }
    }

    public static short[] getFlags(ValueMatrix vm, Column column, int startPoint, int count) throws FwkException {
        short[] ret = null;
        TS_ValueSeq columnValues = null;
        try {
            columnValues = vm.getValueVector(column, startPoint, count);
            if (columnValues != null) {
                ret = columnValues.flag;
            }
        }
        catch (Throwable e) {
            throw new FwkException(1073743324, "$RCSfile: OdsxColumnAccess.java,v $", version, "AH 1999-14-04 10:14", "getFlags(vm, column, " + startPoint + ", " + count + ")", null, e);
        }
        return ret;
    }

    public static double[] getValues(ValueMatrix vm, Column column, int startPoint, int count) throws FwkException {
        double[] ret;
        block11: {
            TS_ValueSeq columnValues = null;
            ret = null;
            try {
                columnValues = vm.getValueVector(column, startPoint, count);
                if (columnValues == null) break block11;
                DataType dataType = columnValues.u.discriminator();
                switch (dataType.value()) {
                    case 6: {
                        int[] tmpData = columnValues.u.longVal();
                        ret = new double[tmpData.length];
                        for (int i = 0; i < tmpData.length; ++i) {
                            ret[i] = tmpData[i];
                        }
                        break;
                    }
                    case 3: {
                        float[] tmpData = columnValues.u.floatVal();
                        ret = new double[tmpData.length];
                        for (int i = 0; i < tmpData.length; ++i) {
                            ret[i] = tmpData[i];
                        }
                        break;
                    }
                    case 2: {
                        short[] tmpData = columnValues.u.shortVal();
                        ret = new double[tmpData.length];
                        for (int i = 0; i < tmpData.length; ++i) {
                            ret[i] = tmpData[i];
                        }
                        break;
                    }
                    case 7: {
                        ret = columnValues.u.doubleVal();
                        break;
                    }
                    default: {
                        throw new FwkException(-2147483605, "$RCSfile: OdsxColumnAccess.java,v $", "Revision$", "AH 1999-14-04 10:13", "The support of the datatype <" + OdsxHelper.datatypeToString(dataType) + "> is not yet implemented.", null, null);
                    }
                }
            }
            catch (Throwable e) {
                throw new FwkException(1073743324, "$RCSfile: OdsxColumnAccess.java,v $", version, "AH 1999-14-04 10:14", "getValues(vm, column, " + startPoint + ", " + count + ")", null, e);
            }
        }
        return ret;
    }

    public short[] getFlags() {
        this.initializeObserver();
        return super.getFlags();
    }

    public int getCount() {
        this.initializeObserver();
        return this.observer == null ? 0 : this.observer.getCount();
    }

    public short getFlagAt(int index) throws FwkException {
        short ret = 0;
        this.initializeObserver();
        try {
            ret = this.observer.getFlagAt(index);
        }
        catch (Throwable t) {
            new FwkException(1073743324, "$RCSfile: OdsxColumnAccess.java,v $", version, "AH 1999-14-04 10:04", "array.length=" + this.observer.getCount() + " index=" + index, (Object)this, t);
            return 15;
        }
        return ret;
    }

    public String getUnitString() {
        if (this.observer == null) {
            this.initializeObserver();
        }
        if (this.unitString == null) {
            try {
                this.unitString = this.column.getUnit();
            }
            catch (AoException aoex) {
                this.unitString = new String("");
            }
        }
        return this.unitString;
    }

    public String[] dependsOn() {
        String[] inDep = new String[]{};
        return inDep;
    }

    public boolean isIndependent() {
        try {
            String[] cols = this.vm.listIndependentColumns(this.getColumnName());
            return cols != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected void determineRange() {
        this.initializeObserver();
        super.determineRange();
    }
}

