/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkColumnAccessGroup;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusItemGroupInterface;
import com.highqsoft.odsx.OdsxColumnAccess;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemRequestedEvent;
import org.asam.ods.Measurement;
import org.asam.ods.SubMatrix;
import org.asam.ods.ValueMatrix;

public class OdsxColumnProducer
extends FwkInfoBusProducer {
    public static final String version = "$Revision: 1.5 $";
    private static OdsxColumnProducer singleInstance;
    private HashMap elementHash = new HashMap();
    private HashMap columnHash = new HashMap();
    private HashMap vmHash = new HashMap();

    public String getVersion() {
        return version;
    }

    private OdsxColumnProducer() {
        super("OdsxColumnProducer@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeTypes((Class)FwkColumnAccessInterface.class));
    }

    public static synchronized OdsxColumnProducer getInstance() {
        if (singleInstance == null) {
            singleInstance = new OdsxColumnProducer();
        }
        return singleInstance;
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (itemName == null) {
            return true;
        }
        if (this.isAssignable(flavor)) {
            if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                DataItem item = (DataItem)this.elementHash.remove(itemName);
                if (item != null) {
                    item.release();
                    this.fireItemRevoked(item);
                }
                if ((item = (DataItem)this.columnHash.remove(itemName)) != null) {
                    item.release();
                    this.fireItemRevoked(item);
                }
                if ((item = (DataItem)this.vmHash.remove(itemName)) != null) {
                    item.release();
                    this.fireItemRevoked(item);
                }
            } else {
                Object[] arr = this.findMultipleDataItems(itemName, flavor);
                if (arr != null && arr.length != 0) {
                    DataItem item;
                    String name;
                    FwkArray vmArr = new FwkArray();
                    for (int i = arr.length; i >= 0; --i) {
                        if (arr[i] instanceof ValueMatrix && this.elementHash.containsValue(arr[i])) {
                            Iterator it = this.elementHash.keySet().iterator();
                            boolean found = false;
                            while (!found && it.hasNext()) {
                                name = (String)it.next();
                                found = arr[i].equals(this.elementHash.get(name));
                                if (!found) continue;
                                vmArr.add((Object)name);
                            }
                            continue;
                        }
                        if (!(arr[i] instanceof FwkColumnAccessInterface) || (item = (DataItem)this.columnHash.remove(name = ((FwkColumnAccessInterface)arr[i]).getName())) == null) continue;
                        item.release();
                        this.fireItemRevoked(item);
                    }
                    int size = vmArr.size();
                    for (int i = 0; i < size; ++i) {
                        name = (String)vmArr.get(i);
                        this.fireItemRevoked((DataItem)this.elementHash.remove(name));
                        name = this.getVMName(name);
                        if (name == null || (item = (DataItem)this.vmHash.remove(name)) == null) continue;
                        item.release();
                        this.fireItemRevoked(item);
                    }
                }
            }
        }
        return true;
    }

    public void add(Measurement meaIe) {
        try {
            this.add(meaIe.getAsamPath(), meaIe.getValueMatrix());
        }
        catch (Throwable meaT) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxColumnProducer.java,v $", version, "AH 1999-06-28 14:25", "Cannot get the ValueMatrix from Measurement", (Object)this, meaT);
        }
    }

    public void add(SubMatrix subIe) {
        try {
            this.add(subIe.getAsamPath(), subIe.getValueMatrix());
        }
        catch (Throwable meaT) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxColumnProducer.java,v $", version, "AH 1999-06-28 14:25", "Cannot get the ValueMatrix from SubMatrix", (Object)this, meaT);
        }
    }

    public void add(String asamPath, ValueMatrix vm) {
        InfoBus ib = this.getInfoBus();
        if (ib != null && vm != null && asamPath != null) {
            this.elementHash.put(asamPath, vm);
            VMColumnGroup group = null;
            try {
                group = new VMColumnGroup(asamPath);
                group.setProperty("InfoBusSource", (Object)this);
                this.vmHash.put(group.getName(), group);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String[] columnNames = vm.listColumns("*");
                for (int i = 0; i < columnNames.length; ++i) {
                    String dataItemName = OdsxColumnProducer.createDataItemName(asamPath, columnNames[i]);
                    OdsxColumnAccess column = new OdsxColumnAccess((InfoBusDataProducer)this, vm, dataItemName, columnNames[i]);
                    this.columnHash.put(dataItemName, column);
                    this.fireItemAvailable((DataItem)column, FwkContainer.getDataFlavors((Class)(class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface == null ? OdsxColumnProducer.class$("com.highqsoft.interfaces.fwk.FwkColumnAccessInterface") : class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface)));
                    if (group == null) continue;
                    group.addChild((FwkInfoBusItemGroupInterface)column);
                }
                if (group != null) {
                    this.fireItemAvailable((DataItem)group, FwkContainer.getDataFlavors((Class)FwkColumnAccessInterface.class));
                }
            }
            catch (Throwable e) {
                throw new FwkException(-1073676289, "$RCSfile: OdsxColumnProducer.java,v $", version, "AH 1999-14-04 11:55", null, (Object)this, e);
            }
        }
    }

    public static String createDataItemName(String asamPath, String columnName) {
        return asamPath + "#" + columnName;
    }

    protected String getVMName(String path) {
        String ret = null;
        int index = path.lastIndexOf(93);
        if (index > -1) {
            ret = "VM(" + path + ")";
        }
        return ret;
    }

    public static String getItemShortName(String name) {
        String ret = name;
        if (name.startsWith("VM(")) {
            int index = name.lastIndexOf(")");
            return "VM(" + OdsxColumnProducer.getItemShortName(name.substring(3, index)) + ")";
        }
        String[] arr = name.split("/\\[");
        int index = -1;
        if (arr.length > 0) {
            index = arr[arr.length - 1].indexOf(93);
        }
        if (index > -1) {
            ret = arr[arr.length - 1].substring(index + 1);
        }
        return ret;
    }

    public static String getColumnName(String dataItemName) {
        int sepIndex = dataItemName.lastIndexOf(35);
        return sepIndex != 0 ? dataItemName.substring(sepIndex + 1) : null;
    }

    protected static String getAsamPath(String dataItemName) {
        int sepIndex = dataItemName.lastIndexOf(35);
        return sepIndex != 0 ? dataItemName.substring(0, sepIndex) : null;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        System.out.println("%TestDataProducer: propertyChange(PropertyChangeEvent ev)");
        System.out.println(ev.toString());
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        String dataItemName;
        super.dataItemRequested(ev);
        if (ev.getDataItem() == null && (dataItemName = ev.getDataItemName()) != null && this.isAssignable(ev.getDataFlavors())) {
            if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                Object dataItem;
                String itemName;
                FwkArray dataItemArray = new FwkArray();
                Iterator it = this.columnHash.keySet().iterator();
                while (it.hasNext()) {
                    itemName = (String)it.next();
                    if (!Pattern.match((String)itemName, (String)dataItemName, (boolean)true)) continue;
                    dataItem = this.columnHash.get(itemName);
                    if (dataItem != null) {
                        dataItemArray.add(dataItem);
                        continue;
                    }
                    FwkContainer.debug((int)5, (String)("   OdsxColumnProducer: Requested data item not found: " + dataItemName));
                }
                it = this.vmHash.keySet().iterator();
                while (it.hasNext()) {
                    itemName = (String)it.next();
                    if (!Pattern.match((String)itemName, (String)dataItemName, (boolean)true)) continue;
                    dataItem = this.vmHash.get(itemName);
                    if (dataItem != null) {
                        dataItemArray.add(dataItem);
                        continue;
                    }
                    FwkContainer.debug((int)5, (String)("   OdsxColumnProducer: Requested data item not found: " + dataItemName));
                }
                if (dataItemArray.size() > 0) {
                    ev.setDataItem((Object)dataItemArray.toArray((Object[])new FwkColumnAccessInterface[dataItemArray.size()]));
                }
            } else if (this.columnHash.containsKey(dataItemName)) {
                ev.setDataItem(this.columnHash.get(dataItemName));
            } else if (this.vmHash.containsKey(dataItemName)) {
                ev.setDataItem(this.vmHash.get(dataItemName));
            }
        }
    }

    public void remove(SubMatrix subIe) {
        try {
            this.remove(subIe.getAsamPath());
        }
        catch (Throwable meaT) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxColumnProducer.java,v $", version, "AH 2001-01-09 10:17", "Cannot remove ValueMatrix", (Object)this, meaT);
        }
    }

    public void remove(Measurement meaIe) {
        try {
            this.remove(meaIe.getAsamPath());
        }
        catch (Throwable meaT) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxColumnProducer.java,v $", version, "AH 2001-01-09 10:17", "Cannot remove ValueMatrix", (Object)this, meaT);
        }
    }

    public void remove(String asamPath) {
        ValueMatrix vm;
        InfoBus ib = this.getInfoBus();
        if (ib != null && asamPath != null && (vm = (ValueMatrix)this.elementHash.remove(asamPath)) != null) {
            try {
                String[] columnNames = vm.listColumns("*");
                for (int i = 0; i < columnNames.length; ++i) {
                    String dataItemName = OdsxColumnProducer.createDataItemName(asamPath, columnNames[i]);
                    this.revoke(dataItemName, FwkContainer.getDataFlavors((Class)(class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface == null ? OdsxColumnProducer.class$("com.highqsoft.interfaces.fwk.FwkColumnAccessInterface") : class$com$highqsoft$interfaces$fwk$FwkColumnAccessInterface)));
                }
                String groupName = this.getVMName(asamPath);
                if (groupName != null) {
                    this.revoke(groupName, FwkContainer.getDataFlavors((Class)FwkColumnAccessInterface.class));
                }
            }
            catch (Throwable e) {
                throw new FwkException(-1073676289, "$RCSfile: OdsxColumnProducer.java,v $", version, "HJB 2000-19-01 11:59", null, (Object)this, e);
            }
            vm = null;
            System.gc();
        }
    }

    public static void main(String[] args) {
        int i;
        String s = "/[Environment]MDF/[Test]A0;/[SubTest]A4;/[Measurement]A4;/[SubMatrix]159#p_kupp_ada.av[0]";
        String p = "/\\[";
        String[] arr = s.split(p);
        System.out.println(s + " " + arr.length + " - " + p);
        for (i = 0; i < arr.length; ++i) {
            System.out.println(arr[i]);
        }
        if (arr.length > 0) {
            arr = arr[arr.length - 1].split("\\A*\\]");
            System.out.println("*********************");
            for (i = 0; i < arr.length; ++i) {
                System.out.println(arr[i]);
            }
        }
    }

    protected class VMColumnGroup
    extends FwkColumnAccessGroup {
        public VMColumnGroup(String path) {
            super(singleInstance.getVMName(path), OdsxColumnProducer.getItemShortName(OdsxColumnProducer.this.getVMName(path)));
            this.shortName = this.columnName;
        }
    }
}

