/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import org.asam.ods.AoException;
import org.asam.ods.RelationRange;

public class OdsxConvert {
    public static String argsToOptions(String[] args) {
        String options = null;
        if (args != null && args.length > 0) {
            boolean nextArg = false;
            StringBuffer strbuf = new StringBuffer();
            String keyword = "";
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    if (nextArg) {
                        strbuf.append(" ");
                    }
                    keyword = args[i].substring(1);
                    strbuf.append(keyword);
                    strbuf.append("=");
                    continue;
                }
                if (keyword.length() > 0) {
                    System.setProperty(keyword, args[i]);
                }
                strbuf.append(args[i]);
                nextArg = true;
                keyword = "";
            }
            options = strbuf.toString();
        }
        return options;
    }

    public static String dataTypeToString(int dt) {
        String dtStr;
        switch (dt) {
            case 0: {
                dtStr = "DT_UNKNOWN";
                break;
            }
            case 1: {
                dtStr = "DT_STRING";
                break;
            }
            case 2: {
                dtStr = "DT_SHORT";
                break;
            }
            case 3: {
                dtStr = "DT_FLOAT";
                break;
            }
            case 4: {
                dtStr = "DT_BOOLEAN";
                break;
            }
            case 5: {
                dtStr = "DT_BYTE";
                break;
            }
            case 6: {
                dtStr = "DT_LONG";
                break;
            }
            case 7: {
                dtStr = "DT_DOUBLE";
                break;
            }
            case 8: {
                dtStr = "DT_LONGLONG";
                break;
            }
            case 9: {
                dtStr = "DT_ID";
                break;
            }
            case 10: {
                dtStr = "DT_DATE";
                break;
            }
            case 11: {
                dtStr = "DT_BYTESTR";
                break;
            }
            case 12: {
                dtStr = "DT_BLOB";
                break;
            }
            case 13: {
                dtStr = "DT_COMPLEX";
                break;
            }
            case 14: {
                dtStr = "DT_DCOMPLEX";
                break;
            }
            case 15: {
                dtStr = "DS_STRING";
                break;
            }
            case 16: {
                dtStr = "DS_SHORT";
                break;
            }
            case 17: {
                dtStr = "DS_FLOAT";
                break;
            }
            case 18: {
                dtStr = "DS_BOOLEAN";
                break;
            }
            case 19: {
                dtStr = "DS_BYTE";
                break;
            }
            case 20: {
                dtStr = "DS_LONG";
                break;
            }
            case 21: {
                dtStr = "DS_DOUBLE";
                break;
            }
            case 22: {
                dtStr = "DS_LONGLONG";
                break;
            }
            case 23: {
                dtStr = "DS_COMPLEX";
                break;
            }
            case 24: {
                dtStr = "DS_DCOMPLEX";
                break;
            }
            case 25: {
                dtStr = "DS_ID";
                break;
            }
            case 26: {
                dtStr = "DS_DATE";
                break;
            }
            case 27: {
                dtStr = "DS_BYTESTR";
                break;
            }
            case 28: {
                dtStr = "DT_EXTERNALREFERENCE";
                break;
            }
            case 29: {
                dtStr = "DS_EXTERNALREFERENCE";
                break;
            }
            default: {
                dtStr = "Not implemented: <" + dt + ">";
            }
        }
        return dtStr;
    }

    public static String relationRangeToString(RelationRange rr) {
        String rrStr = "[" + rr.min + ":";
        rrStr = rr.max != -1 ? rrStr + rr.max : rrStr + "?";
        rrStr = rrStr + "]";
        return rrStr;
    }

    public static String relationTypeToString(int rt) {
        String rtStr = "Unknown";
        switch (rt) {
            case 0: {
                rtStr = "FATHER_CHILD";
                break;
            }
            case 1: {
                rtStr = "INFO";
                break;
            }
            case 2: {
                rtStr = "INHERITANCE";
            }
        }
        return rtStr;
    }

    public static String relationshipToString(int rs) {
        String rsStr = "Unknown";
        switch (rs) {
            case 0: {
                rsStr = "FATHER";
                break;
            }
            case 1: {
                rsStr = "CHILD";
                break;
            }
            case 2: {
                rsStr = "INFO_TO";
                break;
            }
            case 3: {
                rsStr = "INFO_FROM";
                break;
            }
            case 4: {
                rsStr = "INFO_REL";
                break;
            }
            case 5: {
                rsStr = "SUPERTYPE";
                break;
            }
            case 6: {
                rsStr = "SUBTYPE";
                break;
            }
            case 7: {
                rsStr = "ALL_REL";
            }
        }
        return rsStr;
    }

    public static String aoExceptionToString(AoException aoException, String indentString) {
        String errCode = Integer.toString(aoException.errCode.value());
        String sevFlag = "";
        switch (aoException.sevFlag.value()) {
            case 0: {
                sevFlag = "SUCCESS";
                break;
            }
            case 1: {
                sevFlag = "INFORMATION";
                break;
            }
            case 2: {
                sevFlag = "WARNING";
                break;
            }
            case 3: {
                sevFlag = "ERROR";
            }
        }
        if (indentString == null) {
            indentString = "\n   ";
        }
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(indentString);
        strbuf.append("errCode:   ");
        strbuf.append(errCode);
        strbuf.append(indentString);
        strbuf.append("sevFlag:   ");
        strbuf.append(sevFlag);
        strbuf.append(indentString);
        strbuf.append("minorCode: ");
        strbuf.append(Integer.toString(aoException.minorCode));
        strbuf.append(indentString);
        strbuf.append("reason:    ");
        strbuf.append(aoException.reason);
        return strbuf.toString();
    }
}

