/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDOMHandler;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.fwk.FwkXmlInterpreter;
import com.highqsoft.fwk.command.FwkAboutCommand;
import com.highqsoft.fwk.command.FwkToggleCommand;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDOMHandlerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkInstructionInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import com.highqsoft.interfaces.fwk.FwkXmlDtdInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterValueInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.odsx.OdsxFilterValue;
import com.highqsoft.odsx.OdsxRecursiveApplicationElement;
import com.highqsoft.odsx.command.OdsxFilterEditorCommand;
import java.awt.Color;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import org.asam.ods.ApplicationElement;
import org.asam.ods.BaseElement;
import org.asam.ods.InstanceElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OdsxFilter
extends FwkCommand
implements FwkControllerInterface,
OdsxFilterInterface {
    protected static final String PREFS_ENABLED = "OdsxFilter.enabled";
    public final Color DEFAULT_COLOR = Color.black;
    public final Color INSTANCE_ELEMENT_COLOR = new Color(0.6875f, 0.1875f, 0.375f);
    public final Color APPLICATION_ELEMENT_COLOR = Color.blue;
    public final Color COLUMN_COLOR = Color.red;
    public static final String BASEELEMENTMAP_NAME = "BaseElementMap";
    public static final String NAMEVALUEMAP_NAME = "NameValues";
    public static final String APPLICATIONATTRIBUTE = "ApplicationAttribute";
    public static final String APPLICATIONELEMENT = "ApplicationElement";
    public static final String INSTANCEELEMENT = "InstanceElement";
    public static final String INSTANCEATTRIBUTE = "InstanceAttribute";
    public static final String BASEELEMENT = "BaseElement";
    public static final String BASEATTRIBUTE = "BaseAttribute";
    public static final String VISIBLE = "Visible";
    public static final String ENABLED = "Enabled";
    public static final String NAME = "Name";
    public static final String VALUE = "Value";
    public static final String version = "$Revision: 1.5 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected boolean readingDOM;
    protected boolean enabled;
    protected boolean instanceElementEnabled;
    protected boolean applicationElementEnabled;
    protected FwkPropertyGroupInterface valuePropGroup;
    protected URL url;
    protected boolean recursiveApplStruct;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public OdsxFilter() {
        this.setDescriptor(descriptor);
        this.enabled = !FwkPropertyBus.getProperty((String)"OdsxFilter.Disabled", (boolean)false);
        this.instanceElementEnabled = true;
        this.applicationElementEnabled = true;
        FwkContainer.addComponentProperties(this.getClass());
        this.valuePropGroup = new FwkPropertyGroup();
        this.valuePropGroup.setName("");
        String propFile = FwkPropertyBus.getProperty((String)"OdsxFilter.File.Dictionary", (String)null);
        boolean propsFailed = true;
        if (propFile != null) {
            if (!((FwkPropertyGroup)this.valuePropGroup).load(propFile, this.getClass())) {
                FwkContainer.debug((int)2, (String)("failed to read OdsxFilter DictionaryFile <" + propFile + ">."));
                propsFailed = false;
            } else {
                this.valuePropGroup.setName(propFile);
                FwkContainer.debug((int)2, (String)("OdsxFilter PropertyFile OdsxFilter DictionaryFile " + propFile + " loaded."));
            }
        }
        if (propsFailed) {
            OdsxFilterValue beVal = new OdsxFilterValue();
            beVal.setName("AoAny");
            beVal.setTranslatedValue("AoAny");
            beVal.setVisible(false);
            beVal.setEnabled(false);
            this.setValue(BASEELEMENT, beVal);
        }
        this.recursiveApplStruct = FwkPropertyBus.getProperty((String)"OdsxFilter.ResursiveApplStructEnabled", (boolean)false);
        FwkContainer.debug((int)1, (String)("OdsxFilter.ResursiveApplStructEnabled = " + this.recursiveApplStruct));
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        String bString = prefs.get(PREFS_ENABLED, "false");
        if (bString != null) {
            char c = bString.trim().toUpperCase().charAt(0);
            boolean b = c == 'T' || c == 'Y' || c == '1' || c == 'W';
            this.setEnabled(b);
        }
    }

    protected OdsxFilter(boolean cloned) {
    }

    public Object clone() {
        OdsxFilter ret = null;
        try {
            ret = new OdsxFilter(true);
            ret.setDescriptor(OdsxFilter.getDescriptor());
            if (this.url != null) {
                ret.url = new URL(this.url.toExternalForm());
            }
            ret.recursiveApplStruct = this.recursiveApplStruct;
            ret.applicationElementEnabled = this.applicationElementEnabled;
            ret.instanceElementEnabled = this.instanceElementEnabled;
            ret.enabled = this.enabled;
            ret.valuePropGroup = (FwkPropertyGroupInterface)this.valuePropGroup.clone();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public void clone(OdsxFilterInterface filter) {
        this.recursiveApplStruct = filter.getRecursiveApplStructEnabled();
        this.applicationElementEnabled = filter.getEnableApplicationElements();
        this.instanceElementEnabled = filter.getEnableInstanceElements();
        this.enabled = filter.getEnabled();
        this.valuePropGroup = filter.getPropertyGroup();
        this.firePropertyChange("Filter", this, this);
    }

    public FwkPropertyGroupInterface getPropertyGroup() {
        return this.valuePropGroup;
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            OdsxFilterEditorCommand cmd1 = new OdsxFilterEditorCommand(this);
            this.addCommand((FwkCommandInterface)cmd1);
            cmd1 = new FwkToggleCommand((FwkControllerInterface)this);
            cmd1.setTextKey("OdsxFilter.Text.Enabled");
            cmd1.setCommandName(ENABLED);
            cmd1.setToggleState(this.getEnabled());
            this.addCommand((FwkCommandInterface)cmd1);
            FwkCommand parent = new FwkCommand((FwkControllerInterface)this);
            parent.setTextKey("OdsxFilter.Text.Help");
            parent.setCommandName("Help");
            parent.setIconKey("Icon.Help");
            this.addCommand((FwkCommandInterface)parent);
            cmd1 = new FwkCommand((FwkControllerInterface)this);
            cmd1.setTextKey("OdsxFilter.Text.HelpBroker");
            cmd1.setCommandName("HelpBroker");
            cmd1.setIconKey("Icon.Help");
            cmd1.setHelpID(this.getClass().getName());
            parent.addCommand((FwkCommandInterface)cmd1);
            cmd1 = new FwkAboutCommand((FwkControllerInterface)this);
            cmd1.setTextKey("OdsxFilter.Text.About");
            cmd1.setCommandName("About");
            cmd1.setIconKey("Icon.About");
            parent.addCommand((FwkCommandInterface)cmd1);
        }
        return super.getCommands();
    }

    public String getText() {
        return this.getTitleName();
    }

    public void setEnabled(boolean flag) {
        if (this.enabled != flag) {
            boolean old = this.enabled;
            this.enabled = flag;
            Preferences prefs = Preferences.userNodeForPackage(this.getClass());
            prefs.put(PREFS_ENABLED, Boolean.toString(this.enabled));
            this.firePropertyChange(ENABLED, old, flag);
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean isEnabled(OdsxPresentableElementInterface elem) {
        if (!this.getEnabled()) {
            return true;
        }
        boolean ret = true;
        FwkPropertyGroupInterface group = null;
        if (!elem.valueIsA(InstanceElement.class)) {
            if (elem.valueIsA(ApplicationElement.class)) {
                try {
                    ApplicationElement aeObj = (ApplicationElement)elem.getValueAsObject();
                    String type = aeObj.getBaseElement().getType();
                    group = this.valuePropGroup.getGroup(BASEELEMENT);
                    if (group != null) {
                        group = group.getGroup(type);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                String prop = null;
                if (group != null) {
                    prop = group.getProperty(ENABLED);
                }
                if ((group == null || prop == null) && (group = this.valuePropGroup.getGroup(APPLICATIONELEMENT)) != null) {
                    group = this.valuePropGroup.getGroup(elem.getShortName());
                }
                if (group != null) {
                    ret = group.getProperty(ENABLED, ret);
                }
            } else if (elem.valueIsA(BaseElement.class)) {
                // empty if block
            }
        }
        return ret;
    }

    public boolean isEnabled(String key, boolean defaultValue) {
        if (!this.getEnabled()) {
            return true;
        }
        boolean ret = defaultValue;
        FwkPropertyGroupInterface group = this.getGroupForKey(key);
        if (group != null) {
            ret = group.getProperty(ENABLED, defaultValue);
        }
        return ret;
    }

    public void setEnableInstanceElements(boolean flag) {
        if (this.enabled != flag) {
            boolean old = this.instanceElementEnabled;
            this.instanceElementEnabled = flag;
            this.firePropertyChange("EnableInstanceElement", old, flag);
        }
    }

    public boolean getEnableInstanceElements() {
        return this.instanceElementEnabled;
    }

    public void setEnableApplicationElements(boolean flag) {
        if (this.enabled != flag) {
            boolean old = this.applicationElementEnabled;
            this.applicationElementEnabled = flag;
            this.firePropertyChange("EnableApplicationElement", old, flag);
        }
    }

    public boolean getEnableApplicationElements() {
        return this.applicationElementEnabled;
    }

    public boolean isVisible(OdsxPresentableElementInterface elem) {
        if (!this.getEnabled()) {
            return true;
        }
        boolean ret = true;
        FwkPropertyGroupInterface group = null;
        String aeName = null;
        String beType = null;
        if (elem.valueIsA(InstanceElement.class)) {
            try {
                InstanceElement ieObj = (InstanceElement)elem.getValueAsObject();
                ApplicationElement aeObj = ieObj.getApplicationElement();
                aeName = aeObj.getName();
                beType = aeObj.getBaseElement().getType();
            }
            catch (Throwable t) {}
        } else if (elem.valueIsA(ApplicationElement.class)) {
            try {
                ApplicationElement aeObj = (ApplicationElement)elem.getValueAsObject();
                aeName = aeObj.getName();
                beType = aeObj.getBaseElement().getType();
            }
            catch (Throwable t) {}
        } else if (elem.valueIsA(BaseElement.class)) {
            try {
                BaseElement aeObj = (BaseElement)elem.getValueAsObject();
                beType = aeObj.getType();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (beType != null) {
            group = this.valuePropGroup.getGroup(BASEELEMENT);
            if (group != null && (group = group.getGroup(beType)) != null) {
                ret = group.getProperty(VISIBLE, ret);
            }
            if (ret && aeName != null && (group = this.valuePropGroup.getGroup(APPLICATIONELEMENT)) != null && (group = group.getGroup(aeName)) != null) {
                ret = group.getProperty(VISIBLE, ret);
            }
        }
        return ret;
    }

    public boolean isVisible(String key, boolean defaultValue) {
        if (!this.getEnabled()) {
            return true;
        }
        boolean ret = defaultValue;
        FwkPropertyGroupInterface group = this.getGroupForKey(key);
        if (group != null) {
            ret = group.getProperty(VISIBLE, defaultValue);
        }
        return ret;
    }

    protected FwkPropertyGroupInterface getGroupForKey(String key) {
        FwkPropertyGroupInterface ret = this.valuePropGroup.getGroup(key);
        if (ret == null && (ret = this.valuePropGroup.getGroup(APPLICATIONATTRIBUTE)) != null) {
            ret = ret.getGroup(key);
        }
        return ret;
    }

    protected FwkPropertyGroupInterface createGroupForKey(String key) {
        FwkPropertyGroupInterface ret = this.getGroupForKey(key);
        if (ret == null) {
            ret = new FwkPropertyGroup();
            ret.setName(key);
            ret.setProperty(NAME, key);
            ret.setProperty(VALUE, key);
            ret.setProperty(VISIBLE, "true");
            ret.setProperty(ENABLED, "false");
            this.valuePropGroup.put((Object)("ApplicationAttribute." + key), (Object)ret);
        }
        return ret;
    }

    protected FwkPropertyGroupInterface getGroupForElement(OdsxPresentableElementInterface elem) {
        FwkPropertyGroupInterface ret = null;
        if (elem.valueIsA(ApplicationElement.class)) {
            ret = this.valuePropGroup.getGroup(APPLICATIONELEMENT);
            if (ret == null) {
                ret = new FwkPropertyGroup();
                ret.setName(APPLICATIONELEMENT);
                this.valuePropGroup.put((Object)APPLICATIONELEMENT, (Object)ret);
            }
        } else if (elem.valueIsA(InstanceElement.class)) {
            ret = this.valuePropGroup.getGroup(INSTANCEELEMENT);
        } else if (elem.valueIsA(BaseElement.class) && (ret = this.valuePropGroup.getGroup(BASEELEMENT)) == null) {
            ret = new FwkPropertyGroup();
            ret.setName(BASEELEMENT);
            this.valuePropGroup.put((Object)BASEELEMENT, (Object)ret);
        }
        if (ret != null) {
            ret = ret.getGroup(elem.getShortName());
        }
        return ret;
    }

    protected FwkPropertyGroupInterface createGroupForElement(OdsxPresentableElementInterface elem) {
        FwkPropertyGroupInterface ret = this.getGroupForElement(elem);
        if (ret == null) {
            ret = new FwkPropertyGroup();
            String name = elem.getShortName();
            ret.setName(name);
            ret.setProperty(NAME, name);
            ret.setProperty(VALUE, name);
            ret.setProperty(VISIBLE, "true");
            ret.setProperty(ENABLED, "true");
            if (elem.valueIsA(ApplicationElement.class)) {
                this.valuePropGroup.put((Object)("ApplicationElement." + name), (Object)ret);
            } else if (elem.valueIsA(InstanceElement.class)) {
                this.valuePropGroup.put((Object)("InstanceElement." + name), (Object)ret);
            } else if (elem.valueIsA(BaseElement.class)) {
                this.valuePropGroup.put((Object)("BaseElement." + name), (Object)ret);
            } else {
                this.valuePropGroup.put((Object)name, (Object)ret);
            }
        }
        return ret;
    }

    public FwkIconInterface getIcon(OdsxPresentableElementInterface elem) {
        if (elem instanceof OdsxRecursiveApplicationElement) {
            return FwkIconFile.getIcon((String)"Recursive");
        }
        return FwkIconFile.getIcon((String)elem.getBaseName());
    }

    public void setIcon(OdsxPresentableElementInterface elem, FwkIconInterface icon) {
    }

    public Color getColor(OdsxPresentableElementInterface elem) {
        if (elem instanceof OdsxInstanceElementInterface) {
            return this.INSTANCE_ELEMENT_COLOR;
        }
        if (elem instanceof OdsxApplicationElementInterface) {
            return this.APPLICATION_ELEMENT_COLOR;
        }
        if (elem instanceof OdsxColumnInterface) {
            return this.COLUMN_COLOR;
        }
        return this.DEFAULT_COLOR;
    }

    public void setColor(OdsxPresentableElementInterface elem, Color color) {
    }

    public String getTranslatedName(OdsxPresentableElementInterface elem) {
        String val;
        String ret = elem.getShortName();
        if (!this.getEnabled()) {
            return ret;
        }
        FwkPropertyGroupInterface group = this.getGroupForElement(elem);
        if (group != null && (val = group.getProperty(VALUE)) != null) {
            ret = val;
        }
        return ret;
    }

    public String getTranslatedKey(String key, String defaultValue) {
        String ret = defaultValue;
        if (!this.getEnabled()) {
            return ret;
        }
        FwkPropertyGroupInterface group = this.getGroupForKey(key);
        if (group != null) {
            ret = group.getProperty(VALUE, defaultValue);
        }
        return ret;
    }

    public OdsxFilterValueInterface getValue(String key) {
        OdsxFilterValue ret = new OdsxFilterValue();
        FwkPropertyGroupInterface group = this.getGroupForKey(key);
        if (group != null) {
            ret.setName(group.getProperty(NAME, key));
            ret.setTranslatedValue(group.getProperty(VALUE, key));
            ret.setVisible(group.getProperty(VISIBLE, true));
            ret.setEnabled(group.getProperty(ENABLED, true));
        } else {
            ret.setName(key);
            ret.setTranslatedValue(key);
        }
        return ret;
    }

    public void setValue(String group, OdsxFilterValueInterface value) {
        FwkPropertyGroup valueGroup = new FwkPropertyGroup();
        valueGroup.setName(value.getName());
        valueGroup.setProperty(NAME, value.getName());
        valueGroup.setProperty(VALUE, value.getTranslatedValue());
        valueGroup.setProperty(VISIBLE, value.getVisible());
        valueGroup.setProperty(ENABLED, value.getEnabled());
        this.valuePropGroup.addGroup(group + "." + value.getName(), (FwkPropertyGroupInterface)valueGroup);
    }

    public void setTranslatedKey(String key, String value) {
        FwkPropertyGroupInterface group = this.getGroupForKey(key);
        if (group == null) {
            group = this.createGroupForKey(key);
        }
        group.setProperty(VALUE, value);
    }

    public boolean getRecursiveApplStructEnabled() {
        return this.recursiveApplStruct;
    }

    public void setRecursiveApplStructEnabled(boolean flag) {
        boolean old = this.recursiveApplStruct;
        if (old != flag) {
            this.recursiveApplStruct = flag;
            this.firePropertyChange("RecursiveApplStructEnabled", old, flag);
        }
    }

    public void setEnabled(OdsxPresentableElementInterface elem, boolean flag) {
        if (!elem.valueIsA(InstanceElement.class)) {
            FwkPropertyGroupInterface group = this.getGroupForElement(elem);
            if (group == null) {
                group = this.createGroupForElement(elem);
            }
            group.setProperty(ENABLED, "" + flag);
            this.firePropertyChange("Filter", this, this);
        }
    }

    public void setVisible(OdsxPresentableElementInterface elem, boolean flag) {
        if (!elem.valueIsA(InstanceElement.class)) {
            FwkPropertyGroupInterface group = this.getGroupForElement(elem);
            if (group == null) {
                group = this.createGroupForElement(elem);
            }
            group.setProperty(VISIBLE, "" + flag);
            this.firePropertyChange("Filter", this, this);
        }
    }

    public void setTranslatedName(OdsxPresentableElementInterface elem, String value) {
        if (!elem.valueIsA(InstanceElement.class)) {
            FwkPropertyGroupInterface group = this.getGroupForElement(elem);
            if (group == null) {
                group = this.createGroupForElement(elem);
            }
            group.setProperty(VALUE, value);
            this.firePropertyChange("Filter", this, this);
        }
    }

    public void delete(OdsxPresentableElementInterface elem) {
        if (!elem.valueIsA(InstanceElement.class)) {
            String key = elem.getShortName();
            FwkPropertyGroupInterface group = this.valuePropGroup.getGroup(key);
            if (group == null) {
                key = elem.getName();
                group = this.valuePropGroup.getGroup(key);
                if (group != null) {
                    this.valuePropGroup.removeGroup(key);
                }
            } else {
                this.valuePropGroup.removeGroup(key);
            }
            if (group != null) {
                this.firePropertyChange("Delete", key, null);
            }
        }
    }

    public Map getBaseElementMap() {
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        FwkPropertyGroupInterface be = this.getBaseElementGroup();
        Enumeration e = be.groupNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ret.put(key, new Boolean(be.getProperty(key + ".Visible", key.compareTo("AoAny") != 0)));
        }
        return ret;
    }

    public FwkPropertyGroupInterface getBaseElementGroup() {
        FwkPropertyGroupInterface grp = this.valuePropGroup.getGroup(BASEELEMENT);
        FwkPropertyGroup ret = new FwkPropertyGroup();
        if (grp != null) {
            Enumeration e = grp.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                ret.setProperty(key, grp.getProperty(key));
            }
        }
        return ret;
    }

    public synchronized void setBaseElementMap(Map map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            this.valuePropGroup.setProperty("BaseElement." + key + ".Visible", "" + map.get(key));
        }
        this.firePropertyChange(BASEELEMENTMAP_NAME, null, null);
    }

    public synchronized void setBaseElementGroup(FwkPropertyGroupInterface group) {
        Enumeration e = group.groupNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String prefix = "BaseElement." + key;
            this.valuePropGroup.setProperty(prefix + ".Name", group.getProperty(key + ".Name", key));
            this.valuePropGroup.setProperty(prefix + ".Value", group.getProperty(key + ".Value", key));
            this.valuePropGroup.setProperty(prefix + ".Visible", "" + group.getProperty(key + ".Visible", false));
            this.valuePropGroup.setProperty(prefix + ".Enabled", "" + group.getProperty(key + ".Enabled", false));
        }
    }

    public boolean destroyController() {
        return true;
    }

    public void addCommand(OdsxPresentableElementInterface presentable, FwkCommandInterface command) {
        presentable.addCommand(command);
    }

    public void addCommand(OdsxPresentableElementInterface presentable, int index, FwkCommandInterface command) {
        presentable.addCommand(index, command);
    }

    public FwkCommandInterface getCommand(OdsxPresentableElementInterface presentable, String commandName) {
        return presentable.getCommand(commandName);
    }

    public FwkCommandInterface[] getCommands(OdsxPresentableElementInterface presentable) {
        FwkCommandInterface[] ret = presentable.getCommands();
        return ret;
    }

    public synchronized void removeCommand(OdsxPresentableElementInterface presentable, FwkCommandInterface command) {
        presentable.removeCommand(command);
    }

    public void setCommands(OdsxPresentableElementInterface presentable, FwkCommandInterface[] commands) {
        presentable.setCommands(commands);
    }

    public boolean commandsAvailable(OdsxPresentableElementInterface presentable) {
        return presentable.commandsAvailable();
    }

    public void addToGroup(OdsxPresentableElementInterface presentable, int index, String groupIdent, String commandName) {
        presentable.addToGroup(index, groupIdent, commandName);
    }

    public void addToGroup(OdsxPresentableElementInterface presentable, String groupIdent, String commandName) {
        presentable.addToGroup(groupIdent, commandName);
    }

    public void removeFromGroup(OdsxPresentableElementInterface presentable, String groupIdent, String commandName) {
        presentable.removeFromGroup(groupIdent, commandName);
    }

    public void deleteGroup(OdsxPresentableElementInterface presentable, String groupIdent) {
        presentable.deleteGroup(groupIdent);
    }

    public FwkCommandInterface[] getGroup(OdsxPresentableElementInterface presentable, String groupIdent) {
        return presentable.getGroup(groupIdent);
    }

    public boolean groupExists(OdsxPresentableElementInterface presentable, String groupIdent) {
        return presentable.groupExists(groupIdent);
    }

    public Object readConstructor(Document document, Element node) {
        return FwkDOMHandler.readConstructor((Object)this, (Document)document, (Element)node);
    }

    public void readFromDOM(Document doc, Element element) {
        this.readingDOM(true);
        this.clearCommands();
        FwkControllerInterface controller = this.getController();
        try {
            this.setController(this);
            FwkDOMHandler.readCommandsFromDOM((FwkInstructionInterface)this, (Document)doc, (Element)element);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.setController(controller);
        this.setEnabled(true);
        FwkCommandInterface cmd = this.getCommand(ENABLED);
        if (cmd != null) {
            cmd.setToggleState(!this.getEnabled());
        }
        this.firePropertyChange("TranslatedName", null, null);
        this.readingDOM(false);
    }

    public Element writeConstructor(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        return FwkDOMHandler.writeConstructor((Object)this, (String)"Object", (boolean)true, (Document)document, (FwkXmlDtdInterface)dtd, (Node)node, (Map)classProperties, (boolean)false);
    }

    public Element writeToDOM(Document document, FwkXmlDtdInterface dtd, Node node, Map classProperties) {
        Element thisNode = this.writeConstructor(document, dtd, node, classProperties);
        try {
            FwkDOMHandler.writeCommandsToDOM((FwkCommandInterface[])this.getCommands(), (Document)document, (FwkXmlDtdInterface)dtd, (Element)thisNode, null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return thisNode;
    }

    public boolean writeToXML(String filename, boolean validate) {
        return FwkDOMHandler.writeToXML((FwkDOMHandlerInterface)this, (String)filename, (Class)FwkXmlInterpreter.class, (boolean)validate);
    }

    public void readingDOM(boolean flag) {
        this.readingDOM = flag;
    }

    public boolean readingDOM() {
        return this.readingDOM;
    }

    public String visibleKey() {
        return VISIBLE;
    }

    public String enableKey() {
        return ENABLED;
    }

    public String valueKey() {
        return VALUE;
    }

    public String nameKey() {
        return NAME;
    }

    public boolean isEditable(String key) {
        boolean ret = true;
        if (key.startsWith(BASEELEMENT) && key.endsWith(VALUE)) {
            ret = false;
        }
        return ret;
    }

    public String toString() {
        return this.valuePropGroup.toString();
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("An ASAM-ODS Filter");
        descriptor.setTitleName("OdsxFilter");
        descriptor.setName(OdsxFilter.class.getName());
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:09 $", null);
    }
}

