/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPersistence;
import com.highqsoft.fwk.factory.FwkInfoBusProducerFactory;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSelectorInterface;
import com.highqsoft.interfaces.odsx.OdsxSelectorTreeNodeInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionElementInterface;
import com.highqsoft.odsx.OdsxInstanceElement;
import com.highqsoft.odsx.OdsxRecursiveApplicationElement;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OdsxFilteredTreeNode
extends FwkPersistence
implements Cloneable,
MutableTreeNode,
Serializable,
OdsxSelectorTreeNodeInterface {
    public static final String version = "$Revision: 1.6 $";
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("No more elements");
        }
    };
    protected OdsxSelectorTreeNodeInterface parent = null;
    protected Vector children;
    protected OdsxSelectorTreeNodeInterface[] visibleChildren;
    protected transient OdsxPresentableElementInterface presentable;
    protected OdsxSelectorInterface odsSelector = null;
    protected Object userObject;
    protected OdsxFilterInterface odsFilter;
    protected boolean allowsChildren;
    protected boolean isLeaf = false;
    protected boolean isLoaded = false;

    public String getVersion() {
        return version;
    }

    public OdsxFilteredTreeNode() {
        this(null);
    }

    public OdsxFilteredTreeNode(OdsxPresentableElementInterface presentable) {
        this(presentable, null, null, true);
    }

    public OdsxFilteredTreeNode(OdsxPresentableElementInterface presentable, OdsxFilterInterface odsFilter) {
        this(presentable, odsFilter, null, true);
    }

    public OdsxFilteredTreeNode(OdsxPresentableElementInterface presentable, OdsxFilterInterface odsFilter, OdsxSelectorInterface odsSelector) {
        this(presentable, odsFilter, odsSelector, true);
    }

    public OdsxFilteredTreeNode(OdsxPresentableElementInterface presentable, OdsxFilterInterface odsFilter, OdsxSelectorInterface odsSelector, boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
        this.presentable = presentable;
        this.odsFilter = odsFilter;
        if (odsFilter != null) {
            // empty if block
        }
        this.odsSelector = odsSelector;
        if (presentable instanceof OdsxSessionElementInterface) {
            this.children();
        }
    }

    public void firePropertyChange(String propName) {
        ((OdsxSelectorTreeNodeInterface)this.getRoot()).firePropertyChange(propName, this, this);
    }

    public void setColor(Color color) {
        if (this.presentable != null) {
            this.odsFilter.setColor(this.presentable, color);
            this.firePropertyChange("Color");
        }
    }

    public Color getColor() {
        Color ret = Color.black;
        if (this.presentable != null && this.odsFilter != null) {
            ret = this.odsFilter.getColor(this.presentable);
        }
        return ret;
    }

    public boolean isEnabled() {
        boolean ret = true;
        if (this.presentable != null) {
            if (this.odsFilter != null && this.odsFilter.getEnabled()) {
                ret = this.odsFilter.isEnabled(this.presentable);
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public boolean isVisible() {
        boolean ret = true;
        if (this.presentable != null) {
            if (this.odsFilter != null && this.odsFilter.getEnabled()) {
                ret = this.odsFilter.isVisible(this.presentable);
            }
        } else {
            ret = false;
        }
        return ret;
    }

    public void setVisible(boolean flag) {
        if (this.odsFilter != null && this.presentable != null) {
            this.odsFilter.setVisible(this.presentable, flag);
            this.firePropertyChange("Visible");
        }
    }

    public String getTranslatedName() {
        if (this.odsFilter != null) {
            String version = null;
            if (this.presentable != null) {
                version = this.presentable.getODSVersion();
            }
            if (this.presentable != null) {
                if (version == null) {
                    return this.odsFilter.getTranslatedName(this.presentable);
                }
                return this.odsFilter.getTranslatedName(this.presentable) + ";" + version;
            }
        } else {
            String version = null;
            if (this.presentable != null) {
                version = this.presentable.getODSVersion();
            }
            if (this.presentable != null) {
                if (version == null) {
                    return this.presentable.getShortName();
                }
                return this.presentable.getShortName() + ";" + version;
            }
        }
        return this.toString();
    }

    public void setTranslatedName(String value) {
        if (this.presentable != null && this.odsFilter != null) {
            this.odsFilter.setTranslatedName(this.presentable, value);
            this.firePropertyChange("TranslatedName");
        }
    }

    public boolean isInstanceElement() {
        return this.presentable instanceof OdsxInstanceElementInterface;
    }

    public boolean isColumn() {
        return this.presentable instanceof OdsxColumnInterface;
    }

    public boolean isApplicationElement() {
        return this.presentable instanceof OdsxApplicationElementInterface;
    }

    public boolean isSessionElement() {
        return this.presentable instanceof OdsxSessionElementInterface;
    }

    public void delete(boolean flag) {
        if (this.isInstanceElement()) {
            ((OdsxInstanceElement)this.presentable).delete(flag);
        }
        this.odsFilter.delete(this.presentable);
        FwkInfoBusProducerFactory.getInstance().revokeFromAll(this.presentable.getName(), FwkContainer.getDataFlavor(this.presentable.getClass()));
        this.firePropertyChange("Delete");
    }

    public boolean isLeaf() {
        if (this.isLeaf) {
            return this.getChildCount() == 0;
        }
        return false;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    protected void loadChildren() {
        Vector childList;
        if (this.children != null) {
            this.children.clear();
        }
        if ((childList = this.presentable.getElements()) != null && childList.size() != 0) {
            int size = childList.size();
            int count = 0;
            for (int j = 0; j < size; ++j) {
                OdsxPresentableElementInterface presentable = (OdsxPresentableElementInterface)childList.get(j);
                presentable.setSource((FwkInterface)this);
                presentable.setOdsxFilter(this.odsFilter);
                OdsxFilteredTreeNode newNode = new OdsxFilteredTreeNode(presentable, this.odsFilter, this.odsSelector);
                boolean bl = this.isLeaf = !newNode.isEnabled();
                if (presentable instanceof OdsxRecursiveApplicationElement) {
                    newNode.isLeaf = true;
                }
                this.insert(newNode, count++);
            }
        } else {
            this.isLeaf = true;
        }
        this.isLoaded = true;
    }

    public void insert(MutableTreeNode newChild, int childIndex) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        if (!(newChild instanceof OdsxFilteredTreeNode)) {
            throw new IllegalArgumentException("new child is not an instance OdsxFilteredTreeNode");
        }
        OdsxFilteredTreeNode oldParent = (OdsxFilteredTreeNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    public void remove(int childIndex) {
        OdsxFilteredTreeNode child = (OdsxFilteredTreeNode)this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.parent = null;
        child = null;
    }

    public void setParent(MutableTreeNode newParent) {
        if (!(newParent instanceof OdsxSelectorTreeNodeInterface)) {
            throw new IllegalArgumentException("parent is not an instance OdsxSelectorTreeNodeInterface");
        }
        this.parent = (OdsxSelectorTreeNodeInterface)newParent;
        this.firePropertyChange("Parent");
    }

    public TreeNode getParent() {
        return this.parent;
    }

    protected void loadVisibleChildren() {
        if (this.visibleChildren == null) {
            Enumeration enumeration = this.children();
            Vector arr = new Vector();
            while (enumeration.hasMoreElements()) {
                arr.add(enumeration.nextElement());
            }
            int size = arr.size();
            this.visibleChildren = new OdsxSelectorTreeNodeInterface[size];
            if (size > 0) {
                this.visibleChildren = arr.toArray(this.visibleChildren);
                Arrays.sort(this.visibleChildren);
            }
        }
    }

    public void reloadChildren() {
        this.reloadChildren(false);
    }

    public void reloadChildren(boolean enforce) {
        if (enforce || this.isLoaded && !this.isLeaf) {
            this.children = null;
            this.loadChildren();
            if (this.children != null) {
                int count = this.children.size();
                while (--count >= 0) {
                    OdsxSelectorTreeNodeInterface child = (OdsxSelectorTreeNodeInterface)this.children.get(count);
                    child.reloadChildren();
                }
            }
            this.visibleChildren = null;
            this.loadVisibleChildren();
        }
    }

    public TreeNode getChildAt(int index) {
        if (!this.isLoaded) {
            this.loadChildren();
        }
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        if (this.visibleChildren == null) {
            this.loadVisibleChildren();
        }
        return this.visibleChildren[index];
    }

    public int getChildCount() {
        if (!this.isLoaded) {
            this.loadChildren();
        }
        if (this.children == null) {
            return 0;
        }
        if (this.visibleChildren == null) {
            this.loadVisibleChildren();
        }
        return this.visibleChildren.length;
    }

    public int getIndex(TreeNode aChild) {
        if (!this.isLoaded) {
            this.loadChildren();
        }
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (this.visibleChildren == null) {
            this.loadVisibleChildren();
        }
        int ret = -1;
        if (this.visibleChildren != null && this.visibleChildren.length != 0) {
            int count;
            OdsxFilteredTreeNode node = (OdsxFilteredTreeNode)aChild;
            OdsxPresentableElementInterface elem = node.getPresentableElement();
            int size = this.visibleChildren.length;
            for (count = 0; count < size && !this.visibleChildren[count].getPresentableElement().isTheSame(elem); ++count) {
            }
            if (count >= 0 || count < size) {
                ret = count;
            }
        }
        return ret;
    }

    public Enumeration children() {
        if (!this.isLoaded) {
            this.loadChildren();
        }
        if (this.children == null) {
            return EMPTY_ENUMERATION;
        }
        if (this.odsFilter == null) {
            return this.children.elements();
        }
        return new Enumeration(){
            int count = 0;

            public boolean hasMoreElements() {
                boolean found = false;
                int next = this.count;
                int size = OdsxFilteredTreeNode.this.children.size();
                while (!found && next < size) {
                    OdsxFilteredTreeNode node = (OdsxFilteredTreeNode)OdsxFilteredTreeNode.this.children.get(next++);
                    found = OdsxFilteredTreeNode.this.odsFilter.isVisible(node.presentable);
                }
                return found;
            }

            public Object nextElement() {
                Vector vector = OdsxFilteredTreeNode.this.children;
                synchronized (vector) {
                    boolean found = false;
                    int next = this.count;
                    int size = OdsxFilteredTreeNode.this.children.size();
                    while (!found && next < size) {
                        OdsxFilteredTreeNode node = (OdsxFilteredTreeNode)OdsxFilteredTreeNode.this.children.get(next);
                        found = OdsxFilteredTreeNode.this.odsFilter.isVisible(node.presentable);
                        if (found) continue;
                        ++next;
                    }
                    if (found) {
                        this.count = next + 1;
                        return OdsxFilteredTreeNode.this.children.get(next);
                    }
                    throw new NoSuchElementException("Vector Enumeration");
                }
            }
        };
    }

    public void setAllowsChildren(boolean allows) {
        if (allows != this.allowsChildren) {
            this.allowsChildren = allows;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
            this.firePropertyChange("AllowsChildren");
        }
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setPresentableElement(OdsxPresentableElementInterface presentable) {
        if (this.presentable != null) {
            // empty if block
        }
        if (presentable != null) {
            // empty if block
        }
        OdsxPresentableElementInterface old = this.presentable;
        this.presentable = presentable;
        ((OdsxSelectorTreeNodeInterface)this.getRoot()).firePropertyChange("PresentableElement", old, presentable);
    }

    public OdsxPresentableElementInterface getPresentableElement() {
        return this.presentable;
    }

    public void setFilter(OdsxFilterInterface odsFilter) {
        this.setFilter(odsFilter, false);
    }

    public void setFilter(OdsxFilterInterface odsFilter, boolean flag) {
        this.odsFilter = odsFilter;
        if (flag && this.children != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                OdsxFilteredTreeNode child = (OdsxFilteredTreeNode)enumeration.nextElement();
                child.setFilter(odsFilter, flag);
            }
        }
        this.firePropertyChange("Filter");
    }

    public OdsxFilterInterface getFilter() {
        return this.odsFilter;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
        this.firePropertyChange("UserObject");
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        OdsxFilteredTreeNode parent = (OdsxFilteredTreeNode)this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    public void remove(MutableTreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!(aChild instanceof OdsxFilteredTreeNode)) {
            throw new IllegalArgumentException("argument is not an instance of OdsxFilteredTreeNode");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    public void removeAllChildren() {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void add(OdsxFilteredTreeNode newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public boolean isNodeAncestor(TreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        TreeNode ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public boolean isNodeDescendant(OdsxFilteredTreeNode anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        return anotherNode.isNodeAncestor(this);
    }

    public TreeNode getSharedAncestor(OdsxFilteredTreeNode aNode) {
        TreeNode node2;
        TreeNode node1;
        int diff;
        if (aNode == this) {
            return this;
        }
        if (aNode == null) {
            return null;
        }
        int level1 = this.getLevel();
        int level2 = aNode.getLevel();
        if (level2 > level1) {
            diff = level2 - level1;
            node1 = aNode;
            node2 = this;
        } else {
            diff = level1 - level2;
            node1 = this;
            node2 = aNode;
        }
        while (diff > 0) {
            node1 = node1.getParent();
            --diff;
        }
        do {
            if (node1 == node2) {
                return node1;
            }
            node1 = node1.getParent();
            node2 = node2.getParent();
        } while (node1 != null);
        if (node1 != null || node2 != null) {
            throw new Error("nodes should be null");
        }
        return null;
    }

    public boolean isNodeRelated(OdsxFilteredTreeNode aNode) {
        return aNode != null && this.getRoot() == aNode.getRoot();
    }

    public int getDepth() {
        Object last = null;
        Enumeration enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            last = enumeration.nextElement();
        }
        if (last == null) {
            throw new Error("nodes should be null");
        }
        return ((OdsxFilteredTreeNode)last).getLevel() - this.getLevel();
    }

    public int getLevel() {
        int levels = 0;
        TreeNode ancestor = this;
        while ((ancestor = ancestor.getParent()) != null) {
            ++levels;
        }
        return levels;
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public Object[] getPresentablePath() {
        TreeNode[] realPath = this.getPath();
        Object[] retPath = new Object[realPath.length];
        for (int counter = 0; counter < realPath.length; ++counter) {
            retPath[counter] = ((OdsxFilteredTreeNode)realPath[counter]).getPresentableElement();
        }
        return retPath;
    }

    public int getChildIndexByPath(TreePath path) {
        int ret = -1;
        if (this.visibleChildren != null && this.visibleChildren.length != 0) {
            int count;
            OdsxFilteredTreeNode node = (OdsxFilteredTreeNode)path.getLastPathComponent();
            OdsxPresentableElementInterface elem = node.getPresentableElement();
            int size = this.visibleChildren.length;
            for (count = 0; count < size && !this.visibleChildren[count].getPresentableElement().isTheSame(elem); ++count) {
            }
            if (count >= 0 || count < size) {
                ret = count;
            }
        }
        return ret;
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public Object[] getUserObjectPath() {
        TreeNode[] realPath = this.getPath();
        Object[] retPath = new Object[realPath.length];
        for (int counter = 0; counter < realPath.length; ++counter) {
            retPath[counter] = ((OdsxFilteredTreeNode)realPath[counter]).getUserObject();
        }
        return retPath;
    }

    public TreeNode getRoot() {
        OdsxFilteredTreeNode previous;
        TreeNode ancestor = this;
        do {
            previous = ancestor;
        } while ((ancestor = ancestor.getParent()) != null);
        return previous;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public OdsxFilteredTreeNode getNextNode() {
        if (this.getChildCount() == 0) {
            OdsxFilteredTreeNode nextSibling = this.getNextSibling();
            if (nextSibling == null) {
                OdsxFilteredTreeNode aNode = (OdsxFilteredTreeNode)this.getParent();
                while (true) {
                    if (aNode == null) {
                        return null;
                    }
                    nextSibling = aNode.getNextSibling();
                    if (nextSibling != null) {
                        return nextSibling;
                    }
                    aNode = (OdsxFilteredTreeNode)aNode.getParent();
                }
            }
            return nextSibling;
        }
        return (OdsxFilteredTreeNode)this.getChildAt(0);
    }

    public OdsxFilteredTreeNode getPreviousNode() {
        OdsxFilteredTreeNode myParent = (OdsxFilteredTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        OdsxFilteredTreeNode previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            if (previousSibling.getChildCount() == 0) {
                return previousSibling;
            }
            return previousSibling.getLastLeaf();
        }
        return myParent;
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode ancestor) {
        return new PathBetweenNodesEnumeration(ancestor, this);
    }

    public boolean isNodeChild(TreeNode aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public TreeNode getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(0);
    }

    public TreeNode getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    public TreeNode getChildAfter(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("node is not a child");
        }
        if (index < this.getChildCount() - 1) {
            return this.getChildAt(index + 1);
        }
        return null;
    }

    public TreeNode getChildBefore(TreeNode aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (index > 0) {
            return this.getChildAt(index - 1);
        }
        return null;
    }

    public boolean isNodeSibling(TreeNode anotherNode) {
        boolean retval;
        if (anotherNode == null) {
            retval = false;
        } else if (anotherNode == this) {
            retval = true;
        } else {
            TreeNode myParent = this.getParent();
            boolean bl = retval = myParent != null && myParent == anotherNode.getParent();
            if (retval && !((OdsxFilteredTreeNode)this.getParent()).isNodeChild(anotherNode)) {
                throw new Error("sibling has different parent");
            }
        }
        return retval;
    }

    public int getSiblingCount() {
        TreeNode myParent = this.getParent();
        if (myParent == null) {
            return 1;
        }
        return myParent.getChildCount();
    }

    public OdsxFilteredTreeNode getNextSibling() {
        OdsxFilteredTreeNode myParent = (OdsxFilteredTreeNode)this.getParent();
        OdsxFilteredTreeNode retval = myParent == null ? null : (OdsxFilteredTreeNode)myParent.getChildAfter(this);
        if (retval != null && !this.isNodeSibling(retval)) {
            throw new Error("child of parent is not a sibling");
        }
        return retval;
    }

    public OdsxFilteredTreeNode getPreviousSibling() {
        OdsxFilteredTreeNode myParent = (OdsxFilteredTreeNode)this.getParent();
        OdsxFilteredTreeNode retval = myParent == null ? null : (OdsxFilteredTreeNode)myParent.getChildBefore(this);
        if (retval != null && !this.isNodeSibling(retval)) {
            throw new Error("child of parent is not a sibling");
        }
        return retval;
    }

    public OdsxFilteredTreeNode getFirstLeaf() {
        OdsxFilteredTreeNode node = this;
        while (!node.isLeaf()) {
            node = (OdsxFilteredTreeNode)node.getFirstChild();
        }
        return node;
    }

    public OdsxFilteredTreeNode getLastLeaf() {
        OdsxFilteredTreeNode node = this;
        while (!node.isLeaf()) {
            node = (OdsxFilteredTreeNode)node.getLastChild();
        }
        return node;
    }

    public OdsxFilteredTreeNode getNextLeaf() {
        OdsxFilteredTreeNode myParent = (OdsxFilteredTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        OdsxFilteredTreeNode nextSibling = this.getNextSibling();
        if (nextSibling != null) {
            return nextSibling.getFirstLeaf();
        }
        return myParent.getNextLeaf();
    }

    public OdsxFilteredTreeNode getPreviousLeaf() {
        OdsxFilteredTreeNode myParent = (OdsxFilteredTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        OdsxFilteredTreeNode previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            return previousSibling.getLastLeaf();
        }
        return myParent.getPreviousLeaf();
    }

    public int getLeafCount() {
        int count = 0;
        Enumeration enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            TreeNode node = (TreeNode)enumeration.nextElement();
            if (!node.isLeaf()) continue;
            ++count;
        }
        if (count < 1) {
            throw new Error("tree has zero leaves");
        }
        return count;
    }

    public String toString() {
        if (this.presentable == null) {
            return null;
        }
        return this.presentable.toString();
    }

    public Object clone() {
        OdsxFilteredTreeNode newNode = null;
        try {
            newNode = (OdsxFilteredTreeNode)super.clone();
            newNode.children = null;
            newNode.parent = null;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.toString());
        }
        return newNode;
    }

    public void propertyChange(PropertyChangeEvent ev) {
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] tValues = this.presentable != null && this.presentable instanceof Serializable ? new Object[]{"PresentableElement", this.presentable} : new Object[]{};
        s.writeObject(tValues);
        tValues = this.userObject != null && this.userObject instanceof Serializable ? new Object[]{"UserObject", this.userObject} : new Object[]{};
        s.writeObject(tValues);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object[] tValues = (Object[])s.readObject();
        if (tValues.length > 0 && tValues[0].equals("PresentableElement")) {
            try {
                this.presentable = (OdsxPresentableElementInterface)tValues[1];
            }
            catch (Throwable t) {
                this.presentable = null;
            }
        }
        if ((tValues = (Object[])s.readObject()).length > 0 && tValues[0].equals("UserObject")) {
            this.userObject = tValues[1];
        }
    }

    public int compareTo(Object obj) {
        OdsxFilteredTreeNode node = (OdsxFilteredTreeNode)obj;
        if (this.isSessionElement() && !node.isSessionElement()) {
            return Integer.MIN_VALUE;
        }
        if (this.isApplicationElement() && !node.isApplicationElement()) {
            return -2147483647;
        }
        if (this.isInstanceElement() && !node.isInstanceElement()) {
            return -2147483646;
        }
        return this.getTranslatedName().compareTo(node.getTranslatedName());
    }

    public String getAuthor() {
        return this.presentable.getAuthor();
    }

    public String getBuild() {
        return this.presentable.getBuild();
    }

    public String getCompany() {
        return this.presentable.getCompany();
    }

    public String getCompanyInternetAddress() {
        return this.presentable.getCompanyInternetAddress();
    }

    public String getCopyright() {
        return this.presentable.getCopyright();
    }

    public String getCreationDate() {
        return this.presentable.getCreationDate();
    }

    public String getCreationDate(String formatString) {
        return this.presentable.getCreationDate(formatString);
    }

    public String getDateFormatString() {
        return this.presentable.getDateFormatString();
    }

    public String getDescription() {
        return this.presentable.getDescription();
    }

    public FwkIconInterface getIcon() {
        FwkIconInterface ret = null;
        if (this.odsFilter != null) {
            ret = this.odsFilter.getIcon(this.presentable);
        }
        return ret;
    }

    public FwkIconInterface getIcon(int type) {
        return this.presentable.getIcon(type);
    }

    public String getIconKey() {
        return this.presentable.getIconKey();
    }

    public String getIconKey(int type) {
        return this.presentable.getIconKey(type);
    }

    public String getName() {
        return this.getTranslatedName();
    }

    public String getPresentationString(Locale locale) {
        return this.presentable.getPresentationString(locale);
    }

    public String getPresentationString() {
        return this.presentable.getPresentationString(FwkContainer.getLocale());
    }

    public String getSupportEMail() {
        return this.presentable.getSupportEMail();
    }

    public String getTitle() {
        return this.presentable.getTitle();
    }

    public String getTitleName() {
        return this.presentable.getTitleName();
    }

    public void setAuthor(String author) {
        this.presentable.setAuthor(author);
        this.firePropertyChange("Author");
    }

    public void setBuild(String buildnr) {
        this.presentable.setBuild(buildnr);
        this.firePropertyChange("Build");
    }

    public void setCompany(String company) {
        this.presentable.setCompany(company);
        this.firePropertyChange("Company");
    }

    public void setCompanyInternetAddress(String address) {
        this.presentable.setCompanyInternetAddress(address);
        this.firePropertyChange("CompanyInternetAddress");
    }

    public void setCopyright(String copyright) {
        this.presentable.setCopyright(copyright);
        this.firePropertyChange("Copyright");
    }

    public void setCreationDate(String dateString, String formatString) {
        this.presentable.setCreationDate(dateString, formatString);
        this.firePropertyChange("CreationDate");
    }

    public void setDateFormatString(String formatString) {
        this.presentable.setDateFormatString(formatString);
        this.firePropertyChange("DateFormatString");
    }

    public void setDescription(String description) {
        this.presentable.setDescription(description);
        this.firePropertyChange("Description");
    }

    public void setDescriptor(FwkDescriptionInterface descriptor) throws FwkException {
        this.presentable.setDescriptor(descriptor);
        this.firePropertyChange("Descriptor");
    }

    public void setIcon(FwkIconInterface icon) {
        this.presentable.setIcon(icon);
        this.firePropertyChange("Icon");
    }

    public void setIcon(FwkIconInterface icon, int type) {
        this.presentable.setIcon(icon, type);
        this.firePropertyChange("Icon");
    }

    public void setIconKey(String key) {
        this.presentable.setIconKey(key);
        this.firePropertyChange("IconKey");
    }

    public void setIconKey(String key, int type) {
        this.presentable.setIconKey(key, type);
        this.firePropertyChange("IconKey");
    }

    public void setName(String name) {
        this.presentable.setName(name);
        this.firePropertyChange("Name");
    }

    public void setSupportEMail(String eMail) {
        this.presentable.setSupportEMail(eMail);
        this.firePropertyChange("SupportEMail");
    }

    public void setTitleName(String titlename) {
        this.presentable.setTitleName(titlename);
        this.firePropertyChange("TitleName");
    }

    public void addCommand(FwkCommandInterface command) {
        if (this.odsFilter != null) {
            this.odsFilter.addCommand(this.presentable, command);
        } else {
            this.presentable.addCommand(command);
        }
    }

    public void addCommand(int index, FwkCommandInterface command) {
        if (this.odsFilter != null) {
            this.odsFilter.addCommand(this.presentable, index, command);
        } else {
            this.presentable.addCommand(index, command);
        }
    }

    public FwkCommandInterface getCommand(String commandName) {
        FwkCommandInterface cmds = this.odsFilter != null ? this.odsFilter.getCommand(this.presentable, commandName) : this.presentable.getCommand(commandName);
        cmds.setProperty(OdsxSelectorTreeNodeInterface.class.getName(), (Object)this);
        return cmds;
    }

    public FwkCommandInterface[] getCommands() {
        FwkCommandInterface[] cmds = this.odsFilter != null ? this.odsFilter.getCommands(this.presentable) : this.presentable.getCommands();
        this.setCommandProperties(cmds);
        return cmds;
    }

    protected void setCommandProperties(FwkCommandInterface[] commands) {
        if (commands != null) {
            int size = commands.length;
            String clazz = OdsxSelectorTreeNodeInterface.class.getName();
            if (commands[0].getProperty(clazz) == null) {
                while (size-- > 0) {
                    commands[size].setProperty(clazz, (Object)this);
                    this.setCommandProperties(commands[size].getCommands());
                }
            }
        }
    }

    public synchronized void removeCommand(FwkCommandInterface command) {
        if (this.odsFilter != null) {
            this.odsFilter.removeCommand(this.presentable, command);
        } else {
            this.presentable.removeCommand(command);
        }
    }

    public void setCommands(FwkCommandInterface[] commands) {
        if (this.odsFilter != null) {
            this.odsFilter.setCommands(this.presentable, commands);
        } else {
            this.presentable.setCommands(commands);
        }
    }

    public boolean commandsAvailable() {
        if (this.odsFilter != null) {
            return this.odsFilter.commandsAvailable(this.presentable);
        }
        return this.presentable.commandsAvailable();
    }

    public void addToGroup(int index, String groupIdent, String commandName) {
        if (this.odsFilter != null) {
            this.odsFilter.addToGroup(this.presentable, index, groupIdent, commandName);
        } else {
            this.presentable.addToGroup(index, groupIdent, commandName);
        }
    }

    public void addToGroup(String groupIdent, String commandName) {
        if (this.odsFilter != null) {
            this.odsFilter.addToGroup(this.presentable, groupIdent, commandName);
        } else {
            this.presentable.addToGroup(groupIdent, commandName);
        }
    }

    public void removeFromGroup(String groupIdent, String commandName) {
        if (this.odsFilter != null) {
            this.odsFilter.removeFromGroup(this.presentable, groupIdent, commandName);
        } else {
            this.presentable.removeFromGroup(groupIdent, commandName);
        }
    }

    public void deleteGroup(String groupIdent) {
        if (this.odsFilter != null) {
            this.odsFilter.deleteGroup(this.presentable, groupIdent);
        } else {
            this.presentable.deleteGroup(groupIdent);
        }
    }

    public FwkCommandInterface[] getGroup(String groupIdent) {
        if (this.odsFilter != null) {
            return this.odsFilter.getGroup(this.presentable, groupIdent);
        }
        return this.presentable.getGroup(groupIdent);
    }

    public boolean groupExists(String groupIdent) {
        if (this.odsFilter != null) {
            return this.odsFilter.groupExists(this.presentable, groupIdent);
        }
        return this.presentable.groupExists(groupIdent);
    }

    public static void main(String[] args) {
        FwkContainer.initialize((String[])args);
        FwkContainer.openFrame((String)"com.highqsoft.asamcommander.AsamCommander");
    }

    final class PathBetweenNodesEnumeration
    implements Enumeration {
        protected Stack stack;

        public PathBetweenNodesEnumeration(TreeNode ancestor, TreeNode descendant) {
            if (ancestor == null || descendant == null) {
                throw new IllegalArgumentException("argument is null");
            }
            this.stack = new Stack();
            this.stack.push(descendant);
            TreeNode current = descendant;
            while (current != ancestor) {
                if ((current = current.getParent()) == null && descendant != ancestor) {
                    throw new IllegalArgumentException("node " + ancestor + " is not an ancestor of " + descendant);
                }
                this.stack.push(current);
            }
        }

        public boolean hasMoreElements() {
            return this.stack.size() > 0;
        }

        public Object nextElement() {
            try {
                return this.stack.pop();
            }
            catch (EmptyStackException e) {
                throw new NoSuchElementException("No more elements");
            }
        }
    }

    final class BreadthFirstEnumeration
    implements Enumeration {
        protected Queue queue;

        public BreadthFirstEnumeration(TreeNode rootNode) {
            Vector<TreeNode> v = new Vector<TreeNode>(1);
            v.addElement(rootNode);
            this.queue = new Queue();
            this.queue.enqueue(v.elements());
        }

        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && ((Enumeration)this.queue.firstObject()).hasMoreElements();
        }

        public Object nextElement() {
            Enumeration enumer = (Enumeration)this.queue.firstObject();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration<? extends TreeNode> children = node.children();
            if (!enumer.hasMoreElements()) {
                this.queue.dequeue();
            }
            if (children.hasMoreElements()) {
                this.queue.enqueue(children);
            }
            return node;
        }

        final class Queue {
            QNode head;
            QNode tail;

            Queue() {
            }

            public void enqueue(Object anObject) {
                if (this.head == null) {
                    this.head = this.tail = new QNode(anObject, null);
                } else {
                    this.tail = this.tail.next = new QNode(anObject, null);
                }
            }

            public Object dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object retval = this.head.object;
                QNode oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
                return retval;
            }

            public Object firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode {
                public Object object;
                public QNode next;

                public QNode(Object object, QNode next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }

    final class PostorderEnumeration
    implements Enumeration {
        protected TreeNode root;
        protected Enumeration children;
        protected Enumeration subtree;

        public PostorderEnumeration(TreeNode rootNode) {
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = EMPTY_ENUMERATION;
        }

        public boolean hasMoreElements() {
            return this.root != null;
        }

        public Object nextElement() {
            Object retval;
            if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderEnumeration((TreeNode)this.children.nextElement());
                retval = this.subtree.nextElement();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }
    }

    final class PreorderEnumeration
    implements Enumeration {
        protected Stack stack;

        public PreorderEnumeration(TreeNode rootNode) {
            Vector<TreeNode> v = new Vector<TreeNode>(1);
            v.addElement(rootNode);
            this.stack = new Stack();
            this.stack.push(v.elements());
        }

        public boolean hasMoreElements() {
            return !this.stack.empty() && ((Enumeration)this.stack.peek()).hasMoreElements();
        }

        public Object nextElement() {
            Enumeration enumer = (Enumeration)this.stack.peek();
            TreeNode node = (TreeNode)enumer.nextElement();
            Enumeration<? extends TreeNode> children = node.children();
            if (!enumer.hasMoreElements()) {
                this.stack.pop();
            }
            if (children.hasMoreElements()) {
                this.stack.push(children);
            }
            return node;
        }
    }
}

