/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.exception.ErrorNumber;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.asam.ods.AIDName;
import org.asam.ods.AIDNameUnitId;
import org.asam.ods.AIDNameValueUnitId;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplAttr;
import org.asam.ods.ApplElem;
import org.asam.ods.ApplElemAccess;
import org.asam.ods.ApplRel;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.ApplicationStructureValue;
import org.asam.ods.AttrType;
import org.asam.ods.BaseElement;
import org.asam.ods.Blob;
import org.asam.ods.DataType;
import org.asam.ods.ElemId;
import org.asam.ods.ElemResultSet;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.NameValue;
import org.asam.ods.NameValueSeqUnit;
import org.asam.ods.NameValueSeqUnitId;
import org.asam.ods.NameValueUnit;
import org.asam.ods.QueryStructure;
import org.asam.ods.RelationRange;
import org.asam.ods.RelationType;
import org.asam.ods.Relationship;
import org.asam.ods.SelOpcode;
import org.asam.ods.SelOperator;
import org.asam.ods.SelOrder;
import org.asam.ods.SelValue;
import org.asam.ods.SeverityFlag;
import org.asam.ods.TS_Union;
import org.asam.ods.TS_UnionSeq;
import org.asam.ods.TS_Value;
import org.asam.ods.TS_ValueSeq;
import org.asam.ods.T_COMPLEX;
import org.asam.ods.T_DCOMPLEX;
import org.asam.ods.T_ExternalReference;
import org.asam.ods.T_LONGLONG;

public class OdsxHelper {
    public static final String version = "$Revision: 1.28 $";
    public static final String ODS_VERSION = "4.0";
    public static final String ODS_DATE_FORMAT = "yyyyMMddHHmmss";
    public static final String DE_DATE_FORMAT = "dd.MM.yyyy HH:mm:ss";
    public static final String OTHER_DATE_FORMAT = "MM/dd/yyyy hh:mm:ss aaa";
    public static final boolean FLAGS_AS_BITS = FwkPropertyBus.getProperty((String)"OdsxHelper.FlagsAsBits", (boolean)true);
    protected static final String FLAG_FILLER = "0000000000000000";
    public static boolean deLang;
    private static final char PATTERN_ALL = '*';
    private static final char PATTERN_ONE = '?';
    private static final char PATTERN_ESC = '\\';

    public static String getVersion() {
        return version;
    }

    private OdsxHelper() {
    }

    public static String getVersion(InstanceElement instance) {
        String ret = "";
        try {
            NameValueUnit nvu = instance.getValueByBaseName("version");
            ret = OdsxHelper.ts_valueToString(nvu.value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static String escapePattern(String pattern) {
        int length = pattern.length();
        StringBuffer retBuf = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char curChar = pattern.charAt(i);
            if (curChar == '*' || curChar == '?' || curChar == '\\') {
                retBuf.append('\\');
            }
            retBuf.append(curChar);
        }
        return retBuf.toString();
    }

    public static boolean isIndependent(InstanceElement column) {
        boolean ret = false;
        try {
            NameValueUnit nvu = column.getValueByBaseName("independent");
            if ((nvu.value.flag & 1) != 0) {
                DataType datatype = nvu.value.u.discriminator();
                switch (datatype.value()) {
                    case 2: {
                        ret = nvu.value.u.shortVal() != 0;
                        break;
                    }
                    case 3: {
                        ret = nvu.value.u.floatVal() != 0.0f;
                        break;
                    }
                    case 4: {
                        ret = nvu.value.u.booleanVal();
                        break;
                    }
                    case 5: {
                        ret = nvu.value.u.byteVal() != 0;
                        break;
                    }
                    case 6: {
                        ret = nvu.value.u.longVal() != 0;
                        break;
                    }
                    case 7: {
                        ret = nvu.value.u.doubleVal() != 0.0;
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static short[] getFlags(InstanceElement column) {
        short[] ret;
        block9: {
            ret = null;
            try {
                TS_Value flags = column.getValueByBaseName((String)"flags").value;
                if ((flags.flag & 0xF) == 0) break block9;
                switch (flags.u.discriminator().value()) {
                    case 20: {
                        int[] lTmp = flags.u.longSeq();
                        int size = lTmp.length;
                        ret = new short[size];
                        for (int i = 0; i < size; ++i) {
                            ret[i] = (short)lTmp[i];
                        }
                        break;
                    }
                    case 16: {
                        ret = flags.u.shortSeq();
                        break;
                    }
                    case 19: {
                        byte[] bTmp = flags.u.byteSeq();
                        int size = bTmp.length;
                        ret = new short[size];
                        for (int i = 0; i < size; ++i) {
                            ret[i] = bTmp[i];
                        }
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ret;
    }

    public static long isImplicit(InstanceElement column) {
        long ret = 0L;
        try {
            TS_Value value = column.getValueByBaseName((String)"sequence_representation").value;
            if ((value.flag & 0xF) != 0) {
                switch (value.u.discriminator().value()) {
                    case 6: {
                        ret = value.u.longVal();
                        break;
                    }
                    case 2: {
                        ret = value.u.shortVal();
                        break;
                    }
                    case 5: {
                        ret = value.u.byteVal();
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static double[] getRating(InstanceElement column) {
        double[] rating;
        block15: {
            rating = null;
            try {
                int size;
                long impl = OdsxHelper.isImplicit(column);
                if (impl <= 0L || !OdsxHelper.isIndependent(column)) break block15;
                short[] flags = OdsxHelper.getFlags(column);
                boolean valid = true;
                if (flags != null) {
                    size = flags.length;
                    while (--size >= 0 && valid) {
                        valid = (flags[size] & 0xF) != 0;
                    }
                }
                if (!valid) break block15;
                TS_Value values = column.getValueByBaseName((String)"values").value;
                if ((values.flag & 0xF) == 0) break block15;
                switch (values.u.discriminator().value()) {
                    case 17: {
                        float[] dTmp = values.u.floatSeq();
                        size = dTmp.length;
                        rating = new double[size];
                        for (int i = 0; i < size; ++i) {
                            rating[i] = dTmp[i];
                        }
                        break;
                    }
                    case 21: {
                        rating = values.u.doubleSeq();
                        break;
                    }
                    case 20: {
                        int[] lTmp = values.u.longSeq();
                        size = lTmp.length;
                        rating = new double[size];
                        for (int i = 0; i < size; ++i) {
                            rating[i] = lTmp[i];
                        }
                        break;
                    }
                    case 16: {
                        short[] sTmp = values.u.shortSeq();
                        size = sTmp.length;
                        rating = new double[size];
                        for (int i = 0; i < size; ++i) {
                            rating[i] = sTmp[i];
                        }
                        break;
                    }
                    case 19: {
                        byte[] bTmp = values.u.byteSeq();
                        size = bTmp.length;
                        rating = new double[size];
                        for (int i = 0; i < size; ++i) {
                            rating[i] = bTmp[i];
                        }
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return rating;
    }

    public static void setAttributes(InstanceElement ieObj, Map attrs) throws AoException {
        if (attrs != null && attrs.size() > 0) {
            ApplicationElement aeObj = ieObj.getApplicationElement();
            Iterator it = attrs.keySet().iterator();
            ApplicationAttribute aaObj = null;
            Vector<NameValueUnit> nvuVec = new Vector<NameValueUnit>();
            while (it.hasNext()) {
                String key = (String)it.next();
                aaObj = null;
                try {
                    aaObj = aeObj.getAttributeByBaseName(key);
                }
                catch (Throwable tAA) {
                    // empty catch block
                }
                if (aaObj == null) {
                    try {
                        aaObj = aeObj.getAttributeByName(key);
                    }
                    catch (Throwable tAA) {
                        // empty catch block
                    }
                }
                if (aaObj != null) {
                    String value = attrs.get(key).toString();
                    DataType dt = aaObj.getDataType();
                    int aaLen = aaObj.getLength();
                    if (aaLen > 0 && dt.value() == 1 && value.length() > aaLen) {
                        value = value.substring(0, aaLen);
                    }
                    nvuVec.add(OdsxHelper.parseNameValueUnit(ieObj.getValue(aaObj.getName()), value));
                } else if (FwkContainer.getDebugLevel() >= 1) {
                    System.err.println("BaseAttribute or ApplicationAttribute <" + key + "> not found.");
                }
                if (nvuVec.size() <= 0) continue;
                ieObj.setValueSeq(nvuVec.toArray(new NameValueUnit[0]));
            }
        }
    }

    public static String severityFlagToString(SeverityFlag sevFlag) {
        String ret = null;
        switch (sevFlag.value()) {
            case 3: {
                ret = "ERROR";
                break;
            }
            case 2: {
                ret = "WARNING";
                break;
            }
            case 1: {
                ret = "INFORMATION";
                break;
            }
            case 0: {
                ret = "SUCCESS";
            }
        }
        return ret;
    }

    public static String aoExceptionToString(AoException aoException) {
        StringBuffer ret = new StringBuffer(OdsxHelper.severityFlagToString(aoException.sevFlag));
        ret.append(": errCode = " + ErrorNumber.getMessage((int)aoException.errCode.value()));
        ret.append(" minorCode = " + aoException.minorCode);
        ret.append(" reason = " + aoException.reason.replaceAll("\t", "\n"));
        return ret.toString();
    }

    public static String flagsToString(short flag) {
        if (!FLAGS_AS_BITS) {
            if (deLang) {
                return flag == 0 ? "ung\u00fcltig" : "  g\u00fcltig";
            }
            return flag == 0 ? " invalid" : "  valid";
        }
        String ret = Integer.toString(flag, 2);
        int len = ret.length();
        if (len != 4) {
            if (len < 4) {
                ret = FLAG_FILLER.substring(0, 4 - len) + ret;
            } else if (len < 8) {
                ret = FLAG_FILLER.substring(0, 8 - len) + ret;
            } else if (len < 16) {
                ret = FLAG_FILLER.substring(0, 16 - len) + ret;
            }
        }
        return ret;
    }

    public static int getTypeSize(int datatype) {
        int ret = 0;
        switch (datatype) {
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                ret = 1;
                break;
            }
            case 2: 
            case 16: {
                ret = 2;
                break;
            }
            case 3: 
            case 6: 
            case 17: 
            case 20: {
                ret = 4;
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 21: 
            case 22: 
            case 23: {
                ret = 8;
                break;
            }
            case 14: 
            case 24: {
                ret = 16;
                break;
            }
            default: {
                ret = 0;
            }
        }
        return ret;
    }

    public static int getTypeSize(DataType datatype) {
        return OdsxHelper.getTypeSize(datatype.value());
    }

    public static int getTypeSize(TS_Value value) {
        return OdsxHelper.getTypeSize(value.u.discriminator().value());
    }

    public static NameValueUnit createNameValueUnit(String name, DataType datatype, String unit) {
        TS_Union union = new TS_Union();
        switch (datatype.value()) {
            case 0: {
                break;
            }
            case 1: {
                union.stringVal("");
                break;
            }
            case 2: {
                union.shortVal((short)0);
                break;
            }
            case 3: {
                union.floatVal(0.0f);
                break;
            }
            case 4: {
                union.booleanVal(true);
                break;
            }
            case 5: {
                union.byteVal((byte)0);
                break;
            }
            case 6: {
                union.longVal(0);
                break;
            }
            case 7: {
                union.doubleVal(0.0);
                break;
            }
            case 8: {
                union.longlongVal(OdsxHelper.parseLongLong("0"));
                break;
            }
            case 10: {
                SimpleDateFormat formatter = new SimpleDateFormat(ODS_DATE_FORMAT);
                union.dateVal(formatter.format(Calendar.getInstance().getTime()));
                break;
            }
            case 11: {
                union.bytestrVal(new byte[0]);
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                union.complexVal(new T_COMPLEX(0.0f, 0.0f));
                break;
            }
            case 14: {
                union.dcomplexVal(new T_DCOMPLEX(0.0, 0.0));
                break;
            }
            case 15: {
                union.stringSeq(new String[0]);
                break;
            }
            case 16: {
                union.shortSeq(new short[0]);
                break;
            }
            case 17: {
                union.floatSeq(new float[0]);
                break;
            }
            case 18: {
                union.booleanSeq(new boolean[0]);
                break;
            }
            case 19: {
                union.byteSeq(new byte[0]);
                break;
            }
            case 20: {
                union.longSeq(new int[0]);
                break;
            }
            case 21: {
                union.doubleSeq(new double[0]);
                break;
            }
            case 22: {
                union.longlongSeq(new T_LONGLONG[0]);
                break;
            }
            case 23: {
                union.complexSeq(new T_COMPLEX[0]);
                break;
            }
            case 24: {
                union.dcomplexSeq(new T_DCOMPLEX[0]);
                break;
            }
            case 26: {
                union.dateSeq(new String[0]);
                break;
            }
            case 27: {
                union.bytestrSeq(new byte[0][0]);
                break;
            }
            case 28: {
                union.extRefVal(new T_ExternalReference());
                break;
            }
            case 29: {
                union.extRefSeq(new T_ExternalReference[0]);
                break;
            }
        }
        return new NameValueUnit(name, new TS_Value(union, 15), unit == null ? "" : unit);
    }

    public static T_LONGLONG clone(T_LONGLONG val) {
        return new T_LONGLONG(val.low, val.high);
    }

    public static T_COMPLEX clone(T_COMPLEX val) {
        return new T_COMPLEX(val.r, val.i);
    }

    public static T_DCOMPLEX clone(T_DCOMPLEX val) {
        return new T_DCOMPLEX(val.r, val.i);
    }

    public static T_ExternalReference clone(T_ExternalReference val) {
        return new T_ExternalReference(val.description, val.mimeType, val.location);
    }

    public static byte[] clone(byte[] val) {
        byte[] ret;
        int len = val.length;
        if (len > 0) {
            ret = new byte[len];
            System.arraycopy(val, 0, ret, 0, len);
        } else {
            ret = new byte[]{};
        }
        return ret;
    }

    public static String[] clone(String[] val) {
        String[] ret;
        int len = val.length;
        if (len > 0) {
            ret = new String[len];
            System.arraycopy(val, 0, ret, 0, len);
        } else {
            ret = new String[]{};
        }
        return ret;
    }

    public static short[] clone(short[] val) {
        short[] ret;
        int len = val.length;
        if (len > 0) {
            ret = new short[len];
            System.arraycopy(val, 0, ret, 0, len);
        } else {
            ret = new short[]{};
        }
        return ret;
    }

    public static float[] clone(float[] val) {
        float[] ret;
        int len = val.length;
        if (len > 0) {
            ret = new float[len];
            System.arraycopy(val, 0, ret, 0, len);
        } else {
            ret = new float[]{};
        }
        return ret;
    }

    public static boolean[] clone(boolean[] val) {
        boolean[] ret;
        int len = val.length;
        if (len > 0) {
            ret = new boolean[len];
            System.arraycopy(val, 0, ret, 0, len);
        } else {
            ret = new boolean[]{};
        }
        return ret;
    }

    public static int[] clone(int[] val) {
        int[] ret;
        int len = val.length;
        if (len > 0) {
            ret = new int[len];
            System.arraycopy(val, 0, ret, 0, len);
        } else {
            ret = new int[]{};
        }
        return ret;
    }

    public static double[] clone(double[] val) {
        double[] ret;
        int len = val.length;
        if (len > 0) {
            ret = new double[len];
            System.arraycopy(val, 0, ret, 0, len);
        } else {
            ret = new double[]{};
        }
        return ret;
    }

    public static T_LONGLONG[] clone(T_LONGLONG[] val) {
        int len = val.length;
        T_LONGLONG[] ret = new T_LONGLONG[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                ret[i] = OdsxHelper.clone(val[i]);
            }
        }
        return ret;
    }

    public static T_COMPLEX[] clone(T_COMPLEX[] val) {
        int len = val.length;
        T_COMPLEX[] ret = new T_COMPLEX[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                ret[i] = OdsxHelper.clone(val[i]);
            }
        }
        return ret;
    }

    public static T_DCOMPLEX[] clone(T_DCOMPLEX[] val) {
        int len = val.length;
        T_DCOMPLEX[] ret = new T_DCOMPLEX[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                ret[i] = OdsxHelper.clone(val[i]);
            }
        }
        return ret;
    }

    public static T_ExternalReference[] clone(T_ExternalReference[] val) {
        int len = val.length;
        T_ExternalReference[] ret = new T_ExternalReference[len];
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                ret[i] = OdsxHelper.clone(val[i]);
            }
        }
        return ret;
    }

    public static byte[][] clone(byte[][] val) {
        byte[][] ret;
        int len = val.length;
        if (len > 0) {
            ret = new byte[len][val[0].length];
            for (int i = 0; i < len; ++i) {
                ret[i] = OdsxHelper.clone(val[i]);
            }
        } else {
            ret = new byte[0][0];
        }
        return ret;
    }

    public static Blob clone(Blob val) {
        System.err.println(OdsxHelper.class.getName() + ".cloneBlob\n\tThere is no Blob constructor for cloning.");
        return val;
    }

    public static NameValueUnit clone(NameValueUnit nvu) {
        NameValueUnit ret = OdsxHelper.createNameValueUnit(nvu.valName, nvu.value.u.discriminator(), nvu.unit);
        switch (nvu.value.u.discriminator().value()) {
            case 0: {
                break;
            }
            case 1: {
                ret.value.u.stringVal(nvu.value.u.stringVal());
                break;
            }
            case 2: {
                ret.value.u.shortVal(nvu.value.u.shortVal());
                break;
            }
            case 3: {
                ret.value.u.floatVal(nvu.value.u.floatVal());
                break;
            }
            case 4: {
                ret.value.u.booleanVal(nvu.value.u.booleanVal());
                break;
            }
            case 5: {
                ret.value.u.byteVal(nvu.value.u.byteVal());
                break;
            }
            case 6: {
                ret.value.u.longVal(nvu.value.u.longVal());
                break;
            }
            case 7: {
                ret.value.u.doubleVal(nvu.value.u.doubleVal());
                break;
            }
            case 8: {
                ret.value.u.longlongVal(OdsxHelper.clone(nvu.value.u.longlongVal()));
                break;
            }
            case 10: {
                ret.value.u.dateVal(nvu.value.u.dateVal());
                break;
            }
            case 11: {
                ret.value.u.bytestrVal(OdsxHelper.clone(nvu.value.u.bytestrVal()));
                break;
            }
            case 12: {
                ret.value.u.blobVal(OdsxHelper.clone(nvu.value.u.blobVal()));
                break;
            }
            case 13: {
                ret.value.u.complexVal(OdsxHelper.clone(nvu.value.u.complexVal()));
                break;
            }
            case 14: {
                ret.value.u.dcomplexVal(OdsxHelper.clone(nvu.value.u.dcomplexVal()));
                break;
            }
            case 15: {
                ret.value.u.stringSeq(OdsxHelper.clone(nvu.value.u.stringSeq()));
                break;
            }
            case 16: {
                ret.value.u.shortSeq(OdsxHelper.clone(nvu.value.u.shortSeq()));
                break;
            }
            case 17: {
                ret.value.u.floatSeq(OdsxHelper.clone(nvu.value.u.floatSeq()));
                break;
            }
            case 18: {
                ret.value.u.booleanSeq(OdsxHelper.clone(nvu.value.u.booleanSeq()));
                break;
            }
            case 19: {
                ret.value.u.byteSeq(OdsxHelper.clone(nvu.value.u.byteSeq()));
                break;
            }
            case 20: {
                ret.value.u.longSeq(OdsxHelper.clone(nvu.value.u.longSeq()));
                break;
            }
            case 21: {
                ret.value.u.doubleSeq(OdsxHelper.clone(nvu.value.u.doubleSeq()));
                break;
            }
            case 22: {
                ret.value.u.longlongSeq(OdsxHelper.clone(nvu.value.u.longlongSeq()));
                break;
            }
            case 23: {
                ret.value.u.complexSeq(OdsxHelper.clone(nvu.value.u.complexSeq()));
                break;
            }
            case 24: {
                ret.value.u.dcomplexSeq(OdsxHelper.clone(nvu.value.u.dcomplexSeq()));
                break;
            }
            case 26: {
                ret.value.u.dateSeq(OdsxHelper.clone(nvu.value.u.dateSeq()));
                break;
            }
            case 27: {
                ret.value.u.bytestrSeq(OdsxHelper.clone(nvu.value.u.bytestrSeq()));
                break;
            }
            case 28: {
                ret.value.u.extRefVal(OdsxHelper.clone(nvu.value.u.extRefVal()));
                break;
            }
            case 29: {
                ret.value.u.extRefSeq(OdsxHelper.clone(nvu.value.u.extRefSeq()));
                break;
            }
        }
        return ret;
    }

    public static String datatypeToString(DataType dt) {
        switch (dt.value()) {
            case 0: {
                return "DT_UNKNOWN";
            }
            case 1: {
                return "DT_STRING";
            }
            case 2: {
                return "DT_SHORT";
            }
            case 3: {
                return "DT_FLOAT";
            }
            case 4: {
                return "DT_BOOLEAN";
            }
            case 5: {
                return "DT_BYTE";
            }
            case 6: {
                return "DT_LONG";
            }
            case 30: {
                return "DT_ENUM";
            }
            case 7: {
                return "DT_DOUBLE";
            }
            case 8: {
                return "DT_LONGLONG";
            }
            case 10: {
                return "DT_DATE";
            }
            case 11: {
                return "DT_BYTESTR";
            }
            case 12: {
                return "DT_BLOB";
            }
            case 13: {
                return "DT_COMPLEX";
            }
            case 14: {
                return "DT_DCOMPLEX";
            }
            case 15: {
                return "DS_STRING";
            }
            case 16: {
                return "DS_SHORT";
            }
            case 17: {
                return "DS_FLOAT";
            }
            case 18: {
                return "DS_BOOLEAN";
            }
            case 19: {
                return "DS_BYTE";
            }
            case 20: {
                return "DS_LONG";
            }
            case 31: {
                return "DS_ENUM";
            }
            case 21: {
                return "DS_DOUBLE";
            }
            case 22: {
                return "DS_LONGLONG";
            }
            case 23: {
                return "DS_COMPLEX";
            }
            case 24: {
                return "DS_DCOMPLEX";
            }
            case 26: {
                return "DS_DATE";
            }
            case 27: {
                return "DS_BYTESTR";
            }
            case 28: {
                return "DT_EXTERNALREFERENCE";
            }
            case 29: {
                return "DS_EXTERNALREFERENCE";
            }
        }
        return new Integer(dt.value()).toString();
    }

    public static T_LONGLONG parseLongLong(String value) {
        T_LONGLONG ret = new T_LONGLONG();
        try {
            long llVal = Long.parseLong(value);
            ret.low = (int)(llVal & 0xFFFFFFFFL);
            ret.high = (int)(llVal >> 32);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static T_COMPLEX parseComplex(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " ,;iI*(){}[]", false);
        T_COMPLEX complex = new T_COMPLEX();
        if (tokenizer.countTokens() == 2) {
            complex.r = Float.parseFloat(tokenizer.nextToken());
            complex.i = Float.parseFloat(tokenizer.nextToken());
        }
        return complex;
    }

    public static T_DCOMPLEX parseDComplex(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, " ,;iI*(){}[]", false);
        T_DCOMPLEX complex = new T_DCOMPLEX();
        if (tokenizer.countTokens() == 2) {
            complex.r = Double.parseDouble(tokenizer.nextToken());
            complex.i = Double.parseDouble(tokenizer.nextToken());
        }
        return complex;
    }

    public static boolean parseBoolean(String value) {
        return (value = value.trim().toUpperCase()).startsWith("Y") || value.startsWith("J") || value.startsWith("T") || !value.startsWith("0") || value.compareTo("ON") == 0 || value.compareTo("EIN") == 0 || Boolean.getBoolean(value);
    }

    public static NameValueUnit parseNameValueUnit(NameValueUnit nvu, String value) throws RuntimeException, AoException {
        TS_Value ts_value = null;
        try {
            ts_value = new TS_Value(OdsxHelper.parseTS_Union(nvu.value.u.discriminator(), value), 15);
        }
        catch (Throwable t) {
            ts_value = new TS_Value();
            ts_value.flag = 0;
        }
        return new NameValueUnit(nvu.valName, ts_value, nvu.unit);
    }

    public static NameValueUnit createNameValueUnit(String name, String unit, DataType dt, String value) throws RuntimeException, AoException {
        TS_Value ts_value = null;
        try {
            ts_value = new TS_Value(OdsxHelper.parseTS_Union(dt, value), 15);
        }
        catch (Throwable t) {
            ts_value = new TS_Value();
            ts_value.flag = 0;
        }
        return new NameValueUnit(name, ts_value, unit);
    }

    public static TS_Union parseTS_Union(DataType dt, String value) throws RuntimeException, AoException {
        TS_Union ret = new TS_Union();
        switch (dt.value()) {
            case 1: {
                ret.stringVal(value);
                break;
            }
            case 2: {
                ret.shortVal(Short.parseShort(value));
                break;
            }
            case 3: {
                ret.floatVal(Float.parseFloat(value));
                break;
            }
            case 5: {
                try {
                    ret.byteVal(Byte.parseByte(value, 10));
                }
                catch (Throwable t10) {
                    try {
                        ret.byteVal(Byte.parseByte(value, 16));
                    }
                    catch (Throwable t16) {
                        try {
                            ret.byteVal(Byte.parseByte(value, 2));
                        }
                        catch (Throwable t2) {
                            ret.byteVal(Byte.parseByte(value, 8));
                        }
                    }
                }
                break;
            }
            case 4: {
                ret.booleanVal(OdsxHelper.parseBoolean(value));
                break;
            }
            case 30: {
                ret.enumVal(Integer.parseInt(value));
                break;
            }
            case 6: {
                ret.longVal(Integer.parseInt(value));
                break;
            }
            case 7: {
                ret.doubleVal(Double.parseDouble(value));
                break;
            }
            case 8: {
                ret.longlongVal(OdsxHelper.parseLongLong(value));
                break;
            }
            case 13: {
                ret.complexVal(OdsxHelper.parseComplex(value));
                break;
            }
            case 14: {
                ret.dcomplexVal(OdsxHelper.parseDComplex(value));
                break;
            }
            case 10: {
                if (value.indexOf(46) >= 0 || value.indexOf(44) >= 0 || value.indexOf(58) >= 0 || value.indexOf(47) >= 0 || value.indexOf(92) >= 0 || value.indexOf(59) >= 0) {
                    String[] dat = new String[7];
                    int counter = 0;
                    StringTokenizer tokenizer = new StringTokenizer(value, " ,.:/\\;", false);
                    while (tokenizer.hasMoreTokens() && counter < 7) {
                        dat[counter++] = tokenizer.nextToken();
                    }
                    StringBuffer sb = new StringBuffer(20);
                    if (deLang) {
                        if (dat[2] != null) {
                            sb.append(dat[2]);
                        }
                        if (dat[1] != null) {
                            sb.append(dat[1]);
                        }
                        sb.append("" + dat[0]);
                        if (dat[3] != null) {
                            sb.append(dat[3]);
                        }
                        if (dat[4] != null) {
                            sb.append(dat[4]);
                        }
                        if (dat[5] != null) {
                            sb.append(dat[5]);
                        }
                        if (dat[6] != null) {
                            sb.append(dat[6]);
                        }
                    } else {
                        sb.append("" + dat[0]);
                        if (dat[1] != null) {
                            sb.append(dat[1]);
                        }
                        if (dat[2] != null) {
                            sb.append(dat[2]);
                        }
                        if (dat[3] != null) {
                            sb.append(dat[3]);
                        }
                        if (dat[4] != null) {
                            sb.append(dat[4]);
                        }
                        if (dat[5] != null) {
                            sb.append(dat[5]);
                        }
                        if (dat[6] != null) {
                            sb.append(dat[6]);
                        }
                    }
                    ret.dateVal(sb.toString());
                    break;
                }
                ret.dateVal(value);
                break;
            }
            case 11: {
                StringTokenizer tokenizer = new StringTokenizer(value, " ,.:/\\;", false);
                byte[] val = new byte[tokenizer.countTokens()];
                int counter = 0;
                while (tokenizer.hasMoreTokens()) {
                    val[counter++] = Byte.parseByte(tokenizer.nextToken(), 16);
                }
                ret.bytestrVal(val);
                break;
            }
            case 12: {
                System.err.println(OdsxHelper.class.getName() + ".parseTS_Union\n\tThere is no Blob constructor for cloning.");
                break;
            }
            case 15: {
                boolean sc = false;
                Vector<String> arr = new Vector<String>();
                StringTokenizer tokenizer = new StringTokenizer(value, "\n\\[]", true);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.startsWith("\n")) continue;
                    if (token.startsWith("\\")) {
                        sc = true;
                        continue;
                    }
                    if (sc) {
                        sc = false;
                        arr.add(token.substring(1, token.length()));
                        continue;
                    }
                    arr.add(token);
                }
                String[] val = new String[arr.size()];
                ret.stringSeq(arr.toArray(val));
                break;
            }
            case 16: {
                StringTokenizer tokenizer = new StringTokenizer(value, " ,\n[]", false);
                short[] val = new short[tokenizer.countTokens()];
                int counter = 0;
                while (tokenizer.hasMoreTokens()) {
                    val[counter++] = Short.parseShort(tokenizer.nextToken());
                }
                ret.shortSeq(val);
                break;
            }
            case 17: {
                StringTokenizer tokenizer = new StringTokenizer(value, " ,\n", false);
                float[] val = new float[tokenizer.countTokens()];
                int counter = 0;
                while (tokenizer.hasMoreTokens()) {
                    val[counter++] = Float.parseFloat(tokenizer.nextToken());
                }
                ret.floatSeq(val);
                break;
            }
            case 19: {
                StringTokenizer tokenizer = new StringTokenizer(value, " ,\n[]", false);
                byte[] val = new byte[tokenizer.countTokens()];
                int counter = 0;
                while (tokenizer.hasMoreTokens()) {
                    val[counter++] = Byte.parseByte(tokenizer.nextToken(), 16);
                }
                ret.byteSeq(val);
                break;
            }
            case 18: {
                StringTokenizer tokenizer = new StringTokenizer(value, " ,\n[]", false);
                boolean[] val = new boolean[tokenizer.countTokens()];
                int counter = 0;
                while (tokenizer.hasMoreTokens()) {
                    val[counter++] = OdsxHelper.parseBoolean(tokenizer.nextToken());
                }
                ret.booleanSeq(val);
                break;
            }
            case 20: {
                StringTokenizer tokenizer = new StringTokenizer(value, " ,\n[]", false);
                int[] val = new int[tokenizer.countTokens()];
                int counter = 0;
                while (tokenizer.hasMoreTokens()) {
                    val[counter++] = Integer.parseInt(tokenizer.nextToken());
                }
                ret.longSeq(val);
                break;
            }
            case 22: {
                StringTokenizer tokenizer = new StringTokenizer(value, " ,\n[]", false);
                T_LONGLONG[] id = new T_LONGLONG[tokenizer.countTokens()];
                int counter = 0;
                while (tokenizer.hasMoreTokens()) {
                    id[counter++] = OdsxHelper.parseLongLong(tokenizer.nextToken());
                }
                ret.longlongSeq(id);
                break;
            }
            case 21: {
                StringTokenizer tokenizer = new StringTokenizer(value, " ,\n[]", false);
                double[] val = new double[tokenizer.countTokens()];
                int counter = 0;
                while (tokenizer.hasMoreTokens()) {
                    val[counter++] = Double.parseDouble(tokenizer.nextToken());
                }
                ret.doubleSeq(val);
                break;
            }
            case 23: {
                int count;
                StringTokenizer tokenizer = new StringTokenizer(value, " ,;iI*(){}[]\n", false);
                if (count <= 2) break;
                T_COMPLEX[] arr = new T_COMPLEX[count / 2];
                int index = 0;
                for (count = tokenizer.countTokens(); count > 1; count -= 2) {
                    T_COMPLEX val = new T_COMPLEX();
                    val.r = Float.parseFloat(tokenizer.nextToken());
                    val.i = Float.parseFloat(tokenizer.nextToken());
                    arr[index++] = val;
                }
                ret.complexSeq(arr);
                break;
            }
            case 24: {
                int count;
                StringTokenizer tokenizer = new StringTokenizer(value, " ,;iI*(){}[]\n", false);
                if (count <= 2) break;
                T_DCOMPLEX[] arr = new T_DCOMPLEX[count / 2];
                int index = 0;
                for (count = tokenizer.countTokens(); count > 1; count -= 2) {
                    T_DCOMPLEX val = new T_DCOMPLEX();
                    val.r = Double.parseDouble(tokenizer.nextToken());
                    val.i = Double.parseDouble(tokenizer.nextToken());
                    arr[index++] = val;
                }
                ret.dcomplexSeq(arr);
                break;
            }
        }
        return ret;
    }

    public static TS_Union parseTS_Union(DataType dt, String[] value) throws RuntimeException, AoException {
        TS_Union ret = new TS_Union();
        switch (dt.value()) {
            case 8: {
                int size = value.length;
                T_LONGLONG[] val = new T_LONGLONG[size];
                for (int i = 0; i < size; ++i) {
                    val[i] = OdsxHelper.parseLongLong(value[i]);
                }
                ret.longlongSeq(val);
                break;
            }
            case 10: 
            case 26: {
                ret.dateSeq(value);
                break;
            }
            case 11: {
                ret = OdsxHelper.parseTS_Union(dt, StringUtilities.concatenate((String[])value, (String)",", (boolean)true));
                break;
            }
            case 12: {
                ret = OdsxHelper.parseTS_Union(dt, StringUtilities.concatenate((String[])value, (String)",", (boolean)true));
                break;
            }
            case 1: 
            case 15: {
                ret.stringSeq(value);
                break;
            }
            case 2: 
            case 16: {
                short[] val = new short[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Short.parseShort(value[i]);
                }
                ret.shortSeq(val);
                break;
            }
            case 3: 
            case 17: {
                float[] val = new float[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Float.parseFloat(value[i]);
                }
                ret.floatSeq(val);
                break;
            }
            case 5: 
            case 19: {
                byte[] val = new byte[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Byte.parseByte(value[i], 16);
                }
                ret.byteSeq(val);
                break;
            }
            case 4: 
            case 18: {
                boolean[] val = new boolean[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = OdsxHelper.parseBoolean(value[i]);
                }
                ret.booleanSeq(val);
                break;
            }
            case 6: 
            case 20: {
                int[] val = new int[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Integer.parseInt(value[i]);
                }
                ret.longSeq(val);
                break;
            }
            case 7: 
            case 21: {
                double[] val = new double[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Double.parseDouble(value[i]);
                }
                ret.doubleSeq(val);
                break;
            }
            case 13: 
            case 23: {
                ret = OdsxHelper.parseTS_Union(dt, StringUtilities.concatenate((String[])value, (String)",", (boolean)true));
                break;
            }
            case 14: 
            case 24: {
                ret = OdsxHelper.parseTS_Union(dt, StringUtilities.concatenate((String[])value, (String)",", (boolean)true));
                break;
            }
        }
        return ret;
    }

    public static TS_UnionSeq parseTS_UnionSeq(DataType dt, String[] value) throws RuntimeException, AoException {
        TS_UnionSeq ret = new TS_UnionSeq();
        switch (dt.value()) {
            case 8: {
                int size = value.length;
                T_LONGLONG[] val = new T_LONGLONG[size];
                for (int i = 0; i < size; ++i) {
                    val[i] = OdsxHelper.parseLongLong(value[i]);
                }
                ret.longlongVal(val);
                break;
            }
            case 10: 
            case 26: {
                ret.dateVal(value);
                break;
            }
            case 1: 
            case 15: {
                ret.stringVal(value);
                break;
            }
            case 2: 
            case 16: {
                short[] val = new short[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Short.parseShort(value[i]);
                }
                ret.shortVal(val);
                break;
            }
            case 3: 
            case 17: {
                float[] val = new float[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Float.parseFloat(value[i]);
                }
                ret.floatVal(val);
                break;
            }
            case 5: 
            case 19: {
                byte[] val = new byte[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Byte.parseByte(value[i], 16);
                }
                ret.byteVal(val);
                break;
            }
            case 4: 
            case 18: {
                boolean[] val = new boolean[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = OdsxHelper.parseBoolean(value[i]);
                }
                ret.booleanVal(val);
                break;
            }
            case 6: 
            case 20: {
                int[] val = new int[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Integer.parseInt(value[i]);
                }
                ret.longVal(val);
                break;
            }
            case 7: 
            case 21: {
                double[] val = new double[value.length];
                int size = value.length;
                for (int i = 0; i < size; ++i) {
                    val[i] = Double.parseDouble(value[i]);
                }
                ret.doubleVal(val);
                break;
            }
        }
        return ret;
    }

    public static String valToString(String date) {
        String ret = date;
        int valLen = date.length();
        if (valLen != 0) {
            String year = "";
            String month = "";
            String day = "";
            String hours = "";
            String minutes = "";
            String seconds = "";
            String millis = "";
            if (valLen >= 4) {
                year = date.substring(0, 4);
            }
            if (valLen >= 6) {
                month = date.substring(4, 6);
            }
            if (valLen >= 8) {
                day = date.substring(6, 8);
            }
            if (valLen >= 10) {
                hours = date.substring(8, 10);
            }
            if (valLen >= 12) {
                minutes = date.substring(10, 12);
            }
            if (valLen >= 14) {
                seconds = date.substring(12, 14);
            }
            if (valLen > 14) {
                millis = date.substring(14);
            }
            ret = deLang ? (day.length() != 0 ? day : "") + (month.length() != 0 ? "." + month : "") + (year.length() != 0 ? "." + year : "") + (hours.length() != 0 ? " " + hours : "") + (minutes.length() != 0 ? ":" + minutes : "") + (seconds.length() != 0 ? ":" + seconds : "") + (millis.length() != 0 ? "," + millis : "") : (year.length() != 0 ? year : "") + (month.length() != 0 ? "/" + month : "") + (day.length() != 0 ? "/" + day : "") + (hours.length() != 0 ? " " + hours : "") + (minutes.length() != 0 ? ":" + minutes : "") + (seconds.length() != 0 ? ":" + seconds : "") + (millis.length() != 0 ? "," + millis : "");
        }
        return ret;
    }

    public static String valToString(T_LONGLONG val) {
        String ret = "0";
        if (val.high == 0) {
            ret = String.valueOf(val.low);
        } else {
            long llVal = val.high;
            llVal <<= 32;
            ret = String.valueOf(llVal += (long)val.low);
        }
        return ret;
    }

    public static String valToString(T_COMPLEX val) {
        return "(" + val.r + ", i" + val.i + ")";
    }

    public static String valToString(T_DCOMPLEX val) {
        return "(" + val.r + ", i" + val.i + ")";
    }

    public static String valToString(T_ExternalReference val) {
        return val.description + "[" + val.mimeType + ", " + val.location + "]";
    }

    public static String valToString(Object val) {
        if (val instanceof T_COMPLEX) {
            return OdsxHelper.valToString((T_COMPLEX)val);
        }
        if (val instanceof T_DCOMPLEX) {
            return OdsxHelper.valToString((T_DCOMPLEX)val);
        }
        if (val instanceof T_LONGLONG) {
            return OdsxHelper.valToString((T_LONGLONG)val);
        }
        if (val instanceof T_ExternalReference) {
            return OdsxHelper.valToString((T_ExternalReference)val);
        }
        return val.toString();
    }

    public static String seqToString(byte[] val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(byte[] val, int maxCount, boolean multiLine, int lineCount) {
        int valIndex;
        StringBuffer buf = new StringBuffer();
        if (maxCount == 0 || maxCount > val.length) {
            maxCount = val.length - 1;
        }
        int lCount = 0;
        if (multiLine) {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
                if (++lCount != lineCount) continue;
                lCount = 0;
                buf.append("\n");
            }
        } else {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
            }
        }
        if (maxCount == val.length - 1) {
            if (multiLine && ++lCount == lineCount) {
                lCount = 0;
                buf.append("\n");
            }
            try {
                return buf.append(val[valIndex]).toString();
            }
            catch (Throwable t) {
                return buf.toString();
            }
        }
        return buf.append(val[valIndex] + ", ...").toString();
    }

    public static String seqToString(short[] val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(short[] val, int maxCount, boolean multiLine, int lineCount) {
        int valIndex;
        StringBuffer buf = new StringBuffer();
        if (maxCount == 0 || maxCount > val.length) {
            maxCount = val.length - 1;
        }
        int lCount = 0;
        if (multiLine) {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
                if (++lCount != lineCount) continue;
                lCount = 0;
                buf.append("\n");
            }
        } else {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
            }
        }
        if (maxCount == val.length - 1) {
            if (multiLine && ++lCount == lineCount) {
                lCount = 0;
                buf.append("\n");
            }
            try {
                return buf.append(val[valIndex]).toString();
            }
            catch (Throwable t) {
                return buf.toString();
            }
        }
        return buf.append(val[valIndex] + ", ...").toString();
    }

    public static String seqToString(boolean[] val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(boolean[] val, int maxCount, boolean multiLine, int lineCount) {
        int valIndex;
        StringBuffer buf = new StringBuffer();
        if (maxCount == 0 || maxCount > val.length) {
            maxCount = val.length - 1;
        }
        int lCount = 0;
        if (multiLine) {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
                if (++lCount != lineCount) continue;
                lCount = 0;
                buf.append("\n");
            }
        } else {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
            }
        }
        if (maxCount == val.length - 1) {
            if (multiLine && ++lCount == lineCount) {
                lCount = 0;
                buf.append("\n");
            }
            try {
                return buf.append(val[valIndex]).toString();
            }
            catch (Throwable t) {
                return buf.toString();
            }
        }
        return buf.append(val[valIndex] + ", ...").toString();
    }

    public static String seqToString(int[] val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(int[] val, int maxCount, boolean multiLine, int lineCount) {
        int valIndex;
        StringBuffer buf = new StringBuffer();
        if (maxCount == 0 || maxCount > val.length) {
            maxCount = val.length - 1;
        }
        int lCount = 0;
        if (multiLine) {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
                if (++lCount != lineCount) continue;
                lCount = 0;
                buf.append("\n");
            }
        } else {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
            }
        }
        if (maxCount == val.length - 1) {
            if (multiLine && ++lCount == lineCount) {
                lCount = 0;
                buf.append("\n");
            }
            try {
                return buf.append(val[valIndex]).toString();
            }
            catch (Throwable t) {
                return buf.toString();
            }
        }
        return buf.append(val[valIndex] + ", ...").toString();
    }

    public static String seqToString(float[] val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(float[] val, int maxCount, boolean multiLine, int lineCount) {
        int valIndex;
        StringBuffer buf = new StringBuffer();
        if (maxCount == 0 || maxCount > val.length) {
            maxCount = val.length - 1;
        }
        int lCount = 0;
        if (multiLine) {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
                if (++lCount != lineCount) continue;
                lCount = 0;
                buf.append("\n");
            }
        } else {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
            }
        }
        if (maxCount == val.length - 1) {
            if (multiLine && ++lCount == lineCount) {
                lCount = 0;
                buf.append("\n");
            }
            try {
                return buf.append(val[valIndex]).toString();
            }
            catch (Throwable t) {
                return buf.toString();
            }
        }
        return buf.append(val[valIndex] + ", ...").toString();
    }

    public static String seqToString(double[] val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(double[] val, int maxCount, boolean multiLine, int lineCount) {
        int valIndex;
        StringBuffer buf = new StringBuffer();
        if (maxCount == 0 || maxCount > val.length) {
            maxCount = val.length - 1;
        }
        int lCount = 0;
        if (multiLine) {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
                if (++lCount != lineCount) continue;
                lCount = 0;
                buf.append("\n");
            }
        } else {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + ", ");
            }
        }
        if (maxCount == val.length - 1) {
            if (multiLine && ++lCount == lineCount) {
                lCount = 0;
                buf.append("\n");
            }
            try {
                return buf.append(val[valIndex]).toString();
            }
            catch (Throwable t) {
                return buf.toString();
            }
        }
        return buf.append(val[valIndex] + ", ...").toString();
    }

    public static String seqToString(Blob val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(Blob blob, int maxCount, boolean multiLine, int lineCount) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(blob.getHeader() + " val=");
            if (multiLine) {
                sb.append("\n");
            }
            sb.append(OdsxHelper.seqToString(blob.get(0, blob.getLength()), maxCount, multiLine, lineCount));
        }
        catch (Throwable t) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String seqToString(String[] val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(String[] val, int maxCount, boolean multiLine, int lineCount) {
        int valIndex;
        StringBuffer buf = new StringBuffer();
        if (maxCount == 0 || maxCount > val.length) {
            maxCount = val.length - 1;
        }
        if (multiLine) {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + "\n");
            }
        } else {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(val[valIndex] + "\\n ");
            }
        }
        if (maxCount == val.length - 1) {
            try {
                return buf.append(val[valIndex]).toString();
            }
            catch (Throwable t) {
                return buf.toString();
            }
        }
        return buf.append(val[valIndex] + ", ...").toString();
    }

    public static String seqToString(Object[] val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(Object[] val, int maxCount, boolean multiLine, int lineCount) {
        int valIndex;
        StringBuffer buf = new StringBuffer();
        if (maxCount == 0 || maxCount > val.length) {
            maxCount = val.length - 1;
        }
        int lCount = 0;
        if (multiLine) {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(OdsxHelper.valToString(val[valIndex]) + ", ");
                if (++lCount != lineCount) continue;
                lCount = 0;
                buf.append("\n");
            }
        } else {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(OdsxHelper.valToString(val[valIndex]) + ", ");
            }
        }
        if (maxCount == val.length - 1) {
            if (multiLine && ++lCount == lineCount) {
                lCount = 0;
                buf.append("\n");
            }
            try {
                return buf.append(OdsxHelper.valToString(val[valIndex])).toString();
            }
            catch (Throwable t) {
                return buf.toString();
            }
        }
        return buf.append(OdsxHelper.valToString(val[valIndex]) + ", ...").toString();
    }

    public static String seqToString(T_ExternalReference[] val) {
        return OdsxHelper.seqToString(val, 0, false, 0);
    }

    public static String seqToString(T_ExternalReference[] val, int maxCount, boolean multiLine, int lineCount) {
        int valIndex;
        StringBuffer buf = new StringBuffer();
        if (maxCount == 0 || maxCount > val.length) {
            maxCount = val.length;
        }
        int lCount = 0;
        if (multiLine) {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(OdsxHelper.valToString(val[valIndex]) + ", ");
                if (++lCount != lineCount) continue;
                lCount = 0;
                buf.append("\n");
            }
        } else {
            for (valIndex = 0; valIndex < maxCount; ++valIndex) {
                buf.append(OdsxHelper.valToString(val[valIndex]) + ", ");
            }
        }
        if (maxCount >= val.length) {
            return buf.toString();
        }
        return buf.append(OdsxHelper.valToString(val[valIndex]) + ", ...").toString();
    }

    public static String ts_valueSeqToString(TS_ValueSeq ts) {
        StringBuffer buf = new StringBuffer();
        if (ts.u != null) {
            buf.append(OdsxHelper.ts_unionSeqToString(ts.u, 0) + "\n ");
        } else {
            buf.append("null\n ");
        }
        if (ts.flag != null) {
            buf.append(OdsxHelper.seqToString(ts.flag));
        } else {
            buf.append("null");
        }
        return buf.toString();
    }

    public static String ts_valueToString(TS_Value ts) {
        if ((ts.flag & 9) != 0 && ts.u != null) {
            return OdsxHelper.ts_unionToString(ts.u, 0);
        }
        if ((ts.flag & 8) == 0) {
            return "<undefined> " + OdsxHelper.datatypeToString(ts.u.discriminator());
        }
        return "<invalid>" + OdsxHelper.datatypeToString(ts.u.discriminator());
    }

    public static String ts_unionToString(TS_Union ts) {
        return OdsxHelper.ts_unionToString(ts, 0);
    }

    public static String ts_unionToString(TS_Union ts, int maxCount) {
        return OdsxHelper.ts_unionToString(ts, maxCount, false, 0);
    }

    public static String ts_unionToString(TS_Union ts, int maxCount, boolean multiLine, int lineCount) {
        if (maxCount < 0) {
            maxCount = 0;
        }
        String tsString = "";
        if (ts != null && ts.discriminator() != null) {
            try {
                switch (ts.discriminator().value()) {
                    case 1: {
                        tsString = ts.stringVal();
                        break;
                    }
                    case 2: {
                        tsString = String.valueOf(ts.shortVal());
                        break;
                    }
                    case 3: {
                        tsString = String.valueOf(ts.floatVal());
                        break;
                    }
                    case 5: {
                        tsString = String.valueOf(ts.byteVal());
                        break;
                    }
                    case 4: {
                        tsString = String.valueOf(ts.booleanVal());
                        break;
                    }
                    case 6: {
                        tsString = String.valueOf(ts.longVal());
                        break;
                    }
                    case 30: {
                        tsString = String.valueOf(ts.enumVal());
                        break;
                    }
                    case 7: {
                        tsString = String.valueOf(ts.doubleVal());
                        break;
                    }
                    case 8: {
                        tsString = OdsxHelper.valToString(ts.longlongVal());
                        break;
                    }
                    case 13: {
                        tsString = OdsxHelper.valToString(ts.complexVal());
                        break;
                    }
                    case 14: {
                        tsString = OdsxHelper.valToString(ts.dcomplexVal());
                        break;
                    }
                    case 10: {
                        tsString = OdsxHelper.valToString("" + ts.dateVal());
                        break;
                    }
                    case 11: {
                        tsString = OdsxHelper.seqToString(ts.bytestrVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 12: {
                        tsString = OdsxHelper.seqToString(ts.blobVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 15: {
                        tsString = OdsxHelper.seqToString(ts.stringSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 16: {
                        tsString = OdsxHelper.seqToString(ts.shortSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 17: {
                        tsString = OdsxHelper.seqToString(ts.floatSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 19: {
                        tsString = OdsxHelper.seqToString(ts.byteSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 18: {
                        tsString = OdsxHelper.seqToString(ts.booleanSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 20: {
                        tsString = OdsxHelper.seqToString(ts.longSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 31: {
                        tsString = OdsxHelper.seqToString(ts.enumSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 21: {
                        tsString = OdsxHelper.seqToString(ts.doubleSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 22: {
                        tsString = OdsxHelper.seqToString(ts.longlongSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 23: {
                        tsString = OdsxHelper.seqToString(ts.complexSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 24: {
                        tsString = OdsxHelper.seqToString(ts.dcomplexSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 26: {
                        String[] arr = ts.dateSeq();
                        int size = arr.length;
                        String[] tmp = new String[size];
                        for (int i = 0; i < size; ++i) {
                            tmp[i] = OdsxHelper.valToString(arr[i]);
                        }
                        tsString = OdsxHelper.seqToString(tmp, maxCount, multiLine, lineCount);
                        break;
                    }
                    case 27: {
                        tsString = OdsxHelper.seqToString(ts.byteSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 28: {
                        tsString = OdsxHelper.valToString(ts.extRefVal());
                        break;
                    }
                    case 29: {
                        tsString = OdsxHelper.seqToString(ts.extRefSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    default: {
                        tsString = "Unknown datatype " + ts.discriminator().value() + " in class OdsxHelper";
                        break;
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return tsString;
    }

    public static String ts_unionSeqToString(TS_UnionSeq ts) {
        return OdsxHelper.ts_unionSeqToString(ts, 0);
    }

    public static String ts_unionSeqToString(TS_UnionSeq ts, int maxCount) {
        return OdsxHelper.ts_unionSeqToString(ts, maxCount, false, 0);
    }

    public static String ts_unionSeqToString(TS_UnionSeq ts, int maxCount, boolean multiLine, int lineCount) {
        if (maxCount < 0) {
            maxCount = 0;
        }
        String tsString = "";
        if (ts != null && ts.discriminator() != null) {
            try {
                switch (ts.discriminator().value()) {
                    case 1: {
                        tsString = OdsxHelper.seqToString(ts.stringVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 2: {
                        tsString = OdsxHelper.seqToString(ts.shortVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 3: {
                        tsString = OdsxHelper.seqToString(ts.floatVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 5: {
                        tsString = OdsxHelper.seqToString(ts.byteVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 4: {
                        tsString = OdsxHelper.seqToString(ts.booleanVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 6: {
                        tsString = OdsxHelper.seqToString(ts.longVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 30: {
                        tsString = OdsxHelper.seqToString(ts.enumVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 7: {
                        tsString = OdsxHelper.seqToString(ts.doubleVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 8: {
                        tsString = OdsxHelper.seqToString(ts.longlongVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 13: {
                        tsString = OdsxHelper.seqToString(ts.complexVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 14: {
                        tsString = OdsxHelper.seqToString(ts.dcomplexVal(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 10: {
                        String[] arr = ts.dateVal();
                        int size = arr.length;
                        String[] tmp = new String[size];
                        for (int i = 0; i < size; ++i) {
                            tmp[i] = OdsxHelper.valToString(arr[i]);
                        }
                        tsString = OdsxHelper.seqToString(tmp, maxCount, multiLine, lineCount);
                        break;
                    }
                    case 11: {
                        tsString = OdsxHelper.seqToString((Object[])ts.byteSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 28: {
                        tsString = OdsxHelper.seqToString((Object[])ts.extRefSeq(), maxCount, multiLine, lineCount);
                        break;
                    }
                    case 15: {
                        String[][] s = ts.stringSeq();
                        StringBuffer buf = new StringBuffer();
                        int noStr = s.length;
                        for (int i = 0; i < noStr; ++i) {
                            buf.append("\n" + i + ": ");
                            buf.append(OdsxHelper.seqToString(s[i], maxCount, multiLine, lineCount));
                        }
                        tsString = buf.toString();
                        break;
                    }
                    case 16: {
                        short[][] l = ts.shortSeq();
                        StringBuffer buf = new StringBuffer();
                        int noStr = l.length;
                        for (int i = 0; i < noStr; ++i) {
                            buf.append("\n" + i + ": ");
                            buf.append(OdsxHelper.seqToString(l[i], maxCount, multiLine, lineCount));
                        }
                        tsString = buf.toString();
                        break;
                    }
                    case 20: {
                        int[][] l = ts.longSeq();
                        StringBuffer buf = new StringBuffer();
                        int noStr = l.length;
                        for (int i = 0; i < noStr; ++i) {
                            buf.append("\n" + i + ": ");
                            buf.append(OdsxHelper.seqToString(l[i], maxCount, multiLine, lineCount));
                        }
                        tsString = buf.toString();
                        break;
                    }
                    case 17: {
                        float[][] f = ts.floatSeq();
                        StringBuffer buf = new StringBuffer();
                        int noStr = f.length;
                        for (int i = 0; i < noStr; ++i) {
                            buf.append("\n" + i + ": ");
                            buf.append(OdsxHelper.seqToString(f[i], maxCount, multiLine, lineCount));
                        }
                        tsString = buf.toString();
                        break;
                    }
                    case 21: {
                        double[][] f = ts.doubleSeq();
                        StringBuffer buf = new StringBuffer();
                        int noStr = f.length;
                        for (int i = 0; i < noStr; ++i) {
                            buf.append("\n" + i + ": ");
                            buf.append(OdsxHelper.seqToString(f[i], maxCount, multiLine, lineCount));
                        }
                        tsString = buf.toString();
                        break;
                    }
                    case 26: {
                        String[][] s = ts.dateSeq();
                        StringBuffer buf = new StringBuffer();
                        int noStr = s.length;
                        for (int i = 0; i < noStr; ++i) {
                            buf.append("\n" + i + ": ");
                            buf.append(OdsxHelper.seqToString(s[i], maxCount, multiLine, lineCount));
                        }
                        tsString = buf.toString();
                        break;
                    }
                    case 23: {
                        T_COMPLEX[][] s = ts.complexSeq();
                        StringBuffer buf = new StringBuffer();
                        int noStr = s.length;
                        for (int i = 0; i < noStr; ++i) {
                            buf.append("\n" + i + ": ");
                            buf.append(OdsxHelper.seqToString(s[i], maxCount, multiLine, lineCount));
                        }
                        tsString = buf.toString();
                        break;
                    }
                    case 24: {
                        T_DCOMPLEX[][] s = ts.dcomplexSeq();
                        StringBuffer buf = new StringBuffer();
                        int noStr = s.length;
                        for (int i = 0; i < noStr; ++i) {
                            buf.append("\n" + i + ": ");
                            buf.append(OdsxHelper.seqToString(s[i], maxCount, multiLine, lineCount));
                        }
                        tsString = buf.toString();
                        break;
                    }
                    case 29: {
                        T_ExternalReference[][] s = ts.extRefSeq();
                        StringBuffer buf = new StringBuffer();
                        int noStr = s.length;
                        for (int i = 0; i < noStr; ++i) {
                            buf.append("\n" + i + ": ");
                            buf.append(OdsxHelper.seqToString(s[i], maxCount, multiLine, lineCount));
                        }
                        tsString = buf.toString();
                        break;
                    }
                    default: {
                        tsString = "Unknown datatype " + ts.discriminator().value() + " in class OdsxHelper";
                        break;
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return tsString;
    }

    public static String nameValueUnitToString(NameValueUnit nvu) {
        String nvuString = "";
        if (nvu != null) {
            nvuString = nvu.valName + " = " + OdsxHelper.ts_valueToString(nvu.value) + " [" + nvu.unit + "]";
        }
        return nvuString;
    }

    public static String nameValueSeqUnitToString(NameValueSeqUnit nvu) {
        String nvuString = "";
        if (nvu != null) {
            nvuString = nvu.valName + " = " + OdsxHelper.ts_valueSeqToString(nvu.value) + " [" + nvu.unit + "]";
        }
        return nvuString;
    }

    public static String nameValueSeqUnitIdToString(NameValueSeqUnitId nvu) {
        String nvuString = "";
        if (nvu != null) {
            nvuString = nvu.valName + " = " + OdsxHelper.ts_valueSeqToString(nvu.value) + " [" + nvu.unitId.low + "]";
        }
        return nvuString;
    }

    public static String nameValueToString(NameValue nvu) {
        String nvuString = "";
        if (nvu != null) {
            nvuString = OdsxHelper.ts_valueToString(nvu.value);
        }
        return nvuString;
    }

    public static String relationRangeToString(RelationRange relRange) {
        StringBuffer str = new StringBuffer(100);
        str.append("min = " + relRange.min);
        str.append(" max = ");
        switch (relRange.max) {
            case -1: {
                str.append("Many");
                break;
            }
            default: {
                str.append(relRange.max);
            }
        }
        return str.toString();
    }

    public static String relationshipToString(Relationship relship) {
        String str;
        switch (relship.value()) {
            case 0: {
                str = "FATHER";
                break;
            }
            case 1: {
                str = "CHILD";
                break;
            }
            case 2: {
                str = "INFO_TO";
                break;
            }
            case 3: {
                str = "INFO_FROM";
                break;
            }
            case 4: {
                str = "INFO_REL";
                break;
            }
            case 5: {
                str = "SUPERTYPE";
                break;
            }
            case 6: {
                str = "SUBTYPE";
                break;
            }
            case 7: {
                str = "ALL_REL";
                break;
            }
            default: {
                str = "Unknown Relationship";
            }
        }
        return str;
    }

    public static String relationTypeToString(RelationType relType) {
        String str;
        switch (relType.value()) {
            case 0: {
                str = "FATHER_CHILD";
                break;
            }
            case 1: {
                str = "INFO";
                break;
            }
            case 2: {
                str = "INHERITANCE";
                break;
            }
            default: {
                str = "Unknown RelationType";
            }
        }
        return str;
    }

    public static String applAttrToString(ApplAttr aa) {
        StringBuffer str = new StringBuffer(1000);
        str.append("ApplAttr: aaName: " + aa.aaName);
        str.append(", baName: " + aa.baName);
        str.append(", length: " + aa.length);
        str.append(", dType: " + OdsxHelper.datatypeToString(aa.dType));
        str.append(", isObligatory: " + aa.isObligatory);
        str.append(", isUnique: " + aa.isUnique);
        str.append(", unitId: " + aa.unitId.high + "." + aa.unitId.low);
        return str.toString();
    }

    public static String applRelToString(ApplRel ar) {
        StringBuffer str = new StringBuffer(1000);
        str.append("ApplRel: arName: " + ar.arName);
        str.append(", brName: " + ar.brName);
        str.append(", invName: " + ar.invName);
        str.append(", invBrName: " + ar.invBrName);
        str.append(", arRelationType: " + OdsxHelper.relationTypeToString(ar.arRelationType));
        str.append(", arRelationRange: " + ar.arRelationRange.min + "." + ar.arRelationRange.max);
        str.append(", invRelationRange:" + ar.invRelationRange.min + "." + ar.invRelationRange.max);
        return str.toString();
    }

    public static String applElemToString(ApplElem ae) {
        StringBuffer str = new StringBuffer(1000);
        str.append("ApplElem: aeName: " + ae.aeName);
        str.append(", beName: " + ae.beName);
        str.append(", aid: " + ae.aid.high + "." + ae.aid.low);
        str.append("\nattributes:");
        for (int i = 0; i < ae.attributes.length; ++i) {
            str.append("\n\t" + i + ": ");
            String aa = OdsxHelper.applAttrToString(ae.attributes[i]);
            str.append(aa);
        }
        return str.toString();
    }

    public static String applicationStructureValueToString(ApplicationStructureValue asStr) {
        String ae;
        int i;
        StringBuffer str = new StringBuffer(1000);
        str.append("\napplElems:");
        for (i = 0; i < asStr.applElems.length; ++i) {
            str.append("\n" + i + ": ");
            ae = OdsxHelper.applElemToString(asStr.applElems[i]);
            str.append(ae);
        }
        str.append("\napplRelss:");
        for (i = 0; i < asStr.applRels.length; ++i) {
            str.append("\n" + i + ": ");
            ae = OdsxHelper.applRelToString(asStr.applRels[i]);
            str.append(ae);
        }
        return str.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InstanceElement copyInstance(String name, String version, String description, InstanceElement source, InstanceElement parent) throws FwkException, AoException {
        ApplicationRelation[] reList;
        NameValueUnit nvu;
        int i;
        AoSession sourceSession;
        InstanceElement ret = null;
        ApplicationElement parentAe = parent.getApplicationElement();
        ApplicationElement sourceAe = source.getApplicationElement();
        ApplicationStructure asObj = parentAe.getApplicationStructure();
        AoSession session = asObj.getSession();
        if (!session.equals(sourceSession = sourceAe.getApplicationStructure().getSession())) throw new FwkException(-1073676289, "$RCSfile: OdsxHelper.java,v $", version, "AH 2000-07-26 10:36", "InstanceElements are not from the same session.", null, null);
        BaseElement parentBe = parentAe.getBaseElement();
        BaseElement sourceBe = sourceAe.getBaseElement();
        Relationship ship = session.getBaseStructure().getRelation(parentBe, sourceBe).getRelationship();
        if (ship.value() != Relationship.CHILD.value()) throw new FwkException(-1073676289, "$RCSfile: OdsxHelper.java,v $", version, "AH 2000-07-26 10:44", "Father - child relation is not permitted.", null, null);
        ret = sourceAe.createInstance(name);
        String[] attrs = source.listAttributes("*", AttrType.ALL);
        int size = attrs.length;
        for (i = 0; i < size; ++i) {
            nvu = source.getValue(attrs[i]);
            ret.setValue(nvu);
        }
        if (version != null) {
            try {
                nvu = ret.getValueByBaseName("version");
                nvu.value.u.stringVal(version);
                ret.setValue(nvu);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (description != null) {
            try {
                nvu = ret.getValueByBaseName("description");
                nvu.value.u.stringVal(description);
                ret.setValue(nvu);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if ((reList = sourceAe.getRelationsByType(RelationType.INFO)) == null || reList.length == 0) return ret;
        size = reList.length;
        for (i = 0; i < size; ++i) {
            InstanceElementIterator iterator = source.getRelatedInstances(reList[i], "*");
            for (int iCount = iterator.getCount(); iCount > 0; --iCount) {
                iterator.nextOne().createRelation(reList[i], ret);
            }
            iterator.destroy();
        }
        return ret;
    }

    public static float getHighestVersion(T_LONGLONG parIId, T_LONGLONG parAId, ApplicationElement aeObj, String instanceName) {
        float odsVersion = -1.0f;
        try {
            ApplElemAccess aea = aeObj.getApplicationStructure().getSession().getApplElemAccess();
            QueryStructure aoq = new QueryStructure();
            T_LONGLONG aeId = aeObj.getId();
            aoq.condSeq = new SelValue[1];
            ApplicationAttribute aaObj = aeObj.getAttributeByBaseName("name");
            aoq.condSeq[0] = new SelValue();
            aoq.condSeq[0].attr = new AIDNameValueUnitId();
            aoq.condSeq[0].attr.attr = new AIDName();
            aoq.condSeq[0].attr.attr.aid = new T_LONGLONG(aeId.high, aeId.low);
            aoq.condSeq[0].attr.attr.aaName = aaObj.getName();
            aoq.condSeq[0].attr.unitId = new T_LONGLONG();
            aoq.condSeq[0].attr.values = new TS_Value();
            aoq.condSeq[0].attr.values.u = new TS_Union();
            aoq.condSeq[0].attr.values.u.shortVal((short)0);
            aoq.condSeq[0].oper = SelOpcode.LIKE;
            aoq.condSeq[0].value = new TS_Value();
            aoq.condSeq[0].value.u = new TS_Union();
            aoq.condSeq[0].value.u.stringVal(instanceName);
            aoq.operSeq = new SelOperator[0];
            aoq.anuSeq = new AIDNameUnitId[1];
            aaObj = aeObj.getAttributeByBaseName("version");
            aoq.anuSeq[0] = new AIDNameUnitId();
            aoq.anuSeq[0].attr = new AIDName();
            aoq.anuSeq[0].attr.aid = new T_LONGLONG(aeId.high, aeId.low);
            aoq.anuSeq[0].attr.aaName = aaObj.getName();
            aoq.anuSeq[0].unitId = new T_LONGLONG();
            aoq.relInst = new ElemId();
            aoq.relName = "";
            if (parIId != null && parAId != null) {
                aoq.relInst.aid = new T_LONGLONG(parAId.high, parAId.low);
                aoq.relInst.iid = new T_LONGLONG(parIId.high, parIId.low);
            } else {
                aoq.relInst.aid = new T_LONGLONG();
                aoq.relInst.iid = new T_LONGLONG();
            }
            aoq.orderBy = new SelOrder[0];
            ElemResultSet[] elemRes = aea.getInstances(aoq, 0);
            if (elemRes != null && elemRes[0].attrValues != null && elemRes[0].attrValues.length > 0) {
                String[] vArr = elemRes[0].attrValues[0].attrValues.value.u.stringVal();
                int aSize = vArr.length;
                for (int i = 0; i < aSize; ++i) {
                    try {
                        odsVersion = Math.max(odsVersion, Float.parseFloat(vArr[i]));
                        continue;
                    }
                    catch (Throwable tFloat) {
                        // empty catch block
                    }
                }
            }
            odsVersion = odsVersion < 0.0f ? 1.0f : (odsVersion += 1.0f);
        }
        catch (Throwable tInstances) {
            odsVersion = 1.0f;
        }
        return odsVersion;
    }

    public static String getHighestVersionString(T_LONGLONG parIId, T_LONGLONG parAId, ApplicationElement aeObj, String instanceName) {
        String ret = "";
        try {
            ret = "" + OdsxHelper.getHighestVersion(parIId, parAId, aeObj, instanceName);
            try {
                if (ret.endsWith(".0")) {
                    ret = ret.substring(0, ret.indexOf(46));
                }
            }
            catch (Throwable t) {
                ret = "" + (ret.charAt(0) + '\u0001');
            }
        }
        catch (Throwable tInstances) {
            ret = "1";
        }
        return ret;
    }

    public static String getOdsDate(Date date) {
        if (date == null) {
            date = Calendar.getInstance().getTime();
        }
        SimpleDateFormat formatter = new SimpleDateFormat(ODS_DATE_FORMAT);
        return formatter.format(date);
    }

    public static T_LONGLONG longToT_longlong(long id) {
        return new T_LONGLONG((int)(id >> 32 & 0xFFFFFFFFL), (int)(id & 0xFFFFFFFFL));
    }

    public static long t_longlongToLong(T_LONGLONG id) {
        long tmp = id.low >= 0 ? (long)id.high * 0x100000000L + (long)id.low : (long)(id.high + 1) * 0x100000000L + (long)id.low;
        return tmp;
    }

    public static String t_longlongToString(T_LONGLONG id) {
        return "" + OdsxHelper.t_longlongToLong(id);
    }

    public static String t_complexToString(T_COMPLEX complex) {
        return complex.r + " " + complex.i + "i";
    }

    public static String t_dcomplexToString(T_DCOMPLEX complex) {
        return complex.r + " " + complex.i + "i";
    }

    public static NameValueUnit getNameValueUnit(String name, String value) {
        NameValueUnit nvStr = new NameValueUnit();
        TS_Value tsVal = new TS_Value();
        TS_Union u = new TS_Union();
        u.stringVal(value);
        tsVal.u = u;
        nvStr.valName = name;
        nvStr.value = tsVal;
        return nvStr;
    }

    public static NameValueUnit getNameValueUnit(String name, int value) {
        NameValueUnit nvStr = new NameValueUnit();
        TS_Value tsVal = new TS_Value();
        TS_Union u = new TS_Union();
        u.longVal(value);
        tsVal.u = u;
        nvStr.valName = name;
        nvStr.value = tsVal;
        return nvStr;
    }

    public static NameValueUnit getNameValueUnit(String name, short value) {
        NameValueUnit nvStr = new NameValueUnit();
        TS_Value tsVal = new TS_Value();
        TS_Union u = new TS_Union();
        u.shortVal(value);
        tsVal.u = u;
        nvStr.valName = name;
        nvStr.value = tsVal;
        return nvStr;
    }

    public static NameValueUnit getNameValueUnit(String name, boolean value) {
        NameValueUnit nvStr = new NameValueUnit();
        TS_Value tsVal = new TS_Value();
        TS_Union u = new TS_Union();
        u.booleanVal(value);
        tsVal.u = u;
        nvStr.valName = name;
        nvStr.value = tsVal;
        return nvStr;
    }

    public static NameValueUnit getNameValueUnit(String name, float value) {
        NameValueUnit nvStr = new NameValueUnit();
        TS_Value tsVal = new TS_Value();
        TS_Union u = new TS_Union();
        u.floatVal(value);
        tsVal.u = u;
        nvStr.valName = name;
        nvStr.value = tsVal;
        return nvStr;
    }

    public static NameValueUnit getNameValueUnit(String name, double value) {
        NameValueUnit nvStr = new NameValueUnit();
        TS_Value tsVal = new TS_Value();
        TS_Union u = new TS_Union();
        u.doubleVal(value);
        tsVal.u = u;
        nvStr.valName = name;
        nvStr.value = tsVal;
        return nvStr;
    }

    public static NameValueUnit getNameValueUnit(String name, byte value) {
        NameValueUnit nvStr = new NameValueUnit();
        TS_Value tsVal = new TS_Value();
        TS_Union u = new TS_Union();
        u.byteVal(value);
        tsVal.u = u;
        nvStr.valName = name;
        nvStr.value = tsVal;
        return nvStr;
    }

    public static NameValueUnit getNameValueUnitDate(String name, String date) {
        NameValueUnit nvStr = new NameValueUnit();
        TS_Value tsVal = new TS_Value();
        TS_Union u = new TS_Union();
        u.dateVal(date);
        tsVal.u = u;
        nvStr.valName = name;
        nvStr.value = tsVal;
        return nvStr;
    }

    public static InstanceElement getParent(InstanceElement ieObj) {
        InstanceElement ret = null;
        try {
            InstanceElementIterator it = ieObj.getRelatedInstancesByRelationship(Relationship.FATHER, "*");
            ret = it.nextOne();
            it.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static ApplicationElement getParent(ApplicationElement aeObj) {
        ApplicationElement ret = null;
        try {
            ApplicationElement[] father = aeObj.getRelatedElementsByRelationship(Relationship.FATHER);
            if (father != null) {
                String aName = aeObj.getName();
                for (int i = 0; i < father.length; ++i) {
                    if (father[i].getName().compareToIgnoreCase(aName) == 0) continue;
                    ret = father[i];
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static InstanceElement[] getChildren(InstanceElement ieObj) {
        InstanceElement[] ret = new InstanceElement[]{};
        try {
            InstanceElementIterator it = ieObj.getRelatedInstancesByRelationship(Relationship.CHILD, "*");
            int count = it.getCount();
            ret = new InstanceElement[count];
            int i = 0;
            while (count-- > 0) {
                ret[i] = it.nextOne();
                ++i;
            }
            it.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public static InstanceElement[] getInstancesById(ApplicationStructure asObj, ElemId[] ei) throws AoException {
        return OdsxHelper.sortInstancesByElemIds(asObj.getInstancesById(ei), ei);
    }

    protected static InstanceElement[] sortInstancesByElemIds(InstanceElement[] ieArr, ElemId[] eiArr) {
        if (ieArr == null) {
            ieArr = new InstanceElement[]{};
        }
        if (eiArr != null && eiArr.length > 0 && eiArr.length >= ieArr.length) {
            int size = eiArr.length;
            int ieSize = ieArr.length;
            int[] ieIds = new int[ieSize];
            for (int i = 0; i < ieSize; ++i) {
                try {
                    ieIds[i] = ieArr[i].getId().low;
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            InstanceElement[] ret = new InstanceElement[size];
            for (int i = 0; i < ieSize; ++i) {
                int found = -1;
                for (int index = 0; index < size && found < 0; ++index) {
                    if (eiArr[index].iid.low != ieIds[i]) continue;
                    found = index;
                }
                if (found < 0) continue;
                ret[found] = ieArr[i];
            }
            return ret;
        }
        return ieArr;
    }

    public static DataType DT2DS(DataType dt) {
        DataType ret = null;
        switch (dt.value()) {
            case 4: {
                ret = DataType.from_int((int)18);
                break;
            }
            case 5: {
                ret = DataType.from_int((int)19);
                break;
            }
            case 11: {
                ret = DataType.from_int((int)27);
                break;
            }
            case 13: {
                ret = DataType.from_int((int)23);
                break;
            }
            case 10: {
                ret = DataType.from_int((int)26);
                break;
            }
            case 14: {
                ret = DataType.from_int((int)24);
                break;
            }
            case 7: {
                ret = DataType.from_int((int)21);
                break;
            }
            case 28: {
                ret = DataType.from_int((int)29);
                break;
            }
            case 3: {
                ret = DataType.from_int((int)17);
                break;
            }
            case 9: {
                ret = DataType.from_int((int)25);
                break;
            }
            case 6: {
                ret = DataType.from_int((int)20);
                break;
            }
            case 8: {
                ret = DataType.from_int((int)22);
                break;
            }
            case 2: {
                ret = DataType.from_int((int)16);
                break;
            }
            case 1: {
                ret = DataType.from_int((int)15);
                break;
            }
            default: {
                ret = DataType.from_int((int)dt.value());
            }
        }
        return ret;
    }

    public static DataType DS2DT(DataType dt) {
        DataType ret = null;
        switch (dt.value()) {
            case 18: {
                ret = DataType.from_int((int)4);
                break;
            }
            case 19: {
                ret = DataType.from_int((int)5);
                break;
            }
            case 27: {
                ret = DataType.from_int((int)11);
                break;
            }
            case 23: {
                ret = DataType.from_int((int)13);
                break;
            }
            case 26: {
                ret = DataType.from_int((int)10);
                break;
            }
            case 24: {
                ret = DataType.from_int((int)14);
                break;
            }
            case 21: {
                ret = DataType.from_int((int)7);
                break;
            }
            case 29: {
                ret = DataType.from_int((int)28);
                break;
            }
            case 17: {
                ret = DataType.from_int((int)3);
                break;
            }
            case 25: {
                ret = DataType.from_int((int)9);
                break;
            }
            case 20: {
                ret = DataType.from_int((int)6);
                break;
            }
            case 22: {
                ret = DataType.from_int((int)8);
                break;
            }
            case 16: {
                ret = DataType.from_int((int)2);
                break;
            }
            case 15: {
                ret = DataType.from_int((int)1);
                break;
            }
            default: {
                ret = DataType.from_int((int)dt.value());
            }
        }
        return ret;
    }

    public static String getODSVersion(AoSession session) {
        String ret;
        try {
            NameValue nv = session.getContextByName("ODSVERSION");
            ret = OdsxHelper.nameValueToString(nv).trim();
        }
        catch (Throwable t) {
            ret = ODS_VERSION;
        }
        return ret;
    }

    public static String getODSVersion(OdsxSessionInterface session) {
        try {
            return OdsxHelper.getODSVersion(session.getSession());
        }
        catch (Throwable t) {
            return ODS_VERSION;
        }
    }

    public static boolean hasSelfReference(ApplicationElement aeObj) throws AoException {
        boolean ret = false;
        ApplicationElement[] father = aeObj.getRelatedElementsByRelationship(Relationship.FATHER);
        if (father.length > 0) {
            ApplicationElement[] children = aeObj.getRelatedElementsByRelationship(Relationship.CHILD);
            for (int i = 0; !ret && i < children.length; ++i) {
                for (int f = 0; !ret && f < father.length; ++f) {
                    ret = children[i].getName().compareTo(father[f].getName()) == 0;
                }
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        String s = "12.4i";
        String[] arr = s.split("[a-zA-Z_]");
        for (int i = 0; i < arr.length; ++i) {
            System.out.println(arr[i]);
        }
    }

    static {
        Locale locale = FwkContainer.getLocale();
        deLang = locale.getLanguage().compareTo("de") == 0;
    }
}

