/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnAssignmentInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnSaveInfoInterface;
import com.highqsoft.interfaces.odsx.OdsxMeasurementSaveInfoInterface;
import com.highqsoft.interfaces.odsx.OdsxParameterSetSaveInfoInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.interfaces.odsx.OdsxSubMatrixSaveInfoInterface;
import com.highqsoft.ods.AoService;
import com.highqsoft.ods.AoServiceFactory;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.asam.ods.AoException;
import org.asam.ods.AoFactory;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.BaseElement;
import org.asam.ods.DataType;
import org.asam.ods.ElemId;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.NameValue;
import org.asam.ods.NameValueUnit;
import org.asam.ods.RelationType;
import org.asam.ods.Relationship;
import org.asam.ods.TS_Union;
import org.asam.ods.TS_Value;
import org.asam.ods.T_LONGLONG;

public class OdsxMeasurementHelper {
    public static final String version = "$Revision: 1.9 $";
    protected static Object LOCK = new Object();

    public static String getVersion() {
        return version;
    }

    private OdsxMeasurementHelper() {
    }

    protected static void setAttributes(SaveContext saveContext, InstanceElement ieObj, ApplicationElement aeObj, Map attrs) throws AoException {
        if (attrs != null && attrs.size() > 0) {
            Iterator it;
            if (FwkContainer.getDebugLevel() > 0) {
                System.out.println(OdsxMeasurementHelper.class + ".setAttributes() ***************************");
                System.out.println(OdsxMeasurementHelper.class + ".setAttributes() ae = " + aeObj.getName() + " (" + attrs.size() + ")");
                it = attrs.keySet().iterator();
                while (it.hasNext()) {
                    Object k = it.next();
                    System.out.println("\t" + k + " " + attrs.get(k));
                }
            }
            it = attrs.keySet().iterator();
            ApplicationAttribute aaObj = null;
            Vector<NameValueUnit> nvuVec = new Vector<NameValueUnit>();
            while (it.hasNext()) {
                String key = (String)it.next();
                aaObj = saveContext.getApplicationAttribute(ieObj, key);
                if (aaObj != null) {
                    String value = attrs.get(key).toString();
                    DataType dt = saveContext.getDataType(aaObj);
                    int aaLen = saveContext.getLength(aaObj);
                    if (aaLen > 0 && dt.value() == 1 && value.length() > aaLen) {
                        value = value.substring(0, aaLen);
                    }
                    if (FwkContainer.getDebugLevel() > 0) {
                        System.out.println((class$com$highqsoft$odsx$OdsxMeasurementHelper == null ? OdsxMeasurementHelper.class$("com.highqsoft.odsx.OdsxMeasurementHelper") : class$com$highqsoft$odsx$OdsxMeasurementHelper) + ".setAttributes() " + key + ": " + value + " aaObj: " + aaObj.getName());
                    }
                    NameValueUnit nvu = OdsxHelper.parseNameValueUnit(saveContext.getNameValueUnit(ieObj, aeObj, aaObj), value);
                    if (nvu.value != null) {
                        nvuVec.add(nvu);
                        continue;
                    }
                    System.err.println("There is no value for attribute " + key);
                    continue;
                }
                if (FwkContainer.getDebugLevel() < 1) continue;
                System.err.println("BaseAttribute or ApplicationAttribute <" + key + "> not found.");
            }
            if (nvuVec.size() > 0) {
                if (FwkContainer.getDebugLevel() > 0) {
                    NameValueUnit[] t = nvuVec.toArray(new NameValueUnit[0]);
                    for (int tt = 0; tt < t.length; ++tt) {
                        System.out.print("tt = " + tt + " " + t[tt].valName + " -> ");
                        System.out.print(OdsxHelper.nameValueUnitToString(t[tt]));
                        System.out.println(" " + OdsxHelper.datatypeToString(t[tt].value.u.discriminator()));
                    }
                    System.out.println("***************************");
                }
                ieObj.setValueSeq(nvuVec.toArray(new NameValueUnit[0]));
                nvuVec.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstanceElement saveMeasurement(String asamPath, OdsxMeasurementSaveInfoInterface meaInfo) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            boolean reconnected;
            AoSession aoSession;
            SaveContext saveContext;
            InstanceElement meaIe;
            block56: {
                Map attributes = meaInfo.getAttributes();
                if (attributes == null) {
                    return null;
                }
                meaIe = null;
                saveContext = null;
                OdsxSubMatrixSaveInfoInterface[] subInfo = meaInfo.getSubMatrixSaveInfo();
                int totalSM = 0;
                if (subInfo != null) {
                    totalSM = subInfo.length;
                }
                aoSession = meaInfo.getSession();
                reconnected = false;
                if (aoSession != null && asamPath != null && asamPath.length() != 0 && totalSM != 0) {
                    OdsxSessionInterface observer = OdsxSessionFactory.getSessionObserver(aoSession);
                    if (observer != null) {
                        try {
                            AoService aoService = AoServiceFactory.newService((String)observer.getPlumName(), (String)observer.getServiceOptions());
                            AoFactory aoFactory = aoService.newFactory(observer.getServiceName(), observer.getSessionOptions());
                            AoSession tmp = aoFactory.newSession(observer.getAuthentication());
                            if (tmp != null) {
                                aoSession = tmp;
                                reconnected = true;
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    try {
                        String beType;
                        ApplicationElement meaAe = null;
                        InstanceElement parIe = null;
                        saveContext = new SaveContext(aoSession);
                        String versionDate = saveContext.versionDate;
                        ApplicationStructure asObj = saveContext.getApplicationStructure();
                        InstanceElement ieObj = asObj.getInstanceByAsamPath(asamPath);
                        ApplicationElement aeObj = saveContext.getApplicationElement(ieObj);
                        BaseElement beObj = saveContext.getBaseElement(aeObj);
                        String sourceBeType = beType = beObj.getType();
                        if (beType.compareToIgnoreCase("AoMeasurement") == 0) {
                            InstanceElementIterator ei;
                            meaAe = aeObj;
                            ApplicationElement[] aeList = aeObj.getRelatedElementsByRelationship(Relationship.FATHER);
                            if (aeList != null && aeList.length > 0) {
                                aeObj = aeList[0];
                                beObj = saveContext.getBaseElement(aeObj);
                                beType = saveContext.getBaseType(beObj);
                            }
                            if ((ei = ieObj.getRelatedInstancesByRelationship(Relationship.FATHER, "*")) != null && ei.getCount() > 0) {
                                ei.reset();
                                parIe = ei.nextOne();
                            }
                            ei.destroy();
                        } else {
                            parIe = ieObj;
                            meaAe = saveContext.getApplicationElement("AoMeasurement");
                        }
                        ApplicationAttribute nameAa = saveContext.getApplicationAttribute(meaAe, "name");
                        String meaName = meaInfo.getName();
                        if (parIe != null && meaAe != null && (beType.compareToIgnoreCase("AoSubTest") == 0 || beType.compareToIgnoreCase("AoTest") == 0)) {
                            String measurementVersion = OdsxHelper.getHighestVersionString(parIe.getId(), saveContext.getApplicationElement(parIe).getId(), meaAe, meaName);
                            if (!attributes.containsKey("version")) {
                                attributes.put("version", measurementVersion);
                            }
                            if (!attributes.containsKey("version_date")) {
                                attributes.put("version_date", versionDate);
                            }
                            aoSession.startTransaction();
                            try {
                                ApplicationRelation[] reParMeaList;
                                block55: {
                                    int nameLength = saveContext.getLength(nameAa);
                                    meaIe = nameLength > 0 && nameLength < meaName.length() ? meaAe.createInstance(meaName.substring(0, nameLength)) : meaAe.createInstance(meaName);
                                    saveContext.add(meaAe, meaIe);
                                    OdsxMeasurementHelper.setAttributes(saveContext, meaIe, meaAe, attributes);
                                    try {
                                        String version;
                                        NameValueUnit nvuVersion = meaIe.getValueByBaseName("version");
                                        if (nvuVersion == null || (version = nvuVersion.value.u.stringVal()) == null || version.length() == 0) break block55;
                                        try {
                                            float userVersion = new Float(version).floatValue();
                                            try {
                                                float systemVersion = new Float(measurementVersion).floatValue();
                                                if (userVersion > systemVersion) {
                                                    measurementVersion = new Float(userVersion).toString();
                                                }
                                            }
                                            catch (NumberFormatException sysnfe) {
                                                // empty catch block
                                            }
                                            if (version.compareTo(measurementVersion) != 0) {
                                                nvuVersion.value.u.stringVal(measurementVersion);
                                                meaIe.setValue(nvuVersion);
                                            }
                                        }
                                        catch (NumberFormatException usernfe) {}
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                }
                                if (sourceBeType.compareToIgnoreCase("AoMeasurement") == 0) {
                                    try {
                                        ApplicationRelation[] reList = meaAe.getRelationsByType(RelationType.INFO);
                                        if (reList != null && reList.length != 0) {
                                            int size = reList.length;
                                            for (int i = 0; i < size; ++i) {
                                                try {
                                                    InstanceElementIterator iterator = ieObj.getRelatedInstances(reList[i], "*");
                                                    for (int iCount = iterator.getCount(); iCount > 0; --iCount) {
                                                        iterator.nextOne().createRelation(reList[i], meaIe);
                                                    }
                                                    iterator.destroy();
                                                    continue;
                                                }
                                                catch (AoException tRelation) {
                                                    System.err.println(tRelation.reason);
                                                    tRelation.printStackTrace();
                                                }
                                            }
                                        }
                                    }
                                    catch (AoException tRelationType) {
                                        System.err.println(tRelationType.reason);
                                        tRelationType.printStackTrace();
                                    }
                                }
                                if ((reParMeaList = saveContext.getRelations(aeObj, meaAe)) != null && reParMeaList.length != 0) {
                                    int size = reParMeaList.length;
                                    for (int i = 0; i < size; ++i) {
                                        parIe.createRelation(reParMeaList[i], meaIe);
                                    }
                                }
                            }
                            catch (AoException aoeT) {
                                System.err.println(aoeT.reason);
                                try {
                                    aoSession.abortTransaction();
                                }
                                catch (Throwable tAbort) {
                                    // empty catch block
                                }
                                if (reconnected) {
                                    aoSession.close();
                                }
                                throw aoeT;
                            }
                            aoSession.commitTransaction();
                            InstanceElement psIe = OdsxMeasurementHelper.createParameterSet(saveContext, meaIe, meaInfo.getParameterSetSaveInfo());
                            for (int i = 0; i < totalSM; ++i) {
                                OdsxMeasurementHelper.createSubMatrix(saveContext, meaIe, psIe, subInfo[i]);
                            }
                            break block56;
                        }
                        meaIe = null;
                    }
                    catch (AoException oao) {
                        System.err.println(oao.reason);
                        if (reconnected) {
                            aoSession.close();
                        }
                        throw oao;
                    }
                    catch (Exception t) {
                        System.err.println(t.getMessage());
                        t.printStackTrace();
                        if (reconnected) {
                            aoSession.close();
                        }
                        throw t;
                    }
                }
            }
            try {
                OdsxMeasurementHelper.validateMEQAttrs(saveContext, aoSession, meaIe);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (reconnected) {
                if (meaIe != null) {
                    T_LONGLONG aId = null;
                    T_LONGLONG iId = null;
                    try {
                        aId = meaIe.getApplicationElement().getId();
                        iId = meaIe.getId();
                        AoSession aoSes = meaInfo.getSession();
                        InstanceElement[] ret = aoSes.getApplicationStructure().getInstancesById(new ElemId[]{new ElemId(aId, iId)});
                        meaIe.destroy();
                        meaIe = ret[0];
                    }
                    catch (AoException aoe) {
                        System.err.println(OdsxHelper.aoExceptionToString(aoe));
                        if (FwkContainer.getDebugLevel() > 0) {
                            aoe.printStackTrace();
                        }
                        throw aoe;
                    }
                    catch (Throwable t) {
                        System.err.println(t.getClass().getName() + " " + t.getMessage());
                        System.err.println(aId.low + "/" + iId.low + " instance not found!");
                        if (FwkContainer.getDebugLevel() > 0) {
                            t.printStackTrace();
                        }
                        meaIe = null;
                    }
                }
                aoSession.close();
            }
            return meaIe;
        }
    }

    protected static InstanceElement createSubMatrix(SaveContext saveContext, InstanceElement ieObj, OdsxSubMatrixSaveInfoInterface subInfo) throws Exception {
        ApplicationStructure asObj;
        InstanceElement subIe = null;
        if (saveContext == null) {
            saveContext = new SaveContext(subInfo.getSession());
        }
        if ((asObj = saveContext.getApplicationStructure()) != null && ieObj != null) {
            try {
                InstanceElement parIe = null;
                try {
                    ApplicationElement paeObj = null;
                    try {
                        paeObj = saveContext.getApplicationElement(subInfo.getParameterSetSaveInfo().getParameterSetApplElemName());
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (paeObj != null) {
                        ApplicationRelation[] rel = saveContext.getRelations(saveContext.getApplicationElement(ieObj), paeObj);
                        InstanceElementIterator it = ieObj.getRelatedInstances(rel[0], "*");
                        parIe = it.nextOne();
                        it.destroy();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                subIe = OdsxMeasurementHelper.createSubMatrix(saveContext, ieObj, parIe, subInfo);
            }
            catch (AoException oao) {
                System.err.println(oao.reason);
            }
        }
        return subIe;
    }

    public static InstanceElement createSubMatrix(SaveContext saveContext, InstanceElement meaIe, InstanceElement parIe, OdsxSubMatrixSaveInfoInterface subInfo) throws Exception {
        if (saveContext == null) {
            saveContext = new SaveContext(subInfo.getSession());
        }
        InstanceElement subIe = null;
        ApplicationElement meaAe = null;
        String versionDate = saveContext.versionDate;
        OdsxColumnSaveInfoInterface[] colInfo = subInfo.getColumnSaveInfo();
        AoSession aoSession = saveContext.getSession();
        boolean version4 = false;
        if (aoSession != null && meaIe != null) {
            boolean bl = version4 = saveContext.odsVersionVal() >= 4.0f;
            if (saveContext.getBaseType(meaIe).compareToIgnoreCase("AoMeasurement") == 0) {
                meaAe = saveContext.getApplicationElement(meaIe);
            }
            if (meaAe != null) {
                aoSession.startTransaction();
                int size = 0;
                InstanceElement[] cols = null;
                try {
                    Map attributes;
                    ApplicationRelation[] reMeaSubList;
                    ApplicationElement subAe = saveContext.getApplicationElement("AoSubmatrix");
                    if (version4) {
                        ApplicationAttribute subNameAa = saveContext.getApplicationAttribute(subAe, "name");
                        String subName = subInfo.getName();
                        int nameLength = saveContext.getLength(subNameAa);
                        subIe = nameLength > 0 && nameLength < subName.length() ? subAe.createInstance(subName.substring(0, nameLength)) : subAe.createInstance(subName);
                        saveContext.add(subAe, subIe);
                    } else {
                        int subListCount;
                        reMeaSubList = saveContext.getRelations(meaAe, subAe);
                        InstanceElementIterator curSubList = meaIe.getRelatedInstances(reMeaSubList[0], "*");
                        int maxName = subListCount = curSubList.getCount();
                        InstanceElement ieObj = null;
                        while (subListCount > 0) {
                            try {
                                ieObj = curSubList.nextOne();
                                maxName = Math.max(maxName, Integer.parseInt(ieObj.getName()));
                            }
                            catch (Throwable tSubName) {
                                // empty catch block
                            }
                            --subListCount;
                        }
                        curSubList.destroy();
                        subIe = subAe.createInstance("" + (maxName + 1));
                        saveContext.add(subAe, subIe);
                    }
                    reMeaSubList = saveContext.getRelations(meaAe, subAe);
                    if (reMeaSubList != null && reMeaSubList.length != 0) {
                        size = reMeaSubList.length;
                        for (int count = 0; count < size; ++count) {
                            meaIe.createRelation(reMeaSubList[count], subIe);
                        }
                    }
                    if (!(attributes = subInfo.getAttributes()).containsKey("version_date") || versionDate.compareTo((String)attributes.get("version_date")) < 0) {
                        attributes.put("version_date", versionDate);
                    }
                    if (colInfo != null && colInfo.length > 0) {
                        if (!attributes.containsKey("number_of_rows")) {
                            attributes.put("number_of_rows", "" + colInfo[0].getCount());
                        }
                    } else {
                        attributes.put("number_of_rows", "0");
                    }
                    OdsxMeasurementHelper.setAttributes(saveContext, subIe, subAe, attributes);
                    if (colInfo != null && colInfo.length > 0) {
                        size = colInfo.length;
                        cols = new InstanceElement[size];
                        for (int i = 0; i < size; ++i) {
                            cols[i] = OdsxMeasurementHelper.createColumn(saveContext, meaIe, subIe, colInfo[i]);
                        }
                    }
                }
                catch (AoException aoe) {
                    try {
                        aoSession.abortTransaction();
                    }
                    catch (AoException att) {
                        System.err.println(aoe.reason);
                    }
                    System.err.println(aoe.reason);
                    aoe.printStackTrace();
                    throw aoe;
                }
                aoSession.commitTransaction();
                aoSession.startTransaction();
                try {
                    OdsxMeasurementHelper.createParameters(saveContext, subIe, parIe, subInfo.getParameterSetSaveInfo());
                    if (cols != null && cols.length > 0) {
                        for (int i = 0; i < size; ++i) {
                            if (cols[i] == null || colInfo[i] == null) continue;
                            OdsxMeasurementHelper.createParameters(saveContext, cols[i], parIe, colInfo[i].getParameterSetSaveInfo());
                        }
                    }
                }
                catch (AoException aoe) {
                    try {
                        aoSession.abortTransaction();
                    }
                    catch (AoException att) {
                        System.err.println(aoe.reason);
                    }
                    System.err.println(aoe.reason);
                    aoe.printStackTrace();
                    throw aoe;
                }
                aoSession.commitTransaction();
            }
        }
        return subIe;
    }

    public static void validateMEQAttrs(SaveContext saveContext, AoSession aoSession, InstanceElement meaIe) throws Exception {
        if (saveContext == null) {
            saveContext = new SaveContext(aoSession);
        }
        try {
            ApplicationElement meqAe = saveContext.getApplicationElement("AoMeasurementQuantity");
            ApplicationElement meaAe = saveContext.getApplicationElement("AoMeasurement");
            ApplicationElement lcAe = saveContext.getApplicationElement("AoLocalColumn");
            ApplicationRelation reMeqLc = saveContext.getRelations(meqAe, lcAe)[0];
            ApplicationRelation reMeaMeq = saveContext.getRelations(meaAe, meqAe)[0];
            InstanceElementIterator meqs = meaIe.getRelatedInstances(reMeaMeq, "*");
            int count = meqs.getCount();
            aoSession.startTransaction();
            Vector<NameValueUnit> nvuVec = new Vector<NameValueUnit>();
            while (count-- > 0) {
                InstanceElement meqIe = meqs.nextOne();
                InstanceElementIterator it = meqIe.getRelatedInstances(reMeqLc, "*");
                if (it.getCount() > 1) {
                    block21: {
                        NameValueUnit nvu;
                        block20: {
                            block19: {
                                block18: {
                                    nvu = null;
                                    try {
                                        nvu = saveContext.getNameValueUnit(meqIe, meqAe, "minimum");
                                        nvu.value.flag = 0;
                                        nvuVec.add(nvu);
                                    }
                                    catch (Throwable t) {
                                        if (FwkContainer.getDebugLevel() <= 0) break block18;
                                        t.printStackTrace();
                                    }
                                }
                                try {
                                    nvu = saveContext.getNameValueUnit(meqIe, meqAe, "maximum");
                                    nvu.value.flag = 0;
                                    nvuVec.add(nvu);
                                }
                                catch (Throwable t) {
                                    if (FwkContainer.getDebugLevel() <= 0) break block19;
                                    t.printStackTrace();
                                }
                            }
                            try {
                                nvu = saveContext.getNameValueUnit(meqIe, meqAe, "average");
                                nvu.value.flag = 0;
                                nvuVec.add(nvu);
                            }
                            catch (Throwable t) {
                                if (FwkContainer.getDebugLevel() <= 0) break block20;
                                t.printStackTrace();
                            }
                        }
                        try {
                            nvu = saveContext.getNameValueUnit(meqIe, meqAe, "standard_deviation");
                            nvu.value.flag = 0;
                            nvuVec.add(nvu);
                        }
                        catch (Throwable t) {
                            if (FwkContainer.getDebugLevel() <= 0) break block21;
                            t.printStackTrace();
                        }
                    }
                    if (nvuVec.size() > 0) {
                        try {
                            meqIe.setValueSeq(nvuVec.toArray(new NameValueUnit[0]));
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        nvuVec.clear();
                    }
                }
                it.destroy();
            }
            meqs.destroy();
            aoSession.commitTransaction();
        }
        catch (AoException aoe) {
            try {
                aoSession.abortTransaction();
            }
            catch (AoException att) {
                System.err.println(aoe.reason);
            }
            System.err.println(aoe.reason);
            aoe.printStackTrace();
            throw aoe;
        }
    }

    public static InstanceElement createColumn(SaveContext saveContext, InstanceElement meaIe, InstanceElement subIe, OdsxColumnSaveInfoInterface colInfo) throws Exception {
        InstanceElement colIe = null;
        if (subIe != null && colInfo != null) {
            int nameLength;
            if (saveContext == null) {
                saveContext = new SaveContext(colInfo.getSession());
            }
            String versionDate = saveContext.versionDate;
            ApplicationElement subAe = saveContext.getApplicationElement(subIe);
            ApplicationElement qAe = saveContext.getApplicationElement("AoQuantity");
            ApplicationElement meqAe = saveContext.getApplicationElement("AoMeasurementQuantity");
            ApplicationElement lcAe = saveContext.getApplicationElement("AoLocalColumn");
            ApplicationElement unitAe = saveContext.getApplicationElement("AoUnit");
            ApplicationElement meaAe = saveContext.getApplicationElement("AoMeasurement");
            ApplicationRelation reSubLc = saveContext.getRelations(subAe, lcAe)[0];
            ApplicationRelation reMeqLc = saveContext.getRelations(meqAe, lcAe)[0];
            ApplicationRelation reMeaMeq = saveContext.getRelations(meaAe, meqAe)[0];
            ApplicationRelation[] meqQRList = null;
            ApplicationRelation[] meqUnitRList = null;
            if (meqAe != null && qAe != null) {
                meqQRList = saveContext.getRelations(qAe, meqAe);
                meqUnitRList = null;
                if (unitAe != null) {
                    meqUnitRList = saveContext.getRelations(meqAe, unitAe);
                }
            }
            int dataType = colInfo.getDataType();
            int typeSize = 4;
            String qName = colInfo.getQuantityName();
            InstanceElement qIe = saveContext.getQuantity(qName);
            saveContext.add(qAe, qIe);
            InstanceElement meqIe = saveContext.getMEQ(reMeaMeq, meaIe, colInfo.getName());
            if (meqIe == null) {
                try {
                    typeSize = qIe.getValueByBaseName((String)"default_type_size").value.u.longVal();
                }
                catch (Throwable defaultDataTypeException) {
                    // empty catch block
                }
                ApplicationAttribute meqNameAa = saveContext.getApplicationAttribute(meqAe, "name");
                String meqName = colInfo.getName();
                nameLength = saveContext.getLength(meqNameAa);
                meqIe = nameLength > 0 && nameLength < meqName.length() ? meqAe.createInstance(meqName.substring(0, nameLength)) : meqAe.createInstance(meqName);
                saveContext.add(meqAe, meqIe);
                Map attributes = colInfo.getAttributes();
                if (!attributes.containsKey("version_date") || versionDate.compareTo((String)attributes.get("version_date")) < 0) {
                    attributes.put("version_date", saveContext.versionDate);
                }
                if (!attributes.containsKey("datatype")) {
                    attributes.put("datatype", "" + dataType);
                }
                if (!attributes.containsKey("type_size")) {
                    try {
                        dataType = Integer.parseInt(attributes.get("datatype").toString());
                        attributes.put("type_size", "" + OdsxHelper.getTypeSize(dataType));
                    }
                    catch (Throwable t) {
                        attributes.put("type_size", "" + typeSize);
                    }
                }
                OdsxMeasurementHelper.setAttributes(saveContext, meqIe, meqAe, attributes);
                try {
                    NameValueUnit mimeVal = meqIe.getValueByBaseName("mime_type");
                    String mime = OdsxHelper.ts_valueToString(mimeVal.value);
                    int index = mime.toLowerCase().indexOf("aolocalcolumn");
                    if (index > 0) {
                        mime = mime.substring(0, index) + "aomeasurementquantity" + mime.substring(index + "aolocalcolumn".length(), mime.length());
                        meqIe.setValue(OdsxHelper.parseNameValueUnit(mimeVal, mime));
                    }
                }
                catch (Throwable meqMimeT) {
                    // empty catch block
                }
                saveContext.meqMap.put(colInfo.getName(), meqIe);
                if (qIe != null && meqQRList != null && meqQRList.length != 0) {
                    int len = meqQRList.length;
                    for (int count = 0; count < len; ++count) {
                        meqIe.createRelation(meqQRList[count], qIe);
                    }
                }
                meaIe.createRelation(reMeaMeq, meqIe);
                if (unitAe != null) {
                    InstanceElement unitIe = null;
                    try {
                        InstanceElementIterator ii = unitAe.getInstances(colInfo.getUnitString());
                        unitIe = ii.nextOne();
                        ii.destroy();
                    }
                    catch (Throwable tQIe) {
                        unitIe = null;
                    }
                    if (unitIe != null && meqUnitRList != null && meqUnitRList.length != 0) {
                        int len = meqUnitRList.length;
                        for (int j = 0; j < len; ++j) {
                            unitIe.createRelation(meqUnitRList[j], meqIe);
                        }
                    }
                }
            }
            ApplicationAttribute lcNameAa = saveContext.getApplicationAttribute(lcAe, "name");
            String lcName = colInfo.getName();
            nameLength = saveContext.getLength(lcNameAa);
            colIe = nameLength > 0 && nameLength < lcName.length() ? lcAe.createInstance(lcName.substring(0, nameLength)) : lcAe.createInstance(lcName);
            saveContext.add(lcAe, colIe);
            ApplicationAttribute lcValueAa = saveContext.getApplicationAttribute(lcAe, "values");
            ApplicationAttribute lcFlagAa = saveContext.getApplicationAttribute(lcAe, "flags");
            Map attributes = colInfo.getAttributes();
            if (!attributes.containsKey("version_date") || versionDate.compareTo((String)attributes.get("version_date")) < 0) {
                attributes.put("version_date", versionDate);
            }
            OdsxMeasurementHelper.setAttributes(saveContext, colIe, lcAe, attributes);
            TS_Value value = new TS_Value();
            value.u = colInfo.getValues(dataType);
            value.flag = (short)15;
            NameValueUnit nvStr = new NameValueUnit();
            nvStr.valName = lcValueAa.getName();
            nvStr.unit = colInfo.getUnitString();
            if (nvStr.unit == null) {
                nvStr.unit = "";
            }
            nvStr.value = value;
            colIe.setValue(nvStr);
            boolean setFlags = true;
            try {
                NameValueUnit gfnvu = colIe.getValueByBaseName("global_flag");
                setFlags = (gfnvu.value.flag & 1) == 0;
            }
            catch (Throwable tGlobalFlag) {
                // empty catch block
            }
            if (setFlags) {
                value = new TS_Value();
                value.u = colInfo.getFlags();
                value.flag = (short)15;
                nvStr = new NameValueUnit();
                nvStr.valName = lcFlagAa.getName();
                nvStr.unit = "";
                nvStr.value = value;
                colIe.setValue(nvStr);
            }
            subIe.createRelation(reSubLc, colIe);
            meqIe.createRelation(reMeqLc, colIe);
        }
        return colIe;
    }

    public static InstanceElement createParameterSet(SaveContext saveContext, InstanceElement ieObj, OdsxParameterSetSaveInfoInterface pSet) throws AoException {
        if (pSet != null) {
            if (saveContext == null) {
                saveContext = new SaveContext(pSet.getSession());
            }
            InstanceElement ret = null;
            ApplicationElement aeObj = saveContext.getApplicationElement(ieObj);
            ApplicationElement paeObj = null;
            try {
                paeObj = saveContext.getApplicationElement(pSet.getParameterSetApplElemName());
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (paeObj != null) {
                ApplicationRelation[] rel = saveContext.getRelations(aeObj, paeObj);
                if (paeObj != null && rel != null && rel.length != 0) {
                    AoSession session = saveContext.getSession();
                    session.startTransaction();
                    try {
                        ApplicationAttribute parNameAa;
                        int nameLength;
                        String pName = pSet.getName();
                        Map attributes = pSet.getAttributes();
                        String versionDate = saveContext.versionDate;
                        if (!attributes.containsKey("version_date") || versionDate.compareTo((String)attributes.get("version_date")) < 0) {
                            attributes.put("version_date", versionDate);
                        }
                        if (!attributes.containsKey("version")) {
                            attributes.put("version", OdsxHelper.getHighestVersionString(null, null, paeObj, pName));
                        }
                        ret = (nameLength = (parNameAa = saveContext.getApplicationAttribute(paeObj, "name")).getLength()) > 0 && nameLength < pName.length() ? paeObj.createInstance(pName.substring(0, nameLength)) : paeObj.createInstance(pName);
                        saveContext.add(paeObj, ret);
                        OdsxMeasurementHelper.setAttributes(saveContext, ret, paeObj, attributes);
                        int size = rel.length;
                        for (int i = 0; i < size; ++i) {
                            ieObj.createRelation(rel[i], ret);
                        }
                    }
                    catch (AoException aoe) {
                        try {
                            session.abortTransaction();
                        }
                        catch (AoException att) {
                            System.err.println(aoe.reason);
                        }
                        System.err.println(aoe.reason);
                        throw aoe;
                    }
                    session.commitTransaction();
                }
                return ret;
            }
        }
        return null;
    }

    public static void createParameters(SaveContext saveContext, InstanceElement ieObj, InstanceElement psIe, OdsxParameterSetSaveInfoInterface pSet) throws AoException {
        String odsVersionDate = OdsxHelper.getOdsDate(new Date());
        if (pSet != null && psIe != null) {
            if (saveContext == null) {
                saveContext = new SaveContext(pSet.getSession());
            }
            if (ieObj != null && psIe != null) {
                Map params;
                ApplicationElement aeObj = saveContext.getApplicationElement(ieObj);
                ApplicationElement psAe = saveContext.getApplicationElement(psIe);
                ApplicationElement pAe = null;
                try {
                    pAe = saveContext.getApplicationElement(pSet.getParameterApplElemName());
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (pAe == null) {
                    pAe = saveContext.getApplicationElement(pSet.getParameterApplElemName());
                }
                if (saveContext.parameterVersion == 0) {
                    String strVersion = OdsxHelper.getHighestVersionString(psIe.getId(), saveContext.getApplicationElement(psIe).getId(), pAe, "*");
                    saveContext.parameterVersion = 1;
                    try {
                        saveContext.parameterVersion = Math.round(Float.parseFloat(strVersion));
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                ApplicationRelation psRel = null;
                try {
                    psRel = saveContext.getRelations(pAe, psAe)[0];
                }
                catch (Throwable t) {
                    // empty catch block
                }
                ApplicationRelation ieRel = null;
                try {
                    ieRel = saveContext.getRelations(pAe, aeObj)[0];
                }
                catch (Throwable t) {
                    // empty catch block
                }
                ApplicationRelation unitRel = null;
                try {
                    unitRel = saveContext.getRelations(saveContext.getApplicationElement("AoUnit"), pAe)[0];
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (pSet != null && (params = pSet.getAttributes()) != null && params.size() > 0) {
                    Iterator it = params.keySet().iterator();
                    Object key = null;
                    String value = null;
                    String unit = null;
                    Vector<NameValueUnit> nvuVec = new Vector<NameValueUnit>();
                    while (it.hasNext()) {
                        InstanceElement ie;
                        block50: {
                            block49: {
                                ApplicationAttribute pValueAa;
                                block48: {
                                    block47: {
                                        block46: {
                                            value = null;
                                            key = it.next();
                                            if (key != null) {
                                                value = params.get(key).toString().trim();
                                            }
                                            if (key == null || value == null) continue;
                                            if (unitRel != null) {
                                                if (value.endsWith("]")) {
                                                    int idx = value.lastIndexOf(91);
                                                    if (idx > 0) {
                                                        unit = value.substring(idx + 1, value.length() - 1).trim();
                                                        value = value.substring(0, idx).trim();
                                                        if (unit.length() == 0) {
                                                            unit = "1";
                                                        }
                                                    } else {
                                                        unit = "1";
                                                    }
                                                } else {
                                                    unit = null;
                                                }
                                            }
                                            ApplicationAttribute pNameAa = saveContext.getApplicationAttribute(pAe, "name");
                                            String pName = key.toString();
                                            int nameLength = saveContext.getLength(pNameAa);
                                            ie = nameLength > 0 && nameLength < pName.length() ? pAe.createInstance(pName.substring(0, nameLength)) : pAe.createInstance(pName);
                                            saveContext.add(pAe, ie);
                                            try {
                                                nvuVec.add(OdsxHelper.parseNameValueUnit(saveContext.getNameValueUnit(ie, pAe, pNameAa), key.toString()));
                                            }
                                            catch (AoException nameT) {
                                                if (FwkContainer.getDebugLevel() <= 0) break block46;
                                                System.out.println((class$com$highqsoft$odsx$OdsxMeasurementHelper == null ? OdsxMeasurementHelper.class$("com.highqsoft.odsx.OdsxMeasurementHelper") : class$com$highqsoft$odsx$OdsxMeasurementHelper).getName() + ".createParameter");
                                                System.out.println("\t" + nameT.reason);
                                            }
                                        }
                                        try {
                                            pValueAa = saveContext.getApplicationAttribute(pAe, "Value");
                                            nvuVec.add(OdsxHelper.parseNameValueUnit(saveContext.getNameValueUnit(ie, pAe, pValueAa), value));
                                        }
                                        catch (AoException valueT) {
                                            if (FwkContainer.getDebugLevel() <= 0) break block47;
                                            System.out.println((class$com$highqsoft$odsx$OdsxMeasurementHelper == null ? OdsxMeasurementHelper.class$("com.highqsoft.odsx.OdsxMeasurementHelper") : class$com$highqsoft$odsx$OdsxMeasurementHelper).getName() + ".createParameter");
                                            System.out.println("\t" + valueT.reason);
                                        }
                                    }
                                    try {
                                        pValueAa = saveContext.getApplicationAttribute(pAe, "version");
                                        nvuVec.add(OdsxHelper.parseNameValueUnit(saveContext.getNameValueUnit(ie, pAe, pValueAa), "" + saveContext.parameterVersion));
                                        ++saveContext.parameterVersion;
                                    }
                                    catch (AoException versionT) {
                                        if (FwkContainer.getDebugLevel() <= 0) break block48;
                                        System.out.println((class$com$highqsoft$odsx$OdsxMeasurementHelper == null ? OdsxMeasurementHelper.class$("com.highqsoft.odsx.OdsxMeasurementHelper") : class$com$highqsoft$odsx$OdsxMeasurementHelper).getName() + ".createParameter");
                                        System.out.println("\t" + versionT.reason);
                                    }
                                }
                                try {
                                    pValueAa = saveContext.getApplicationAttribute(pAe, "version_date");
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(saveContext.getNameValueUnit(ie, pAe, pValueAa), "" + odsVersionDate));
                                    ++saveContext.parameterVersion;
                                }
                                catch (AoException versionDateT) {
                                    if (FwkContainer.getDebugLevel() <= 0) break block49;
                                    System.out.println((class$com$highqsoft$odsx$OdsxMeasurementHelper == null ? OdsxMeasurementHelper.class$("com.highqsoft.odsx.OdsxMeasurementHelper") : class$com$highqsoft$odsx$OdsxMeasurementHelper).getName() + ".createParameter");
                                    System.out.println("\t" + versionDateT.reason);
                                }
                            }
                            int dt = 1;
                            try {
                                Float.parseFloat(value);
                                dt = 3;
                            }
                            catch (Throwable fT) {
                                try {
                                    Integer.parseInt(value);
                                    dt = 6;
                                }
                                catch (Throwable iT) {
                                    // empty catch block
                                }
                            }
                            try {
                                ApplicationAttribute pDatatypeAa = saveContext.getApplicationAttribute(pAe, "Datatype");
                                nvuVec.add(OdsxHelper.parseNameValueUnit(saveContext.getNameValueUnit(ie, pAe, pDatatypeAa), "" + dt));
                            }
                            catch (AoException dataTypeT) {
                                if (FwkContainer.getDebugLevel() <= 0) break block50;
                                System.out.println((class$com$highqsoft$odsx$OdsxMeasurementHelper == null ? OdsxMeasurementHelper.class$("com.highqsoft.odsx.OdsxMeasurementHelper") : class$com$highqsoft$odsx$OdsxMeasurementHelper).getName() + ".createParameter");
                                System.out.println("\t" + dataTypeT.reason);
                            }
                        }
                        if (nvuVec.size() > 0) {
                            block51: {
                                try {
                                    ie.setValueSeq(nvuVec.toArray(new NameValueUnit[0]));
                                }
                                catch (AoException seqT) {
                                    if (FwkContainer.getDebugLevel() <= 0) break block51;
                                    System.out.println((class$com$highqsoft$odsx$OdsxMeasurementHelper == null ? OdsxMeasurementHelper.class$("com.highqsoft.odsx.OdsxMeasurementHelper") : class$com$highqsoft$odsx$OdsxMeasurementHelper).getName() + ".createParameter");
                                    System.out.println("\t" + seqT.reason);
                                }
                            }
                            nvuVec.clear();
                        }
                        if (unitRel != null && unit != null) {
                            try {
                                InstanceElement unitIe = saveContext.getUnit(unit);
                                if (unitIe != null) {
                                    ie.createRelation(unitRel, unitIe);
                                }
                            }
                            catch (Throwable tUnit) {
                                // empty catch block
                            }
                        }
                        if (psRel != null) {
                            ie.createRelation(psRel, psIe);
                        }
                        if (ieRel == null) continue;
                        ie.createRelation(ieRel, ieObj);
                    }
                }
            }
        }
    }

    public static InstanceElement saveMeasurement(String asamPath, FwkDialogPaneValueInterface editorValue, OdsxColumnAssignmentInterface assignment) throws Exception {
        AoSession aoSession;
        InstanceElement meaIe = null;
        int[] smSizes = assignment.getColumnSizes();
        int totalSM = 0;
        if (smSizes != null && (totalSM = smSizes.length) > 1) {
            Arrays.sort(smSizes);
        }
        if ((aoSession = assignment.getSession()) != null && asamPath != null && asamPath.length() != 0 && totalSM != 0) {
            try {
                ApplicationElement[] aeList;
                String beType;
                ApplicationElement meaAe = null;
                InstanceElement parIe = null;
                ApplicationStructure asObj = aoSession.getApplicationStructure();
                InstanceElement ieObj = asObj.getInstanceByAsamPath(asamPath);
                ApplicationElement aeObj = ieObj.getApplicationElement();
                BaseElement beObj = aeObj.getBaseElement();
                String sourceBeType = beType = beObj.getType();
                if (beType.compareToIgnoreCase("AoMeasurement") == 0) {
                    InstanceElementIterator ei;
                    meaAe = aeObj;
                    aeList = aeObj.getRelatedElementsByRelationship(Relationship.FATHER);
                    if (aeList != null && aeList.length > 0) {
                        aeObj = aeList[0];
                        beObj = aeObj.getBaseElement();
                        beType = beObj.getType();
                    }
                    if ((ei = ieObj.getRelatedInstancesByRelationship(Relationship.FATHER, "*")) != null && ei.getCount() > 0) {
                        ei.reset();
                        parIe = ei.nextOne();
                    }
                    ei.destroy();
                } else {
                    parIe = ieObj;
                    aeList = asObj.getElementsByBaseType("AoMeasurement");
                    if (aeList != null && aeList.length > 0) {
                        meaAe = aeList[0];
                    }
                }
                ApplicationAttribute nameAa = meaAe.getAttributeByBaseName("name");
                NameValueUnit nvu = (NameValueUnit)editorValue.getProperty(nameAa.getName());
                String meaName = nvu.value.u.stringVal();
                if (parIe != null && meaAe != null && (beType.compareTo("AoSubTest") == 0 || beType.compareTo("AoTest") == 0)) {
                    ApplicationRelation[] reParMeaList;
                    block32: {
                        String measurementVersion = OdsxHelper.getHighestVersionString(parIe.getId(), parIe.getApplicationElement().getId(), meaAe, meaName);
                        aoSession.startTransaction();
                        ApplicationAttribute meaNameAa = meaAe.getAttributeByBaseName("name");
                        int nameLength = meaNameAa.getLength();
                        meaIe = nameLength > 0 && nameLength < meaName.length() ? meaAe.createInstance(meaName.substring(0, nameLength)) : meaAe.createInstance(meaName);
                        Iterator it = editorValue.getProperties();
                        while (it.hasNext()) {
                            String key = (String)it.next();
                            meaIe.setValue((NameValueUnit)editorValue.getProperty(key));
                        }
                        try {
                            NameValueUnit nvuVersion = meaIe.getValueByBaseName("version");
                            if (nvuVersion == null) break block32;
                            String version = nvuVersion.value.u.stringVal();
                            if (version != null && version.length() == 0) {
                                version = measurementVersion;
                            }
                            if (version == null || version.length() == 0) break block32;
                            try {
                                float userVersion = new Float(version).floatValue();
                                try {
                                    float systemVersion = new Float(measurementVersion).floatValue();
                                    if (userVersion > systemVersion) {
                                        measurementVersion = new Float(userVersion).toString();
                                    }
                                }
                                catch (NumberFormatException sysnfe) {
                                    // empty catch block
                                }
                                nvuVersion.value.u.stringVal(measurementVersion);
                                meaIe.setValue(nvuVersion);
                            }
                            catch (NumberFormatException usernfe) {}
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (sourceBeType.compareToIgnoreCase("AoMeasurement") == 0) {
                        try {
                            ApplicationRelation[] reList = meaAe.getRelationsByType(RelationType.INFO);
                            if (reList != null && reList.length != 0) {
                                int size = reList.length;
                                for (int i = 0; i < size; ++i) {
                                    try {
                                        InstanceElementIterator iterator = ieObj.getRelatedInstances(reList[i], "*");
                                        for (int iCount = iterator.getCount(); iCount > 0; --iCount) {
                                            iterator.nextOne().createRelation(reList[i], meaIe);
                                        }
                                        iterator.destroy();
                                        continue;
                                    }
                                    catch (Throwable tRelation) {
                                        tRelation.printStackTrace();
                                    }
                                }
                            }
                        }
                        catch (Throwable tRelationType) {
                            tRelationType.printStackTrace();
                        }
                    }
                    if ((reParMeaList = asObj.getRelations(aeObj, meaAe)) != null && reParMeaList.length != 0) {
                        int size = reParMeaList.length;
                        for (int i = 0; i < size; ++i) {
                            parIe.createRelation(reParMeaList[i], meaIe);
                        }
                    }
                    aoSession.commitTransaction();
                    OdsxMeasurementHelper.appendToMeasurement(meaIe.getAsamPath(), assignment);
                }
                meaIe = null;
            }
            catch (Exception t) {
                t.printStackTrace();
                meaIe = null;
                try {
                    aoSession.abortTransaction();
                }
                catch (Throwable tAbort) {
                    // empty catch block
                }
                throw t;
            }
        } else {
            meaIe = null;
        }
        return meaIe;
    }

    public static InstanceElement appendToMeasurement(String asamPath, OdsxColumnAssignmentInterface assignment) {
        InstanceElement meaIe;
        block174: {
            ApplicationElement meaAe = null;
            meaIe = null;
            String versionDate = OdsxHelper.getOdsDate(Calendar.getInstance().getTime());
            int[] smSizes = assignment.getColumnSizes();
            int totalSM = 0;
            if (smSizes != null && (totalSM = smSizes.length) > 1) {
                Arrays.sort(smSizes);
            }
            AoSession aoSession = assignment.getSession();
            boolean version4 = false;
            if (aoSession != null && asamPath != null && asamPath.length() != 0 && totalSM != 0) {
                try {
                    NameValue nv = aoSession.getContextByName("ODSVERSION");
                    version4 = OdsxHelper.nameValueToString(nv).startsWith("4");
                    ApplicationStructure asObj = aoSession.getApplicationStructure();
                    InstanceElement ieObj = asObj.getInstanceByAsamPath(asamPath);
                    ApplicationElement aeObj = ieObj.getApplicationElement();
                    BaseElement beObj = aeObj.getBaseElement();
                    if (beObj.getType().compareToIgnoreCase("AoMeasurement") == 0) {
                        meaAe = aeObj;
                        meaIe = ieObj;
                    }
                    if (meaAe != null && meaIe != null) {
                        InstanceElement[] subMatrixArr = new InstanceElement[totalSM];
                        aoSession.startTransaction();
                        ApplicationElement subAe = null;
                        ApplicationElement[] aeList = asObj.getElementsByBaseType("AoSubmatrix");
                        if (aeList.length != 0) {
                            subAe = aeList[0];
                        }
                        ApplicationElement qAe = null;
                        aeList = asObj.getElementsByBaseType("AoQuantity");
                        if (aeList.length != 0) {
                            qAe = aeList[0];
                        }
                        ApplicationElement meqAe = null;
                        aeList = asObj.getElementsByBaseType("AoMeasurementQuantity");
                        if (aeList.length != 0) {
                            meqAe = aeList[0];
                        }
                        ApplicationElement lcAe = null;
                        aeList = asObj.getElementsByBaseType("AoLocalColumn");
                        if (aeList.length != 0) {
                            lcAe = aeList[0];
                        }
                        ApplicationElement unitAe = null;
                        aeList = asObj.getElementsByBaseType("AoUnit");
                        if (aeList.length != 0) {
                            unitAe = aeList[0];
                        }
                        ApplicationRelation[] meqQRList = null;
                        ApplicationRelation[] meaMeqRList = null;
                        ApplicationRelation[] meqUnitRList = null;
                        if (meqAe != null && qAe != null) {
                            meqQRList = asObj.getRelations(qAe, meqAe);
                            meaMeqRList = asObj.getRelations(meaAe, meqAe);
                            meqUnitRList = null;
                            if (unitAe != null) {
                                meqUnitRList = asObj.getRelations(meqAe, unitAe);
                            }
                        }
                        ApplicationAttribute meqVersionAa = null;
                        try {
                            meqVersionAa = meqAe.getAttributeByBaseName("version");
                        }
                        catch (Throwable tVersion) {
                            // empty catch block
                        }
                        ApplicationAttribute meqVersion_dateAa = null;
                        try {
                            meqVersion_dateAa = meqAe.getAttributeByBaseName("version_date");
                        }
                        catch (Throwable tVersion_data) {
                            // empty catch block
                        }
                        ApplicationAttribute meqInterpolationAa = null;
                        try {
                            meqInterpolationAa = meqAe.getAttributeByBaseName("interpolation");
                        }
                        catch (Throwable tInterpolation) {
                            // empty catch block
                        }
                        ApplicationAttribute meqDatatypeAa = null;
                        try {
                            meqDatatypeAa = meqAe.getAttributeByBaseName("datatype");
                        }
                        catch (Throwable tDataType) {
                            // empty catch block
                        }
                        ApplicationAttribute meqRankAa = null;
                        try {
                            meqRankAa = meqAe.getAttributeByBaseName("rank");
                        }
                        catch (Throwable tRank) {
                            // empty catch block
                        }
                        ApplicationAttribute meqDimensionAa = null;
                        try {
                            meqDimensionAa = meqAe.getAttributeByBaseName("dimension");
                        }
                        catch (Throwable tDimension) {
                            // empty catch block
                        }
                        ApplicationAttribute meqType_sizeAa = null;
                        try {
                            meqType_sizeAa = meqAe.getAttributeByBaseName("type_size");
                        }
                        catch (Throwable tType_data) {
                            // empty catch block
                        }
                        ApplicationAttribute meqMinimumAa = null;
                        try {
                            meqMinimumAa = meqAe.getAttributeByBaseName("minimum");
                        }
                        catch (Throwable tMinimum) {
                            // empty catch block
                        }
                        ApplicationAttribute meqMaximumAa = null;
                        try {
                            meqMaximumAa = meqAe.getAttributeByBaseName("maximum");
                        }
                        catch (Throwable tMaximum) {
                            // empty catch block
                        }
                        ApplicationAttribute meqAverageAa = null;
                        try {
                            meqAverageAa = meqAe.getAttributeByBaseName("average");
                        }
                        catch (Throwable tAverage) {
                            // empty catch block
                        }
                        ApplicationAttribute meqStandard_DeviationAa = null;
                        try {
                            meqStandard_DeviationAa = meqAe.getAttributeByBaseName("standard_deviation");
                        }
                        catch (Throwable tDeviation) {
                            // empty catch block
                        }
                        ApplicationAttribute lcVersionAa = null;
                        try {
                            lcVersionAa = lcAe.getAttributeByBaseName("version");
                        }
                        catch (Throwable tVersion) {
                            // empty catch block
                        }
                        ApplicationAttribute lcVersion_dateAa = null;
                        try {
                            lcVersion_dateAa = lcAe.getAttributeByBaseName("version_date");
                        }
                        catch (Throwable tVersion_data) {
                            // empty catch block
                        }
                        ApplicationAttribute lcMinimumAa = null;
                        try {
                            lcMinimumAa = lcAe.getAttributeByBaseName("minimum");
                        }
                        catch (Throwable tMinimum) {
                            // empty catch block
                        }
                        ApplicationAttribute lcMaximumAa = null;
                        try {
                            lcMaximumAa = lcAe.getAttributeByBaseName("maximum");
                        }
                        catch (Throwable tMaximum) {
                            // empty catch block
                        }
                        ApplicationAttribute lcIndependentAa = null;
                        try {
                            lcIndependentAa = lcAe.getAttributeByBaseName("independent");
                        }
                        catch (Throwable tIndependent) {
                            // empty catch block
                        }
                        ApplicationAttribute lcImplicitAa = null;
                        try {
                            lcImplicitAa = lcAe.getAttributeByBaseName("sequence_representation");
                        }
                        catch (Throwable tIndependent) {
                            // empty catch block
                        }
                        ApplicationAttribute lcValueAa = null;
                        try {
                            lcValueAa = lcAe.getAttributeByBaseName("values");
                        }
                        catch (Throwable tValue) {
                            // empty catch block
                        }
                        ApplicationAttribute lcFlagAa = null;
                        try {
                            lcFlagAa = lcAe.getAttributeByBaseName("flags");
                        }
                        catch (Throwable tFlag) {
                            // empty catch block
                        }
                        ApplicationAttribute subVersionAa = null;
                        try {
                            subVersionAa = subAe.getAttributeByBaseName("version");
                        }
                        catch (Throwable tVersion) {
                            // empty catch block
                        }
                        ApplicationAttribute subVersion_dateAa = null;
                        try {
                            subVersion_dateAa = subAe.getAttributeByBaseName("version_date");
                        }
                        catch (Throwable tVersion) {
                            // empty catch block
                        }
                        ApplicationAttribute subNumber_of_rowsAa = null;
                        try {
                            subNumber_of_rowsAa = subAe.getAttributeByBaseName("number_of_rows");
                        }
                        catch (Throwable tVersion) {
                            // empty catch block
                        }
                        if (meqAe != null && qAe != null) {
                            Object[] darr;
                            int subListCount;
                            String colName;
                            int j;
                            int dataType;
                            InstanceElementIterator it;
                            FwkColumnAccessInterface col;
                            InstanceElement qIe = null;
                            InstanceElement meqIe = null;
                            HashMap<String, InstanceElement> meqMap = new HashMap<String, InstanceElement>();
                            InstanceElementIterator curMeqList = meaIe.getRelatedInstances(meaMeqRList[0], "*");
                            for (int meqListCount = curMeqList.getCount(); meqListCount > 0; --meqListCount) {
                                meqIe = curMeqList.nextOne();
                                meqMap.put(meqIe.getName(), meqIe);
                            }
                            curMeqList.destroy();
                            int colSize = assignment.size();
                            Vector<NameValueUnit> nvuVec = new Vector<NameValueUnit>();
                            for (int colCount = 0; colCount < colSize; ++colCount) {
                                String quantityName = assignment.getQuantityName(colCount);
                                if (meqMap.get(quantityName) != null) continue;
                                col = assignment.getChannel(colCount);
                                meqIe = meqAe.createInstance(quantityName);
                                it = qAe.getInstances(quantityName);
                                qIe = it.nextOne();
                                it.destroy();
                                meqMap.put(quantityName, meqIe);
                                dataType = assignment.getOdsColumnDataType(colCount).value();
                                try {
                                    dataType = qIe.getValueByBaseName((String)"default_datatype").value.u.longVal();
                                }
                                catch (Throwable defaultDataTypeException) {
                                    // empty catch block
                                }
                                if (meqVersionAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqVersionAa.getName()), "1"));
                                }
                                if (meqVersion_dateAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqVersion_dateAa.getName()), versionDate));
                                }
                                if (meqInterpolationAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqInterpolationAa.getName()), "0"));
                                }
                                if (meqDatatypeAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqDatatypeAa.getName()), "" + dataType));
                                }
                                if (meqRankAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqRankAa.getName()), "1"));
                                }
                                if (meqDimensionAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqDimensionAa.getName()), "1"));
                                }
                                if (meqType_sizeAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqType_sizeAa.getName()), "1"));
                                }
                                if (meqMinimumAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqMinimumAa.getName()), "" + col.getMinimum()));
                                }
                                if (meqMaximumAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqMaximumAa.getName()), "" + col.getMaximum()));
                                }
                                if (meqAverageAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqAverageAa.getName()), "" + col.getAverage()));
                                }
                                if (meqStandard_DeviationAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqStandard_DeviationAa.getName()), "" + col.getStandardDeviation()));
                                }
                                if (nvuVec.size() > 0) {
                                    meqIe.setValueSeq(nvuVec.toArray(new NameValueUnit[0]));
                                    nvuVec.clear();
                                }
                                if (qIe != null && meqQRList != null && meqQRList.length != 0) {
                                    int len = meqQRList.length;
                                    for (int count = 0; count < len; ++count) {
                                        meqIe.createRelation(meqQRList[count], qIe);
                                    }
                                }
                                if (meaMeqRList != null && meaMeqRList.length != 0) {
                                    int len = meaMeqRList.length;
                                    for (int j2 = 0; j2 < len; ++j2) {
                                        meqIe.createRelation(meaMeqRList[j2], meaIe);
                                    }
                                }
                                if (unitAe == null) continue;
                                InstanceElement unitIe = null;
                                try {
                                    InstanceElementIterator ii = unitAe.getInstances(assignment.getUnitString(colCount));
                                    unitIe = ii.nextOne();
                                    ii.destroy();
                                }
                                catch (Throwable tQIe) {
                                    tQIe.printStackTrace();
                                    unitIe = null;
                                }
                                if (unitIe == null || meqUnitRList == null || meqUnitRList.length == 0) continue;
                                int len = meqUnitRList.length;
                                for (j = 0; j < len; ++j) {
                                    unitIe.createRelation(meqUnitRList[j], meqIe);
                                }
                            }
                            String assignmentUnitString = "";
                            if (assignment.getImplicitCreation() && meqMap.get(colName = assignment.getQuantity()) == null) {
                                meqIe = meqAe.createInstance(colName);
                                it = qAe.getInstances(colName);
                                qIe = it.nextOne();
                                it.destroy();
                                meqMap.put(colName, meqIe);
                                dataType = assignment.getOdsColumnDataType().value();
                                try {
                                    dataType = qIe.getValueByBaseName((String)"default_datatype").value.u.longVal();
                                }
                                catch (Throwable defaultDataTypeException) {
                                    // empty catch block
                                }
                                if (meqVersionAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqVersionAa.getName()), "1"));
                                }
                                if (meqVersion_dateAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqVersion_dateAa.getName()), versionDate));
                                }
                                if (meqInterpolationAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqInterpolationAa.getName()), "0"));
                                }
                                if (meqDatatypeAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqDatatypeAa.getName()), "" + dataType));
                                }
                                if (meqRankAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqRankAa.getName()), "1"));
                                }
                                if (meqDimensionAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqDimensionAa.getName()), "1"));
                                }
                                if (meqType_sizeAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(meqIe.getValue(meqType_sizeAa.getName()), "1"));
                                }
                                if (nvuVec.size() > 0) {
                                    meqIe.setValueSeq(nvuVec.toArray(new NameValueUnit[0]));
                                    nvuVec.clear();
                                }
                                if (qIe != null && meqQRList != null && meqQRList.length != 0) {
                                    int len = meqQRList.length;
                                    for (int count = 0; count < len; ++count) {
                                        meqIe.createRelation(meqQRList[count], qIe);
                                    }
                                }
                                if (meaMeqRList != null && meaMeqRList.length != 0) {
                                    int len = meaMeqRList.length;
                                    for (int j3 = 0; j3 < len; ++j3) {
                                        meqIe.createRelation(meaMeqRList[j3], meaIe);
                                    }
                                }
                                if (unitAe != null) {
                                    InstanceElement unitIe = null;
                                    try {
                                        assignmentUnitString = assignment.getUnitString();
                                        InstanceElementIterator ii = unitAe.getInstances(assignmentUnitString);
                                        unitIe = ii.nextOne();
                                        ii.destroy();
                                    }
                                    catch (Throwable tQIe) {
                                        assignmentUnitString = "";
                                        unitIe = null;
                                    }
                                    if (unitIe != null && meqUnitRList != null && meqUnitRList.length != 0) {
                                        int len = meqUnitRList.length;
                                        for (j = 0; j < len; ++j) {
                                            unitIe.createRelation(meqUnitRList[j], meqIe);
                                        }
                                    }
                                }
                            }
                            ApplicationRelation[] reMeaSubList = asObj.getRelations(meaAe, subAe);
                            ApplicationRelation[] reSubLcList = asObj.getRelations(subAe, lcAe);
                            ApplicationRelation[] reMeqLcList = asObj.getRelations(meqAe, lcAe);
                            InstanceElementIterator curSubList = meaIe.getRelatedInstances(reMeaSubList[0], "*");
                            int maxName = subListCount = curSubList.getCount();
                            while (subListCount > 0) {
                                try {
                                    ieObj = curSubList.nextOne();
                                    maxName = Math.max(maxName, Integer.parseInt(ieObj.getName()));
                                }
                                catch (Throwable tSubName) {
                                    // empty catch block
                                }
                                --subListCount;
                            }
                            curSubList.destroy();
                            for (int smCount = 0; smCount < totalSM; ++smCount) {
                                InstanceElement subIe;
                                subMatrixArr[smCount] = subIe = subAe.createInstance("" + (maxName + smCount + 1));
                                if (subVersionAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(subIe.getValue(subVersionAa.getName()), "1"));
                                }
                                if (subVersion_dateAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(subIe.getValue(subVersion_dateAa.getName()), versionDate));
                                }
                                if (subNumber_of_rowsAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(subIe.getValue(subNumber_of_rowsAa.getName()), "" + smSizes[smCount]));
                                }
                                if (nvuVec.size() > 0) {
                                    subIe.setValueSeq(nvuVec.toArray(new NameValueUnit[0]));
                                    nvuVec.clear();
                                }
                                if (reMeaSubList != null && reMeaSubList.length != 0) {
                                    int size = reMeaSubList.length;
                                    for (int count = 0; count < size; ++count) {
                                        meaIe.createRelation(reMeaSubList[count], subIe);
                                    }
                                }
                                if (!assignment.getImplicitCreation()) continue;
                                String colName2 = assignment.getQuantity();
                                InstanceElement lcIe = lcAe.createInstance(colName2);
                                if (lcVersionAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcVersionAa.getName()), "1"));
                                }
                                if (lcVersion_dateAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcVersion_dateAa.getName()), versionDate));
                                }
                                double maximum = assignment.getOffset() + assignment.getFactor() * (double)smSizes[smCount];
                                double minimum = assignment.getOffset();
                                if (lcMinimumAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcMinimumAa.getName()), "" + Math.min(minimum, maximum)));
                                }
                                if (lcMaximumAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcMaximumAa.getName()), "" + Math.max(minimum, maximum)));
                                }
                                if (lcIndependentAa != null) {
                                    nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcIndependentAa.getName()), "1"));
                                }
                                if (lcImplicitAa != null) {
                                    if (version4) {
                                        nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcImplicitAa.getName()), "2"));
                                    } else {
                                        nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcImplicitAa.getName()), "1"));
                                    }
                                }
                                NameValueUnit nvStr = new NameValueUnit();
                                TS_Value value = new TS_Value();
                                TS_Union u = new TS_Union();
                                int indepDatatype = 3;
                                ieObj = (InstanceElement)meqMap.get(colName2);
                                try {
                                    indepDatatype = ieObj.getValueByBaseName((String)"datatype").value.u.longVal();
                                }
                                catch (Throwable indepDataTypeEx) {
                                    // empty catch block
                                }
                                switch (indepDatatype) {
                                    case 5: 
                                    case 19: {
                                        byte[] barr = new byte[]{(byte)assignment.getOffset(), (byte)assignment.getFactor()};
                                        u.byteSeq(barr);
                                        break;
                                    }
                                    case 2: 
                                    case 16: {
                                        short[] sarr = new short[]{(short)Math.round(assignment.getOffset()), (short)Math.round(assignment.getFactor())};
                                        u.shortSeq(sarr);
                                        break;
                                    }
                                    case 6: 
                                    case 20: {
                                        int[] larr = new int[]{(int)Math.round(assignment.getOffset()), (int)Math.round(assignment.getFactor())};
                                        u.longSeq(larr);
                                        break;
                                    }
                                    case 3: 
                                    case 17: {
                                        float[] farr = new float[]{(float)assignment.getOffset(), (float)assignment.getFactor()};
                                        u.floatSeq(farr);
                                        break;
                                    }
                                    case 7: 
                                    case 21: {
                                        darr = new double[]{assignment.getOffset(), assignment.getFactor()};
                                        u.doubleSeq(darr);
                                        break;
                                    }
                                    default: {
                                        float[] dfarr = new float[]{(float)assignment.getOffset(), (float)assignment.getFactor()};
                                        u.floatSeq(dfarr);
                                    }
                                }
                                value.u = u;
                                value.flag = (short)15;
                                nvStr.valName = lcValueAa.getName();
                                nvStr.unit = assignmentUnitString;
                                if (nvStr.unit == null) {
                                    nvStr.unit = "";
                                }
                                nvStr.value = value;
                                nvuVec.add(nvStr);
                                if (nvuVec.size() > 0) {
                                    lcIe.setValueSeq(nvuVec.toArray(new NameValueUnit[0]));
                                    nvuVec.clear();
                                }
                                try {
                                    nvStr = lcIe.getValueByBaseName("global_flag");
                                    nvStr.value.flag = (short)15;
                                    nvStr.value.u.shortVal((short)15);
                                    lcIe.setValue(nvStr);
                                }
                                catch (Throwable tGlobalFlag) {
                                    nvStr = new NameValueUnit();
                                    value = new TS_Value();
                                    u = new TS_Union();
                                    u.shortSeq(new short[]{15, 15});
                                    value.u = u;
                                    nvStr.valName = lcFlagAa.getName();
                                    nvStr.value = value;
                                    nvStr.unit = "";
                                    lcIe.setValue(nvStr);
                                }
                                if (reSubLcList != null && reSubLcList.length != 0) {
                                    int size = reSubLcList.length;
                                    for (int i = 0; i < size; ++i) {
                                        subIe.createRelation(reSubLcList[i], lcIe);
                                    }
                                }
                                if (ieObj == null || reMeqLcList == null || reMeqLcList.length == 0) continue;
                                int size = reMeqLcList.length;
                                for (int i = 0; i < size; ++i) {
                                    ieObj.createRelation(reMeqLcList[i], lcIe);
                                }
                            }
                            if (meqAe != null && qAe != null) {
                                colSize = assignment.size();
                                for (int colCount = 0; colCount < colSize; ++colCount) {
                                    col = assignment.getChannel(colCount);
                                    if (col == null) continue;
                                    InstanceElement subMatrix = null;
                                    int index = Arrays.binarySearch(smSizes, col.getCount());
                                    if (index >= 0) {
                                        subMatrix = subMatrixArr[index];
                                    }
                                    if (subMatrix == null) continue;
                                    String colName3 = assignment.getOdsColumnName(colCount);
                                    InstanceElement lcIe = lcAe.createInstance(colName3);
                                    if (lcVersionAa != null) {
                                        nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcVersionAa.getName()), "1"));
                                    }
                                    if (lcVersion_dateAa != null) {
                                        nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcVersion_dateAa.getName()), versionDate));
                                    }
                                    if (lcMinimumAa != null) {
                                        nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcMinimumAa.getName()), "" + col.getMinimum()));
                                    }
                                    if (lcMaximumAa != null) {
                                        nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcMaximumAa.getName()), "" + col.getMaximum()));
                                    }
                                    if (lcIndependentAa != null) {
                                        nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcIndependentAa.getName()), "" + (assignment.getIndependent(colCount) ? 1 : 0)));
                                    }
                                    if (lcImplicitAa != null) {
                                        nvuVec.add(OdsxHelper.parseNameValueUnit(lcIe.getValue(lcImplicitAa.getName()), "" + (col.isImplicit() ? 1 : 0)));
                                    }
                                    int dataType2 = assignment.getOdsColumnDataType(colCount).value();
                                    meqIe = (InstanceElement)meqMap.get(assignment.getQuantityName(colCount));
                                    try {
                                        dataType2 = meqIe.getValueByBaseName((String)"datatype").value.u.longVal();
                                    }
                                    catch (Throwable dataTypeException) {
                                        // empty catch block
                                    }
                                    NameValueUnit nvStr = new NameValueUnit();
                                    TS_Value value = new TS_Value();
                                    TS_Union u = new TS_Union();
                                    double[] data = col.getValues();
                                    int colLen = data.length;
                                    if (col.isImplicit()) {
                                        colLen = 2;
                                    }
                                    switch (dataType2) {
                                        case 5: 
                                        case 19: {
                                            byte[] barr = new byte[col.getCount()];
                                            for (int count = 0; count < colLen; ++count) {
                                                barr[count] = (byte)data[count];
                                            }
                                            u.byteSeq(barr);
                                            break;
                                        }
                                        case 2: 
                                        case 16: {
                                            short[] sarr = new short[col.getCount()];
                                            for (int count = 0; count < colLen; ++count) {
                                                sarr[count] = (short)data[count];
                                            }
                                            u.shortSeq(sarr);
                                            break;
                                        }
                                        case 6: 
                                        case 20: {
                                            int[] larr = new int[col.getCount()];
                                            for (int count = 0; count < colLen; ++count) {
                                                larr[count] = (int)data[count];
                                            }
                                            u.longSeq(larr);
                                            break;
                                        }
                                        case 3: 
                                        case 17: {
                                            float[] farr = new float[col.getCount()];
                                            for (int count = 0; count < colLen; ++count) {
                                                farr[count] = (float)data[count];
                                            }
                                            u.floatSeq(farr);
                                            break;
                                        }
                                        case 10: 
                                        case 26: {
                                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
                                            darr = new String[col.getCount()];
                                            for (int count = 0; count < colLen; ++count) {
                                                try {
                                                    darr[count] = (double)simpleDateFormat.format(new Date((long)data[count]));
                                                    continue;
                                                }
                                                catch (Throwable t) {
                                                    t.printStackTrace();
                                                }
                                            }
                                            u.dateSeq((String[])darr);
                                            break;
                                        }
                                        case 1: 
                                        case 15: {
                                            String[] strarr = new String[col.getCount()];
                                            for (int count = 0; count < colLen; ++count) {
                                                strarr[count] = "" + data[count];
                                            }
                                            u.stringSeq(strarr);
                                            break;
                                        }
                                        case 7: 
                                        case 21: {
                                            u.doubleSeq(col.getValues());
                                            break;
                                        }
                                        default: {
                                            u.doubleSeq(col.getValues());
                                        }
                                    }
                                    value.u = u;
                                    value.flag = (short)15;
                                    nvStr.valName = lcValueAa.getName();
                                    nvStr.value = value;
                                    nvStr.unit = "";
                                    nvuVec.add(nvStr);
                                    if (nvuVec.size() > 0) {
                                        lcIe.setValueSeq(nvuVec.toArray(new NameValueUnit[0]));
                                        nvuVec.clear();
                                    }
                                    boolean setFlags = true;
                                    try {
                                        NameValueUnit gfnvu = lcIe.getValueByBaseName("global_flag");
                                        setFlags = (gfnvu.value.flag & 1) == 0;
                                    }
                                    catch (Throwable tGlobalFlag) {
                                        // empty catch block
                                    }
                                    if (setFlags) {
                                        nvStr = new NameValueUnit();
                                        value = new TS_Value();
                                        value.flag = (short)15;
                                        u = new TS_Union();
                                        u.shortSeq(col.getFlags());
                                        value.u = u;
                                        nvStr.valName = lcFlagAa.getName();
                                        nvStr.value = value;
                                        nvStr.unit = "";
                                        lcIe.setValue(nvStr);
                                    }
                                    if (reSubLcList != null && reSubLcList.length != 0) {
                                        int size = reSubLcList.length;
                                        for (int i = 0; i < size; ++i) {
                                            subMatrix.createRelation(reSubLcList[i], lcIe);
                                        }
                                    }
                                    if ((meqIe = (InstanceElement)meqMap.get(assignment.getQuantityName(colCount))) == null || reMeqLcList == null || reMeqLcList.length == 0) continue;
                                    int size = reMeqLcList.length;
                                    for (int i = 0; i < size; ++i) {
                                        meqIe.createRelation(reMeqLcList[i], lcIe);
                                    }
                                }
                            }
                            aoSession.commitTransaction();
                            break block174;
                        }
                        meaIe = null;
                        break block174;
                    }
                    meaIe = null;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    meaIe = null;
                    try {
                        aoSession.abortTransaction();
                    }
                    catch (Throwable tAbort) {}
                }
            } else {
                meaIe = null;
            }
        }
        return meaIe;
    }

    public static void main(String[] args) {
        String odsVersion;
        String s = odsVersion = "4.5.8.6a";
        int fidx = s.indexOf(46);
        s = s.replaceAll("[a-zA-Z]", "");
        int lidx = -1;
        while (fidx != lidx) {
            lidx = s.lastIndexOf(46);
            if (lidx == fidx) continue;
            s = s.substring(0, lidx);
        }
        System.out.println(Float.parseFloat(s));
    }

    protected static class SaveContext {
        AoSession aoSession;
        ApplicationStructure asObj;
        String odsVersion = null;
        float odsVersionVal = 0.0f;
        HashMap aeMap;
        HashMap baeMap;
        HashMap beMap;
        HashMap aaMap;
        HashMap dtMap;
        HashMap lenMap;
        HashMap namMap;
        HashMap tMap;
        HashMap relMap;
        HashMap nvuMap;
        HashMap qtyMap;
        HashMap meqMap;
        HashMap unitMap;
        int parameterVersion = 0;
        String versionDate = OdsxHelper.getOdsDate(Calendar.getInstance().getTime());

        public SaveContext(AoSession aoSession) {
            this.aoSession = aoSession;
            try {
                this.asObj = aoSession.getApplicationStructure();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.aeMap = new HashMap();
            this.baeMap = new HashMap();
            this.beMap = new HashMap();
            this.aaMap = new HashMap();
            this.dtMap = new HashMap();
            this.tMap = new HashMap();
            this.lenMap = new HashMap();
            this.relMap = new HashMap();
            this.namMap = new HashMap();
            this.nvuMap = new HashMap();
            this.qtyMap = new HashMap();
            this.meqMap = new HashMap();
            this.unitMap = new HashMap();
        }

        protected void finalize() throws Throwable {
            this.asObj = null;
            this.aeMap = null;
            this.baeMap = null;
            this.beMap = null;
            this.aaMap = null;
            this.dtMap = null;
            this.tMap = null;
            this.lenMap = null;
            this.relMap = null;
            this.namMap = null;
            this.nvuMap = null;
            this.qtyMap = null;
            this.meqMap = null;
            this.unitMap = null;
        }

        public AoSession getSession() {
            return this.aoSession;
        }

        public ApplicationStructure getApplicationStructure() {
            return this.asObj;
        }

        public void add(ApplicationElement aeObj, InstanceElement ieObj) {
            if (!this.aeMap.containsKey(ieObj)) {
                this.aeMap.put(ieObj, aeObj);
            }
        }

        public ApplicationElement getApplicationElement(InstanceElement ieObj) throws AoException {
            ApplicationElement ret = null;
            ret = (ApplicationElement)this.aeMap.get(ieObj);
            if (ret == null) {
                ret = ieObj.getApplicationElement();
                this.aeMap.put(ieObj, ret);
            }
            return ret;
        }

        public BaseElement getBaseElement(ApplicationElement aeObj) throws AoException {
            BaseElement ret = (BaseElement)this.beMap.get(aeObj);
            if (ret == null) {
                ret = aeObj.getBaseElement();
                this.beMap.put(aeObj, ret);
            }
            return ret;
        }

        public BaseElement getBaseElement(InstanceElement ieObj) throws AoException {
            return this.getBaseElement(this.getApplicationElement(ieObj));
        }

        public ApplicationElement getApplicationElement(String type) throws AoException {
            ApplicationElement ret = (ApplicationElement)this.baeMap.get(type);
            if (ret == null) {
                try {
                    ret = this.asObj.getElementsByBaseType(type)[0];
                }
                catch (Throwable aaa) {
                    // empty catch block
                }
                try {
                    ret = this.asObj.getElementByName(type);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (ret != null) {
                    this.baeMap.put(type, ret);
                }
            }
            return ret;
        }

        public ApplicationAttribute getApplicationAttribute(InstanceElement ieObj, String key) throws AoException {
            return this.getApplicationAttribute(this.getApplicationElement(ieObj), key);
        }

        public ApplicationAttribute getApplicationAttribute(ApplicationElement aeObj, String key) throws AoException {
            ApplicationAttribute ret = null;
            HashMap keyMap = this.getAttributeKeyMap(aeObj);
            Object val = keyMap.get(key);
            if (!(val instanceof String) && (ret = (ApplicationAttribute)val) == null) {
                try {
                    ret = aeObj.getAttributeByBaseName(key);
                }
                catch (Throwable tAA) {
                    // empty catch block
                }
                if (ret == null) {
                    try {
                        ret = aeObj.getAttributeByName(key);
                        if (!this.namMap.containsKey(ret)) {
                            this.namMap.put(ret, key);
                        }
                    }
                    catch (Throwable tAA) {
                        // empty catch block
                    }
                }
                if (ret != null) {
                    keyMap.put(key, ret);
                } else {
                    keyMap.put(key, "");
                }
            }
            return ret;
        }

        protected HashMap getAttributeKeyMap(ApplicationElement aeObj) {
            HashMap ret = (HashMap)this.aaMap.get(aeObj);
            if (ret == null) {
                ret = new HashMap();
                this.aaMap.put(aeObj, ret);
            }
            return ret;
        }

        public DataType getDataType(ApplicationAttribute aaObj) throws AoException {
            DataType ret = (DataType)this.dtMap.get(aaObj);
            if (ret == null) {
                ret = aaObj.getDataType();
                this.dtMap.put(aaObj, ret);
            }
            return ret;
        }

        public int getLength(ApplicationAttribute aaObj) throws AoException {
            Integer ret = (Integer)this.lenMap.get(aaObj);
            if (ret == null) {
                ret = new Integer(aaObj.getLength());
                this.lenMap.put(aaObj, ret);
            }
            return ret;
        }

        public String getName(ApplicationAttribute aaObj) throws AoException {
            String ret = (String)this.namMap.get(aaObj);
            if (ret == null) {
                ret = aaObj.getName();
                this.namMap.put(aaObj, ret);
            }
            return ret;
        }

        public String getBaseType(BaseElement beObj) throws AoException {
            String ret = (String)this.tMap.get(beObj);
            if (ret == null) {
                ret = beObj.getType();
                this.tMap.put(beObj, ret);
            }
            return ret;
        }

        public String getBaseType(ApplicationElement aeObj) throws AoException {
            return this.getBaseType(this.getBaseElement(aeObj));
        }

        public String getBaseType(InstanceElement ieObj) throws AoException {
            return this.getBaseType(this.getApplicationElement(ieObj));
        }

        public ApplicationRelation[] getRelations(ApplicationElement ae1, ApplicationElement ae2) {
            ApplicationRelation[] ret = null;
            HashMap<ApplicationElement, ApplicationRelation[]> map = (HashMap<ApplicationElement, ApplicationRelation[]>)this.relMap.get(ae1);
            if (map == null && (map = (HashMap)this.relMap.get(ae2)) != null) {
                ApplicationElement tmp = ae2;
                ae2 = ae1;
                ae1 = tmp;
            }
            if (map == null) {
                map = new HashMap<ApplicationElement, ApplicationRelation[]>();
                this.relMap.put(ae1, map);
            }
            if ((ret = (ApplicationRelation[])map.get(ae2)) == null) {
                try {
                    ret = this.asObj.getRelations(ae1, ae2);
                }
                catch (Throwable ttt) {
                    // empty catch block
                }
                if (ret != null) {
                    map.put(ae2, ret);
                }
            }
            return ret;
        }

        public NameValueUnit getNameValueUnit(InstanceElement ieObj, ApplicationElement aeObj, String aaName) {
            try {
                return this.getNameValueUnit(ieObj, aeObj, this.getApplicationAttribute(aeObj, aaName));
            }
            catch (Throwable tt) {
                return null;
            }
        }

        public NameValueUnit getNameValueUnit(InstanceElement ieObj, ApplicationElement aeObj, ApplicationAttribute aaObj) {
            NameValueUnit ret = null;
            try {
                HashMap<ApplicationAttribute, NameValueUnit> map;
                if (aeObj == null) {
                    aeObj = this.getApplicationElement(ieObj);
                }
                if ((map = (HashMap<ApplicationAttribute, NameValueUnit>)this.nvuMap.get(aeObj)) == null) {
                    map = new HashMap<ApplicationAttribute, NameValueUnit>();
                    this.nvuMap.put(aeObj, map);
                }
                if ((ret = (NameValueUnit)map.get(aaObj)) == null) {
                    try {
                        ret = ieObj.getValue(this.getName(aaObj));
                        map.put(aaObj, ret);
                    }
                    catch (Throwable t) {}
                }
            }
            catch (Throwable t) {
                try {
                    ret = ieObj.getValue(this.getName(aaObj));
                }
                catch (Throwable tRet) {
                    // empty catch block
                }
            }
            return ret;
        }

        public float odsVersionVal() {
            if (this.odsVersion == null) {
                try {
                    NameValue nv = this.aoSession.getContextByName("ODSVERSION");
                    this.odsVersion = OdsxHelper.nameValueToString(nv).trim();
                }
                catch (Throwable t) {
                    this.odsVersion = "???";
                }
                String s = this.odsVersion;
                int fidx = s.indexOf(46);
                s = s.replaceAll("[a-zA-Z]", "");
                int lidx = -1;
                while (fidx != lidx) {
                    lidx = s.lastIndexOf(46);
                    if (lidx == fidx) continue;
                    s = s.substring(0, lidx);
                }
                try {
                    this.odsVersionVal = Float.parseFloat(s);
                }
                catch (Throwable t) {
                    this.odsVersionVal = 0.0f;
                }
            }
            return this.odsVersionVal;
        }

        public InstanceElement getQuantity(String qName) {
            InstanceElement ret = (InstanceElement)this.qtyMap.get(qName);
            if (ret == null) {
                try {
                    ApplicationElement qAe = this.getApplicationElement("AoQuantity");
                    InstanceElementIterator it = qAe.getInstances(qName);
                    ret = it.nextOne();
                    it.destroy();
                    this.qtyMap.put(qName, ret);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return ret;
        }

        public InstanceElement getMEQ(ApplicationRelation reMeaMeq, InstanceElement meaIe, String meqName) {
            InstanceElement ret = (InstanceElement)this.meqMap.get(meqName);
            if (ret == null) {
                try {
                    InstanceElementIterator it = meaIe.getRelatedInstances(reMeaMeq, meqName);
                    ret = it.nextOne();
                    this.meqMap.put(meqName, ret);
                    it.destroy();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return ret;
        }

        public InstanceElement getUnit(String unit) {
            InstanceElement ret = (InstanceElement)this.unitMap.get(unit);
            if (ret == null) {
                try {
                    ApplicationElement unitAe = this.getApplicationElement("AoUnit");
                    ret = unitAe.getInstanceByName(unit);
                    if (ret != null) {
                        this.unitMap.put(unit, ret);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return ret;
        }
    }
}

