/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkColumnAccess;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.command.FwkCopyToClipboardCommand;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxChangeEventInterface;
import com.highqsoft.interfaces.odsx.OdsxChangeListenerInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.command.OdsxATFFilterCommand;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.awt.Color;
import java.awt.Container;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import javax.infobus.ArrayAccess;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;

public abstract class OdsxPresentableElement
extends FwkColumnAccess
implements OdsxPresentableElementInterface,
OdsxChangeListenerInterface {
    protected static final String SEPARATOR = "\n==================================================================================\n";
    public final Color DEFAULT_COLOR = Color.black;
    public static final String version = "$Revision: 1.7 $";
    protected Object defaultObject = new Object();
    protected Object value;
    protected OdsxFilterInterface odsFilter = null;
    protected Color color = null;
    protected HashMap beQueries;

    public String getVersion() {
        return version;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.value = null;
        this.odsFilter = null;
    }

    protected OdsxPresentableElement() {
        FwkContainer.addComponentProperties((Class)OdsxPresentableElement.class);
        this.value = this.defaultObject;
        this.beQueries = new HashMap();
    }

    public boolean isTheSame(OdsxPresentableElementInterface elem) {
        return this.value.equals(elem.getValueAsObject());
    }

    public void setOdsxFilter(OdsxFilterInterface odsFilter) {
        this.odsFilter = odsFilter;
        this.clearCommands();
    }

    public OdsxFilterInterface getOdsxFilter() {
        return this.odsFilter;
    }

    protected OdsxPresentableElement(String value) {
        this();
        this.value = value;
        this.setName(FwkPropertyBus.getProperty((String)value));
    }

    public String getBaseName() {
        return "Presentable";
    }

    public FwkIconInterface getIcon() {
        return this.odsFilter.getIcon(this);
    }

    public String getValueAsString() {
        return this.getPresentationString();
    }

    public Object getItemByCoordinates(int[] coord) {
        if (coord[0] < 0 || coord[0] > 0) {
            throw new FwkException(-2147461534, "$RCSfile: OdsxPresentableElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "array.length=1 index=" + coord[0], (Object)this, (Throwable)new ArrayIndexOutOfBoundsException(coord[0]));
        }
        return this.value;
    }

    public int[] getDimensions() {
        int[] ret = new int[]{1};
        return ret;
    }

    public ArrayAccess subdivide(int[] start, int[] end) {
        if (start[0] != 0 && end[0] != 0) {
            throw new FwkException(-2147461534, "$RCSfile: OdsxPresentableElement.java,v $", this.getVersion(), "AH 2000-05-24 16:49", "array.length=1", (Object)this, (Throwable)new ArrayIndexOutOfBoundsException(start[0] != 0 ? start[0] : end[0]));
        }
        return this;
    }

    public void setItemByCoordinates(int[] coord, Object item) throws FwkException {
        if (coord[0] < 0 || coord[0] > 0) {
            throw new FwkException(-2147461534, "$RCSfile: OdsxPresentableElement.java,v $", this.getVersion(), "AH 2000-05-24 16:50", "array.length=1 index=" + coord[0], (Object)this, (Throwable)new ArrayIndexOutOfBoundsException(coord[0]));
        }
        this.value = item;
    }

    public void setValueAsObject(Object value) throws FwkException {
        this.value = value;
        this.changeManager.fireItemValueChanged((Object)this, null);
    }

    public Object getValueAsObject() {
        return this.value;
    }

    public String getPresentationString() {
        return this.getPresentationString(FwkContainer.getLocale());
    }

    public String getPresentationString(Locale l) {
        return this.getPresentationString(l, null);
    }

    public String getPresentationString(Locale locale, OdsxFilterInterface filter) {
        StringWriter sw = new StringWriter(4096);
        try {
            this.getPresentationString(sw, "All", locale, filter);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return sw.toString();
    }

    public String getODSVersion() {
        return null;
    }

    public String toString() {
        String version = this.getODSVersion();
        if (version != null) {
            return this.getName() + ";" + version;
        }
        return this.getName();
    }

    public void getPresentationString(Writer w, String spec, Locale l, OdsxFilterInterface f) throws IOException {
        try {
            w.write("" + this.value);
        }
        catch (Throwable t) {
            AoSession aoSession = this.getSession();
            FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(aoSession), null, null, (Throwable)t);
        }
    }

    public Vector getElements() {
        return null;
    }

    public Vector getRelatedElements() {
        return null;
    }

    public ApplicationRelation[] getRelations() {
        ApplicationRelation[] ret = new ApplicationRelation[]{};
        try {
            ApplicationElement aeElem1 = null;
            if (this instanceof OdsxApplicationElementInterface) {
                aeElem1 = ((OdsxApplicationElementInterface)((Object)this)).getApplicationElement();
            } else if (this instanceof OdsxInstanceElementInterface) {
                aeElem1 = ((OdsxInstanceElementInterface)((Object)this)).getInstanceElement().getApplicationElement();
            }
            ret = aeElem1.getAllRelations();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public AoSession getSession() {
        AoSession ret = null;
        ApplicationElement ae = null;
        if (this instanceof OdsxApplicationElementInterface) {
            ae = ((OdsxApplicationElementInterface)((Object)this)).getApplicationElement();
        } else if (this instanceof OdsxInstanceElementInterface) {
            try {
                ae = ((OdsxInstanceElementInterface)((Object)this)).getInstanceElement().getApplicationElement();
            }
            catch (Throwable t) {}
        } else if (this.value instanceof AoSession) {
            ret = (AoSession)this.value;
        }
        if (ret == null && ae != null) {
            try {
                ApplicationStructure as = ae.getApplicationStructure();
                ret = as.getSession();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ret;
    }

    public ApplicationRelation[] getRelations(OdsxPresentableElementInterface elem) {
        ApplicationRelation[] ret = new ApplicationRelation[]{};
        try {
            ApplicationStructure as;
            ApplicationElement aeElem1 = null;
            ApplicationElement aeElem2 = null;
            if (this instanceof OdsxApplicationElementInterface) {
                aeElem1 = ((OdsxApplicationElementInterface)((Object)this)).getApplicationElement();
            } else if (this instanceof OdsxInstanceElementInterface) {
                aeElem1 = ((OdsxInstanceElementInterface)((Object)this)).getInstanceElement().getApplicationElement();
            }
            if (elem instanceof OdsxApplicationElementInterface) {
                aeElem2 = ((OdsxApplicationElementInterface)((Object)this)).getApplicationElement();
            } else if (elem instanceof OdsxInstanceElementInterface) {
                aeElem2 = ((OdsxInstanceElementInterface)((Object)this)).getInstanceElement().getApplicationElement();
            }
            if (aeElem1 != null && aeElem2 != null && (as = aeElem1.getApplicationStructure()) != null) {
                ret = as.getRelations(aeElem1, aeElem2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public String getShortName(int length) {
        String name;
        String ret = name = this.getName();
        int len = name.length();
        if (len > length) {
            int index = name.indexOf(47);
            while (index != -1 && len - index > length) {
                index = name.indexOf(47, index + 1);
            }
            if (index == -1) {
                index = name.indexOf(92);
                while (index != -1 && len - index > length) {
                    index = name.indexOf(92, index + 1);
                }
            }
            ret = index == -1 ? "..." + ret.substring(ret.length() - length) : "..." + ret.substring(index);
        }
        return ret;
    }

    public String getIdentificationString() {
        return this.getName();
    }

    public FwkCommandInterface[] getCommands() {
        if (!this.commandsAvailable()) {
            String[] commands;
            String commandClasses;
            super.getCommands();
            Object cmd = new FwkCopyToClipboardCommand((FwkControllerInterface)this);
            this.addCommand((FwkCommandInterface)cmd);
            if (OdsxATFFilterCommand.hasServices()) {
                boolean create = true;
                AoSession aoSession = this.getSession();
                OdsxSessionInterface session = OdsxSessionFactory.getSessionObserver(aoSession);
                String type = null;
                try {
                    type = aoSession.getType();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (type != null && type.toUpperCase().startsWith("ATF-") && session != null) {
                    String options = session.getSessionOptions();
                    if (options != null && options.length() != 0 && options.toUpperCase().indexOf("FILENAME") < 0) {
                        create = false;
                    } else {
                        options = session.getAuthentication();
                        if (options != null && options.length() != 0 && options.toUpperCase().indexOf("FILENAME") < 0) {
                            create = false;
                        }
                    }
                }
                if (create && OdsxATFFilterCommand.commandAvailableForSession(session)) {
                    cmd = new OdsxATFFilterCommand((FwkControllerInterface)this);
                    cmd.setTextKey("OdsxATFFilter.Text.Create");
                    cmd.setCommandName("CreateATF");
                    this.addCommand((FwkCommandInterface)cmd);
                }
            }
            if ((commandClasses = FwkPropertyBus.getProperty((String)"OdsxPresentableElement.Command.Classes", (String)null)) != null && (commands = StringUtilities.split((String)commandClasses, (String)",", (boolean)true)) != null && commands.length != 0) {
                int size = commands.length;
                Class[] paramClasses = new Class[]{FwkControllerInterface.class};
                Object[] params = new Object[]{this};
                for (int i = 0; i < size; ++i) {
                    try {
                        Class<?> clazz = Class.forName(commands[i]);
                        cmd = null;
                        try {
                            Constructor<?> constructor = clazz.getConstructor(paramClasses);
                            cmd = (FwkCommandInterface)constructor.newInstance(params);
                        }
                        catch (Throwable noConstructor) {
                            cmd = (FwkCommandInterface)clazz.newInstance();
                            cmd.setController((FwkControllerInterface)this);
                        }
                        if (cmd == null) continue;
                        this.addCommand((FwkCommandInterface)cmd);
                        continue;
                    }
                    catch (Throwable t) {
                        if (FwkContainer.getDebugLevel() <= 0) continue;
                        t.printStackTrace();
                    }
                }
            }
        }
        return super.getCommands();
    }

    public void delete(boolean flag) {
    }

    public boolean matchBaseElement(String baseElementName) {
        Boolean ret;
        if (this.beQueries == null) {
            this.beQueries = new HashMap();
        }
        if ((ret = (Boolean)this.beQueries.get(baseElementName)) == null) {
            ret = new Boolean(this.getBaseName().compareToIgnoreCase(baseElementName) == 0);
            this.beQueries.put(baseElementName, ret);
        }
        return ret;
    }

    public boolean valueIsA(Class clazz) {
        if (this.value != null) {
            return clazz.isAssignableFrom(this.value.getClass());
        }
        return false;
    }

    public void release() {
        OdsxSessionFactory.removeOdsxChangeListener(this.getSession(), this);
        if (this.beQueries != null) {
            this.beQueries.clear();
            this.beQueries = null;
        }
        super.release();
    }

    public void odsChanged(OdsxChangeEventInterface event) {
    }
}

