/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementProducerInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemRequestedEvent;

public class OdsxPresentableElementProducer
extends FwkInfoBusProducer
implements OdsxPresentableElementProducerInterface,
FwkPropertyChangeListenerInterface {
    public static final String version = "$Revision: 1.5 $";
    private HashMap instHash;
    private HashMap applHash;
    private HashMap colHash;
    private HashMap elemHash;
    private Object MAPLOCK = new Object();
    protected static final DataFlavor applFlavor = FwkContainer.getDataFlavor((Class)OdsxApplicationElementInterface.class)[0];
    protected static final DataFlavor instFlavor = FwkContainer.getDataFlavor((Class)OdsxInstanceElementInterface.class)[0];
    protected static final DataFlavor[] colFlavor = new DataFlavor[]{FwkContainer.getDataFlavor((Class)OdsxColumnInterface.class)[0], FwkContainer.getDataFlavor((Class)FwkColumnAccessInterface.class)[0]};
    protected static int counter = 0;

    public String getVersion() {
        return version;
    }

    public OdsxPresentableElementProducer() {
        super("OdsxPresentableElementProducer[" + counter++ + "]@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeTypes((Class)OdsxPresentableElementInterface.class));
        this.addMimeType(FwkContainer.getMimeType((Class)OdsxInstanceElementInterface.class));
        this.addMimeType(FwkContainer.getMimeType((Class)OdsxApplicationElementInterface.class));
        this.addMimeType(FwkContainer.getMimeType((Class)OdsxColumnInterface.class));
        this.addMimeType(FwkContainer.getMimeType((Class)FwkColumnAccessInterface.class));
        this.instHash = new HashMap();
        this.applHash = new HashMap();
        this.colHash = new HashMap();
        this.elemHash = new HashMap();
    }

    public void fireItemAvailable(DataItem item, DataFlavor[] flavor) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)item;
            ib.fireItemAvailable(elem.getName(), flavor, (InfoBusDataProducer)this);
        }
    }

    public void fireItemRevoked(DataItem item) {
        if (item != null) {
            InfoBus ib = this.getInfoBus();
            if (ib != null) {
                OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)item;
                ib.fireItemRevoked(elem.getName(), (InfoBusDataProducer)this);
            }
            item.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (itemName == null) {
            return true;
        }
        if (this.isAssignable(flavor)) {
            if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                Object object = this.MAPLOCK;
                synchronized (object) {
                    this.instHash.remove(itemName);
                    this.applHash.remove(itemName);
                    this.colHash.remove(itemName);
                    this.fireItemRevoked((DataItem)this.elemHash.remove(itemName));
                }
            }
            Object[] arr = this.findMultipleDataItems(itemName, flavor);
            if (arr != null && arr.length != 0) {
                for (int i = arr.length; i >= 0; --i) {
                    try {
                        OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)arr[i];
                        String name = elem.getName();
                        Object object = this.MAPLOCK;
                        synchronized (object) {
                            this.instHash.remove(name);
                            this.applHash.remove(name);
                            this.colHash.remove(name);
                            this.fireItemRevoked((DataItem)this.elemHash.remove(name));
                            continue;
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(OdsxPresentableElementInterface elem) {
        if (elem == null) {
            return;
        }
        InfoBus ib = this.getInfoBus();
        if (ib != null && elem != null) {
            String ident = elem.getName();
            Object object = this.MAPLOCK;
            synchronized (object) {
                if (elem instanceof OdsxApplicationElementInterface) {
                    this.applHash.put(ident, elem);
                } else if (elem instanceof OdsxColumnInterface) {
                    this.colHash.put(ident, elem);
                    this.instHash.put(ident, elem);
                } else if (elem instanceof OdsxInstanceElementInterface) {
                    this.instHash.put(ident, elem);
                }
                this.elemHash.put(ident, elem);
            }
            elem.addPropertyChangeListener("Name", this);
            this.fireItemAvailable((DataItem)elem, FwkContainer.getDataFlavors(elem.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        super.dataItemRequested(ev);
        if (ev.getDataItem() == null) {
            String dataItemName = ev.getDataItemName();
            if (dataItemName != null) {
                boolean applRequested = false;
                boolean instRequested = false;
                boolean colRequested = false;
                DataFlavor[] df = ev.getDataFlavors();
                for (int i = df.length - 1; !(i < 0 || applRequested && instRequested && colRequested); --i) {
                    if (!applRequested) {
                        applRequested = applFlavor.equals(df[i]);
                    }
                    if (!instRequested) {
                        instRequested = instFlavor.equals(df[i]);
                    }
                    if (colRequested || (colRequested = colFlavor[0].equals(df[i]))) continue;
                    colRequested = colFlavor[1].equals(df[i]);
                }
                boolean assignable = this.isAssignable(ev.getDataFlavors());
                if (applRequested || instRequested || colRequested || assignable) {
                    HashMap hm = applRequested ? this.applHash : (instRequested ? this.instHash : (colRequested ? this.colHash : this.elemHash));
                    Object dataItem = hm.get(dataItemName);
                    if (dataItem == null) {
                        if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                            FwkArray dataItemArray = new FwkArray();
                            Iterator it = this.elemHash.keySet().iterator();
                            while (it.hasNext()) {
                                String itemName = (String)it.next();
                                if (!Pattern.match((String)itemName, (String)dataItemName, (boolean)false)) continue;
                                Object object = this.MAPLOCK;
                                synchronized (object) {
                                    dataItem = hm.get(itemName);
                                    if (dataItem != null) {
                                        dataItemArray.add(dataItem);
                                    } else {
                                        FwkContainer.debug((int)5, (String)("   OdsxPresentableElementProducer: Requested data item not found: " + dataItemName));
                                    }
                                }
                            }
                            if (dataItemArray.size() > 0) {
                                ev.setDataItem((Object)dataItemArray.toArray((Object[])new OdsxPresentableElementInterface[dataItemArray.size()]));
                            }
                        } else {
                            FwkContainer.debug((int)5, (String)("   OdsxPresentableElementProducer: Requested data item not found: " + dataItemName));
                        }
                    } else {
                        ev.setDataItem(dataItem);
                    }
                } else {
                    FwkContainer.debug((int)5, (String)"   OdsxPresentableElementProducer: Requested DataFlavor is not assignable.");
                }
            } else {
                FwkContainer.debug((int)5, (String)"   OdsxPresentableElementProducer: Data Item Name == null");
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getPropertyName().compareTo("Name") == 0) {
            OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)ev.getSource();
            this.remove((String)ev.getOldValue());
            this.add(elem);
        }
    }

    public void remove(OdsxPresentableElementInterface elem) {
        if (elem != null) {
            this.remove(elem.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String ident) {
        InfoBus ib = this.getInfoBus();
        if (ib != null && ident != null) {
            Object object = this.MAPLOCK;
            synchronized (object) {
                if (this.elemHash.get(ident) != null || this.applHash.get(ident) != null || this.instHash.get(ident) != null || this.colHash.get(ident) != null) {
                    this.applHash.remove(ident);
                    this.instHash.remove(ident);
                    this.colHash.remove(ident);
                    this.fireItemRevoked((DataItem)this.elemHash.remove(ident));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Vector elem = new Vector();
        Object object = this.MAPLOCK;
        synchronized (object) {
            Iterator it = this.elemHash.keySet().iterator();
            while (it.hasNext()) {
                elem.add(it.next());
            }
        }
        int size = elem.size();
        for (int i = 0; i < size; ++i) {
            this.remove((String)elem.get(i));
        }
    }
}

