/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkApplication;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkControlledByInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import com.highqsoft.interfaces.odsx.OdsxPathInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentorInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentorPanelInterface;
import com.highqsoft.odsx.OdsxPresentableElementConsumer;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRequestedEvent;
import javax.infobus.InfoBusItemRevokedEvent;

public class OdsxPresentor
extends FwkApplication
implements OdsxPresentorInterface {
    public static final String version = "$Revision: 1.3 $";
    public static final DataFlavor[] pathFlavor = FwkContainer.getDataFlavor((Class)OdsxPathInterface.class);
    static int producerCounter = 0;
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected OdsxPresentableElementConsumer consumer;
    protected OdsxPathProducer producer;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    public OdsxPresentor() {
        this.panel = null;
        this.consumer = new OdsxPresentableElementConsumer();
        this.consumer.addPropertyChangeListener(this);
        this.producer = new OdsxPathProducer();
        this.setDescriptor(descriptor);
        this.register();
    }

    public void run() {
    }

    public OdsxPresentor(OdsxPresentorPanelInterface panel) {
        this();
        this.setPanel(panel);
    }

    public boolean exit() {
        boolean ret = super.exit();
        if (ret) {
            this.consumer.unregister();
            this.producer.unregister();
        }
        return ret;
    }

    public void setController(FwkControllerInterface controller) {
        super.setController(controller);
        this.producer.setController(controller);
        this.consumer.setController(controller);
    }

    public void setPanel(FwkPanelInterface panel) {
        FwkControllerInterface controller = panel.getController();
        super.setPanel(panel);
        this.setController(controller);
        this.setIconKey(panel.getIconKey());
        ((OdsxPresentorPanelInterface)panel).setPresentor(this);
    }

    public void publishPath(OdsxPathInterface path) {
        this.producer.removeAll();
        this.producer.add(path);
    }

    public boolean isAssignable(DataFlavor[] flavors) {
        return this.consumer.isAssignable(flavors);
    }

    public void dataItemRevoked(InfoBusItemRevokedEvent ev) {
        this.consumer.dataItemRevoked(ev);
    }

    public void dataItemAvailable(InfoBusItemAvailableEvent ev) {
        this.consumer.dataItemAvailable(ev);
    }

    public Object findDataItem(String dataItemName) {
        return this.consumer.findDataItem(dataItemName);
    }

    public Object findDataItem(String dataItemName, DataFlavor[] flavors) {
        return this.consumer.findDataItem(dataItemName, flavors);
    }

    public Object[] findMultipleDataItems(String dataItemName) {
        return this.consumer.findMultipleDataItems(dataItemName);
    }

    public Object[] findMultipleDataItems(String dataItemName, DataFlavor[] flavors) {
        return this.consumer.findMultipleDataItems(dataItemName, flavors);
    }

    public DataFlavor getDataFlavor(int index) throws FwkException {
        return this.consumer.getDataFlavor(index);
    }

    public DataFlavor[] getDataFlavors() throws FwkException {
        return this.consumer.getDataFlavors();
    }

    public void addMimeType(String type) {
        this.consumer.addMimeType(type);
    }

    public void removeMimeType(String type) {
        this.consumer.removeMimeType(type);
    }

    public String[] getMimeTypes() {
        return this.consumer.getMimeTypes();
    }

    public void propertyChange(PropertyChangeEvent ev) {
        String prop = ev.getPropertyName();
        try {
            if (prop.compareTo("Available") == 0) {
                ((OdsxPresentorPanelInterface)this.panel).addPresentable((OdsxPresentableElementInterface)ev.getNewValue());
            } else if (prop.compareTo("Revoked") == 0) {
                ((OdsxPresentorPanelInterface)this.panel).removePresentable((OdsxPresentableElementInterface)ev.getOldValue());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void fireExecuteStateEvent(FwkExecuteStateEventInterface event) {
        FwkControllerInterface controller = this.getController();
        if (controller != null && controller instanceof FwkApplicationInterface) {
            ((FwkApplicationInterface)controller).fireExecuteStateEvent(event);
        }
        super.fireExecuteStateEvent(event);
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("ODS Presentor");
        descriptor.setTitleName("OdsxPresentor.Text.Title");
        descriptor.setName(OdsxPresentor.class.getName());
        descriptor.setCreationDate("$Date: 2005/02/03 14:49:22 $", null);
    }

    public class OdsxPathProducer
    extends FwkInfoBusProducer
    implements FwkControlledByInterface {
        HashMap pMap;

        public OdsxPathProducer() {
            super("OdsxPathProducer[" + producerCounter++ + "]@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeTypes((Class)(class$com$highqsoft$interfaces$odsx$OdsxPathInterface == null ? (class$com$highqsoft$interfaces$odsx$OdsxPathInterface = OdsxPresentor.class$("com.highqsoft.interfaces.odsx.OdsxPathInterface")) : class$com$highqsoft$interfaces$odsx$OdsxPathInterface)));
            this.pMap = new HashMap();
        }

        public boolean revoke(String itemName, DataFlavor[] flavor) {
            if (itemName == null) {
                return true;
            }
            if (this.isAssignable(flavor)) {
                if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                    this.fireItemRevoked((DataItem)this.pMap.remove(itemName));
                } else {
                    Object[] arr = this.findMultipleDataItems(itemName, flavor);
                    if (arr != null && arr.length != 0) {
                        for (int i = arr.length; i >= 0; --i) {
                            try {
                                OdsxPathInterface path = (OdsxPathInterface)arr[i];
                                String pathName = path.getPath();
                                this.fireItemRevoked((DataItem)this.pMap.remove(pathName));
                                continue;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            return true;
        }

        public void dataItemRequested(InfoBusItemRequestedEvent ev) {
            super.dataItemRequested(ev);
            if (ev.getDataItem() == null && this.isAssignable(ev.getDataFlavors())) {
                ev.setDataItem(this.pMap.get(ev.getDataItemName()));
            }
        }

        public void add(OdsxPathInterface elem) {
            InfoBus ib;
            if (elem != null && (ib = this.getInfoBus()) != null) {
                String ident = elem.getPath();
                this.pMap.put(ident, elem);
                ib.fireItemAvailable(ident, pathFlavor, (InfoBusDataProducer)this);
            }
        }

        public void remove(OdsxPathInterface elem) {
            if (elem != null) {
                this.remove(elem.getPath());
            }
        }

        public synchronized void remove(String ident) {
            this.fireItemRevoked((DataItem)this.pMap.remove(ident));
        }

        public synchronized void removeAll() {
            Iterator it = this.pMap.keySet().iterator();
            while (it.hasNext()) {
                this.remove((String)it.next());
            }
        }
    }
}

