/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkTableSorter;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.interfaces.odsx.OdsxTableModelInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxPresentorPanel;
import com.highqsoft.odsx.OdsxTableHelper;
import com.highqsoft.odsx.OdsxTablePresentorPanel;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.asam.ods.AIDName;
import org.asam.ods.AIDNameUnitId;
import org.asam.ods.AIDNameValueUnitId;
import org.asam.ods.AoException;
import org.asam.ods.ApplElemAccess;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.DataType;
import org.asam.ods.ElemId;
import org.asam.ods.ElemResultSet;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.NameValueUnit;
import org.asam.ods.QueryStructure;
import org.asam.ods.RelationRange;
import org.asam.ods.Relationship;
import org.asam.ods.SelOpcode;
import org.asam.ods.SelOperator;
import org.asam.ods.SelOrder;
import org.asam.ods.SelValue;
import org.asam.ods.TS_Union;
import org.asam.ods.TS_Value;
import org.asam.ods.TS_ValueSeq;
import org.asam.ods.T_LONGLONG;

public class OdsxQueryTablePresentor
extends OdsxPresentorPanel {
    public static final String version = "$Revision: 1.8 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected JTabbedPane jTabbedPane;
    HashMap tabHash;
    HashMap nameHash;
    HashMap sceduled;
    static /* synthetic */ Class class$java$lang$String;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)OdsxTablePresentorPanel.class, (FwkDescriptionInterface)descriptor);
    }

    public OdsxQueryTablePresentor() {
        this.setDescriptor(OdsxQueryTablePresentor.getDescriptor());
        int width = 600;
        try {
            width = Integer.parseInt(FwkPropertyBus.getProperty((String)"OdsxTablePresentorPanel.Width"));
        }
        catch (Throwable tWidth) {
            // empty catch block
        }
        int height = 400;
        try {
            height = Integer.parseInt(FwkPropertyBus.getProperty((String)"OdsxTablePresentorPanel.Height"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tabHash = new HashMap();
        this.nameHash = new HashMap();
        this.sceduled = new HashMap();
        this.setLayout(new BorderLayout());
        this.jTabbedPane = new JTabbedPane(1);
        this.add("Center", this.jTabbedPane);
        this.setPreferredSize(new Dimension(width, height));
    }

    public void addPresentable(OdsxPresentableElementInterface presentable) {
        if (!this.isVisible()) {
            this.sceduled.put(presentable, presentable);
            return;
        }
        this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, FwkPropertyBus.getProperty((String)"OdsxTablePresentorPanel.Text.CreatingPanel")));
        boolean isAE = presentable instanceof OdsxApplicationElementInterface;
        boolean isSession = presentable instanceof OdsxSessionInterface;
        boolean isColumn = presentable instanceof OdsxColumnInterface;
        JComponent display = null;
        ApplicationElement aeObj = null;
        InstanceElement ieObj = null;
        try {
            if (isAE) {
                aeObj = ((OdsxApplicationElementInterface)presentable).getApplicationElement();
            } else if (!isSession && !isColumn) {
                ieObj = ((OdsxInstanceElementInterface)presentable).getInstanceElement();
                aeObj = ieObj.getApplicationElement();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (aeObj != null) {
            if (ieObj == null) {
                String[] titles = this.getColumnTitles(presentable);
                if (titles.length != 0) {
                    String timeStr = "0,0 sec";
                    String[] cTitle = new String[titles.length];
                    OdsxFilterInterface filter = presentable.getOdsxFilter();
                    for (int i = titles.length - 1; i >= 0; --i) {
                        cTitle[i] = filter.getTranslatedKey(titles[i], titles[i]);
                    }
                    OdsxTableModelInterface model = null;
                    try {
                        model = OdsxTableHelper.createApplicationElementTable(((OdsxApplicationElementInterface)presentable).getApplicationElement(), true);
                        long time = model.getTimeToLoad();
                        timeStr = time / 1000L + "," + time % 1000L + " sec";
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.add("North", new JLabel(timeStr));
                        FwkTableSorter sorter = new FwkTableSorter((TableModel)model);
                        JTable table = new JTable((TableModel)sorter);
                        sorter.addMouseListenerToHeaderInTable(table);
                        table.setAutoResizeMode(0);
                        JScrollPane jScrollPane = new JScrollPane(table);
                        panel.add("Center", jScrollPane);
                        display = panel;
                    }
                    catch (AoException aoe) {
                        FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(presentable.getSession()), (String)"OdsxQueryTablePresentor.Text.ErrorOccured", (String)OdsxHelper.aoExceptionToString(aoe), (Throwable)aoe);
                        System.err.println(aoe.reason);
                        aoe.printStackTrace();
                    }
                    catch (Throwable t) {
                        FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(presentable.getSession()), (String)"OdsxQueryTablePresentor.Text.ErrorOccured", (String)t.getMessage(), (Throwable)t);
                        t.printStackTrace();
                    }
                }
            } else {
                ApplicationElement relatedAe;
                block33: {
                    OdsxInstanceElementInterface instance = (OdsxInstanceElementInterface)presentable;
                    relatedAe = null;
                    try {
                        if (instance.getBaseName().compareTo("AoMeasurement") == 0) {
                            ApplicationStructure as = aeObj.getApplicationStructure();
                            try {
                                ApplicationElement[] aeArray = as.getElementsByBaseType("AoMeasurementQuantity");
                                if (aeArray != null && aeArray.length > 0) {
                                    relatedAe = aeArray[0];
                                }
                                break block33;
                            }
                            catch (AoException tAe) {
                                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(presentable.getSession()), (String)"OdsxQueryTablePresentor.Text.ErrorOccured", (String)OdsxHelper.aoExceptionToString(tAe), (Throwable)tAe);
                            }
                            break block33;
                        }
                        ApplicationElement[] aeArray = aeObj.getRelatedElementsByRelationship(Relationship.CHILD);
                        if (aeArray != null && aeArray.length > 0) {
                            relatedAe = aeArray[0];
                        }
                    }
                    catch (AoException aoe) {
                        FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(presentable.getSession()), (String)"OdsxQueryTablePresentor.Text.ErrorOccured", (String)OdsxHelper.aoExceptionToString(aoe), (Throwable)aoe);
                        aoe.printStackTrace();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (relatedAe != null) {
                    OdsxTableModelInterface model = null;
                    String timeStr = "0,0 sec";
                    try {
                        model = OdsxTableHelper.createInstanceElementChildTable(ieObj, relatedAe, true);
                        long time = model.getTimeToLoad();
                        timeStr = time / 1000L + "," + time % 1000L + " sec";
                        JPanel panel = new JPanel(new BorderLayout());
                        panel.add("North", new JLabel(timeStr));
                        JTable table = new JTable(model);
                        table.setAutoResizeMode(0);
                        JScrollPane jScrollPane = new JScrollPane(table);
                        panel.add("Center", jScrollPane);
                        display = panel;
                    }
                    catch (AoException aoe) {
                        FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(presentable.getSession()), (String)"OdsxQueryTablePresentor.Text.ErrorOccured", (String)OdsxHelper.aoExceptionToString(aoe), (Throwable)aoe);
                        System.err.println(aoe.reason);
                        aoe.printStackTrace();
                    }
                    catch (Throwable t) {
                        FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(presentable.getSession()), (String)"OdsxQueryTablePresentor.Text.ErrorOccured", (String)t.getMessage(), (Throwable)t);
                        t.printStackTrace();
                    }
                }
            }
        }
        OdsxFilterInterface filter = presentable.getOdsxFilter();
        if (display == null) {
            JTextArea jTextArea = new JTextArea();
            if (filter != null) {
                jTextArea.setForeground(filter.getColor(presentable));
            } else {
                jTextArea.setForeground(Color.black);
            }
            jTextArea.setEditable(false);
            jTextArea.setSelectionStart(0);
            jTextArea.setSelectionEnd(0);
            TextWriter writer = new TextWriter(jTextArea);
            try {
                presentable.getPresentationString(writer, "All", FwkContainer.getLocale(), presentable.getOdsxFilter());
            }
            catch (Throwable t) {
                // empty catch block
            }
            writer.close();
            display = new JScrollPane(jTextArea);
        }
        this.jTabbedPane.add(presentable.getShortName(50), display);
        this.nameHash.put(presentable, presentable.getName());
        this.tabHash.put(presentable.getName(), display);
        int count = this.tabHash.size() - 1;
        if (filter != null) {
            this.jTabbedPane.setIconAt(count, (Icon)filter.getIcon(presentable));
            this.jTabbedPane.setForegroundAt(count, filter.getColor(presentable));
        } else {
            this.jTabbedPane.setForegroundAt(count, Color.black);
        }
        this.jTabbedPane.setToolTipTextAt(count, presentable.getName());
        this.jTabbedPane.setSelectedIndex(count);
        this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
    }

    public void removePresentable(OdsxPresentableElementInterface presentable) {
        this.sceduled.remove(presentable);
        try {
            JComponent panel;
            Object name = this.nameHash.remove(presentable);
            if (name != null && (panel = (JComponent)this.tabHash.remove(presentable.getName())) != null) {
                this.jTabbedPane.remove(panel);
            }
        }
        catch (Throwable th) {
            System.out.println(this.getClass().getName() + ".removePresentable, th = " + th);
        }
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        Iterator it = this.sceduled.keySet().iterator();
        while (it.hasNext()) {
            this.addPresentable((OdsxPresentableElementInterface)it.next());
        }
        this.sceduled.clear();
    }

    public String[] getColumnTitles(OdsxPresentableElementInterface presentable) {
        String[] ret;
        block12: {
            ret = new String[]{};
            try {
                if (presentable instanceof OdsxApplicationElementInterface) {
                    ret = this.getApplicationElementAttributes(presentable, ((OdsxApplicationElementInterface)presentable).getApplicationElement());
                    break block12;
                }
                if (presentable instanceof OdsxInstanceElementInterface) {
                    InstanceElement ie = ((OdsxInstanceElementInterface)presentable).getInstanceElement();
                    ApplicationElement ae = null;
                    if (ie.getApplicationElement().getBaseElement().getType().compareTo("AoMeasurement") == 0) {
                        ApplicationStructure as = ie.getApplicationElement().getApplicationStructure();
                        try {
                            ApplicationElement[] aeArray = as.getElementsByBaseType("AoMeasurementQuantity");
                            if (aeArray != null && aeArray.length > 0) {
                                ae = aeArray[0];
                            }
                        }
                        catch (Throwable tAe) {}
                    } else {
                        ApplicationElement[] aeArray = ie.getApplicationElement().getRelatedElementsByRelationship(Relationship.CHILD);
                        if (aeArray != null && aeArray.length > 0) {
                            ae = aeArray[0];
                        }
                    }
                    if (ae != null) {
                        ret = this.getApplicationElementAttributes(presentable, ae);
                    }
                    break block12;
                }
                if (!(presentable instanceof OdsxColumnInterface) && !(presentable instanceof OdsxSessionElementInterface)) {
                    System.out.println(this.getClass().getName() + ".getColumnTitle unknown PresentableElement class " + presentable.getClass().getName());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return ret;
    }

    protected String[] getApplicationElementAttributes(OdsxPresentableElementInterface presentable, ApplicationElement ae) {
        String[] ret = new String[]{};
        try {
            ApplicationAttribute[] aas = ae.getAttributes("*");
            Vector<String> aa = new Vector<String>();
            OdsxFilterInterface filter = presentable.getOdsxFilter();
            int size = aas.length;
            if (filter == null || !filter.getEnabled()) {
                for (int i = 0; i < size; ++i) {
                    try {
                        aa.add(aas[i].getName());
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            } else if (filter.isVisible(presentable)) {
                for (int i = 0; i < size; ++i) {
                    try {
                        String key = aas[i].getName();
                        if (!filter.isVisible(key, true)) continue;
                        aa.add(key);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            ret = new String[aa.size()];
            ret = aa.toArray(ret);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    public String[][] getColumnValues(OdsxPresentableElementInterface presentable, Vector header) {
        String[][] ret = new String[0][0];
        try {
            if (presentable instanceof OdsxApplicationElementInterface) {
                long time = System.currentTimeMillis();
                ret = this.selectForApplicationElement(((OdsxApplicationElementInterface)presentable).getApplicationElement(), header);
                System.out.println(System.currentTimeMillis() - time);
            } else if (!(presentable instanceof OdsxInstanceElementInterface || presentable instanceof OdsxColumnInterface || presentable instanceof OdsxSessionElementInterface)) {
                System.out.println(this.getClass().getName() + ".getColumnTitle unknown PresentableElement class " + presentable.getClass().getName());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    protected String[][] getInstanceAttributeValues(InstanceElementIterator it, String[] titles) {
        Locale locale = FwkContainer.getLocale();
        boolean deLang = locale.getLanguage().compareTo("de") == 0;
        String[][] ret = new String[0][0];
        try {
            int height = it.getCount();
            int width = titles.length;
            ret = new String[height][width];
            for (int i = 0; i < height; ++i) {
                InstanceElement ie = it.nextOne();
                for (int j = 0; j < width; ++j) {
                    try {
                        NameValueUnit nvu = ie.getValue(titles[j]);
                        TS_Union u = nvu.value.u;
                        short flag = nvu.value.flag;
                        if (flag != 0) {
                            ret[i][j] = OdsxHelper.ts_unionToString(u, 5);
                            continue;
                        }
                        if (deLang) {
                            ret[i][j] = "<ung\u00fcltig>";
                            continue;
                        }
                        ret[i][j] = "<invalid>";
                        continue;
                    }
                    catch (Throwable tVal) {
                        ret[i][j] = deLang ? "<ung\u00fcltig>" : "<invalid>";
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    public String[][] selectForApplicationElement(ApplicationElement ae, Vector titles) {
        String[][] ret = null;
        titles.clear();
        if (ae != null) {
            try {
                int v;
                int i;
                int i2;
                DataType dt;
                ApplicationStructure asObj = ae.getApplicationStructure();
                T_LONGLONG aeId = ae.getId();
                ApplElemAccess aea = asObj.getSession().getApplElemAccess();
                ApplicationRelation[] aeRel = ae.getAllRelations();
                Vector<ApplicationElement> relVec = new Vector<ApplicationElement>();
                Vector<String> relName = new Vector<String>();
                for (int i3 = 0; i3 < aeRel.length; ++i3) {
                    if (aeRel[i3].getRelationship().value() == 1) continue;
                    RelationRange relRange = aeRel[i3].getRelationRange();
                    if (relRange.max != 1) continue;
                    ApplicationElement elem2 = aeRel[i3].getElem2();
                    if (elem2.getId().low == aeId.low) continue;
                    relVec.add(aeRel[i3].getElem2());
                    relName.add(aeRel[i3].getRelationName());
                }
                ApplicationElement[] relAe = relVec.toArray(new ApplicationElement[relVec.size()]);
                String[] relNames = relName.toArray(new String[relName.size()]);
                QueryStructure aoq = new QueryStructure();
                aoq.condSeq = new SelValue[1];
                ApplicationAttribute aaObj = ae.getAttributeByBaseName("name");
                aoq.condSeq[0] = new SelValue();
                aoq.condSeq[0].attr = new AIDNameValueUnitId();
                aoq.condSeq[0].attr.attr = new AIDName();
                aoq.condSeq[0].attr.attr.aid = aeId;
                aoq.condSeq[0].attr.attr.aaName = aaObj.getName();
                aoq.condSeq[0].attr.unitId = new T_LONGLONG();
                aoq.condSeq[0].attr.values = new TS_Value();
                aoq.condSeq[0].attr.values.u = new TS_Union();
                aoq.condSeq[0].attr.values.u.shortVal((short)0);
                aoq.condSeq[0].oper = SelOpcode.LIKE;
                aoq.condSeq[0].value = new TS_Value();
                aoq.condSeq[0].value.u = new TS_Union();
                aoq.condSeq[0].value.u.stringVal("*");
                aoq.operSeq = new SelOperator[0];
                ApplicationAttribute[] attrs = ae.getAttributes("*");
                int size = attrs.length;
                boolean check = true;
                block20: for (int i4 = 0; i4 < size; ++i4) {
                    dt = attrs[i4].getDataType();
                    switch (dt.value()) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 10: 
                        case 25: {
                            if (check) {
                                String type = attrs[i4].getBaseAttribute().getName();
                                if (type != null && type.compareToIgnoreCase("id") == 0) {
                                    titles.insertElementAt(attrs[i4].getName(), 0);
                                    check = false;
                                    continue block20;
                                }
                                titles.add(attrs[i4].getName());
                                continue block20;
                            }
                            titles.add(attrs[i4].getName());
                            continue block20;
                        }
                    }
                }
                int relOffset = titles.size();
                HashMap<String, TS_ValueSeq> relValues = new HashMap<String, TS_ValueSeq>();
                for (i2 = 0; i2 < relNames.length; ++i2) {
                    titles.add(relNames[i2]);
                }
                size = titles.size();
                aoq.anuSeq = new AIDNameUnitId[size];
                for (i2 = 0; i2 < size; ++i2) {
                    aoq.anuSeq[i2] = new AIDNameUnitId();
                    aoq.anuSeq[i2].attr = new AIDName();
                    aoq.anuSeq[i2].attr.aid = aeId;
                    aoq.anuSeq[i2].attr.aaName = (String)titles.get(i2);
                    aoq.anuSeq[i2].unitId = new T_LONGLONG();
                }
                aoq.relInst = new ElemId();
                aoq.relName = "";
                aoq.relInst.aid = new T_LONGLONG();
                aoq.relInst.iid = new T_LONGLONG();
                aoq.orderBy = new SelOrder[0];
                ElemResultSet[] elemRes = aea.getInstances(aoq, 0);
                if (elemRes != null && elemRes.length == 1) {
                    size = elemRes[0].attrValues.length;
                    ret = null;
                    titles.clear();
                    block23: for (i = 0; i < size; ++i) {
                        dt = elemRes[0].attrValues[i].attrValues.value.u.discriminator();
                        switch (dt.value()) {
                            case 4: {
                                titles.add(elemRes[0].attrValues[i].attrValues.valName);
                                boolean[] bb = elemRes[0].attrValues[i].attrValues.value.u.booleanVal();
                                int vSize = bb.length;
                                for (int v2 = 0; v2 < vSize; ++v2) {
                                    ret[i][v2] = "" + bb[v2];
                                }
                                continue block23;
                            }
                            case 5: {
                                titles.add(elemRes[0].attrValues[i].attrValues.valName);
                                byte[] by = elemRes[0].attrValues[i].attrValues.value.u.byteVal();
                                int vSize = by.length;
                                for (int v3 = 0; v3 < vSize; ++v3) {
                                    ret[i][v3] = "" + by[v3];
                                }
                                continue block23;
                            }
                            case 10: {
                                titles.add(elemRes[0].attrValues[i].attrValues.valName);
                                String[] dv = elemRes[0].attrValues[i].attrValues.value.u.dateVal();
                                int vSize = dv.length;
                                for (int v4 = 0; v4 < vSize; ++v4) {
                                    ret[i][v4] = "" + dv[v4];
                                }
                                continue block23;
                            }
                            case 7: {
                                titles.add(elemRes[0].attrValues[i].attrValues.valName);
                                double[] dob = elemRes[0].attrValues[i].attrValues.value.u.doubleVal();
                                int vSize = dob.length;
                                for (int v5 = 0; v5 < vSize; ++v5) {
                                    ret[i][v5] = "" + dob[v5];
                                }
                                continue block23;
                            }
                            case 3: {
                                titles.add(elemRes[0].attrValues[i].attrValues.valName);
                                float[] fo = elemRes[0].attrValues[i].attrValues.value.u.floatVal();
                                int vSize = fo.length;
                                for (int v6 = 0; v6 < vSize; ++v6) {
                                    ret[i][v6] = "" + fo[v6];
                                }
                                continue block23;
                            }
                            case 6: 
                            case 25: {
                                titles.add(elemRes[0].attrValues[i].attrValues.valName);
                                int[] id = elemRes[0].attrValues[i].attrValues.value.u.longVal();
                                if (ret == null) {
                                    ret = new String[size][id.length];
                                } else if (i >= relOffset) {
                                    relValues.put(elemRes[0].attrValues[i].attrValues.valName, elemRes[0].attrValues[i].attrValues.value);
                                }
                                int vSize = id.length;
                                for (int v7 = 0; v7 < vSize; ++v7) {
                                    ret[i][v7] = "" + id[v7];
                                }
                                continue block23;
                            }
                            case 2: {
                                titles.add(elemRes[0].attrValues[i].attrValues.valName);
                                short[] sid = elemRes[0].attrValues[i].attrValues.value.u.shortVal();
                                int vSize = sid.length;
                                for (v = 0; v < vSize; ++v) {
                                    ret[i][v] = "" + sid[v];
                                }
                                continue block23;
                            }
                            case 1: {
                                titles.add(elemRes[0].attrValues[i].attrValues.valName);
                                String[] ds = elemRes[0].attrValues[i].attrValues.value.u.stringVal();
                                int vSize = ds.length;
                                for (int v8 = 0; v8 < vSize; ++v8) {
                                    ret[i][v8] = "" + ds[v8];
                                }
                                continue block23;
                            }
                            default: {
                                Arrays.fill(ret[i], "");
                            }
                        }
                    }
                }
                int relSize = relNames.length;
                for (i = 0; i < relSize; ++i) {
                    int pos = relOffset + i;
                    Arrays.fill(ret[pos], "");
                    TS_ValueSeq ids = (TS_ValueSeq)relValues.get(relNames[i]);
                    aoq = new QueryStructure();
                    aoq.condSeq = new SelValue[1];
                    aaObj = relAe[i].getAttributeByBaseName("id");
                    T_LONGLONG relId = relAe[i].getId();
                    aoq.condSeq[0] = new SelValue();
                    aoq.condSeq[0].attr = new AIDNameValueUnitId();
                    aoq.condSeq[0].attr.attr = new AIDName();
                    aoq.condSeq[0].attr.attr.aid = relId;
                    aoq.condSeq[0].attr.attr.aaName = aaObj.getName();
                    aoq.condSeq[0].attr.unitId = new T_LONGLONG();
                    aoq.condSeq[0].attr.values = new TS_Value();
                    aoq.condSeq[0].attr.values.u = new TS_Union();
                    aoq.condSeq[0].attr.values.u.shortVal((short)0);
                    aoq.condSeq[0].oper = SelOpcode.INSET;
                    aoq.condSeq[0].value = new TS_Value();
                    aoq.condSeq[0].value.u = new TS_Union();
                    aoq.condSeq[0].value.u.longSeq(ids.u.longVal());
                    aoq.operSeq = new SelOperator[0];
                    aoq.anuSeq = new AIDNameUnitId[2];
                    aaObj = relAe[i].getAttributeByBaseName("id");
                    aoq.anuSeq[0] = new AIDNameUnitId();
                    aoq.anuSeq[0].attr = new AIDName();
                    aoq.anuSeq[0].attr.aid = relId;
                    aoq.anuSeq[0].attr.aaName = aaObj.getName();
                    aoq.anuSeq[0].unitId = new T_LONGLONG();
                    aaObj = relAe[i].getAttributeByBaseName("name");
                    aoq.anuSeq[1] = new AIDNameUnitId();
                    aoq.anuSeq[1].attr = new AIDName();
                    aoq.anuSeq[1].attr.aid = relId;
                    aoq.anuSeq[1].attr.aaName = aaObj.getName();
                    aoq.anuSeq[1].unitId = new T_LONGLONG();
                    aoq.relInst = new ElemId();
                    aoq.relName = "";
                    aoq.relInst.aid = new T_LONGLONG();
                    aoq.relInst.iid = new T_LONGLONG();
                    aoq.orderBy = new SelOrder[0];
                    elemRes = aea.getInstances(aoq, 0);
                    if (elemRes != null && elemRes.length == 1) {
                        size = elemRes[0].attrValues.length;
                        block33: for (int elem = 0; elem < size; ++elem) {
                            dt = elemRes[0].attrValues[elem].attrValues.value.u.discriminator();
                            switch (dt.value()) {
                                case 6: 
                                case 25: {
                                    System.out.println("**** int (" + i + ") **** " + elemRes[0].attrValues[elem].attrValues.valName);
                                    int[] dl = elemRes[0].attrValues[elem].attrValues.value.u.longVal();
                                    int vSize = dl.length;
                                    continue block33;
                                }
                                case 1: {
                                    System.out.println("**** String (" + i + ") **** " + elemRes[0].attrValues[elem].attrValues.valName);
                                    String[] ds = elemRes[0].attrValues[elem].attrValues.value.u.stringVal();
                                    int vSize = ds.length;
                                    for (v = 0; v < vSize; ++v) {
                                        ret[pos][v] = "" + ds[v];
                                    }
                                    continue block33;
                                }
                            }
                        }
                        continue;
                    }
                    Arrays.fill(ret[relOffset + i], "");
                }
            }
            catch (AoException aoe) {
                System.err.println(aoe.reason);
                aoe.printStackTrace();
            }
        }
        return ret;
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("Table-Presentor Panel");
        descriptor.setTitleName("OdsxQueryTablePresentor.Text.Title");
        descriptor.setName(OdsxQueryTablePresentor.class.getName());
        descriptor.setCreationDate("$Date: 2007/10/15 14:34:02 $", null);
        descriptor.setIconKey("Icon.Table");
    }

    public class TextWriter
    extends Writer {
        JTextArea area;

        public TextWriter(JTextArea area) {
            this.area = area;
        }

        public void close() {
            this.flush();
        }

        public void flush() {
            this.area.repaint();
        }

        public void write(char[] cbuf, int off, int len) {
            if (off < 0) {
                off = 0;
            }
            this.area.append(new String(cbuf, off, len));
        }
    }

    public class TablePresentorModel
    implements TableModel {
        protected Object[][] data;
        protected Vector titles;

        public TablePresentorModel(Object[][] data, Vector titles) {
            this.data = data;
            this.titles = titles;
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void addTableModelListener(TableModelListener l) {
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = OdsxQueryTablePresentor.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            try {
                return this.data.length;
            }
            catch (Throwable throwable) {
                return 0;
            }
        }

        public String getColumnName(int columnIndex) {
            return this.titles.get(columnIndex).toString();
        }

        public int getRowCount() {
            try {
                return this.data[0].length;
            }
            catch (Throwable throwable) {
                return 0;
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[columnIndex][rowIndex];
        }

        public void removeTableModelListener(TableModelListener l) {
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }
}

