/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.OdsxFilterValue;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxSession;
import java.awt.Container;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.BaseStructure;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.Relationship;

public class OdsxReadDictionary {
    public static final String version = "$Revision: 1.6 $";
    OdsxSessionInterface odsSession = null;
    String outputFile;
    String plugComponent;
    String iniFile;
    String serviceName;
    String serviceOptions;
    String sessionOptions;
    String asamPath;
    String valueAttribute;
    String keyAttribute;
    String removablePrefix;
    boolean verbose;
    boolean help;
    FwkPropertyGroup propGrp = new FwkPropertyGroup();

    public static String getVersion() {
        return version;
    }

    public OdsxReadDictionary() {
        this.outputFile = FwkPropertyBus.getProperty((String)"OutputFile", (String)"OdsxFilter.Dictionary");
        this.plugComponent = FwkPropertyBus.getProperty((String)"PlugableComponent", (String)"com.highqsoft.ods.athos.AoService");
        this.removablePrefix = FwkPropertyBus.getProperty((String)"RemovablePrefix", (String)"AODS_");
        this.iniFile = FwkPropertyBus.getProperty((String)"iniFile", (String)"");
        this.serviceName = FwkPropertyBus.getProperty((String)"ServiceName", (String)"Puma");
        this.serviceOptions = FwkPropertyBus.getProperty((String)"ServiceOptions", (String)"");
        if (this.iniFile.length() != 0) {
            this.serviceOptions = this.serviceOptions.length() == 0 ? "-INIFILE=" + this.iniFile : this.serviceOptions + " -INIFILE=" + this.iniFile;
        }
        this.sessionOptions = FwkPropertyBus.getProperty((String)"SessionOptions", (String)"");
        this.asamPath = FwkPropertyBus.getProperty((String)"AsamPath", (String)"/[Environment]Rad/[Language]Ger");
        this.valueAttribute = FwkPropertyBus.getProperty((String)"ValueAttribute", (String)"iValue");
        this.keyAttribute = FwkPropertyBus.getProperty((String)"KeyAttribute", (String)"iKey");
        this.verbose = FwkPropertyBus.getProperty((String)"Verbose", (boolean)false) || FwkPropertyBus.getProperty((String)"verbose", (boolean)false);
        this.help = FwkPropertyBus.getProperty((String)"Help", (boolean)true);
        if (this.verbose || this.help) {
            System.out.println("The OdsxReadDictionary uses the following parameters to read the database:");
            this.printParams(System.out, null);
        }
    }

    public void printParams(PrintStream ps, String prefix) {
        if (prefix == null) {
            prefix = "\t";
        }
        ps.println(this.getParams(prefix));
    }

    public String getParams(String prefix) {
        if (prefix == null) {
            prefix = "\t";
        }
        return prefix + "-OutputFile:        " + this.outputFile + "\n" + prefix + "-PlugableComponent: " + this.plugComponent + "\n" + prefix + "-IniFile:           " + this.iniFile + "\n" + prefix + "-ServiceName:       " + this.serviceName + "\n" + prefix + "-ServiceOptions:    " + this.serviceOptions + "\n" + prefix + "-SessionOptions:    " + this.sessionOptions + "\n" + prefix + "-AsamPath:          " + this.asamPath + "\n" + prefix + "-RemovablePrefix:   " + this.removablePrefix + "\n" + prefix + "-ValueAttribute:    " + this.valueAttribute + "\n" + prefix + "-KeyAttribute:      " + this.keyAttribute + "\n" + prefix + "-Verbose:           " + this.verbose + "\n" + prefix + "-Help:              " + this.help;
    }

    public boolean connect() {
        boolean ret = true;
        if (this.odsSession == null) {
            this.odsSession = new OdsxSession();
            this.odsSession.setPlumName(this.plugComponent);
            this.odsSession.setServiceName(this.serviceName);
            this.odsSession.setServiceOptions(this.serviceOptions);
            this.odsSession.setSessionOptions(this.sessionOptions);
            try {
                this.odsSession.getService();
            }
            catch (Throwable t) {
                FwkContainer.showErrorMessage((Container)null, null, null, (Throwable)t);
                ret = false;
            }
            if (this.odsSession.isValid()) {
                if (!this.odsSession.hasPermissions()) {
                    this.odsSession.close();
                    this.odsSession = null;
                }
            } else {
                System.err.println("Service " + this.serviceName + " not found or wrong parameters.");
                this.odsSession.close();
                this.odsSession = null;
            }
        }
        boolean bl = ret = this.odsSession != null;
        if (!ret) {
            System.err.println("The connection to database failed.");
            if (!this.help && !this.verbose) {
                this.printParams(System.err, null);
            }
        } else if (this.verbose) {
            System.out.println("Connect to database successful.");
        }
        return ret;
    }

    public boolean disconnect() {
        if (this.odsSession != null) {
            this.odsSession.close();
            if (this.verbose) {
                System.out.println("Disconnect from database.");
            }
            this.odsSession = null;
        }
        return true;
    }

    public boolean readDictionary() {
        boolean connected;
        boolean ret = false;
        boolean sessionFound = false;
        boolean applicationStructureFound = false;
        boolean keyFound = false;
        boolean valueFound = false;
        boolean pathFound = false;
        boolean elemFound = false;
        int count = 0;
        boolean bl = connected = this.odsSession != null;
        if (connected) {
            try {
                String value;
                AoSession session = this.odsSession.getSession();
                sessionFound = true;
                BaseStructure bsObj = session.getBaseStructure();
                String[] beName = bsObj.listElements("*");
                for (int i = beName.length - 1; i >= 0; --i) {
                    if (beName[i].compareTo("AoAny") == 0) {
                        this.propGrp.put((Object)("BaseElement." + beName[i] + "." + "Name"), (Object)beName[i]);
                        this.propGrp.put((Object)("BaseElement." + beName[i] + "." + "Value"), (Object)beName[i]);
                        this.propGrp.put((Object)("BaseElement." + beName[i] + "." + "Visible"), (Object)"false");
                        this.propGrp.put((Object)("BaseElement." + beName[i] + "." + "Enabled"), (Object)"false");
                        continue;
                    }
                    this.propGrp.put((Object)("BaseElement." + beName[i] + "." + "Name"), (Object)beName[i]);
                    this.propGrp.put((Object)("BaseElement." + beName[i] + "." + "Value"), (Object)beName[i]);
                    this.propGrp.put((Object)("BaseElement." + beName[i] + "." + "Visible"), (Object)"true");
                    this.propGrp.put((Object)("BaseElement." + beName[i] + "." + "Enabled"), (Object)"true");
                }
                ApplicationStructure asObj = session.getApplicationStructure();
                applicationStructureFound = true;
                String[] elems = asObj.listElements("*");
                if (this.removablePrefix != null && this.removablePrefix.length() > 0) {
                    for (int i = elems.length - 1; i >= 0; --i) {
                        value = elems[i];
                        int index = value.indexOf(this.removablePrefix);
                        if (index == 0) {
                            value = value.substring(this.removablePrefix.length());
                        }
                        this.propGrp.put((Object)("ApplicationElement." + elems[i] + "." + "Name"), (Object)elems[i]);
                        this.propGrp.put((Object)("ApplicationElement." + elems[i] + "." + "Value"), (Object)value);
                        this.propGrp.put((Object)("ApplicationElement." + elems[i] + "." + "Visible"), (Object)"true");
                        this.propGrp.put((Object)("ApplicationElement." + elems[i] + "." + "Enabled"), (Object)"true");
                    }
                } else {
                    for (int i = elems.length - 1; i >= 0; --i) {
                        this.propGrp.put((Object)("ApplicationElement." + elems[i] + "." + "Name"), (Object)elems[i]);
                        this.propGrp.put((Object)("ApplicationElement." + elems[i] + "." + "Value"), (Object)elems[i]);
                        this.propGrp.put((Object)("ApplicationElement." + elems[i] + "." + "Visible"), (Object)"true");
                        this.propGrp.put((Object)("ApplicationElement." + elems[i] + "." + "Enabled"), (Object)"true");
                    }
                }
                InstanceElement ieObj = asObj.getInstanceByAsamPath(this.asamPath);
                pathFound = true;
                if (this.verbose) {
                    System.out.println("InstanceElement " + ieObj.getAsamPath() + " loaded.");
                }
                InstanceElementIterator it = ieObj.getRelatedInstancesByRelationship(Relationship.CHILD, "*");
                elemFound = true;
                count = it.getCount();
                while (count-- > 0) {
                    String key;
                    InstanceElement elem = it.nextOne();
                    if (this.verbose) {
                        System.out.println(elem.getName());
                    }
                    boolean bl2 = keyFound = (key = OdsxHelper.nameValueUnitToString(elem.getValue(this.keyAttribute)).trim()).length() != 0;
                    if (this.verbose) {
                        System.out.println("\tkey:   " + key);
                    }
                    boolean bl3 = valueFound = (value = OdsxHelper.nameValueUnitToString(elem.getValue(this.valueAttribute)).trim()).length() != 0;
                    if (this.verbose) {
                        System.out.println("\tvalue: " + value);
                    }
                    if (!keyFound || !valueFound) continue;
                    OdsxFilterValue val = new OdsxFilterValue(key, value);
                    this.propGrp.put((Object)("ApplicationAttribute." + key + "." + "Name"), (Object)key);
                    this.propGrp.put((Object)("ApplicationAttribute." + key + "." + "Value"), (Object)value);
                    this.propGrp.put((Object)("ApplicationAttribute." + key + "." + "Visible"), (Object)("" + val.getVisible()));
                    this.propGrp.put((Object)("ApplicationAttribute." + key + "." + "Enabled"), (Object)("" + val.getEnabled()));
                }
                it.destroy();
                ret = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!ret) {
            System.err.println("Cannot read the dictionary from database.");
            if (!connected) {
                System.err.println("There is no connection to database.");
            } else if (!sessionFound) {
                System.err.println("Cannot load a session.");
            } else if (!applicationStructureFound) {
                System.err.println("Cannot load ApplicationStructure");
            } else if (!pathFound) {
                System.err.println("Cannot load Instance from specified AsamPath.");
            } else if (!elemFound || count <= 0) {
                System.err.println("Instance of specified AsamPath has no children.");
            } else if (!keyFound) {
                System.err.println("Cannot load specified key attribute.");
            } else if (!valueFound) {
                System.err.println("Cannot load specified value attribute.");
            }
            System.err.println("See the event logging for additional information.");
        }
        return ret;
    }

    public void dump(PrintStream ps) {
        this.propGrp.list(ps);
    }

    public boolean dump() {
        boolean ret = true;
        try {
            FileOutputStream fos = new FileOutputStream(this.outputFile);
            PrintStream ps = new PrintStream(fos);
            try {
                this.dump(ps);
            }
            catch (Throwable t) {
                System.err.println("Cannot write file " + this.outputFile + ".");
                ret = false;
            }
            fos.close();
            if (this.verbose) {
                System.out.println("Dictionary dumped to file " + this.outputFile);
            }
        }
        catch (Throwable tFos) {
            System.err.println("Cannot open file " + this.outputFile + " for writing.");
            ret = false;
        }
        return ret;
    }

    public static void main(String[] args) {
        String[] addArgs = new String[]{"-Odsx.NewSession.AskForPassword", "false"};
        String[] arguments = new String[args.length + addArgs.length];
        System.arraycopy(addArgs, 0, arguments, 0, addArgs.length);
        if (args.length > 0) {
            System.arraycopy(args, 0, arguments, addArgs.length, args.length);
        }
        FwkContainer.initialize((String[])arguments);
        OdsxReadDictionary rd = new OdsxReadDictionary();
        if (rd.connect() && rd.readDictionary()) {
            rd.dump();
        }
        rd.disconnect();
        System.exit(0);
    }
}

