/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import java.util.Vector;

public class OdsxSecurityHelper {
    public static final String version = "$Revision: 1.5 $";
    public static final String SEC_DELETE = "SEC_DELETE";
    public static final String SEC_GRANT = "SEC_GRANT";
    public static final String SEC_INSERT = "SEC_INSERT";
    public static final String SEC_READ = "SEC_READ";
    public static final String SEC_UPDATE = "SEC_UPDATE";
    public static final String SEC_NONE = "NO_ACCESS";
    public static final String ATTRIBUTE_SECURITY = "ATTRIBUTE_SECURITY";
    public static final String ELEMENT_SECURITY = "ELEMENT_SECURITY";
    public static final String INSTANCE_SECURITY = "INSTANCE_SECURITY";
    public static final String NO_SECURITY = "NO_SECURITY";
    private static final String SEP_CHARACTER = " | ";

    public static String getVersion() {
        return version;
    }

    private OdsxSecurityHelper() {
    }

    public static String securityLevelToString(int secLevel) {
        String ret = null;
        if (secLevel == 0) {
            ret = NO_SECURITY;
        } else {
            boolean addSep = false;
            StringBuffer sl = new StringBuffer();
            sl.append("");
            if ((secLevel & 1) != 0) {
                sl.append(ELEMENT_SECURITY);
                addSep = true;
            }
            if ((secLevel & 2) != 0) {
                if (addSep) {
                    sl.append(SEP_CHARACTER);
                }
                sl.append(INSTANCE_SECURITY);
                addSep = true;
            }
            if ((secLevel & 4) != 0) {
                if (addSep) {
                    sl.append(SEP_CHARACTER);
                }
                sl.append(ATTRIBUTE_SECURITY);
                addSep = true;
            }
            ret = sl.toString();
        }
        return ret;
    }

    public static String[] securityLevelToStringArray(int secLevel) {
        Vector<String> vec = new Vector<String>();
        if (secLevel == 0) {
            vec.add(NO_SECURITY);
        } else {
            if ((secLevel & 1) != 0) {
                vec.add(ELEMENT_SECURITY);
            }
            if ((secLevel & 2) != 0) {
                vec.add(INSTANCE_SECURITY);
            }
            if ((secLevel & 4) != 0) {
                vec.add(ATTRIBUTE_SECURITY);
            }
        }
        return vec.toArray(new String[vec.size()]);
    }

    public static int parseSecurityLevel(String secLevelString) {
        int secLevel = 0;
        String[] s = secLevelString.split(SEP_CHARACTER);
        if (s == null) {
            s = new String[]{secLevelString};
        }
        for (int i = 0; i < s.length; ++i) {
            if (s[i].compareToIgnoreCase(ELEMENT_SECURITY) == 0) {
                secLevel |= 1;
            }
            if (s[i].compareToIgnoreCase(INSTANCE_SECURITY) == 0) {
                secLevel |= 2;
            }
            if (s[i].compareToIgnoreCase(ATTRIBUTE_SECURITY) != 0) continue;
            secLevel |= 4;
        }
        return secLevel;
    }

    public static String securityRightsToString(int right) {
        String ret = null;
        if (right == 0) {
            ret = SEC_NONE;
        } else {
            boolean addSep = false;
            StringBuffer sl = new StringBuffer();
            sl.append("");
            if ((right & 1) != 0) {
                sl.append(SEC_READ);
                addSep = true;
            }
            if ((right & 2) != 0) {
                if (addSep) {
                    sl.append(SEP_CHARACTER);
                }
                sl.append(SEC_UPDATE);
                addSep = true;
            }
            if ((right & 4) != 0) {
                if (addSep) {
                    sl.append(SEP_CHARACTER);
                }
                sl.append(SEC_INSERT);
                addSep = true;
            }
            if ((right & 8) != 0) {
                if (addSep) {
                    sl.append(SEP_CHARACTER);
                }
                sl.append(SEC_DELETE);
                addSep = true;
            }
            if ((right & 0x10) != 0) {
                if (addSep) {
                    sl.append(SEP_CHARACTER);
                }
                sl.append(SEC_GRANT);
                addSep = true;
            }
            ret = sl.toString();
        }
        return ret;
    }

    public static String[] securityRightsToStringArray(int right) {
        Vector<String> vec = new Vector<String>();
        if (right == 0) {
            vec.add(SEC_NONE);
        } else {
            if ((right & 1) != 0) {
                vec.add(SEC_READ);
            }
            if ((right & 2) != 0) {
                vec.add(SEC_UPDATE);
            }
            if ((right & 4) != 0) {
                vec.add(SEC_INSERT);
            }
            if ((right & 8) != 0) {
                vec.add(SEC_DELETE);
            }
            if ((right & 0x10) != 0) {
                vec.add(SEC_GRANT);
            }
        }
        return vec.toArray(new String[vec.size()]);
    }

    public static int parseSecurityRights(String secLevelString) {
        int right = 0;
        String[] s = secLevelString.split(SEP_CHARACTER);
        if (s == null) {
            s = new String[]{secLevelString};
        }
        for (int i = 0; i < s.length; ++i) {
            if (s[i].compareToIgnoreCase(SEC_READ) == 0) {
                right |= 1;
            }
            if (s[i].compareToIgnoreCase(SEC_UPDATE) == 0) {
                right |= 2;
            }
            if (s[i].compareToIgnoreCase(SEC_INSERT) == 0) {
                right |= 4;
            }
            if (s[i].compareToIgnoreCase(SEC_DELETE) == 0) {
                right |= 8;
            }
            if (s[i].compareToIgnoreCase(SEC_GRANT) != 0) continue;
            right |= 0x10;
        }
        return right;
    }

    public static void main(String[] args) {
        for (int secLevel = 0; secLevel < 8; ++secLevel) {
            String secLevelString = OdsxSecurityHelper.securityLevelToString(secLevel);
            System.out.println(secLevel + " = " + secLevelString + " -> " + OdsxSecurityHelper.parseSecurityLevel(secLevelString));
        }
        for (int right = 0; right < 32; ++right) {
            String secRightString = OdsxSecurityHelper.securityRightsToString(right);
            System.out.println(right + " = " + secRightString + " -> " + OdsxSecurityHelper.parseSecurityRights(secRightString));
        }
        System.exit(0);
    }
}

