/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkApplication;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDOMHandler;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusConsumer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkServiceProvider;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControlledByInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.fwk.FwkPanelInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxPathInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSelectorInterface;
import com.highqsoft.interfaces.odsx.OdsxSelectorPanelInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionCustomizerInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionMenuInterface;
import com.highqsoft.odsx.OdsxFilter;
import com.highqsoft.odsx.OdsxFilteredTreeNode;
import com.highqsoft.odsx.OdsxPresentableElementProducer;
import com.highqsoft.odsx.OdsxSelectorPanel;
import com.highqsoft.odsx.command.OdsxCloseSessionCommand;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.infobus.DataItem;
import javax.infobus.InfoBusDataConsumer;
import javax.infobus.InfoBusItemAvailableEvent;
import javax.infobus.InfoBusItemRequestedEvent;
import org.asam.ods.AoException;

public class OdsxSelector
extends FwkApplication
implements OdsxSelectorInterface,
FwkPropertyChangeListenerInterface {
    public static final String version = "$Revision: 1.7 $";
    public static final OdsxFilterInterface FILTER = new OdsxFilter();
    public static final DataFlavor[] pathFlavor = FwkContainer.getDataFlavor((Class)OdsxPathInterface.class);
    static int consumerCounter = 0;
    protected static final String FILTER_CLASSNAME = "com.highqsoft.odsx.OdsxFilter";
    protected static final String FILTER_XMLFILE = "com_highqsoft_odsx_OdsxFilter.xml";
    public static final String SYSTEM_ERROR_TITLE = "OdsxSelector.Text.SystemErrorTitle";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected OdsxSessionInterface odsSession;
    protected OdsxFilterInterface odsFilter;
    protected boolean recursive;
    protected OdsxFilteredTreeNode treeRoot;
    protected OdsxPresentableElementProducer producer;
    protected OdsxPathConsumer consumer;
    protected String rootTitleName;
    protected Vector treeMouseListeners;
    protected Vector treeMouseMotionListeners;
    protected String asamPath;
    protected boolean setAsRoot;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)OdsxSelector.class, (FwkDescriptionInterface)descriptor);
    }

    public OdsxSelector() {
        block6: {
            block5: {
                this.odsSession = null;
                this.odsFilter = null;
                this.recursive = true;
                this.treeRoot = null;
                this.producer = null;
                this.consumer = null;
                this.rootTitleName = null;
                this.treeMouseListeners = null;
                this.treeMouseMotionListeners = null;
                this.asamPath = null;
                this.setAsRoot = false;
                this.setDescriptor(descriptor);
                this.producer = new OdsxPresentableElementProducer();
                this.consumer = new OdsxPathConsumer();
                this.register();
                try {
                    String filterXMLFile = FwkPropertyBus.getProperty((String)"OdsxSelector.FilterXMLFile", (String)FILTER_XMLFILE);
                    this.odsFilter = (OdsxFilterInterface)FwkDOMHandler.readFromXML(null, (String)filterXMLFile);
                }
                catch (Throwable t) {
                    if (FwkContainer.getDebugLevel() <= 0) break block5;
                    t.printStackTrace();
                }
            }
            if (this.odsFilter == null) {
                String filterClassName = FwkPropertyBus.getProperty((String)"OdsxSelector.Filter", (String)FILTER_CLASSNAME);
                try {
                    this.odsFilter = (OdsxFilterInterface)FwkContainer.instantiate((String)filterClassName, (String)SYSTEM_ERROR_TITLE);
                }
                catch (Throwable t) {
                    if (FwkContainer.getDebugLevel() <= 0) break block6;
                    t.printStackTrace();
                }
            }
        }
    }

    public void run() {
    }

    public void add(OdsxPresentableElementInterface elem) {
        this.producer.add(elem);
    }

    public void addMimeType(String type) {
    }

    public void addMouseListener(MouseListener listener) {
        if (this.panel != null) {
            ((OdsxSelectorPanelInterface)this.panel).addTreeMouseListener(listener);
        } else {
            if (this.treeMouseListeners == null) {
                this.treeMouseListeners = new Vector();
            }
            this.treeMouseListeners.add(listener);
        }
    }

    public void addMouseMotionListener(MouseMotionListener listener) {
        if (this.panel != null) {
            ((OdsxSelectorPanelInterface)this.panel).addTreeMouseMotionListener(listener);
        } else {
            if (this.treeMouseMotionListeners == null) {
                this.treeMouseMotionListeners = new Vector();
            }
            this.treeMouseMotionListeners.add(listener);
        }
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        this.producer.dataItemRequested(ev);
    }

    public boolean exit() {
        boolean ret = super.exit();
        if (ret) {
            this.producer.removeAll();
            this.consumer.unregister();
            this.producer.unregister();
            if (this.odsSession != null) {
                this.odsSession.close();
                this.odsSession = null;
            }
        }
        return ret;
    }

    public Object findDataItem(String dataItemName) {
        Object ret = this.producer.findDataItem(dataItemName);
        return ret;
    }

    public Object findDataItem(String dataItemName, DataFlavor[] flavors) {
        return this.producer.findDataItem(dataItemName, flavors);
    }

    public Object[] findMultipleDataItems(String dataItemName) {
        return this.producer.findMultipleDataItems(dataItemName);
    }

    public Object[] findMultipleDataItems(String dataItemName, DataFlavor[] flavors) {
        return this.producer.findMultipleDataItems(dataItemName, flavors);
    }

    public void fireItemAvailable(DataItem item, DataFlavor[] flavor) {
    }

    public void fireItemRevoked(DataItem item) {
    }

    public FwkCommandInterface[] getCommands() {
        FwkCommandInterface[] ret;
        Object[] menu;
        Vector<Object> vec = new Vector<Object>();
        FwkCommandInterface tmp = null;
        if (this.panel != null && (tmp = ((OdsxSelectorPanelInterface)this.panel).getCommandObject()) != null) {
            vec.add(tmp);
            FwkCommand sep = new FwkCommand();
            sep.setSeparator(true);
            vec.add(sep);
        }
        if ((menu = FwkServiceProvider.getInstance().lookup(OdsxSessionMenuInterface.class)) != null) {
            int size = menu.length;
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    OdsxSessionMenuInterface m = (OdsxSessionMenuInterface)menu[i];
                    m.setSession(this.getSession());
                    FwkCommandInterface[] cmds = m.getCommands();
                    int c = cmds.length;
                    for (int j = 0; j < c; ++j) {
                        vec.add(cmds[j]);
                    }
                }
            }
        } else {
            if (this.odsFilter != null && (ret = this.odsFilter.getCommands()) != null && ret.length != 0) {
                tmp = new FwkCommand();
                tmp.setTextKey("OdsxSelector.Text.Filter");
                tmp.setCommands(ret);
                vec.add(tmp);
                FwkCommand sep = new FwkCommand();
                sep.setSeparator(true);
                vec.add(sep);
            }
            OdsxCloseSessionCommand closeCmd = new OdsxCloseSessionCommand(this.getController());
            closeCmd.setProperty("Session", this.getSession());
            vec.add((Object)closeCmd);
            Object[] customizer = FwkServiceProvider.getInstance().lookup(OdsxSessionCustomizerInterface.class);
            if (customizer != null && customizer.length > 0) {
                int size = customizer.length;
                for (int i = 0; i < size; ++i) {
                    OdsxSessionCustomizerInterface c = (OdsxSessionCustomizerInterface)customizer[i];
                    c.setSession(this.getSession());
                    if (!c.isUseable()) continue;
                    vec.add(c);
                }
            }
        }
        ret = new FwkCommandInterface[vec.size()];
        ret = vec.toArray(ret);
        return ret;
    }

    public DataFlavor getDataFlavor(int index) throws FwkException {
        return this.getDataFlavors()[index];
    }

    public DataFlavor[] getDataFlavors() throws FwkException {
        return this.producer.getDataFlavors();
    }

    public OdsxFilterInterface getFilter() {
        return this.odsFilter;
    }

    public String[] getMimeTypes() {
        return this.producer.getMimeTypes();
    }

    public FwkPanelInterface getPanel() {
        if (this.panel == null) {
            int i;
            OdsxSelectorPanel selectorPanel = new OdsxSelectorPanel(this);
            selectorPanel.setController(this.getController());
            this.setPanel(selectorPanel);
            if (this.odsSession != null) {
                if (this.odsFilter != null) {
                    this.setFilter(this.odsFilter, true);
                }
                ((OdsxSelectorPanelInterface)this.panel).setSession(this.odsSession, this);
            } else {
                this.setFilter(this.odsFilter, true);
            }
            if (this.rootTitleName != null) {
                this.setRootTitleName(this.rootTitleName);
            }
            if (this.treeMouseListeners != null) {
                for (i = 0; i < this.treeMouseListeners.size(); ++i) {
                    this.addMouseListener((MouseListener)this.treeMouseListeners.elementAt(i));
                }
                this.treeMouseListeners = null;
            }
            if (this.treeMouseMotionListeners != null) {
                for (i = 0; i < this.treeMouseMotionListeners.size(); ++i) {
                    this.addMouseMotionListener((MouseMotionListener)this.treeMouseMotionListeners.elementAt(i));
                }
                this.treeMouseMotionListeners = null;
            }
            if (this.asamPath != null) {
                try {
                    this.setSelectedAsamPath(this.asamPath, this.setAsRoot, true);
                }
                catch (AoException aoException) {
                    // empty catch block
                }
            }
        }
        return this.panel;
    }

    public String getRootTitleName() {
        if (this.panel != null) {
            this.rootTitleName = ((OdsxSelectorPanelInterface)this.panel).getRootTitleName();
        }
        return this.rootTitleName;
    }

    public OdsxSessionInterface getSession() {
        return this.odsSession;
    }

    public void propertyChange(PropertyChangeEvent ev) {
        this.producer.propertyChange(ev);
    }

    public void remove(OdsxPresentableElementInterface elem) {
        this.remove(elem.getName());
    }

    public void remove(String ident) {
        this.producer.remove(ident);
    }

    public void removeAll() {
        RemoveAllThread thread = new RemoveAllThread();
        thread.start();
    }

    public void removeMimeType(String type) {
        this.producer.removeMimeType(type);
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        return this.producer.revoke(itemName, flavor);
    }

    public void setController(FwkControllerInterface controller) {
        super.setController(controller);
        this.producer.setController(controller);
        this.consumer.setController(controller);
    }

    public void setFilter(OdsxFilterInterface odsFilter, boolean recursive) {
        OdsxFilterInterface oldFilter = this.odsFilter;
        this.fireVetoableChange("Filter", oldFilter, odsFilter);
        this.odsFilter = odsFilter;
        this.recursive = recursive;
        if (this.panel != null) {
            ((OdsxSelectorPanelInterface)this.panel).setFilter(odsFilter, recursive);
        }
        this.firePropertyChange("Filter", oldFilter, odsFilter);
    }

    public void setPanel(FwkPanelInterface panel) {
        FwkControllerInterface controller = panel.getController();
        super.setPanel(panel);
        this.setIconKey(panel.getIconKey());
        ((OdsxSelectorPanelInterface)panel).setSelector(this);
        this.setController(controller);
    }

    public void setRootTitleName(String rootTitleName) {
        this.rootTitleName = rootTitleName;
        if (this.panel != null) {
            ((OdsxSelectorPanelInterface)this.panel).setRootTitleName(rootTitleName);
        }
    }

    public void fireExecuteStateEvent(FwkExecuteStateEventInterface event) {
        FwkControllerInterface controller = this.getController();
        if (controller != null && !controller.equals(this) && controller instanceof FwkApplicationInterface) {
            ((FwkApplicationInterface)controller).fireExecuteStateEvent(event);
        }
        super.fireExecuteStateEvent(event);
    }

    public void setSelectedAsamPath(String asamPath) throws AoException {
        this.setSelectedAsamPath(asamPath, false, true);
    }

    public void setSelectedAsamPath(String asamPath, boolean setAsRoot, boolean open) throws AoException {
        if (this.panel != null) {
            ((OdsxSelectorPanelInterface)this.panel).setSelectedAsamPath(asamPath, setAsRoot, open);
        } else {
            this.asamPath = asamPath;
            this.setAsRoot = setAsRoot;
        }
    }

    public void setSession(OdsxSessionInterface odsSession) {
        this.odsSession = odsSession;
        if (this.panel != null) {
            ((OdsxSelectorPanelInterface)this.panel).setSession(odsSession, this);
        }
        try {
            this.setName(FwkContainer.getUniqueName((String)(this.getName() + " " + odsSession.getName())));
        }
        catch (Throwable t) {
            this.setName(FwkContainer.getUniqueName((String)(this.getName() + " NoName")));
        }
    }

    public static void main(String[] args) {
        FwkContainer.initialize((String[])args);
        FwkContainer.openFrame((String)descriptor.getName());
    }

    static {
        descriptor.setAuthor("Hans-Joachim Bothe");
        descriptor.setBuild(version);
        descriptor.setDescription("ODS Selector");
        descriptor.setTitleName("OdsxSelector.Text.Title");
        descriptor.setName(OdsxSelector.class.getName());
        descriptor.setCreationDate("$Date: 2006/06/02 08:22:05 $", null);
        descriptor.setIconKey("Icon.AoService");
    }

    public class RemoveAllThread
    extends FwkThread {
        public void run() {
            try {
                OdsxSelector.this.producer.removeAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class RemoveThread
    extends FwkThread {
        String ident;

        public RemoveThread(String ident) {
            this.ident = ident;
        }

        public void run() {
            try {
                OdsxSelector.this.producer.remove(this.ident);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class AddThread
    extends FwkThread {
        OdsxPresentableElementInterface elem;

        public AddThread(OdsxPresentableElementInterface elem) {
            this.elem = elem;
        }

        public void run() {
            try {
                OdsxSelector.this.producer.add(this.elem);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class OdsxPathConsumer
    extends FwkInfoBusConsumer
    implements FwkControlledByInterface {
        protected FwkControllerInterface controller;

        public OdsxPathConsumer() {
            super("OdsxPathConsumer[" + consumerCounter++ + "]@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeTypes((Class)(class$com$highqsoft$interfaces$odsx$OdsxPathInterface == null ? (class$com$highqsoft$interfaces$odsx$OdsxPathInterface = OdsxSelector.class$("com.highqsoft.interfaces.odsx.OdsxPathInterface")) : class$com$highqsoft$interfaces$odsx$OdsxPathInterface)));
        }

        public FwkControllerInterface getController() {
            return this.controller;
        }

        public void setController(FwkControllerInterface controller) {
            if (this.controller == null || !this.controller.equals(controller)) {
                this.unregister();
                this.controller = controller;
                this.register();
            }
        }

        public void dataItemAvailable(InfoBusItemAvailableEvent ev) {
            OdsxPathInterface path;
            DataFlavor[] arr = ev.getDataFlavors();
            if (this.isAssignable(arr) && (path = (OdsxPathInterface)ev.requestDataItem((InfoBusDataConsumer)this, FwkContainer.getDataFlavor((Class)(class$com$highqsoft$interfaces$odsx$OdsxPathInterface == null ? (class$com$highqsoft$interfaces$odsx$OdsxPathInterface = OdsxSelector.class$("com.highqsoft.interfaces.odsx.OdsxPathInterface")) : class$com$highqsoft$interfaces$odsx$OdsxPathInterface)))) != null && OdsxSelector.this.odsSession.isTheSame(path.getSession())) {
                try {
                    OdsxSelector.this.setSelectedAsamPath(path.getPath());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }
}

