/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkDragAndDrop;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkPanel;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkServiceProvider;
import com.highqsoft.fwk.FwkStringTransfer;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.listener.FwkPopupMenuUnregisterListener;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyChangeListenerInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxChangeEventInterface;
import com.highqsoft.interfaces.odsx.OdsxChangeListenerInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSelectorInterface;
import com.highqsoft.interfaces.odsx.OdsxSelectorMultiItemMenuInterface;
import com.highqsoft.interfaces.odsx.OdsxSelectorPanelInterface;
import com.highqsoft.interfaces.odsx.OdsxSelectorTreeNodeInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.OdsxApplicationElement;
import com.highqsoft.odsx.OdsxChangeEvent;
import com.highqsoft.odsx.OdsxFilteredTreeNode;
import com.highqsoft.odsx.OdsxInstanceElement;
import com.highqsoft.odsx.OdsxPresentableElement;
import com.highqsoft.odsx.OdsxSelectorTreeCellRenderer;
import com.highqsoft.odsx.OdsxSessionElement;
import com.highqsoft.odsx.command.OdsxDeleteInstanceCommand;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import com.highqsoft.odsx.listener.OdsxSelectorTreeSelectionListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.InstanceElement;

public class OdsxSelectorPanel
extends FwkPanel
implements OdsxChangeListenerInterface,
OdsxSelectorPanelInterface,
FwkPropertyChangeListenerInterface {
    protected final int DELETE_PROP = 1;
    protected final int TRANSLATEDNAME_PROP = 2;
    protected final int BASEELEMENTMAP_PROP = 3;
    protected final int ENABLED_PROP = 4;
    protected final int FILTER_PROP = 5;
    protected final int ENABLEINSTANCEELEMENT_PROP = 6;
    protected final int ENABLEAPPLICATIONELEMENT_PROP = 7;
    public static final String version = "$Revision: 1.17 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected OdsxSessionInterface odsSession = null;
    protected OdsxFilterInterface odsFilter = null;
    protected OdsxFilteredTreeNode treeRoot = null;
    protected DefaultTreeModel treeModel;
    protected HashMap openNodes;
    protected static HashMap propNames;
    protected Vector selectedPath;
    protected String rootTitleName = "OdsxSelector.Text.RootTitle";
    protected JScrollPane scrollPane;
    protected JTree tree;
    protected OdsxSelectorInterface odsSelector;
    protected DNDSupport dnd;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    private OdsxSelectorPanel() {
        this.setDescriptor(descriptor);
        this.tree = new JTree();
        this.openNodes = new HashMap();
        this.selectedPath = new Vector();
        ExpandListener el = new ExpandListener();
        this.tree.addTreeExpansionListener(el);
        this.tree.addTreeWillExpandListener(el);
        this.tree.addTreeSelectionListener(el);
        this.tree.addMouseListener(new TreeMouseListener());
        this.dnd = new DNDSupport();
        this.dnd.setInfoBusName(FwkDataBus.BUSNAME);
    }

    public OdsxSelectorPanel(OdsxSelectorInterface selector) {
        this();
        this.odsSelector = selector;
    }

    public void setSelector(OdsxSelectorInterface odsSelector) {
        this.odsSelector = odsSelector;
    }

    public OdsxSelectorInterface getSelector() {
        return this.odsSelector;
    }

    public void setRootTitleName(String rootTitleName) {
        if (this.treeRoot != null) {
            this.treeRoot.setName(FwkPropertyBus.getProperty((String)rootTitleName));
        }
        this.setTitleName(rootTitleName);
    }

    public String getRootTitleName() {
        return this.getTitleName();
    }

    public OdsxFilteredTreeNode getTreeRoot() {
        return this.treeRoot;
    }

    public JTree getTree() {
        return this.tree;
    }

    public OdsxFilterInterface getFilter() {
        return this.odsFilter;
    }

    public OdsxSessionInterface getSession() {
        return this.odsSession;
    }

    public void setFilter(OdsxFilterInterface odsFilter, boolean recursive) {
        if (this.odsFilter != null) {
            this.odsFilter.removePropertyChangeListener(this);
        }
        if (odsFilter != null) {
            odsFilter.addPropertyChangeListener(this);
        }
        this.odsFilter = odsFilter;
        if (recursive && this.treeRoot != null) {
            this.treeRoot.setFilter(odsFilter, recursive);
        }
    }

    public void setSession(OdsxSessionInterface odsSession, OdsxSelectorInterface odsSelector) {
        if (this.odsSession != null) {
            OdsxSessionFactory.removeOdsxChangeListener(this.odsSession.getSession(), this);
        }
        this.odsSession = odsSession;
        if (odsSession != null) {
            OdsxSessionFactory.addOdsxChangeListener(this.odsSession.getSession(), this);
            OdsxFilterInterface filter = this.getFilter();
            OdsxSessionElement elem = new OdsxSessionElement(odsSession.getSession());
            elem.setOdsxFilter(filter);
            elem.setName(odsSession.getName());
            this.treeRoot = new OdsxFilteredTreeNode(elem, filter, odsSelector);
            this.treeRoot.addPropertyChangeListener(this);
            this.treeModel = new DefaultTreeModel(this.treeRoot);
            this.tree.setModel(this.treeModel);
            this.tree.setCellRenderer(new OdsxSelectorTreeCellRenderer());
            this.tree.addTreeSelectionListener(new OdsxSelectorTreeSelectionListener(odsSelector));
            this.tree.setBackground(this.getBackground());
            this.tree.setRootVisible(true);
            this.scrollPane = new JScrollPane(this.tree);
            this.add(this.scrollPane);
        } else {
            FwkContainer.showErrorMessage((Container)((Object)this), (String)"No Session", null, (String)null);
        }
    }

    public void setSelectedAsamPath(String asamPath) throws AoException {
        this.setSelectedAsamPath(asamPath, false, true);
    }

    public void setSelectedAsamPath(String asamPath, boolean setAsRoot, boolean open) throws AoException {
        InstanceElement ieObj;
        ApplicationElement aeObj;
        ApplicationStructure asObj;
        if (asamPath == null || asamPath.trim().length() == 0) {
            return;
        }
        FwkContainer.debug((int)1, (String)("<" + asamPath + ">"));
        String applSep = "]/[";
        boolean isApplElem = asamPath.indexOf(applSep) != -1;
        Vector<OdsxPresentableElement> elems = new Vector<OdsxPresentableElement>();
        boolean stop = false;
        String path = asamPath;
        if (isApplElem) {
            String applElemName = asamPath;
            try {
                asObj = this.odsSession.getSession().getApplicationStructure();
                int sIndex = 1;
                int eIndex = path.indexOf(applSep, sIndex);
                if (eIndex != -1) {
                    sIndex = eIndex + applSep.length();
                    eIndex = path.indexOf(applSep, sIndex);
                    while (eIndex != -1) {
                        applElemName = path.substring(sIndex, eIndex);
                        aeObj = asObj.getElementByName(applElemName);
                        elems.add(new OdsxApplicationElement(aeObj));
                        sIndex = eIndex + applSep.length();
                        eIndex = path.indexOf(applSep, sIndex);
                    }
                    applElemName = path.substring(sIndex, path.length() - 1);
                    aeObj = asObj.getElementByName(applElemName);
                    elems.add(new OdsxApplicationElement(aeObj));
                }
            }
            catch (Throwable tApplName) {
                System.err.println("Element not found <" + applElemName + ">.");
                tApplName.printStackTrace();
                FwkContainer.showErrorMessage((Container)((Object)this), null, (String)FwkPropertyBus.getProperty((String)"Error.Text.ElementNotFound"), (String)applElemName);
            }
        } else {
            stop = path.trim().length() == 0;
            try {
                asObj = this.odsSession.getSession().getApplicationStructure();
            }
            catch (Throwable asT) {
                asObj = null;
            }
            while (!stop) {
                try {
                    ieObj = asObj.getInstanceByAsamPath(path);
                    elems.add(0, new OdsxInstanceElement(ieObj));
                    int index = path.lastIndexOf(47);
                    while (index > 0 && path.charAt(index - 1) == '\\') {
                        index = path.lastIndexOf(47, index - 1);
                    }
                    path = path.substring(0, index);
                    index = path.lastIndexOf(47);
                    stop = path.trim().length() == 0;
                }
                catch (Throwable t) {
                    stop = true;
                    if (path.indexOf(47) == path.lastIndexOf(47)) continue;
                    t.printStackTrace();
                    FwkContainer.showErrorMessage((Container)((Object)this), null, (String)FwkPropertyBus.getProperty((String)"Error.Text.ElementNotFound"), (String)path);
                }
            }
        }
        if (elems.size() != 0 && !setAsRoot) {
            stop = false;
            while (!isApplElem && !stop && elems.size() != 0) {
                ieObj = ((OdsxInstanceElement)elems.get(0)).getInstanceElement();
                try {
                    aeObj = ieObj.getApplicationElement();
                    String type = aeObj.getBaseElement().getType();
                    if (elems.size() == 1 || !type.toLowerCase().equals("aoenvironment")) {
                        elems.add(0, new OdsxApplicationElement(aeObj));
                        stop = true;
                        continue;
                    }
                    elems.remove(0);
                }
                catch (Throwable t) {
                    elems.remove(0);
                }
            }
            int size = elems.size();
            if (size != 0) {
                int firstRow = -1;
                int lastRow = -1;
                int elemCount = 0;
                OdsxFilteredTreeNode toFind = new OdsxFilteredTreeNode((OdsxPresentableElementInterface)elems.get(elemCount));
                int count = 0;
                int tot = this.tree.getRowCount();
                while (elemCount < size && count < tot) {
                    TreePath treePath;
                    OdsxFilteredTreeNode treeNode;
                    if ((treeNode = (OdsxFilteredTreeNode)(treePath = this.tree.getPathForRow(count++)).getLastPathComponent()).compareTo(toFind) != 0) continue;
                    if (firstRow == -1) {
                        firstRow = count - 1;
                    }
                    lastRow = count - 1;
                    if (open || elemCount + 1 < size) {
                        this.tree.expandRow(count - 1);
                    }
                    tot = this.tree.getRowCount();
                    if (++elemCount >= size) continue;
                    toFind = new OdsxFilteredTreeNode((OdsxPresentableElementInterface)elems.get(elemCount));
                }
                if (firstRow != -1) {
                    Rectangle rect = this.tree.getRowBounds(firstRow);
                    JScrollBar scrollBar = this.scrollPane.getVerticalScrollBar();
                    scrollBar.setValue(rect.y);
                    this.tree.setSelectionRow(lastRow);
                    this.tree.scrollRowToVisible(lastRow);
                }
            }
        }
        if (setAsRoot) {
            this.treeRoot = new OdsxFilteredTreeNode((OdsxPresentableElementInterface)elems.get(0), this.odsFilter, this.odsSelector);
            this.treeRoot.addPropertyChangeListener(this);
            this.treeModel = new DefaultTreeModel(this.treeRoot);
            this.tree.setModel(this.treeModel);
        }
    }

    public OdsxSelectorTreeNodeInterface getNodeByAsamPath(String asamPath) throws AoException {
        InstanceElement ieObj;
        ApplicationElement aeObj;
        ApplicationStructure asObj;
        OdsxFilteredTreeNode toFind = null;
        if (asamPath == null || asamPath.trim().length() == 0) {
            return toFind;
        }
        FwkContainer.debug((int)1, (String)("<" + asamPath + ">"));
        String applSep = "]/[";
        boolean isApplElem = asamPath.indexOf(applSep) != -1;
        Vector<OdsxPresentableElement> elems = new Vector<OdsxPresentableElement>();
        boolean stop = false;
        String path = asamPath;
        if (isApplElem) {
            String applElemName = asamPath;
            try {
                asObj = this.odsSession.getSession().getApplicationStructure();
                int sIndex = 1;
                int eIndex = path.indexOf(applSep, sIndex);
                if (eIndex != -1) {
                    sIndex = eIndex + applSep.length();
                    eIndex = path.indexOf(applSep, sIndex);
                    while (eIndex != -1) {
                        applElemName = path.substring(sIndex, eIndex);
                        aeObj = asObj.getElementByName(applElemName);
                        elems.add(new OdsxApplicationElement(aeObj));
                        sIndex = eIndex + applSep.length();
                        eIndex = path.indexOf(applSep, sIndex);
                    }
                    applElemName = path.substring(sIndex, path.length() - 1);
                    aeObj = asObj.getElementByName(applElemName);
                    elems.add(new OdsxApplicationElement(aeObj));
                }
            }
            catch (Throwable tApplName) {
                tApplName.printStackTrace();
                FwkContainer.showErrorMessage((Container)((Object)this), null, (String)FwkPropertyBus.getProperty((String)"Error.Text.ElementNotFound"), (String)applElemName);
            }
        } else {
            boolean bl = stop = path.trim().length() == 0;
            while (!stop) {
                try {
                    asObj = this.odsSession.getSession().getApplicationStructure();
                    ieObj = asObj.getInstanceByAsamPath(path);
                    elems.add(0, new OdsxInstanceElement(ieObj));
                    int index = path.lastIndexOf(47);
                    path = path.substring(0, index);
                    stop = path.trim().length() == 0;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    stop = true;
                    FwkContainer.showErrorMessage((Container)((Object)this), null, (String)FwkPropertyBus.getProperty((String)"Error.Text.ElementNotFound"), (String)path);
                }
            }
        }
        if (elems.size() != 0) {
            stop = false;
            while (!isApplElem && !stop && elems.size() != 0) {
                ieObj = ((OdsxInstanceElement)elems.get(0)).getInstanceElement();
                try {
                    aeObj = ieObj.getApplicationElement();
                    elems.add(0, new OdsxApplicationElement(aeObj));
                    stop = true;
                }
                catch (Throwable t) {
                    elems.remove(0);
                }
            }
            int size = elems.size();
            if (size != 0) {
                int firstRow = -1;
                int elemCount = 0;
                toFind = new OdsxFilteredTreeNode((OdsxPresentableElementInterface)elems.get(elemCount));
                int count = 0;
                int tot = this.tree.getRowCount();
                while (elemCount < size && count < tot) {
                    TreePath treePath;
                    OdsxFilteredTreeNode treeNode;
                    if ((treeNode = (OdsxFilteredTreeNode)(treePath = this.tree.getPathForRow(count++)).getLastPathComponent()).compareTo(toFind) != 0) continue;
                    if (firstRow == -1) {
                        firstRow = count - 1;
                    }
                    this.tree.expandRow(count - 1);
                    tot = this.tree.getRowCount();
                    if (++elemCount >= size) continue;
                    toFind = treeNode;
                }
            }
        }
        return toFind;
    }

    public void addTreeMouseListener(MouseListener listener) {
        this.tree.addMouseListener(listener);
    }

    public void addTreeMouseMotionListener(MouseMotionListener listener) {
        this.tree.addMouseMotionListener(listener);
    }

    public synchronized void propertyChange(PropertyChangeEvent ev) {
        String propName;
        Integer i;
        if (propNames == null) {
            propNames = new HashMap();
            propNames.put("Enabled", new Integer(4));
            propNames.put("Filter", new Integer(5));
            propNames.put("Delete", new Integer(1));
            propNames.put("TranslatedName", new Integer(2));
            propNames.put("BaseElementMap", new Integer(3));
            propNames.put("EnableInstanceElement", new Integer(6));
            propNames.put("EnableApplicationElement", new Integer(7));
        }
        if ((i = (Integer)propNames.get(propName = ev.getPropertyName())) != null) {
            switch (i) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    this.treeRoot.reloadChildren(true);
                    this.treeModel.reload();
                    Iterator it = this.openNodes.keySet().iterator();
                    while (it.hasNext()) {
                        this.tree.expandPath((TreePath)it.next());
                    }
                    TreePath[] arr = new TreePath[this.selectedPath.size()];
                    this.tree.setSelectionPaths(this.selectedPath.toArray(arr));
                    break;
                }
            }
        }
    }

    public void updateTree() {
        JScrollBar horScrollBar = this.scrollPane.getHorizontalScrollBar();
        JScrollBar verScrollBar = this.scrollPane.getVerticalScrollBar();
        int horPos = horScrollBar.getValue();
        int verPos = verScrollBar.getValue();
        Enumeration<TreePath> e = this.tree.getExpandedDescendants(new TreePath(this.treeRoot));
        Object[] arr = this.odsSelector.findMultipleDataItems("*", FwkContainer.getDataFlavor((Class)OdsxPresentableElementInterface.class));
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                this.odsSelector.remove((OdsxPresentableElementInterface)arr[i]);
            }
        }
        this.treeRoot.reloadChildren();
        this.treeModel.reload(this.treeRoot);
        TreePath path = null;
        OdsxFilteredTreeNode node = null;
        Vector<TreePath> vec = new Vector<TreePath>();
        while (e.hasMoreElements()) {
            path = e.nextElement();
            node = (OdsxFilteredTreeNode)path.getLastPathComponent();
            node.reloadChildren();
            vec.add(path);
        }
        int size = vec.size();
        if (size > 0) {
            TreePath[] pArr = vec.toArray(new TreePath[vec.size()]);
            Arrays.sort(pArr, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((TreePath)o1).getPathCount() - ((TreePath)o1).getPathCount();
                }

                public boolean equals(Object obj) {
                    return this.equals(obj);
                }
            });
            for (int i = 0; i < size; ++i) {
                this.tree.expandPath(pArr[i]);
            }
        }
        horScrollBar.setValue(horPos);
        verScrollBar.setValue(verPos);
    }

    public FwkCommandInterface[] getCommands() {
        TreePath[] arr = this.tree.getSelectionPaths();
        boolean instancesSelected = false;
        if (arr != null) {
            for (int i = 0; !instancesSelected && i < arr.length; ++i) {
                OdsxSelectorTreeNodeInterface treeNode = (OdsxSelectorTreeNodeInterface)arr[i].getLastPathComponent();
                OdsxPresentableElementInterface presentable = treeNode.getPresentableElement();
                instancesSelected = presentable instanceof OdsxInstanceElementInterface;
            }
        }
        if (instancesSelected) {
            Object[] menu = FwkServiceProvider.getInstance().lookup(OdsxSelectorMultiItemMenuInterface.class);
            if (menu != null) {
                int i;
                int size = menu.length;
                super.getCommands();
                if (size > 0 && (i = 0) < size) {
                    OdsxSelectorMultiItemMenuInterface m = (OdsxSelectorMultiItemMenuInterface)menu[i];
                    m.setSelector(this.odsSelector);
                    FwkCommandInterface[] cmds = m.getCommands();
                    Vector<FwkCommandInterface> vec = new Vector<FwkCommandInterface>();
                    if (cmds != null && cmds.length > 0) {
                        int c = cmds.length;
                        for (int j = 0; j < c; ++j) {
                            vec.add(cmds[j]);
                        }
                    }
                    return vec.toArray(new FwkCommandInterface[vec.size()]);
                }
            } else if (!this.commandsAvailable()) {
                super.getCommands();
                DeleteMultiInstanceCommand cmd = new DeleteMultiInstanceCommand();
                this.addCommand((FwkCommandInterface)cmd);
            }
            return super.getCommands();
        }
        return new FwkCommandInterface[0];
    }

    public void odsChanged(OdsxChangeEventInterface ev) {
        if (ev.getModifier().equals(OdsxChangeEvent.AEInstanceRemoved) || ev.getModifier().equals(OdsxChangeEvent.AEInstanceCreated)) {
            try {
                int tot = this.tree.getRowCount();
                OdsxFilteredTreeNode treeNode = null;
                int count = 0;
                boolean found = false;
                while (!found && count < tot) {
                    TreePath treePath = this.tree.getPathForRow(count++);
                    treeNode = (OdsxFilteredTreeNode)treePath.getLastPathComponent();
                    try {
                        boolean equal = false;
                        Object source = ev.getSource();
                        OdsxPresentableElementInterface elem = treeNode.getPresentableElement();
                        if (source instanceof ApplicationElement && elem instanceof OdsxApplicationElementInterface) {
                            equal = ((OdsxApplicationElementInterface)elem).isTheSame((ApplicationElement)source);
                        } else if (source instanceof InstanceElement && elem instanceof OdsxInstanceElementInterface) {
                            equal = ((OdsxInstanceElementInterface)elem).isTheSame((InstanceElement)source);
                        } else if (source instanceof AoSession && elem instanceof OdsxSessionElementInterface) {
                            equal = ((OdsxSessionElementInterface)elem).isTheSame((AoSession)source);
                        }
                        if (!equal) continue;
                        if (treeNode.isLoaded()) {
                            treeNode.reloadChildren();
                            this.treeModel.reload(treeNode);
                            this.tree.repaint();
                        }
                        found = true;
                    }
                    catch (Throwable t) {}
                }
            }
            catch (Throwable t) {}
        } else if (ev.getModifier().equals(OdsxChangeEvent.IEChildAdded) || ev.getModifier().equals(OdsxChangeEvent.IEChildRemoved)) {
            try {
                int tot = this.tree.getRowCount();
                OdsxFilteredTreeNode treeNode = null;
                int count = 0;
                boolean found = false;
                while (!found && count < tot) {
                    TreePath treePath;
                    int pathCount;
                    if ((pathCount = (treePath = this.tree.getPathForRow(count++)).getPathCount()) < 2) continue;
                    treeNode = (OdsxFilteredTreeNode)treePath.getPathComponent(pathCount - 2);
                    try {
                        boolean equal = false;
                        Object source = ev.getSource();
                        OdsxPresentableElementInterface elem = treeNode.getPresentableElement();
                        if (source instanceof ApplicationElement && elem instanceof OdsxApplicationElementInterface) {
                            equal = ((OdsxApplicationElementInterface)elem).isTheSame((ApplicationElement)source);
                        } else if (source instanceof InstanceElement && elem instanceof OdsxInstanceElementInterface) {
                            equal = ((OdsxInstanceElementInterface)elem).isTheSame((InstanceElement)source);
                        } else if (source instanceof AoSession && elem instanceof OdsxSessionElementInterface) {
                            equal = ((OdsxSessionElementInterface)elem).isTheSame((AoSession)source);
                        }
                        if (!equal) continue;
                        if (treeNode.isLoaded()) {
                            treeNode.reloadChildren();
                            this.treeModel.reload(treeNode);
                            this.tree.repaint();
                        }
                        found = true;
                    }
                    catch (Throwable t) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public FwkCommandInterface getCommandObject() {
        return new UpdateTreeCommand();
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("ODS Selector Panel");
        descriptor.setTitleName("OdsxSelectorPanel.Text.Title");
        descriptor.setName(OdsxSelectorPanel.class.getName());
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:10 $", null);
        propNames = null;
    }

    protected class UpdateTreeCommand
    extends FwkCommand {
        public UpdateTreeCommand() {
            this.setTextKey("OdsxSeletorPanel.Text.UpdateTree");
            this.setCommandName("Update");
            this.setIconKey("Icon.Update");
        }

        public boolean execute(EventObject ev) {
            OdsxSelectorPanel.this.setCursor(new Cursor(3));
            OdsxSelectorPanel.this.updateTree();
            OdsxSelectorPanel.this.setCursor(Cursor.getDefaultCursor());
            return true;
        }
    }

    protected class DeleteMultiInstanceCommand
    extends FwkCommand {
        public DeleteMultiInstanceCommand() {
            this.setTextKey("OdsxDeleteInstanceCommand.Text.DeleteInstances");
            this.setCommandName("Delete");
            this.setIconKey("Icon.delete");
        }

        public boolean execute(EventObject ev) {
            Vector<OdsxPresentableElementInterface> vec = new Vector<OdsxPresentableElementInterface>();
            TreePath[] arr = OdsxSelectorPanel.this.tree.getSelectionPaths();
            boolean instancesSelected = false;
            for (int i = 0; !instancesSelected && i < arr.length; ++i) {
                OdsxSelectorTreeNodeInterface treeNode = (OdsxSelectorTreeNodeInterface)arr[i].getLastPathComponent();
                OdsxPresentableElementInterface presentable = treeNode.getPresentableElement();
                if (!(presentable instanceof OdsxInstanceElementInterface)) continue;
                vec.add(presentable);
            }
            int size = vec.size();
            if (size > 0) {
                return OdsxDeleteInstanceCommand.deleteInstances(FwkGUIFactory.getDialogParent((EventObject)ev), vec.toArray(new OdsxInstanceElementInterface[size]));
            }
            return true;
        }
    }

    class DNDSupport
    extends FwkDragAndDrop {
        int row;

        public DNDSupport() {
            super((Component)OdsxSelectorPanel.this.tree);
            this.row = -1;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public Transferable getTransferData() {
            TreePath path;
            FwkStringTransfer ret = null;
            if (this.row > 0 && (path = OdsxSelectorPanel.this.tree.getPathForRow(this.row)) != null) {
                OdsxSelectorTreeNodeInterface treeNode = (OdsxSelectorTreeNodeInterface)path.getLastPathComponent();
                ret = new FwkStringTransfer(treeNode.getPresentableElement().getPresentationString());
            }
            return ret;
        }
    }

    public class TreeMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            JPopupMenu popup;
            FwkCommandInterface[] commands;
            JTree tree = (JTree)e.getSource();
            if (tree.getSelectionCount() == 1) {
                int row = tree.getRowForLocation(e.getX(), e.getY());
                if (tree.isRowSelected(row)) {
                    JPopupMenu popup2;
                    FwkCommandInterface[] commands2;
                    if ((e.getModifiers() & 0x10) != 0) {
                        OdsxSelectorPanel.this.dnd.setRow(row);
                    }
                    TreePath path = tree.getPathForRow(row);
                    OdsxSelectorTreeNodeInterface treeNode = (OdsxSelectorTreeNodeInterface)path.getLastPathComponent();
                    if ((e.getModifiers() & 4) != 0 && (commands2 = treeNode.getCommands()) != null && commands2.length != 0 && (popup2 = FwkGUIFactory.createPopupMenu((FwkCommandInterface[])commands2, (boolean)false)) != null) {
                        popup2.addPopupMenuListener((PopupMenuListener)FwkPopupMenuUnregisterListener.getInstance());
                        popup2.show((Component)e.getSource(), e.getX(), e.getY());
                    }
                }
            } else if ((e.getModifiers() & 4) != 0 && (commands = OdsxSelectorPanel.this.getCommands()) != null && commands.length != 0 && (popup = FwkGUIFactory.createPopupMenu((FwkCommandInterface[])commands, (boolean)false)) != null) {
                popup.addPopupMenuListener((PopupMenuListener)FwkPopupMenuUnregisterListener.getInstance());
                popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    public class ExpandListener
    implements TreeExpansionListener,
    TreeWillExpandListener,
    TreeSelectionListener {
        Cursor initial = null;

        public void valueChanged(TreeSelectionEvent event) {
            OdsxSelectorPanel.this.selectedPath.clear();
            TreePath[] arr = event.getPaths();
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                OdsxSelectorPanel.this.selectedPath.add(arr[i]);
            }
        }

        public void treeWillCollapse(TreeExpansionEvent event) {
        }

        public void treeWillExpand(TreeExpansionEvent event) {
            Container top = OdsxSelectorPanel.this.tree.getTopLevelAncestor();
            if (top != null) {
                this.initial = top.getCursor();
                top.setCursor(Cursor.getPredefinedCursor(3));
            }
            FwkControllerInterface controller = OdsxSelectorPanel.this.getController();
            OdsxFilteredTreeNode node = (OdsxFilteredTreeNode)event.getPath().getLastPathComponent();
            if (controller != null && controller instanceof FwkApplicationInterface) {
                ((FwkApplicationInterface)controller).fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, FwkPropertyBus.getProperty((String)"Text.Open") + " " + node.getTranslatedName()));
            }
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            OdsxSelectorPanel.this.openNodes.remove(event.getPath());
        }

        public void treeExpanded(TreeExpansionEvent event) {
            Container top = OdsxSelectorPanel.this.tree.getTopLevelAncestor();
            if (top != null && this.initial != null) {
                top.setCursor(this.initial);
                this.initial = null;
            }
            OdsxSelectorPanel.this.openNodes.put(event.getPath(), event.getPath());
            OdsxSelectorPanel.this.tree.scrollPathToVisible(event.getPath());
            FwkControllerInterface controller = OdsxSelectorPanel.this.getController();
            if (controller != null && controller instanceof FwkApplicationInterface) {
                ((FwkApplicationInterface)controller).fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
            }
        }
    }
}

