/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.odsx.OdsxFilteredTreeNode;
import com.highqsoft.odsx.OdsxRecursiveApplicationElement;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class OdsxSelectorTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    public static final String version = "$Revision: 1.3 $";

    public String getVersion() {
        return version;
    }

    public OdsxSelectorTreeCellRenderer() {
        this.setBackgroundSelectionColor(Color.orange);
        this.setBackgroundNonSelectionColor(this.getBackground());
    }

    public synchronized Component getTreeCellRendererComponent(JTree tree, Object currNode, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        OdsxFilteredTreeNode theNode = (OdsxFilteredTreeNode)currNode;
        String name = theNode.getTranslatedName();
        boolean isRecursive = theNode.getPresentableElement() instanceof OdsxRecursiveApplicationElement;
        if (name != null && name.length() > 0) {
            if (!isRecursive) {
                this.setText(name);
            }
        } else {
            this.setText("???");
        }
        if (isRecursive) {
            theNode.isLeaf = true;
        }
        this.setIcon((Icon)theNode.getIcon());
        this.setForeground(theNode.getColor());
        this.selected = selected;
        return this;
    }

    public void paintBackground(Graphics g) {
        Icon currentIcon = this.getIcon();
        Color bgColor = this.selected ? Color.yellow : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
        g.setColor(bgColor);
        if (currentIcon != null && this.getText() != null) {
            int offset = currentIcon.getIconWidth() + this.getIconTextGap();
            g.fillRect(offset, 0, this.getWidth() - offset, this.getHeight());
        } else {
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void paintComponent(Graphics g) {
        if (this.isVisible()) {
            this.paintBackground(g);
            super.paintComponent(g);
        }
    }
}

