/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkItem;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.dialog.FwkAuthenticationDialogPane;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateListenerInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.ods.AoService;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import com.highqsoft.odsx.factory.UserAbortSelectionException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationStructure;
import org.omg.CORBA.Object;

public class OdsxSession
extends FwkItem
implements OdsxSessionInterface {
    public static final String version = "$Revision: 1.13 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    private String authentication;
    private String serviceOptions = null;
    private String sessionOptions = null;
    private String plumName = null;
    private String serviceName;
    private String sessionName;
    protected Vector listeners;
    protected boolean cancelled = false;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
        this.listeners.clear();
        this.listeners = null;
    }

    public OdsxSession() {
        FwkContainer.addComponentProperties(this.getClass());
        this.setDescriptor(descriptor);
        this.listeners = new Vector();
        this.setSessionOptions("");
        StringBuffer sBuf = new StringBuffer();
        String tmp = FwkPropertyBus.getProperty((String)"Odsx.NewSession.Authentication", (String)null);
        if (tmp != null) {
            sBuf.append(tmp);
        }
        if ((tmp = FwkPropertyBus.getProperty((String)"Odsx.NewSession.Username", (String)null)) != null) {
            if (sBuf.length() > 0) {
                sBuf.append(", USER=").append(tmp);
            } else {
                sBuf.append("USER=").append(tmp);
            }
        }
        if ((tmp = FwkPropertyBus.getProperty((String)"Odsx.NewSession.Password", (String)null)) != null) {
            if (sBuf.length() > 0) {
                sBuf.append(", PASSWORD=").append(tmp);
            } else {
                sBuf.append("PASSWORD=").append(tmp);
            }
        }
        if ((tmp = FwkPropertyBus.getProperty((String)"Odsx.NewSession.OpenMode", (String)"read")) != null) {
            if (sBuf.length() > 0) {
                sBuf.append(", OPENMODE=").append(tmp);
            } else {
                sBuf.append("OPENMODE=").append(tmp);
            }
        }
        this.authentication = OdsxSessionFactory.normalizeOptionString(sBuf.toString());
    }

    public void close() throws FwkException {
        try {
            OdsxSessionFactory.close(this);
            this.listeners.clear();
        }
        catch (Throwable t) {
            throw new FwkException(1073743324, "$RCSfile: OdsxSession.java,v $", version, "AH 2000-10-06 14:28", null, (java.lang.Object)"See previous event", t);
        }
    }

    public boolean isTheSame(AoSession aoSession) {
        boolean ret = false;
        AoSession thisSession = this.getSession();
        ret = thisSession.equals(aoSession);
        if (!ret && thisSession instanceof Object && aoSession instanceof Object) {
            try {
                String thisName = thisSession.getName();
                String elemName = aoSession.getName();
                ret = thisName.compareTo(elemName) == 0;
            }
            catch (Throwable tNoName) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean isTheSame(OdsxPresentableElementInterface elem) {
        boolean ret = elem instanceof OdsxSessionInterface;
        if (ret) {
            ret = this.isTheSame(((OdsxSessionInterface)((java.lang.Object)elem)).getSession());
        }
        return ret;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public String getName() {
        return this.getSessionName();
    }

    public String getOptions() {
        boolean noServiceOptions;
        boolean noSessionOptions = this.sessionOptions == null || this.sessionOptions.length() != 0;
        boolean bl = noServiceOptions = this.serviceOptions == null || this.serviceOptions.length() != 0;
        if (!noSessionOptions && !noServiceOptions) {
            return OdsxSessionFactory.normalizeOptionString(this.serviceOptions + ", " + this.sessionOptions);
        }
        if (!noSessionOptions) {
            return OdsxSessionFactory.normalizeOptionString(this.sessionOptions);
        }
        if (!noServiceOptions) {
            return OdsxSessionFactory.normalizeOptionString(this.serviceOptions);
        }
        return "";
    }

    public String getSessionOptions() {
        if (this.sessionOptions != null) {
            return this.sessionOptions;
        }
        return "";
    }

    public String getServiceOptions() {
        if (this.serviceOptions != null) {
            return this.serviceOptions;
        }
        return "";
    }

    public String getPlumName() {
        return this.plumName != null ? this.plumName : "";
    }

    public String getServiceName() {
        return this.serviceName != null ? this.serviceName : "";
    }

    public boolean isValid() {
        try {
            return this.getSession() != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public boolean hasPermissions() {
        boolean ret = false;
        if (this.isValid()) {
            try {
                ApplicationStructure as = this.getSession().getApplicationStructure();
                ret = as != null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ret;
    }

    public AoService getService() throws FwkException {
        if (this.plumName == null) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxSession.java,v $", version, "AH 2000-10-06 14:12", null, (java.lang.Object)"Set the name of the plugable component first.", null);
        }
        if (this.serviceOptions == null) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxSession.java,v $", version, "AH 2000-10-06 14:13", null, (java.lang.Object)"Set the service options first.", null);
        }
        try {
            return OdsxSessionFactory.getService(this);
        }
        catch (Throwable t) {
            throw new FwkException(1073743324, "$RCSfile: OdsxSession.java,v $", version, "AH 2000-10-06 14:26", null, (java.lang.Object)"See previous event", t);
        }
    }

    public AoSession getSession() throws FwkException {
        if (this.sessionOptions == null) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxSession.java,v $", version, "AH 2000-10-06 14:15", null, (java.lang.Object)"Set the session options first.", null);
        }
        if (this.authentication == null) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxSession.java,v $", version, "AH 2000-10-06 14:13", null, (java.lang.Object)"Set the authentication string.", null);
        }
        try {
            if (FwkContainer.getDebugLevel() >= 1) {
                System.out.println(this.toString());
            }
            return OdsxSessionFactory.getSession(this);
        }
        catch (AoException aoe) {
            System.err.println(OdsxHelper.aoExceptionToString(aoe));
            aoe.printStackTrace();
            throw new FwkException(1073743324, "$RCSfile: OdsxSession.java,v $", version, "AH 2000-10-06 14:27", null, (java.lang.Object)"See previous event", (Throwable)aoe);
        }
        catch (UserAbortSelectionException uase) {
            this.cancelled = true;
            throw new FwkException(1073743324, "$RCSfile: OdsxSession.java,v $", version, "AH 2006-02-06 13:33", null, (java.lang.Object)"Use abort selection.", (Throwable)uase);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new FwkException(1073743324, "$RCSfile: OdsxSession.java,v $", version, "AH 2000-10-06 14:27", null, (java.lang.Object)"See previous event", t);
        }
    }

    public AoSession getCheckedSession() throws FwkException {
        if (this.sessionOptions == null) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxSession.java,v $", version, "AH 2006-02-28 14:15", null, (java.lang.Object)"Set the session options first.", null);
        }
        if (this.authentication == null) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxSession.java,v $", version, "AH 2006-02-28 14:13", null, (java.lang.Object)"Set the authentication string.", null);
        }
        try {
            if (FwkContainer.getDebugLevel() >= 1) {
                System.out.println(this.toString());
            }
            return OdsxSessionFactory.getCheckedSession(this);
        }
        catch (AoException aoe) {
            System.err.println(OdsxHelper.aoExceptionToString(aoe));
            aoe.printStackTrace();
            throw new FwkException(1073743324, "$RCSfile: OdsxSession.java,v $", version, "AH 2006-02-28 14:27", null, (java.lang.Object)"See previous event", (Throwable)aoe);
        }
        catch (UserAbortSelectionException uase) {
            this.cancelled = true;
            throw new FwkException(1073743324, "$RCSfile: OdsxSession.java,v $", version, "AH 2006-02-28 13:33", null, (java.lang.Object)"Use abort selection.", (Throwable)uase);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new FwkException(1073743324, "$RCSfile: OdsxSession.java,v $", version, "AH 2006-02-28 14:27", null, (java.lang.Object)"See previous event", t);
        }
    }

    public String getSessionName() {
        if (this.sessionName != null) {
            return this.sessionName;
        }
        return this.serviceName;
    }

    public void setAuthentication(String authentication) {
        if (authentication == null) {
            String username = null;
            String password = null;
            boolean askForPassword = FwkPropertyBus.getProperty((String)"Odsx.NewSession.AskForPassword", (boolean)true);
            boolean batchMode = FwkContainer.isBatchMode();
            if (!batchMode && askForPassword) {
                FwkAuthenticationDialogPane pane = new FwkAuthenticationDialogPane();
                FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, (String)(FwkPropertyBus.getProperty((String)"Odsx.NewSession.AuthenticationDialog.Text.Title") + " " + this.serviceName), (String)"FwkAuthenticationDialog.Icon", (FwkDialogPaneInterface)pane);
                if (val != null) {
                    username = (String)val.getProperty("Username");
                    password = (String)val.getProperty("Password");
                }
            } else {
                username = "";
                password = "";
            }
            if (username != null && password != null) {
                StringBuffer sBuf = new StringBuffer();
                if (username != null && username.length() != 0) {
                    sBuf.append("USER=" + username);
                }
                if (password != null && password.length() != 0) {
                    if (sBuf.length() > 0) {
                        sBuf.append(",PASSWORD=" + password);
                    } else {
                        sBuf.append("PASSWORD=" + password);
                    }
                }
                this.authentication = OdsxSessionFactory.normalizeOptionString(sBuf.toString());
            }
        } else {
            this.authentication = OdsxSessionFactory.normalizeOptionString(authentication);
        }
    }

    public void setSessionOptions(String options) {
        this.sessionOptions = OdsxSessionFactory.normalizeOptionString(options);
    }

    public void setSessionOptions(String options, String authentication) {
        this.sessionOptions = OdsxSessionFactory.normalizeOptionString(options);
        this.setAuthentication(authentication);
    }

    public void setServiceOptions(String options) {
        this.serviceOptions = OdsxSessionFactory.normalizeOptionString(options, false);
    }

    public void setPlumName(String plumName) {
        this.plumName = plumName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String toString() {
        HashMap entries = new HashMap();
        FwkSortedArray arr = OdsxSessionFactory.getOptionMap(this.getAuthentication(), entries, true);
        int size = arr.size();
        StringBuffer buf = new StringBuffer();
        try {
            for (int i = 0; i < size; ++i) {
                String key = arr.get(i).toString();
                if (i > 0) {
                    buf.append(", ").append(key).append("=");
                } else {
                    buf.append(key).append("=");
                }
                if (key.equals("PASSWORD")) {
                    buf.append("********");
                    continue;
                }
                buf.append(entries.get(key));
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return "Name           = " + this.getName() + "\n" + "PlumName       = " + this.getPlumName() + "\n" + "ServiceOption  = " + this.getServiceOptions() + "\n" + "SessionOption  = " + this.getSessionOptions() + "\n" + "Authentication = " + buf.toString();
    }

    public String getValueAsString() {
        return this.toString();
    }

    public java.lang.Object getValueAsObject() {
        return this.getSession();
    }

    public void setValue(java.lang.Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExecuteStateListener(FwkExecuteStateListenerInterface l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecuteStateListener(FwkExecuteStateListenerInterface l) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireExecuteStateEvent(FwkExecuteStateEventInterface event) {
        Vector vector = this.listeners;
        synchronized (vector) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                FwkExecuteStateListenerInterface l = (FwkExecuteStateListenerInterface)this.listeners.get(i);
                l.executeStateChanged(event);
            }
        }
    }

    public String getPresentationString(Locale locale) {
        return this.getClass().getName() + " [Revision: " + FwkContainer.getNiceVersion((String)version) + "]\n" + this.toString();
    }

    public static void main(String[] args) {
        OdsxSession session = new OdsxSession();
        session.setPlumName("com.highqsoft.ods.corba.AoService");
        session.setServiceOptions("NameServicePort=900, NameServiceHost=localhost");
        session.setServiceName("ZEUS/DB");
        session.setAuthentication("USER=zeus, PASSWORD=zeus");
        System.out.println(session);
    }

    static {
        descriptor.setAuthor("Hans-Joachim Bothe");
        descriptor.setBuild(version);
        descriptor.setDescription("An ASAM-ODS Session");
        descriptor.setTitleName("OdsxSession");
        descriptor.setName(OdsxSession.class.getName());
        descriptor.setCreationDate("$Date: 2007/01/12 14:45:46 $", null);
        descriptor.setIconKey("Icon.AoService");
    }
}

