/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkServiceProvider;
import com.highqsoft.fwk.exception.ErrorNumber;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionCustomizerInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionMenuInterface;
import com.highqsoft.odsx.OdsxApplicationElement;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxPresentableElement;
import com.highqsoft.odsx.command.OdsxCheckModelCommand;
import com.highqsoft.odsx.command.OdsxDebugLevelEditorCommand;
import com.highqsoft.odsx.command.OdsxInstanceCreateCommand;
import com.highqsoft.odsx.command.OdsxSetContextCommand;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import com.highqsoft.util.StringFormat;
import java.awt.Container;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Vector;
import javax.infobus.InvalidDataException;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.DataType;
import org.asam.ods.EnumerationDefinition;
import org.asam.ods.NameValue;
import org.asam.ods.NameValueIterator;
import org.asam.ods.TS_Union;
import org.omg.CORBA.Object;

public class OdsxSessionElement
extends OdsxPresentableElement
implements OdsxSessionElementInterface {
    public static final String version = "$Revision: 1.19 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return descriptor;
    }

    protected OdsxSessionElement() {
        this.setDescriptor(descriptor);
    }

    public OdsxSessionElement(AoSession session) {
        this();
        this.setValueAsObject(session);
        String rootTitle = null;
        try {
            rootTitle = session.getName();
        }
        catch (Throwable tName) {
            // empty catch block
        }
        if (rootTitle == null) {
            rootTitle = FwkPropertyBus.getProperty((String)"OdsxSessionElement.Text.Title");
            try {
                NameValue nv = session.getContextByName("ENVNAME");
                rootTitle = nv.value.u.stringVal();
            }
            catch (Throwable tEnvironment) {
                try {
                    NameValue nv = session.getContextByName("FILENAME");
                    rootTitle = nv.value.u.stringVal();
                }
                catch (Throwable tFilename) {
                    rootTitle = this.getTitle();
                }
            }
        }
        this.setName(rootTitle);
    }

    public boolean isValid() {
        boolean ret = false;
        try {
            AoSession session = (AoSession)this.getValueAsObject();
            if (session != null) {
                session.getName();
                ret = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public boolean isTheSame(AoSession aoSession) {
        AoSession thisSession = this.getSession();
        boolean ret = aoSession.equals(thisSession);
        if (!ret && aoSession instanceof Object && thisSession instanceof Object) {
            try {
                String thisName = thisSession.getName();
                String elemName = aoSession.getName();
                ret = thisName.compareTo(elemName) == 0;
            }
            catch (Throwable tNoName) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean isTheSame(OdsxPresentableElementInterface elem) {
        boolean ret = elem instanceof OdsxSessionInterface;
        if (ret) {
            ret = this.isTheSame(((OdsxSessionInterface)((java.lang.Object)elem)).getSession());
        }
        return ret;
    }

    public String getBaseName() {
        return "AoSession";
    }

    public AoSession getSession() {
        return (AoSession)this.getValueAsObject();
    }

    public void setItemByCoordinates(int[] coord, java.lang.Object item) throws FwkException {
        if (!(item instanceof AoSession)) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxSessionElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "Class cast exception", (java.lang.Object)this, (Throwable)new InvalidDataException("Item is not of the type AoSession."));
        }
        super.setItemByCoordinates(coord, item);
    }

    public void setValueAsObject(java.lang.Object item) throws FwkException {
        if (!(item instanceof AoSession)) {
            throw new FwkException(-1073676289, "$RCSfile: OdsxSessionElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "Class cast exception", (java.lang.Object)this, (Throwable)new InvalidDataException("Item is not of the type AoSession."));
        }
        super.setValueAsObject(item);
    }

    public void getPresentationString(Writer w, String spec, Locale locale, OdsxFilterInterface filter) {
        try {
            boolean all;
            boolean bl = all = spec == null || spec.compareTo("Header only") != 0;
            if (locale == null) {
                locale = FwkContainer.getLocale();
            }
            boolean deLang = locale.getLanguage().compareTo("de") == 0;
            AoSession session = this.getSession();
            if (all) {
                w.write("Name:     \t" + this.getName() + "\n");
                w.write("Asam-Pfad:\t" + this.getIdentificationString());
                w.write("\n==================================================================================\n");
            }
            try {
                NameValueIterator nvi = session.getContext("*");
                int count = nvi.getCount();
                DataType dt = null;
                String type = null;
                TS_Union u = null;
                String val = "";
                while (count-- > 0) {
                    NameValue nv = nvi.nextOne();
                    type = null;
                    try {
                        u = nv.value.u;
                        short flag = nv.value.flag;
                        dt = u.discriminator();
                        type = all ? StringFormat.printf((String)"[%15.15s]", (String)nv.valName) + StringFormat.printf((String)" %-12.12s", (String)OdsxHelper.datatypeToString(dt)) + " (" + OdsxHelper.flagsToString(flag) + ")" : nv.valName;
                    }
                    catch (Throwable t) {
                        type = deLang ? StringFormat.printf((String)"[%15.15s]", (String)nv.valName) + StringFormat.printf((String)" %-12.12s", (String)"unbekannt") + " (  Fehler)" : StringFormat.printf((String)"[%15.15s]", (String)nv.valName) + StringFormat.printf((String)" %-12.12s", (String)"unknown") + " (  error)";
                    }
                    if (all) {
                        w.write("\n" + type);
                    } else {
                        w.write(type);
                    }
                    if (nv.valName.toUpperCase().matches(".*PASSWORD.*")) {
                        val = "*********";
                    } else if (u != null) {
                        switch (dt.value()) {
                            case 4: {
                                val = "" + u.booleanVal();
                                break;
                            }
                            case 5: {
                                val = "" + u.byteVal();
                                break;
                            }
                            case 13: {
                                val = "" + u.complexVal();
                                break;
                            }
                            case 10: {
                                val = "" + u.dateVal();
                                break;
                            }
                            case 14: {
                                val = "" + u.dcomplexVal();
                                break;
                            }
                            case 7: {
                                val = "" + u.doubleVal();
                                break;
                            }
                            case 3: {
                                val = "" + u.floatVal();
                                break;
                            }
                            case 6: {
                                val = "" + u.longVal();
                                break;
                            }
                            case 8: {
                                val = "" + u.longlongVal();
                                break;
                            }
                            case 2: {
                                val = "" + u.shortVal();
                                break;
                            }
                            case 1: {
                                val = "" + u.stringVal();
                                break;
                            }
                            case 0: {
                                val = "<???>";
                                break;
                            }
                            default: {
                                val = "<..>";
                            }
                        }
                    }
                    if (deLang) {
                        w.write(val.length() == 0 ? "\t<leer>" : "\t" + val);
                    } else {
                        w.write(val.length() == 0 ? "\t<empty>" : "\t" + val);
                    }
                    if (all) continue;
                    w.write("\n");
                }
                this.writeEnumerations(w, spec, locale);
            }
            catch (AoException aoe) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, (String)OdsxHelper.aoExceptionToString(aoe), (Throwable)aoe);
            }
            catch (Throwable th) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, null, (Throwable)th);
            }
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.getSession()), null, null, (Throwable)t);
        }
    }

    public void writeEnumerations(Writer w, String spec, Locale locale) throws AoException, IOException {
        block7: {
            try {
                AoSession session = null;
                ApplicationStructure as = null;
                session = this.getSession();
                as = session.getApplicationStructure();
                if (as != null) {
                    w.write("\n");
                    String[] enums = as.listEnumerations();
                    if (enums != null && enums.length > 0) {
                        int count = enums.length;
                        for (int i = 0; i < count; ++i) {
                            EnumerationDefinition enumDef = as.getEnumerationDefinition(enums[i]);
                            if (enumDef == null) continue;
                            w.write("\n");
                            w.write(enums[i]);
                            w.write(" {\n");
                            String[] names = enumDef.listItemNames();
                            if (names != null && names.length > 0) {
                                int size = names.length;
                                for (int n = 0; n < size; ++n) {
                                    w.write("\t");
                                    w.write(names[n]);
                                    w.write(" \t" + enumDef.getItem(names[n]) + "\n");
                                }
                            }
                            w.write("}\n");
                        }
                    }
                }
            }
            catch (AoException aoe) {
                if (aoe.errCode.value() == 43) break block7;
                throw aoe;
            }
        }
    }

    public Vector getElements() {
        Vector<OdsxApplicationElement> ret = new Vector<OdsxApplicationElement>();
        AoSession session = null;
        ApplicationStructure as = null;
        try {
            session = this.getSession();
            as = session.getApplicationStructure();
        }
        catch (AoException aoException) {
            new FwkException(ErrorNumber.getExternal((int)aoException.errCode.value()), "$RCSfile: OdsxSessionElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "Failed to load children of <" + this.getName() + ">.\n" + OdsxHelper.aoExceptionToString(aoException), (java.lang.Object)this, (Throwable)aoException);
        }
        if (as != null) {
            ApplicationElement[] top = null;
            try {
                top = as.getTopLevelElements("*");
            }
            catch (AoException aoException) {
                if (aoException.errCode.value() == ErrorNumber.getValue((int)-1073741824)) {
                    new FwkException(0x4000FFFF, "$RCSfile: OdsxSessionElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "Failed to load children of <" + this.getName() + ">.\n" + OdsxHelper.aoExceptionToString(aoException), (java.lang.Object)this, (Throwable)aoException);
                }
                new FwkException(ErrorNumber.getExternal((int)aoException.errCode.value()), "$RCSfile: OdsxSessionElement.java,v $", this.getVersion(), "AH 2000-05-24 16:48", "Failed to load children of <" + this.getName() + ">.\n" + OdsxHelper.aoExceptionToString(aoException), (java.lang.Object)this, (Throwable)aoException);
            }
            if (top != null) {
                int size = top.length;
                for (int i = 0; i < size; ++i) {
                    OdsxApplicationElement elem = new OdsxApplicationElement(top[i]);
                    elem.setTopLevelElement(true);
                    elem.setOdsxFilter(this.odsFilter);
                    ret.add(elem);
                }
            }
        }
        return ret;
    }

    public String getIdentificationString() {
        return "[" + this.getName() + "]";
    }

    public FwkCommandInterface[] getCommands() {
        block8: {
            block9: {
                if (this.commandsAvailable()) break block8;
                java.lang.Object[] menu = FwkServiceProvider.getInstance().lookup(OdsxSessionMenuInterface.class);
                if (menu == null) break block9;
                int size = menu.length;
                if (size <= 0) break block8;
                for (int i = 0; i < size; ++i) {
                    OdsxSessionMenuInterface m = (OdsxSessionMenuInterface)menu[i];
                    m.setSession(this.getSession());
                    FwkCommandInterface[] cmds = m.getCommands();
                    int c = cmds.length;
                    for (int j = 0; j < c; ++j) {
                        this.addCommand(cmds[j]);
                    }
                }
                break block8;
            }
            super.getCommands();
            if (FwkPropertyBus.getProperty((String)"Demo", (boolean)false)) {
                OdsxInstanceCreateCommand cmd1 = new OdsxInstanceCreateCommand((FwkControllerInterface)this);
                this.addCommand((FwkCommandInterface)cmd1);
            }
            FwkCommandInterface baseElementCommand = null;
            if (this.odsFilter != null) {
                baseElementCommand = this.odsFilter.getCommand("BaseElementView");
            }
            if (baseElementCommand != null) {
                FwkCommandInterface parent = this.getCommand("View");
                if (parent == null) {
                    parent = new FwkCommand();
                    parent.setTextKey("Text.View");
                    parent.setCommandName("View");
                    parent.setIconKey("Icon.View");
                    this.addCommand(parent);
                }
                parent.addCommand(baseElementCommand);
            }
            this.addCommand((FwkCommandInterface)new OdsxDebugLevelEditorCommand((FwkControllerInterface)this));
            this.addCommand((FwkCommandInterface)new OdsxSetContextCommand((FwkControllerInterface)this));
            this.addCommand((FwkCommandInterface)new OdsxCheckModelCommand((FwkControllerInterface)this));
            java.lang.Object[] customizer = FwkServiceProvider.getInstance().lookup(OdsxSessionCustomizerInterface.class);
            if (customizer != null && customizer.length > 0) {
                int size = customizer.length;
                for (int i = 0; i < size; ++i) {
                    OdsxSessionCustomizerInterface c = (OdsxSessionCustomizerInterface)customizer[i];
                    c.setSession(this.getSession());
                    if (!c.isUseable()) continue;
                    this.addCommand(c);
                }
            }
        }
        return super.getCommands();
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("An ASAM-ODS Session");
        descriptor.setTitleName("OdsxSessionElement");
        descriptor.setName(OdsxSessionElement.class.getName());
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:10 $", null);
        descriptor.setIconKey("Icon.AoSession");
    }
}

