/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkInfoBusProducer;
import com.highqsoft.fwk.util.Pattern;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionProducerInterface;
import java.awt.datatransfer.DataFlavor;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.infobus.DataItem;
import javax.infobus.InfoBus;
import javax.infobus.InfoBusDataProducer;
import javax.infobus.InfoBusItemRequestedEvent;

public class OdsxSessionProducer
extends FwkInfoBusProducer
implements OdsxSessionProducerInterface {
    public static final String version = "$Revision: 1.4 $";
    private Hashtable sessionHash = new Hashtable();
    static int counter = 0;

    public String getVersion() {
        return version;
    }

    public OdsxSessionProducer() {
        super("OdsxSessionProducer[" + counter++ + "]@" + FwkDataBus.BUSNAME, FwkContainer.getFwkMimeTypes((Class)OdsxSessionInterface.class));
    }

    public boolean revoke(String itemName, DataFlavor[] flavor) {
        if (itemName == null) {
            return true;
        }
        if (this.isAssignable(flavor)) {
            if (itemName.indexOf(63) == -1 && itemName.indexOf(42) == -1) {
                OdsxSessionInterface session = (OdsxSessionInterface)this.sessionHash.remove(itemName);
                if (session != null) {
                    this.fireItemRevoked(session);
                    session.close();
                }
            } else {
                Object[] arr = this.findMultipleDataItems(itemName, flavor);
                if (arr != null && arr.length != 0) {
                    for (int i = arr.length; i >= 0; --i) {
                        try {
                            OdsxSessionInterface session = (OdsxSessionInterface)arr[i];
                            session = (OdsxSessionInterface)this.sessionHash.remove(itemName);
                            if (session == null) continue;
                            this.fireItemRevoked(session);
                            session.close();
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return true;
    }

    public OdsxSessionInterface[] listSessions() {
        OdsxSessionInterface[] ret = new OdsxSessionInterface[]{};
        if (this.sessionHash != null && this.sessionHash.size() != 0) {
            ret = new OdsxSessionInterface[this.sessionHash.size()];
            Iterator it = this.sessionHash.keySet().iterator();
            int counter = 0;
            while (it.hasNext()) {
                ret[counter++] = (OdsxSessionInterface)this.sessionHash.get(it.next());
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(OdsxSessionInterface odsSession) throws FwkException {
        Hashtable hashtable = this.sessionHash;
        synchronized (hashtable) {
            String sessionName = odsSession.getSessionName();
            if (odsSession.getSession() != null) {
                if (this.sessionHash.containsKey(sessionName)) {
                    String uniqueName;
                    int i = 2;
                    do {
                        uniqueName = sessionName + "_" + i;
                        ++i;
                    } while (this.sessionHash.containsKey(uniqueName));
                    odsSession.setSessionName(uniqueName);
                    sessionName = uniqueName;
                }
            } else {
                throw new FwkException(-1073676289, "$RCSfile: OdsxSessionProducer.java,v $", version, "AH 2001-01-26 09:08", "Cannot connect the session <" + sessionName + ">.", (Object)this, null);
            }
            this.sessionHash.put(sessionName, odsSession);
            this.fireItemAvailable(odsSession, FwkContainer.getDataFlavors((Class)OdsxSessionInterface.class));
        }
    }

    public void removeSession(OdsxSessionInterface odsSession) {
        this.removeSession(odsSession.getSessionName());
    }

    public void removeSession(String sessionName) {
        OdsxSessionInterface session = (OdsxSessionInterface)this.sessionHash.remove(sessionName);
        if (session != null) {
            this.fireItemRevoked(session);
            session.close();
        }
    }

    public void fireItemAvailable(DataItem item, DataFlavor[] flavor) {
        InfoBus ib = this.getInfoBus();
        if (ib != null) {
            OdsxSessionInterface session = (OdsxSessionInterface)item;
            ib.fireItemAvailable(session.getSessionName(), flavor, (InfoBusDataProducer)this);
        }
    }

    public void fireItemRevoked(DataItem item) {
        InfoBus ib;
        if (item != null && (ib = this.getInfoBus()) != null) {
            OdsxSessionInterface session = (OdsxSessionInterface)item;
            ib.fireItemRevoked(session.getSessionName(), (InfoBusDataProducer)this);
        }
    }

    public void dataItemRequested(InfoBusItemRequestedEvent ev) {
        super.dataItemRequested(ev);
        if (ev.getDataItem() == null) {
            String dataItemName = ev.getDataItemName();
            if (dataItemName != null) {
                DataFlavor[] dataFlavors = ev.getDataFlavors();
                int size = dataFlavors.length;
                int i = 0;
                boolean assignable = false;
                while (i < size && !assignable) {
                    assignable = dataFlavors[i++].getRepresentationClass().isAssignableFrom(class$com$highqsoft$interfaces$odsx$OdsxSessionInterface == null ? OdsxSessionProducer.class$("com.highqsoft.interfaces.odsx.OdsxSessionInterface") : class$com$highqsoft$interfaces$odsx$OdsxSessionInterface);
                }
                if (assignable) {
                    if (dataItemName.indexOf(42) != -1 || dataItemName.indexOf(63) != -1) {
                        FwkArray dataItemArray = new FwkArray();
                        Enumeration sessionNames = this.sessionHash.keys();
                        while (sessionNames.hasMoreElements()) {
                            String itemName = (String)sessionNames.nextElement();
                            if (!Pattern.match((String)itemName, (String)dataItemName, (boolean)true)) continue;
                            Object dataItem = this.sessionHash.get(itemName);
                            if (dataItem != null) {
                                dataItemArray.add(dataItem);
                                continue;
                            }
                            FwkContainer.debug((int)5, (String)("   OdsxSessionProducer: Requested data item not found: " + dataItemName));
                        }
                        if (dataItemArray.size() > 0) {
                            ev.setDataItem((Object)dataItemArray.toArray((Object[])new OdsxSessionInterface[dataItemArray.size()]));
                        }
                    } else {
                        Object dataItem = this.sessionHash.get(dataItemName);
                        if (dataItem != null) {
                            ev.setDataItem(dataItem);
                        } else {
                            FwkContainer.debug((int)5, (String)("   OdsxSessionProducer: Requested data item not found: " + dataItemName));
                        }
                    }
                } else {
                    FwkContainer.debug((int)5, (String)"   OdsxSessionProducer: Requested DataFlavor is not assignable.");
                }
            } else {
                FwkContainer.debug((int)5, (String)"   OdsxSessionProducer: Data Item Name == null");
            }
        }
    }

    public void propertyChange(PropertyChangeEvent ev) {
        System.out.println("%OdsxSessionProducer: propertyChange(PropertyChangeEvent ev)");
        System.out.println(ev.toString());
    }
}

