/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.exception.ErrorNumber;
import com.highqsoft.interfaces.odsx.OdsxTableModelInterface;
import com.highqsoft.odsx.OdsxHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.event.TableModelListener;
import org.asam.ods.AIDName;
import org.asam.ods.AIDNameUnitId;
import org.asam.ods.AIDNameValueUnitId;
import org.asam.ods.AggrFunc;
import org.asam.ods.AoException;
import org.asam.ods.ApplElemAccess;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.BaseAttribute;
import org.asam.ods.DataType;
import org.asam.ods.ElemId;
import org.asam.ods.ElemResultSet;
import org.asam.ods.InstanceElement;
import org.asam.ods.JoinDef;
import org.asam.ods.JoinType;
import org.asam.ods.QueryStructure;
import org.asam.ods.QueryStructureExt;
import org.asam.ods.RelationRange;
import org.asam.ods.RelationType;
import org.asam.ods.ResultSetExt;
import org.asam.ods.SelAIDNameUnitId;
import org.asam.ods.SelItem;
import org.asam.ods.SelOpcode;
import org.asam.ods.SelOperator;
import org.asam.ods.SelOrder;
import org.asam.ods.SelValue;
import org.asam.ods.SelValueExt;
import org.asam.ods.TS_Union;
import org.asam.ods.TS_Value;
import org.asam.ods.TS_ValueSeq;
import org.asam.ods.T_LONGLONG;

public class OdsxTableHelper {
    public static OdsxTableModelInterface createTable(InstanceElement relIE, ApplicationElement ae, boolean withRel) throws AoException {
        long time = System.currentTimeMillis();
        Model model = new Model();
        if (ae != null) {
            int i;
            DataType dt;
            T_LONGLONG relIID;
            T_LONGLONG relAID;
            ApplicationElement relAE;
            ApplicationStructure asObj = ae.getApplicationStructure();
            if (relIE != null) {
                relAE = relIE.getApplicationElement();
                relAID = relAE.getId();
                relIID = relIE.getId();
            } else {
                relAE = null;
                relAID = null;
                relIID = null;
            }
            T_LONGLONG aeId = ae.getId();
            ApplElemAccess aea = asObj.getSession().getApplElemAccess();
            String[] relNames = new String[]{};
            ApplicationElement[] relAe = new ApplicationElement[]{};
            if (withRel) {
                ApplicationRelation[] aeRel = null;
                try {
                    aeRel = ae.getAllRelations();
                }
                catch (AoException getRelAOE) {
                    aeRel = new ApplicationRelation[]{};
                }
                Vector<ApplicationElement> relVec = new Vector<ApplicationElement>();
                Vector<String> relName = new Vector<String>();
                for (int i2 = 0; i2 < aeRel.length; ++i2) {
                    if (aeRel[i2].getRelationship().value() == 1) continue;
                    RelationRange relRange = aeRel[i2].getRelationRange();
                    if (relRange.max != 1) continue;
                    relVec.add(aeRel[i2].getElem2());
                    relName.add(aeRel[i2].getRelationName());
                }
                relAe = relVec.toArray(new ApplicationElement[relVec.size()]);
                relNames = relName.toArray(new String[relName.size()]);
            }
            QueryStructure aoq = new QueryStructure();
            aoq.condSeq = new SelValue[1];
            ApplicationAttribute aaObj = ae.getAttributeByBaseName("name");
            aoq.condSeq[0] = new SelValue();
            aoq.condSeq[0].attr = new AIDNameValueUnitId();
            aoq.condSeq[0].attr.attr = new AIDName();
            aoq.condSeq[0].attr.attr.aid = new T_LONGLONG(aeId.high, aeId.low);
            aoq.condSeq[0].attr.attr.aaName = aaObj.getName();
            aoq.condSeq[0].attr.unitId = new T_LONGLONG();
            aoq.condSeq[0].attr.values = new TS_Value();
            aoq.condSeq[0].attr.values.u = new TS_Union();
            aoq.condSeq[0].attr.values.u.shortVal((short)0);
            aoq.condSeq[0].oper = SelOpcode.LIKE;
            aoq.condSeq[0].value = new TS_Value();
            aoq.condSeq[0].value.u = new TS_Union();
            aoq.condSeq[0].value.u.stringVal("*");
            aoq.operSeq = new SelOperator[0];
            ApplicationAttribute[] attrs = ae.getAttributes("*");
            int size = attrs.length;
            boolean check = true;
            block28: for (int i3 = 0; i3 < size; ++i3) {
                dt = attrs[i3].getDataType();
                switch (dt.value()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 25: 
                    case 30: {
                        if (check) {
                            BaseAttribute ba = attrs[i3].getBaseAttribute();
                            if (ba == null) continue block28;
                            String type = ba.getName();
                            if (type != null && type.compareToIgnoreCase("id") == 0) {
                                model.colHeader.insertElementAt(attrs[i3].getName(), 0);
                                check = false;
                                continue block28;
                            }
                            model.colHeader.add(attrs[i3].getName());
                            continue block28;
                        }
                        model.colHeader.add(attrs[i3].getName());
                        continue block28;
                    }
                }
            }
            int relOffset = model.colHeader.size();
            for (i = 0; i < relNames.length; ++i) {
                model.colHeader.add(relNames[i]);
            }
            size = model.colHeader.size();
            aoq.anuSeq = new AIDNameUnitId[size];
            for (i = 0; i < size; ++i) {
                aoq.anuSeq[i] = new AIDNameUnitId();
                aoq.anuSeq[i].attr = new AIDName();
                aoq.anuSeq[i].attr.aid = new T_LONGLONG(aeId.high, aeId.low);
                aoq.anuSeq[i].attr.aaName = (String)model.colHeader.get(i);
                aoq.anuSeq[i].unitId = new T_LONGLONG();
            }
            aoq.relInst = new ElemId();
            aoq.relName = "";
            if (relAID != null && relIID != null) {
                aoq.relInst.aid = new T_LONGLONG(relAID.high, relAID.low);
                aoq.relInst.iid = new T_LONGLONG(relIID.high, relIID.low);
            } else {
                aoq.relInst.aid = new T_LONGLONG();
                aoq.relInst.iid = new T_LONGLONG();
            }
            aoq.orderBy = new SelOrder[0];
            ElemResultSet[] elemRes = null;
            try {
                elemRes = aea.getInstances(aoq, 0);
            }
            catch (AoException aoe) {
                aoe.printStackTrace();
                System.err.println(ErrorNumber.getText((int)ErrorNumber.getValue((int)aoe.errCode.value())) + " " + aoe.reason);
                FwkContainer.showErrorMessage((String)"ODS Error", (String)"ODS Error", (Throwable)aoe);
            }
            catch (Throwable t) {
                t.printStackTrace();
                elemRes = null;
            }
            HashMap<String, TS_ValueSeq> relValues = new HashMap<String, TS_ValueSeq>();
            if (elemRes != null && elemRes.length == 1) {
                int v;
                int vSize;
                size = elemRes[0].attrValues.length;
                model.colHeader.clear();
                block31: for (int i4 = 0; i4 < size; ++i4) {
                    dt = elemRes[0].attrValues[i4].attrValues.value.u.discriminator();
                    switch (dt.value()) {
                        case 4: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            boolean[] bb = elemRes[0].attrValues[i4].attrValues.value.u.booleanVal();
                            vSize = bb.length;
                            for (int v2 = 0; v2 < vSize; ++v2) {
                                model.data[i4][v2] = "" + bb[v2];
                            }
                            continue block31;
                        }
                        case 5: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            byte[] by = elemRes[0].attrValues[i4].attrValues.value.u.byteVal();
                            vSize = by.length;
                            for (int v3 = 0; v3 < vSize; ++v3) {
                                model.data[i4][v3] = "" + by[v3];
                            }
                            continue block31;
                        }
                        case 10: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            String[] dv = elemRes[0].attrValues[i4].attrValues.value.u.dateVal();
                            vSize = dv.length;
                            for (int v4 = 0; v4 < vSize; ++v4) {
                                model.data[i4][v4] = OdsxHelper.valToString("" + dv[v4]);
                            }
                            continue block31;
                        }
                        case 7: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            double[] dob = elemRes[0].attrValues[i4].attrValues.value.u.doubleVal();
                            vSize = dob.length;
                            for (int v5 = 0; v5 < vSize; ++v5) {
                                model.data[i4][v5] = "" + dob[v5];
                            }
                            continue block31;
                        }
                        case 3: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            float[] fo = elemRes[0].attrValues[i4].attrValues.value.u.floatVal();
                            vSize = fo.length;
                            for (int v6 = 0; v6 < vSize; ++v6) {
                                model.data[i4][v6] = "" + fo[v6];
                            }
                            continue block31;
                        }
                        case 30: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            int[] em = elemRes[0].attrValues[i4].attrValues.value.u.enumVal();
                            vSize = em.length;
                            for (int v7 = 0; v7 < vSize; ++v7) {
                                model.data[i4][v7] = "" + em[v7];
                            }
                            continue block31;
                        }
                        case 6: 
                        case 25: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            int[] id = elemRes[0].attrValues[i4].attrValues.value.u.longVal();
                            if (model.colHeader.size() == 1) {
                                model.data = new Object[size][id.length];
                            } else if (i4 >= relOffset) {
                                relValues.put(elemRes[0].attrValues[i4].attrValues.valName, elemRes[0].attrValues[i4].attrValues.value);
                            }
                            vSize = id.length;
                            for (int v8 = 0; v8 < vSize; ++v8) {
                                model.data[i4][v8] = new Integer(id[v8]);
                            }
                            continue block31;
                        }
                        case 8: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            T_LONGLONG[] llid = elemRes[0].attrValues[i4].attrValues.value.u.longlongVal();
                            if (model.colHeader.size() == 1) {
                                model.data = new Object[size][llid.length];
                            } else if (i4 >= relOffset) {
                                relValues.put(elemRes[0].attrValues[i4].attrValues.valName, elemRes[0].attrValues[i4].attrValues.value);
                            }
                            vSize = llid.length;
                            for (int v9 = 0; v9 < vSize; ++v9) {
                                long ll = llid[v9].low < 0 ? (long)(-2 * (llid[v9].high + 1) + llid[v9].low) : (long)(-2 * llid[v9].high + llid[v9].low);
                                model.data[i4][v9] = new Long(ll);
                            }
                            continue block31;
                        }
                        case 2: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            short[] sid = elemRes[0].attrValues[i4].attrValues.value.u.shortVal();
                            vSize = sid.length;
                            for (v = 0; v < vSize; ++v) {
                                model.data[i4][v] = "" + sid[v];
                            }
                            continue block31;
                        }
                        case 1: {
                            model.colHeader.add(elemRes[0].attrValues[i4].attrValues.valName);
                            String[] ds = elemRes[0].attrValues[i4].attrValues.value.u.stringVal();
                            vSize = ds.length;
                            for (int v10 = 0; v10 < vSize; ++v10) {
                                model.data[i4][v10] = "" + ds[v10];
                            }
                            continue block31;
                        }
                        default: {
                            Arrays.fill(model.data[i4], "");
                        }
                    }
                }
                int relSize = relNames.length;
                for (int i5 = 0; i5 < relSize; ++i5) {
                    int pos = relOffset + i5;
                    TS_ValueSeq ids = (TS_ValueSeq)relValues.get(relNames[i5]);
                    if (ids != null) {
                        int count;
                        T_LONGLONG[] inset;
                        int r;
                        Object[] relOrder;
                        int rSize;
                        Arrays.fill(model.data[pos], "");
                        if (ids.u.discriminator().value() == 6) {
                            int[] rId = ids.u.longVal();
                            rSize = rId.length;
                            relOrder = new RelOrder[rSize];
                            for (r = 0; r < rSize; ++r) {
                                relOrder[r] = new RelOrder(rId[r], r);
                            }
                        } else {
                            T_LONGLONG[] rllId = ids.u.longlongVal();
                            rSize = rllId.length;
                            relOrder = new RelOrder[rSize];
                            for (r = 0; r < rSize; ++r) {
                                relOrder[r] = new RelOrder(rllId[r].high, rllId[r].low, r);
                            }
                        }
                        if ((inset = OdsxTableHelper.reduceRelationInset((RelOrder[])relOrder)).length <= 0) continue;
                        aoq = new QueryStructure();
                        aoq.condSeq = new SelValue[1];
                        aaObj = relAe[i5].getAttributeByBaseName("id");
                        T_LONGLONG relId = relAe[i5].getId();
                        aoq.condSeq[0] = new SelValue();
                        aoq.condSeq[0].attr = new AIDNameValueUnitId();
                        aoq.condSeq[0].attr.attr = new AIDName();
                        aoq.condSeq[0].attr.attr.aid = new T_LONGLONG(relId.high, relId.low);
                        aoq.condSeq[0].attr.attr.aaName = aaObj.getName();
                        aoq.condSeq[0].attr.unitId = new T_LONGLONG();
                        aoq.condSeq[0].attr.values = new TS_Value();
                        aoq.condSeq[0].attr.values.u = new TS_Union();
                        aoq.condSeq[0].attr.values.u.shortVal((short)0);
                        aoq.condSeq[0].oper = SelOpcode.INSET;
                        aoq.condSeq[0].value = new TS_Value();
                        aoq.condSeq[0].value.u = new TS_Union();
                        aoq.condSeq[0].value.u.longlongSeq(inset);
                        aoq.operSeq = new SelOperator[0];
                        aoq.anuSeq = new AIDNameUnitId[2];
                        aaObj = relAe[i5].getAttributeByBaseName("id");
                        aoq.anuSeq[0] = new AIDNameUnitId();
                        aoq.anuSeq[0].attr = new AIDName();
                        aoq.anuSeq[0].attr.aid = new T_LONGLONG(relId.high, relId.low);
                        aoq.anuSeq[0].attr.aaName = aaObj.getName();
                        aoq.anuSeq[0].unitId = new T_LONGLONG();
                        aaObj = relAe[i5].getAttributeByBaseName("name");
                        aoq.anuSeq[1] = new AIDNameUnitId();
                        aoq.anuSeq[1].attr = new AIDName();
                        aoq.anuSeq[1].attr.aid = new T_LONGLONG(relId.high, relId.low);
                        aoq.anuSeq[1].attr.aaName = aaObj.getName();
                        aoq.anuSeq[1].unitId = new T_LONGLONG();
                        aoq.relInst = new ElemId();
                        aoq.relName = "";
                        aoq.relInst.aid = new T_LONGLONG();
                        aoq.relInst.iid = new T_LONGLONG();
                        aoq.orderBy = new SelOrder[0];
                        elemRes = null;
                        try {
                            elemRes = aea.getInstances(aoq, 0);
                        }
                        catch (Throwable t) {
                            elemRes = null;
                        }
                        if (elemRes == null || elemRes.length != 1) continue;
                        size = elemRes[0].attrValues.length;
                        Order[] order = null;
                        block45: for (int elem = 0; elem < size; ++elem) {
                            dt = elemRes[0].attrValues[elem].attrValues.value.u.discriminator();
                            switch (dt.value()) {
                                case 6: {
                                    int[] dl = elemRes[0].attrValues[elem].attrValues.value.u.longVal();
                                    vSize = dl.length;
                                    if (order == null) {
                                        order = new Order[vSize];
                                    }
                                    for (int v11 = 0; v11 < vSize; ++v11) {
                                        order[v11] = new Order(dl[v11]);
                                    }
                                    continue block45;
                                }
                                case 8: {
                                    T_LONGLONG[] dll = elemRes[0].attrValues[elem].attrValues.value.u.longlongVal();
                                    vSize = dll.length;
                                    if (order == null) {
                                        order = new Order[vSize];
                                    }
                                    for (int v12 = 0; v12 < vSize; ++v12) {
                                        order[v12] = new Order(dll[v12].high, dll[v12].low);
                                    }
                                    continue block45;
                                }
                                case 1: {
                                    String[] ds = elemRes[0].attrValues[elem].attrValues.value.u.stringVal();
                                    vSize = ds.length;
                                    for (v = 0; v < vSize; ++v) {
                                        order[v].data = "" + ds[v];
                                    }
                                    continue block45;
                                }
                            }
                        }
                        if (order == null || order.length <= 0) continue;
                        Arrays.sort(relOrder);
                        Arrays.sort(order);
                        int orderSize = order.length;
                        vSize = relOrder.length;
                        String val = "";
                        int act = 0;
                        for (count = 0; count < vSize && (((RelOrder)relOrder[count]).idLow != order[act].idLow || ((RelOrder)relOrder[count]).idHigh != order[act].idHigh); ++count) {
                            model.data[pos][((RelOrder)relOrder[count]).idx] = val;
                        }
                        val = order[act].data.toString();
                        while (count < vSize && act < orderSize) {
                            if (((RelOrder)relOrder[count]).idLow != order[act].idLow || ((RelOrder)relOrder[count]).idHigh != order[act].idHigh) {
                                if (++act == orderSize) break;
                                val = order[act].data.toString();
                            }
                            model.data[pos][((RelOrder)relOrder[count]).idx] = val;
                            ++count;
                        }
                        while (count < vSize) {
                            model.data[pos][((RelOrder)relOrder[count]).idx] = "";
                            ++count;
                        }
                        continue;
                    }
                    System.err.println(relNames[i5] + " not selectable.");
                    --relOffset;
                }
            }
        }
        model.time = System.currentTimeMillis() - time;
        if (FwkContainer.getDebugLevel() >= 1) {
            System.out.println(model);
        }
        return model;
    }

    public static OdsxTableModelInterface createApplicationElementTable(ApplicationElement ae, boolean withRel) throws AoException {
        return OdsxTableHelper.createTable(null, ae, withRel);
    }

    public static OdsxTableModelInterface createInstanceElementChildTable(InstanceElement ieObj, ApplicationElement relatedAe, boolean withRel) throws AoException {
        return OdsxTableHelper.createTable(ieObj, relatedAe, withRel);
    }

    public static T_LONGLONG[] reduceRelationInset(RelOrder[] arr) {
        int iCount;
        Arrays.sort(arr);
        int iSize = arr.length;
        T_LONGLONG[] inset = new T_LONGLONG[iSize];
        int count = 0;
        for (iCount = 0; iCount < iSize && arr[iCount].idLow == 0 && arr[iCount].idHigh == 0; ++iCount) {
        }
        if (iCount < iSize) {
            inset[count] = arr[iCount].getT_LONGLONG();
            ++count;
        }
        while (iCount < iSize) {
            if (arr[iCount].notEqual(inset[count - 1])) {
                inset[count] = arr[iCount].getT_LONGLONG();
                ++count;
            }
            ++iCount;
        }
        if (count < inset.length) {
            T_LONGLONG[] tmp = new T_LONGLONG[count];
            if (count > 0) {
                System.arraycopy(inset, 0, tmp, 0, tmp.length);
            } else {
                inset = new T_LONGLONG[]{};
            }
            inset = tmp;
        }
        return inset;
    }

    public static int[] reduceRelationInset(int[] arr) {
        int iCount;
        Arrays.sort(arr);
        int iSize = arr.length;
        int[] inset = new int[iSize];
        int count = 0;
        for (iCount = 0; iCount < iSize && arr[iCount] == 0; ++iCount) {
        }
        if (iCount < iSize) {
            inset[count] = arr[iCount];
            ++count;
        }
        while (iCount < iSize) {
            if (arr[iCount] != inset[count - 1]) {
                inset[count] = arr[iCount];
                ++count;
            }
            ++iCount;
        }
        if (count < inset.length - 1) {
            int[] tmp = new int[count];
            if (count > 0) {
                System.arraycopy(inset, 0, tmp, 0, tmp.length);
            } else {
                inset = new int[]{};
            }
            inset = tmp;
        }
        return inset;
    }

    public static ElemResultSet createTable2(InstanceElement relIE, ApplicationElement ae, boolean withRel) throws AoException {
        ApplicationStructure asObj;
        long time = System.currentTimeMillis();
        Model model = new Model();
        if (ae != null) {
            asObj = ae.getApplicationStructure();
            T_LONGLONG aeId = ae.getId();
            ApplElemAccess aea = asObj.getSession().getApplElemAccess();
        }
        if (ae != null) {
            int i;
            T_LONGLONG relIID;
            T_LONGLONG relAID;
            ApplicationElement relAE;
            asObj = ae.getApplicationStructure();
            if (relIE != null) {
                relAE = relIE.getApplicationElement();
                relAID = relAE.getId();
                relIID = relIE.getId();
            } else {
                relAE = null;
                relAID = null;
                relIID = null;
            }
            T_LONGLONG aeId = ae.getId();
            ApplElemAccess aea = asObj.getSession().getApplElemAccess();
            String[] relNames = new String[]{};
            ApplicationElement[] relAe = new ApplicationElement[]{};
            if (withRel) {
                ApplicationRelation[] aeRel = null;
                try {
                    aeRel = ae.getAllRelations();
                }
                catch (AoException getRelAOE) {
                    aeRel = new ApplicationRelation[]{};
                }
                Vector<ApplicationElement> relVec = new Vector<ApplicationElement>();
                Vector<String> relName = new Vector<String>();
                for (int i2 = 0; i2 < aeRel.length; ++i2) {
                    if (aeRel[i2].getRelationship().value() == 1) continue;
                    RelationRange relRange = aeRel[i2].getRelationRange();
                    if (relRange.max != 1) continue;
                    relVec.add(aeRel[i2].getElem2());
                    relName.add(aeRel[i2].getRelationName());
                }
                relAe = relVec.toArray(new ApplicationElement[relVec.size()]);
                relNames = relName.toArray(new String[relName.size()]);
            }
            QueryStructure aoq = new QueryStructure();
            aoq.condSeq = new SelValue[1];
            ApplicationAttribute aaObj = ae.getAttributeByBaseName("name");
            aoq.condSeq[0] = new SelValue();
            aoq.condSeq[0].attr = new AIDNameValueUnitId();
            aoq.condSeq[0].attr.attr = new AIDName();
            aoq.condSeq[0].attr.attr.aid = new T_LONGLONG(aeId.high, aeId.low);
            aoq.condSeq[0].attr.attr.aaName = aaObj.getName();
            aoq.condSeq[0].attr.unitId = new T_LONGLONG();
            aoq.condSeq[0].attr.values = new TS_Value();
            aoq.condSeq[0].attr.values.u = new TS_Union();
            aoq.condSeq[0].attr.values.u.shortVal((short)0);
            aoq.condSeq[0].oper = SelOpcode.LIKE;
            aoq.condSeq[0].value = new TS_Value();
            aoq.condSeq[0].value.u = new TS_Union();
            aoq.condSeq[0].value.u.stringVal("*");
            aoq.operSeq = new SelOperator[0];
            ApplicationAttribute[] attrs = ae.getAttributes("*");
            int size = attrs.length;
            boolean check = true;
            block9: for (int i3 = 0; i3 < size; ++i3) {
                DataType dt = attrs[i3].getDataType();
                switch (dt.value()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 25: 
                    case 30: {
                        if (check) {
                            BaseAttribute ba = attrs[i3].getBaseAttribute();
                            if (ba == null) continue block9;
                            String type = ba.getName();
                            if (type != null && type.compareToIgnoreCase("id") == 0) {
                                model.colHeader.insertElementAt(attrs[i3].getName(), 0);
                                check = false;
                                continue block9;
                            }
                            model.colHeader.add(attrs[i3].getName());
                            continue block9;
                        }
                        model.colHeader.add(attrs[i3].getName());
                        continue block9;
                    }
                }
            }
            int relOffset = model.colHeader.size();
            for (i = 0; i < relNames.length; ++i) {
                model.colHeader.add(relNames[i]);
            }
            size = model.colHeader.size();
            aoq.anuSeq = new AIDNameUnitId[size];
            for (i = 0; i < size; ++i) {
                aoq.anuSeq[i] = new AIDNameUnitId();
                aoq.anuSeq[i].attr = new AIDName();
                aoq.anuSeq[i].attr.aid = new T_LONGLONG(aeId.high, aeId.low);
                aoq.anuSeq[i].attr.aaName = (String)model.colHeader.get(i);
                aoq.anuSeq[i].unitId = new T_LONGLONG();
            }
            aoq.relInst = new ElemId();
            aoq.relName = "";
            if (relAID != null && relIID != null) {
                aoq.relInst.aid = new T_LONGLONG(relAID.high, relAID.low);
                aoq.relInst.iid = new T_LONGLONG(relIID.high, relIID.low);
            } else {
                aoq.relInst.aid = new T_LONGLONG();
                aoq.relInst.iid = new T_LONGLONG();
            }
            aoq.orderBy = new SelOrder[0];
            ElemResultSet[] elemRes = null;
            try {
                elemRes = aea.getInstances(aoq, 0);
            }
            catch (AoException aoe) {
                aoe.printStackTrace();
                System.err.println(ErrorNumber.getText((int)ErrorNumber.getValue((int)aoe.errCode.value())) + " " + aoe.reason);
                FwkContainer.showErrorMessage((String)"ODS Error", (String)"ODS Error", (Throwable)aoe);
                return elemRes[0];
            }
            catch (Throwable t) {
                t.printStackTrace();
                elemRes = null;
                return elemRes[0];
            }
            return elemRes[0];
        }
        return null;
    }

    public static ResultSetExt createTableResultSetExt(ApplicationStructure asObj, ApplicationElement ae) throws AoException {
        long time = System.currentTimeMillis();
        Model model = new Model();
        if (ae != null) {
            ApplicationRelation rel;
            int i;
            Vector<ApplicationRelation> relVec = new Vector<ApplicationRelation>();
            T_LONGLONG aeId = ae.getId();
            ApplElemAccess aea = asObj.getSession().getApplElemAccess();
            ApplicationRelation[] aeRel = null;
            try {
                aeRel = ae.getAllRelations();
            }
            catch (AoException aoe) {
                aeRel = new ApplicationRelation[]{};
                aoe.printStackTrace();
            }
            for (int i2 = 0; i2 < aeRel.length; ++i2) {
                boolean elemsequal;
                T_LONGLONG ll1 = aeRel[i2].getElem1().getId();
                T_LONGLONG ll2 = aeRel[i2].getElem2().getId();
                boolean bl = elemsequal = ll1.high == ll2.high && ll1.low == ll2.low;
                if (aeRel[i2].getRelationship().value() == 1 || elemsequal) continue;
                RelationRange relRange = aeRel[i2].getRelationRange();
                if (relRange.max != 1) continue;
                relVec.add(aeRel[i2]);
            }
            aeRel = relVec.toArray(new ApplicationRelation[relVec.size()]);
            QueryStructureExt query = new QueryStructureExt();
            ApplicationAttribute[] attrs = ae.getAttributes("*");
            int attrSize = attrs.length;
            int relSize = aeRel.length;
            query.anuSeq = new SelAIDNameUnitId[attrSize + relSize];
            String[] aaNames = ae.listAttributes("*");
            for (i = 0; i < attrSize; ++i) {
                query.anuSeq[i] = new SelAIDNameUnitId();
                query.anuSeq[i].aggregate = AggrFunc.NONE;
                query.anuSeq[i].unitId = new T_LONGLONG();
                query.anuSeq[i].attr = new AIDName();
                query.anuSeq[i].attr.aaName = aaNames[i];
                query.anuSeq[i].attr.aid = aeId;
            }
            for (i = 0; i < relSize; ++i) {
                rel = aeRel[i];
                query.anuSeq[attrSize + i] = new SelAIDNameUnitId();
                query.anuSeq[attrSize + i].aggregate = AggrFunc.NONE;
                query.anuSeq[attrSize + i].unitId = new T_LONGLONG();
                query.anuSeq[attrSize + i].attr = new AIDName();
                query.anuSeq[attrSize + i].attr.aaName = rel.getElem2().getAttributeByBaseName("name").getName();
                query.anuSeq[attrSize + i].attr.aid = rel.getElem2().getId();
            }
            query.condSeq = new SelItem[1];
            query.condSeq[0] = new SelItem();
            ApplicationAttribute aaObj = ae.getAttributeByBaseName("id");
            AIDNameUnitId aidNameUnitId = new AIDNameUnitId(new AIDName(new T_LONGLONG(aeId.high, aeId.low), aaObj.getName()), new T_LONGLONG());
            TS_Union u = new TS_Union();
            u.longlongVal(new T_LONGLONG());
            SelValueExt sel = new SelValueExt(aidNameUnitId, SelOpcode.GT, new TS_Value(u, 15));
            query.condSeq[0].value(sel);
            query.joinSeq = new JoinDef[relSize];
            for (int i3 = 0; i3 < relSize; ++i3) {
                rel = aeRel[i3];
                query.joinSeq[i3] = new JoinDef();
                query.joinSeq[i3].refName = rel.getRelationName();
                query.joinSeq[i3].fromAID = rel.getElem1().getId();
                query.joinSeq[i3].toAID = rel.getElem2().getId();
                query.joinSeq[i3].joiningType = JoinType.JTOUTER;
            }
            query.groupBy = new AIDName[0];
            query.orderBy = new SelOrder[0];
            ResultSetExt[] rsext = aea.getInstancesExt(query, 0);
            return rsext[0];
        }
        return null;
    }

    public static ResultSetExt createTableResultSetExt(ApplicationStructure asObj, InstanceElement ie) throws AoException {
        long time = System.currentTimeMillis();
        if (ie != null) {
            int i;
            Vector<ApplicationRelation> relVec = new Vector<ApplicationRelation>();
            ApplicationElement aeObj = ie.getApplicationElement();
            ApplicationElement aeFather = null;
            ApplicationElement aeChild = null;
            T_LONGLONG aeId = aeObj.getId();
            ApplElemAccess aea = asObj.getSession().getApplElemAccess();
            ApplicationRelation[] aeRel = null;
            try {
                aeRel = aeObj.getRelationsByType(RelationType.FATHER_CHILD);
            }
            catch (AoException aoe) {
                aeRel = new ApplicationRelation[]{};
                aoe.printStackTrace();
            }
            for (int i2 = 0; i2 < aeRel.length; ++i2) {
                if (aeRel[i2].getRelationship().value() != 1) continue;
                RelationRange relRange = aeRel[i2].getRelationRange();
                if (relRange.max != -1) continue;
                relVec.add(aeRel[i2]);
            }
            aeRel = relVec.toArray(new ApplicationRelation[relVec.size()]);
            if (aeObj.getName().equals(aeRel[0].getElem1().getName())) {
                aeFather = aeObj;
                aeChild = aeRel[0].getElem2();
            } else if (aeObj.getName().equals(aeRel[0].getElem2().getName())) {
                aeFather = aeRel[0].getElem2();
                aeChild = aeObj;
            }
            QueryStructureExt query = new QueryStructureExt();
            ApplicationAttribute[] attrs = aeChild.getAttributes("*");
            ApplicationRelation rel = null;
            int attrSize = attrs.length;
            int relSize = aeRel.length;
            query.anuSeq = new SelAIDNameUnitId[attrSize + relSize];
            String[] aaNames = aeChild.listAttributes("*");
            for (i = 0; i < attrSize; ++i) {
                query.anuSeq[i] = new SelAIDNameUnitId();
                query.anuSeq[i].aggregate = AggrFunc.NONE;
                query.anuSeq[i].unitId = new T_LONGLONG();
                query.anuSeq[i].attr = new AIDName();
                query.anuSeq[i].attr.aaName = aaNames[i];
                query.anuSeq[i].attr.aid = aeChild.getId();
            }
            for (i = 0; i < relSize; ++i) {
                rel = aeRel[i];
                query.anuSeq[attrSize + i] = new SelAIDNameUnitId();
                query.anuSeq[attrSize + i].aggregate = AggrFunc.NONE;
                query.anuSeq[attrSize + i].unitId = new T_LONGLONG();
                query.anuSeq[attrSize + i].attr = new AIDName();
                query.anuSeq[attrSize + i].attr.aaName = aeFather.getAttributeByBaseName("name").getName();
                query.anuSeq[attrSize + i].attr.aid = aeId;
            }
            query.condSeq = new SelItem[1];
            query.condSeq[0] = new SelItem();
            AIDNameUnitId aidNameUnitId = new AIDNameUnitId(new AIDName(aeChild.getId(), rel.getInverseRelationName()), new T_LONGLONG());
            TS_Union u = new TS_Union();
            u.longlongVal(ie.getId());
            SelValueExt sel = new SelValueExt(aidNameUnitId, SelOpcode.EQ, new TS_Value(u, 15));
            query.condSeq[0].value(sel);
            query.joinSeq = new JoinDef[relSize];
            for (int i3 = 0; i3 < relSize; ++i3) {
                rel = aeRel[i3];
                query.joinSeq[i3] = new JoinDef();
                query.joinSeq[i3].refName = rel.getRelationName();
                query.joinSeq[i3].fromAID = rel.getElem2().getId();
                query.joinSeq[i3].toAID = rel.getElem1().getId();
                query.joinSeq[i3].joiningType = JoinType.JTDEFAULT;
            }
            query.groupBy = new AIDName[0];
            query.orderBy = new SelOrder[0];
            ResultSetExt[] rsext = aea.getInstancesExt(query, 0);
            return rsext[0];
        }
        return null;
    }

    static class RelOrder
    implements Comparable {
        int idHigh;
        int idLow;
        int idx;

        public RelOrder(int idHigh, int idLow, int idx) {
            this.idHigh = idHigh;
            this.idLow = idLow;
            this.idx = idx;
        }

        public RelOrder(int id, int idx) {
            this(0, id, idx);
        }

        public int compareTo(Object o) {
            int diff = this.idHigh - ((RelOrder)o).idHigh;
            if (diff == 0) {
                diff = this.idLow - ((RelOrder)o).idLow;
            }
            return diff;
        }

        public boolean notEqual(T_LONGLONG ll) {
            return ll.low != this.idLow || ll.high != this.idHigh;
        }

        public T_LONGLONG getT_LONGLONG() {
            return new T_LONGLONG(this.idHigh, this.idLow);
        }
    }

    static class Order
    implements Comparable {
        int idHigh;
        int idLow;
        Object data;

        public Order(int id) {
            this(0, id);
        }

        public Order(int idHigh, int idLow) {
            this.idHigh = idHigh;
            this.idLow = idLow;
        }

        public int compareTo(Object o) {
            int diff = this.idHigh - ((Order)o).idHigh;
            if (diff == 0) {
                diff = this.idLow - ((Order)o).idLow;
            }
            return diff;
        }
    }

    static class Model
    implements OdsxTableModelInterface {
        Vector colHeader = new Vector();
        Object[][] data = null;
        long time;

        public void addTableModelListener(TableModelListener l) {
        }

        public Class getColumnClass(int columnIndex) {
            try {
                return this.data[columnIndex][0].getClass();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        public int getColumnCount() {
            return this.colHeader.size();
        }

        public String getColumnName(int columnIndex) {
            return (String)this.colHeader.get(columnIndex);
        }

        public int getRowCount() {
            try {
                return this.data[0].length;
            }
            catch (Throwable throwable) {
                return 0;
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[columnIndex][rowIndex];
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public void removeTableModelListener(TableModelListener l) {
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public String toString() {
            String str;
            StringBuffer ret = new StringBuffer();
            int cCount = this.getColumnCount();
            int rCount = this.getRowCount();
            int[] width = new int[cCount];
            String[] space = new String[cCount];
            for (int c = 0; c < cCount; ++c) {
                str = (String)this.colHeader.get(c);
                width[c] = str.length();
                for (int r = 0; r < rCount; ++r) {
                    width[c] = Math.max(width[c], this.data[c][r].toString().length());
                }
                char[] s = new char[width[c] + 1];
                Arrays.fill(s, ' ');
                space[c] = new String(s);
                if (c == 0) {
                    ret.append("| ").append(str);
                } else {
                    ret.append(" ").append(str);
                }
                ret.append(space[c].substring(0, width[c] - str.length() + 1)).append("|");
            }
            char[] s = new char[ret.length()];
            Arrays.fill(s, '-');
            ret.append("\n").append(new String(s)).append("\n");
            for (int r = 0; r < rCount; ++r) {
                str = this.data[0][r].toString();
                ret.append("| ").append(str);
                ret.append(space[0].substring(0, width[0] - str.length() + 1)).append("|");
                for (int c = 1; c < cCount; ++c) {
                    str = this.data[c][r].toString();
                    ret.append(" ").append(str);
                    ret.append(space[c].substring(0, width[c] - str.length() + 1)).append("|");
                }
                ret.append("\n");
            }
            ret.append("\n" + cCount + " columns " + rCount + " rows\nelapsed time " + this.time / 1000L + "," + this.time % 1000L + " sec\n");
            return ret.toString();
        }

        public long getTimeToLoad() {
            return this.time;
        }
    }
}

