/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkTableSorter;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionElementInterface;
import com.highqsoft.odsx.OdsxApplicationElement;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxInstanceElement;
import com.highqsoft.odsx.OdsxPresentorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.NameValueUnit;
import org.asam.ods.Relationship;
import org.asam.ods.TS_Union;

public class OdsxTablePresentorPanel
extends OdsxPresentorPanel {
    public static final String version = "$Revision: 1.6 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    protected JTabbedPane jTabbedPane;
    HashMap tabHash;
    HashMap nameHash;
    HashMap schedule;
    Object SCHEDULE_LOCK = new Object();

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)OdsxTablePresentorPanel.class, (FwkDescriptionInterface)descriptor);
    }

    public OdsxTablePresentorPanel() {
        this.setDescriptor(OdsxTablePresentorPanel.getDescriptor());
        int width = 600;
        try {
            width = Integer.parseInt(FwkPropertyBus.getProperty((String)"OdsxTablePresentorPanel.Width"));
        }
        catch (Throwable tWidth) {
            // empty catch block
        }
        int height = 400;
        try {
            height = Integer.parseInt(FwkPropertyBus.getProperty((String)"OdsxTablePresentorPanel.Height"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tabHash = new HashMap();
        this.nameHash = new HashMap();
        this.schedule = new HashMap();
        this.setLayout(new BorderLayout());
        this.jTabbedPane = new JTabbedPane(1);
        this.add("Center", this.jTabbedPane);
        this.setPreferredSize(new Dimension(width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPresentable(OdsxPresentableElementInterface presentable) {
        String[] titles;
        if (!this.isVisible()) {
            Object object = this.SCHEDULE_LOCK;
            synchronized (object) {
                this.schedule.put(presentable, presentable);
            }
            return;
        }
        this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, FwkPropertyBus.getProperty((String)"OdsxTablePresentorPanel.Text.CreatingPanel")));
        boolean isSession = presentable instanceof OdsxSessionElementInterface;
        JScrollPane jScrollPane = null;
        if (!isSession && (titles = this.getColumnTitles(presentable)).length != 0) {
            Object[] cTitle = new String[titles.length];
            OdsxFilterInterface filter = presentable.getOdsxFilter();
            for (int i = titles.length - 1; i >= 0; --i) {
                cTitle[i] = filter.getTranslatedKey(titles[i], titles[i]);
            }
            TablePresentorModel model = new TablePresentorModel(this.getColumnValues(presentable, titles), cTitle);
            FwkTableSorter tableSorter = new FwkTableSorter((TableModel)model);
            JTable table = new JTable((TableModel)tableSorter);
            table.setAutoResizeMode(0);
            tableSorter.addMouseListenerToHeaderInTable(table);
            jScrollPane = new JScrollPane(table);
        }
        OdsxFilterInterface filter = presentable.getOdsxFilter();
        if (jScrollPane == null) {
            JTextArea jTextArea = new JTextArea();
            if (filter != null) {
                jTextArea.setForeground(filter.getColor(presentable));
            } else {
                jTextArea.setForeground(Color.black);
            }
            jTextArea.setEditable(false);
            jTextArea.setSelectionStart(0);
            jTextArea.setSelectionEnd(0);
            TextWriter writer = new TextWriter(jTextArea);
            try {
                presentable.getPresentationString(writer, "All", FwkContainer.getLocale(), presentable.getOdsxFilter());
            }
            catch (Throwable t) {
                // empty catch block
            }
            writer.close();
            jScrollPane = new JScrollPane(jTextArea);
        }
        this.jTabbedPane.add(presentable.getShortName(50), jScrollPane);
        this.nameHash.put(presentable, presentable.getName());
        this.tabHash.put(presentable.getName(), jScrollPane);
        int count = this.tabHash.size() - 1;
        if (filter != null) {
            this.jTabbedPane.setIconAt(count, (Icon)filter.getIcon(presentable));
            this.jTabbedPane.setForegroundAt(count, filter.getColor(presentable));
        } else {
            this.jTabbedPane.setForegroundAt(count, Color.black);
        }
        this.jTabbedPane.setToolTipTextAt(count, presentable.getName());
        this.jTabbedPane.setSelectedIndex(count);
        this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePresentable(OdsxPresentableElementInterface presentable) {
        Object object = this.SCHEDULE_LOCK;
        synchronized (object) {
            this.schedule.remove(presentable);
        }
        try {
            JScrollPane panel = null;
            Object name = this.nameHash.remove(presentable);
            if (name != null && (panel = (JScrollPane)this.tabHash.remove(presentable.getName())) != null) {
                this.jTabbedPane.remove(panel);
            }
        }
        catch (Throwable th) {
            System.out.println(this.getClass().getName() + ".removePresentable, th = " + th);
        }
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Vector<OdsxPresentableElementInterface> vec = new Vector<OdsxPresentableElementInterface>();
                    Object object = OdsxTablePresentorPanel.this.SCHEDULE_LOCK;
                    synchronized (object) {
                        Iterator it = OdsxTablePresentorPanel.this.schedule.keySet().iterator();
                        while (it.hasNext()) {
                            vec.add((OdsxPresentableElementInterface)it.next());
                        }
                    }
                    int size = vec.size();
                    for (int i = 0; i < size; ++i) {
                        OdsxTablePresentorPanel.this.addPresentable((OdsxPresentableElementInterface)vec.get(i));
                    }
                    OdsxTablePresentorPanel.this.schedule.clear();
                }
            });
            t.start();
        }
    }

    public String[] getColumnTitles(OdsxPresentableElementInterface presentable) {
        String[] ret;
        block12: {
            ret = new String[]{};
            try {
                if (presentable instanceof OdsxApplicationElementInterface) {
                    ret = this.getApplicationElementAttributes(presentable, ((OdsxApplicationElement)presentable).getApplicationElement());
                    break block12;
                }
                if (presentable instanceof OdsxInstanceElementInterface) {
                    InstanceElement ie = ((OdsxInstanceElementInterface)presentable).getInstanceElement();
                    ApplicationElement ae = null;
                    if (ie.getApplicationElement().getBaseElement().getType().compareTo("AoMeasurement") == 0) {
                        ApplicationStructure as = ie.getApplicationElement().getApplicationStructure();
                        try {
                            ApplicationElement[] aeArray = as.getElementsByBaseType("AoMeasurementQuantity");
                            if (aeArray != null && aeArray.length > 0) {
                                ae = aeArray[0];
                            }
                        }
                        catch (Throwable tAe) {}
                    } else {
                        ApplicationElement[] aeArray = ie.getApplicationElement().getRelatedElementsByRelationship(Relationship.CHILD);
                        if (aeArray != null && aeArray.length > 0) {
                            ae = aeArray[0];
                        }
                    }
                    if (ae != null) {
                        ret = this.getApplicationElementAttributes(presentable, ae);
                    }
                    break block12;
                }
                if (!(presentable instanceof OdsxColumnInterface) && !(presentable instanceof OdsxSessionElementInterface)) {
                    System.out.println(this.getClass().getName() + ".getColumnTitle unknown PresentableElement class " + presentable.getClass().getName());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return ret;
    }

    protected String[] getApplicationElementAttributes(OdsxPresentableElementInterface presentable, ApplicationElement ae) {
        String[] ret = new String[]{};
        try {
            ApplicationAttribute[] aas = ae.getAttributes("*");
            Vector<String> aa = new Vector<String>();
            OdsxFilterInterface filter = presentable.getOdsxFilter();
            int size = aas.length;
            if (filter == null || !filter.getEnabled()) {
                for (int i = 0; i < size; ++i) {
                    try {
                        aa.add(aas[i].getName());
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            } else if (filter.isVisible(presentable)) {
                for (int i = 0; i < size; ++i) {
                    try {
                        String key = aas[i].getName();
                        if (!filter.isVisible(key, true)) continue;
                        aa.add(key);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            ret = new String[aa.size()];
            ret = aa.toArray(ret);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    public String[][] getColumnValues(OdsxPresentableElementInterface presentable, String[] titles) {
        String[][] ret;
        block13: {
            ret = new String[0][0];
            try {
                if (presentable instanceof OdsxApplicationElementInterface) {
                    ApplicationElement ae = ((OdsxApplicationElement)presentable).getApplicationElement();
                    InstanceElementIterator it = ae.getInstances("*");
                    ret = this.getInstanceAttributeValues(it, titles);
                    it.destroy();
                    break block13;
                }
                if (presentable instanceof OdsxInstanceElementInterface) {
                    InstanceElementIterator it;
                    InstanceElement ie = ((OdsxInstanceElement)presentable).getInstanceElement();
                    ApplicationElement ae = ie.getApplicationElement();
                    if (ae.getBaseElement().getType().compareTo("AoMeasurement") == 0) {
                        ApplicationStructure as = ae.getApplicationStructure();
                        try {
                            ApplicationElement[] aeArray = as.getElementsByBaseType("AoMeasurementQuantity");
                            if (aeArray != null && aeArray.length > 0) {
                                ae = aeArray[0];
                            }
                        }
                        catch (Throwable tAe) {}
                    } else {
                        ApplicationElement[] aeArray = ae.getRelatedElementsByRelationship(Relationship.CHILD);
                        if (aeArray != null && aeArray.length > 0) {
                            ae = aeArray[0];
                        }
                    }
                    if (ae == null) break block13;
                    try {
                        ApplicationRelation[] rels = ae.getApplicationStructure().getRelations(ie.getApplicationElement(), ae);
                        it = ie.getRelatedInstances(rels[0], "*");
                    }
                    catch (Throwable tRel) {
                        it = ae.getInstances("*");
                    }
                    ret = this.getInstanceAttributeValues(it, titles);
                    it.destroy();
                    break block13;
                }
                if (!(presentable instanceof OdsxColumnInterface) && !(presentable instanceof OdsxSessionElementInterface)) {
                    System.out.println(this.getClass().getName() + ".getColumnTitle unknown PresentableElement class " + presentable.getClass().getName());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return ret;
    }

    protected String[][] getInstanceAttributeValues(InstanceElementIterator it, String[] titles) {
        Locale locale = FwkContainer.getLocale();
        boolean deLang = locale.getLanguage().compareTo("de") == 0;
        String[][] ret = new String[0][0];
        try {
            int height = it.getCount();
            int width = titles.length;
            ret = new String[height][width];
            for (int i = 0; i < height; ++i) {
                InstanceElement ie = it.nextOne();
                for (int j = 0; j < width; ++j) {
                    try {
                        NameValueUnit nvu = ie.getValue(titles[j]);
                        TS_Union u = nvu.value.u;
                        short flag = nvu.value.flag;
                        if (flag != 0) {
                            ret[i][j] = OdsxHelper.ts_unionToString(u, 5);
                            continue;
                        }
                        if (deLang) {
                            ret[i][j] = "<ung\u00fcltig>";
                            continue;
                        }
                        ret[i][j] = "<invalid>";
                        continue;
                    }
                    catch (Throwable tVal) {
                        ret[i][j] = deLang ? "<ung\u00fcltig>" : "<invalid>";
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret;
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("ODS Table-Presentor Panel");
        descriptor.setTitleName("OdsxTablePresentorPanel.Text.Title");
        descriptor.setName(OdsxTablePresentorPanel.class.getName());
        descriptor.setCreationDate("$Date: 2007/10/15 14:34:02 $", null);
        descriptor.setIconKey("Icon.Table");
    }

    public class TextWriter
    extends Writer {
        JTextArea area;

        public TextWriter(JTextArea area) {
            this.area = area;
        }

        public void close() {
            this.flush();
        }

        public void flush() {
            this.area.repaint();
        }

        public void write(char[] cbuf, int off, int len) {
            if (off < 0) {
                off = 0;
            }
            this.area.append(new String(cbuf, off, len));
        }
    }

    public class TablePresentorModel
    extends DefaultTableModel {
        public TablePresentorModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

