/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.util.StringFormat;
import java.util.Locale;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.AttrType;
import org.asam.ods.DataType;
import org.asam.ods.InstanceElement;
import org.asam.ods.TS_Union;

public class OdsxTextPresentor {
    protected static final String SEPARATOR = "\n==================================================================================\n";

    public static StringBuffer getPresentationString(InstanceElement ie) {
        return OdsxTextPresentor.getPresentationString(ie, FwkContainer.getLocale());
    }

    public static StringBuffer getPresentationString(InstanceElement ie, Locale locale) {
        StringBuffer buffer;
        block64: {
            buffer = new StringBuffer();
            try {
                String baName;
                boolean isLocalColumn;
                buffer.append(ie.getName() + "\n" + ie.getAsamPath());
                buffer.append(SEPARATOR);
                ApplicationElement ae = ie.getApplicationElement();
                String[] attrNames = ie.listAttributes("*", AttrType.ALL);
                int size = attrNames.length;
                boolean bl = isLocalColumn = ae.getBaseElement().getType().compareTo("AoLocalColumn") == 0;
                if (isLocalColumn) {
                    String[] arr = new String[attrNames.length - 1];
                    int counter = 0;
                    for (int i = 0; i < size; ++i) {
                        try {
                            baName = ae.getAttributeByName(attrNames[i]).getBaseAttribute().getName();
                            if (baName.compareTo("values") == 0 || baName.compareTo("flags") == 0) continue;
                            arr[counter++] = attrNames[i];
                            continue;
                        }
                        catch (Throwable t) {
                            arr[counter++] = attrNames[i];
                        }
                    }
                    attrNames = arr;
                    size = counter;
                }
                for (int i = 0; i < size; ++i) {
                    buffer.append("\n" + StringFormat.printf((String)"%-30.30s", (String)attrNames[i]));
                    try {
                        baName = ae.getAttributeByName(attrNames[i]).getBaseAttribute().getName();
                    }
                    catch (Throwable t) {
                        baName = "";
                    }
                    TS_Union u = ie.getValue((String)attrNames[i]).value.u;
                    short flag = ie.getValue((String)attrNames[i]).value.flag;
                    DataType dt = u.discriminator();
                    String type = StringFormat.printf((String)"[%15.15s]", (String)baName) + StringFormat.printf((String)" %-12.12s", (String)OdsxHelper.datatypeToString(dt)) + " (" + (flag == 0 ? "invalid" : "  valid") + ")";
                    buffer.append("\t" + type);
                    String val = OdsxHelper.ts_unionToString(u);
                    buffer.append(val.length() == 0 ? "\t<empty>" : "\t" + val);
                }
                if (!isLocalColumn) break block64;
                buffer.append(SEPARATOR);
                TS_Union valU = ie.getValueByBaseName((String)"values").value.u;
                short valF = ie.getValueByBaseName((String)"values").value.flag;
                DataType dt = valU.discriminator();
                buffer.append("\nvalues are " + (valF == 0 ? "invalid" : "valid"));
                TS_Union flagU = ie.getValueByBaseName((String)"flags").value.u;
                short flagF = ie.getValueByBaseName((String)"flags").value.flag;
                if (flagF == 0) {
                    buffer.append("\nFlags are not valid!");
                }
                short[] flags = null;
                switch (flagU.discriminator().value()) {
                    case 16: {
                        flags = flagU.shortSeq();
                        break;
                    }
                    case 20: {
                        int[] lTmp = flagU.longSeq();
                        size = lTmp.length;
                        flags = new short[size];
                        for (int i = 0; i < size; ++i) {
                            flags[i] = (short)lTmp[i];
                        }
                        break;
                    }
                    case 19: {
                        byte[] bTmp = flagU.byteSeq();
                        size = bTmp.length;
                        flags = new short[size];
                        for (int i = 0; i < size; ++i) {
                            flags[i] = bTmp[i];
                        }
                        break;
                    }
                    default: {
                        buffer.append("\nNo flags available.");
                    }
                }
                buffer.append("\n(*) - valid / (-) - invalid / (?) - unknown flag\n");
                switch (dt.value()) {
                    case 18: {
                        boolean[] bvalue = valU.booleanSeq();
                        size = bvalue.length;
                        for (int i = 0; i < size; ++i) {
                            if (flags == null || flags.length <= i) {
                                buffer.append("\n(?[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + bvalue[i]);
                                continue;
                            }
                            if (flags == null || flags[i] != 0) {
                                buffer.append("\n(*[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + bvalue[i]);
                                continue;
                            }
                            buffer.append("\n(-[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + bvalue[i]);
                        }
                        break;
                    }
                    case 19: {
                        byte[] byvalue = valU.byteSeq();
                        size = byvalue.length;
                        for (int i = 0; i < size; ++i) {
                            if (flags == null || flags.length <= i) {
                                buffer.append("\n(?[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + byvalue[i]);
                                continue;
                            }
                            if (flags == null || flags[i] != 0) {
                                buffer.append("\n(*[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + byvalue[i]);
                                continue;
                            }
                            buffer.append("\n(-[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + byvalue[i]);
                        }
                        break;
                    }
                    case 23: {
                        buffer.append("(?) <DS_COMPLEX unsupported>");
                        break;
                    }
                    case 26: {
                        String[] dtvalue = valU.dateSeq();
                        size = dtvalue.length;
                        for (int i = 0; i < size; ++i) {
                            if (flags == null || flags.length <= i) {
                                buffer.append("\n(?[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + dtvalue[i]);
                                continue;
                            }
                            if (flags == null || flags[i] != 0) {
                                buffer.append("\n(*[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + dtvalue[i]);
                                continue;
                            }
                            buffer.append("\n(-[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + dtvalue[i]);
                        }
                        break;
                    }
                    case 24: {
                        buffer.append("(?) <DS_DCOMPLEX unsupported>");
                        break;
                    }
                    case 21: {
                        double[] dvalue = valU.doubleSeq();
                        size = dvalue.length;
                        for (int i = 0; i < size; ++i) {
                            if (flags == null || flags.length <= i) {
                                buffer.append("\n(?[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + dvalue[i]);
                                continue;
                            }
                            if (flags == null || flags[i] != 0) {
                                buffer.append("\n(*[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + dvalue[i]);
                                continue;
                            }
                            buffer.append("\n(-[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + dvalue[i]);
                        }
                        break;
                    }
                    case 17: {
                        float[] fvalue = valU.floatSeq();
                        size = fvalue.length;
                        for (int i = 0; i < size; ++i) {
                            if (flags == null || flags.length <= i) {
                                buffer.append("\n(?[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + fvalue[i]);
                                continue;
                            }
                            if (flags == null || flags[i] != 0) {
                                buffer.append("\n(*[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + fvalue[i]);
                                continue;
                            }
                            buffer.append("\n(-[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + fvalue[i]);
                        }
                        break;
                    }
                    case 20: {
                        int[] lvalue = valU.longSeq();
                        size = lvalue.length;
                        for (int i = 0; i < size; ++i) {
                            if (flags == null || flags.length <= i) {
                                buffer.append("\n(?[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + lvalue[i]);
                                continue;
                            }
                            if (flags == null || flags[i] != 0) {
                                buffer.append("\n(*[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + lvalue[i]);
                                continue;
                            }
                            buffer.append("\n(-[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + lvalue[i]);
                        }
                        break;
                    }
                    case 22: {
                        buffer.append("(?) <DS_LONGLONG unsupported>");
                        break;
                    }
                    case 16: {
                        short[] ivalue = valU.shortSeq();
                        size = ivalue.length;
                        for (int i = 0; i < size; ++i) {
                            if (flags == null || flags.length <= i) {
                                buffer.append("\n(?[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + ivalue[i]);
                                continue;
                            }
                            if (flags == null || flags[i] != 0) {
                                buffer.append("\n(*[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + ivalue[i]);
                                continue;
                            }
                            buffer.append("\n(-[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + ivalue[i]);
                        }
                        break;
                    }
                    case 15: {
                        String[] svalue = valU.stringSeq();
                        size = svalue.length;
                        for (int i = 0; i < size; ++i) {
                            if (flags == null || flags.length <= i) {
                                buffer.append("\n(?[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + svalue[i]);
                                continue;
                            }
                            if (flags == null || flags[i] != 0) {
                                buffer.append("\n(*[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + svalue[i]);
                                continue;
                            }
                            buffer.append("\n(-[" + StringFormat.printf((String)"%7d", (int)i) + "])\t" + svalue[i]);
                        }
                        break;
                    }
                    case 27: {
                        byte[][] val = valU.bytestrSeq();
                        size = val.length;
                        for (int i = 0; i < size; ++i) {
                            if (flags == null || flags.length <= i) {
                                buffer.append("\n(?[" + StringFormat.printf((String)"%7d", (int)i) + "])\t");
                            } else if (flags == null || flags[i] != 0) {
                                buffer.append("\n(*[" + StringFormat.printf((String)"%7d", (int)i) + "])\t");
                            } else {
                                buffer.append("\n(-[" + StringFormat.printf((String)"%7d", (int)i) + "])\t");
                            }
                            int streamSize = val[i].length;
                            for (int j = 0; j < streamSize; ++j) {
                                int out = (val[i][j] >> 4 & 0xF) + 48;
                                if (out > 57) {
                                    out = out - 1 - 57 + 65;
                                }
                                buffer.append(out);
                                out = (val[i][j] & 0xF) + 48;
                                if (out > 57) {
                                    out = out - 1 - 57 + 65;
                                }
                                buffer.append(out);
                                buffer.append(" ");
                            }
                        }
                        break;
                    }
                    case 0: {
                        buffer.append("(?) <???>");
                        break;
                    }
                    default: {
                        buffer.append("(?) <..>");
                    }
                }
            }
            catch (Throwable th) {
                FwkContainer.showErrorMessage(null, null, (Throwable)th);
            }
        }
        return buffer;
    }

    public static StringBuffer getPresentationString(ApplicationElement ae) {
        return OdsxTextPresentor.getPresentationString(ae, FwkContainer.getLocale());
    }

    public static StringBuffer getPresentationString(ApplicationElement ae, Locale locale) {
        StringBuffer buffer = new StringBuffer();
        try {
            String baName;
            boolean isLocalColumn;
            buffer.append(ae.getName() + SEPARATOR);
            String[] attrNames = ae.listAttributes("*");
            int size = attrNames.length;
            boolean bl = isLocalColumn = ae.getBaseElement().getType().compareTo("AoLocalColumn") == 0;
            if (isLocalColumn) {
                String[] arr = new String[attrNames.length - 1];
                int counter = 0;
                for (int i = 0; i < size; ++i) {
                    try {
                        baName = ae.getAttributeByName(attrNames[i]).getBaseAttribute().getName();
                        if (baName.compareTo("values") == 0 || baName.compareTo("flags") == 0) continue;
                        arr[counter++] = attrNames[i];
                        continue;
                    }
                    catch (Throwable t) {
                        arr[counter++] = attrNames[i];
                    }
                }
                attrNames = arr;
                size = counter;
            }
            for (int i = 0; i < size; ++i) {
                buffer.append("\n" + StringFormat.printf((String)"%-30.30s", (String)attrNames[i]));
                try {
                    ApplicationAttribute aa = ae.getAttributeByName(attrNames[i]);
                    baName = aa.getBaseAttribute().getName();
                    DataType dt = aa.getDataType();
                    buffer.append("\t" + StringFormat.printf((String)"[%15.15s]", (String)baName) + StringFormat.printf((String)" %-12.12s\n", (String)OdsxHelper.datatypeToString(dt)));
                    continue;
                }
                catch (Throwable t) {
                    buffer.append("\n");
                }
            }
        }
        catch (Throwable th) {
            FwkContainer.showErrorMessage(null, null, (Throwable)th);
        }
        return buffer;
    }
}

