/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx;

import com.highqsoft.fwk.FwkApplicationBus;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkItem;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkServiceProvider;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.fwk.factory.FwkDescriptionFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.fwk.listener.FwkPopupMenuUnregisterListener;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkCommandInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDescriptionInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPathInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxTextPresentorMenuInterface;
import com.highqsoft.interfaces.p2d.P2DAttributorInterface;
import com.highqsoft.interfaces.p2d.P2DBoundingBoxInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DLayouterInterface;
import com.highqsoft.odsx.OdsxApplicationElement;
import com.highqsoft.odsx.OdsxColumn;
import com.highqsoft.odsx.OdsxInstanceElement;
import com.highqsoft.odsx.OdsxPathAttributor;
import com.highqsoft.odsx.OdsxPresentableElement;
import com.highqsoft.odsx.OdsxPresentorPanel;
import com.highqsoft.odsx.OdsxSelectHelper;
import com.highqsoft.odsx.command.OdsxLayouterCommand;
import com.highqsoft.odsx.command.OdsxPublicValueMatrixCommand;
import com.highqsoft.odsx.command.OdsxUnpublicValueMatrixCommand;
import com.highqsoft.p2d.P2DBoundingBox;
import com.highqsoft.p2d.P2DCanvas;
import com.highqsoft.p2d.P2DPlot;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuListener;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.BaseRelation;
import org.asam.ods.RelationRange;
import org.asam.ods.T_LONGLONG;

public class OdsxTextPresentorPanel
extends OdsxPresentorPanel {
    public static final String version = "$Revision: 1.16 $";
    protected static final FwkDescriptionInterface descriptor = new FwkDescription();
    static double hLastDividerLocation;
    static double vLastDividerLocation;
    protected JTabbedPane jTabbedPane;
    HashMap tabHash;
    HashMap nameHash;
    HashMap schedule;
    Object SCHEDULE_LOCK = new Object();
    String presentationSpec;

    public String getVersion() {
        return version;
    }

    public static FwkDescriptionInterface getDescriptor() {
        return FwkDescriptionFactory.getDescriptor((Class)OdsxTextPresentorPanel.class, (FwkDescriptionInterface)descriptor);
    }

    public OdsxTextPresentorPanel() {
        this.setDescriptor(OdsxTextPresentorPanel.getDescriptor());
        this.presentationSpec = null;
        int width = 600;
        try {
            width = Integer.parseInt(FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.Width"));
        }
        catch (Throwable tWidth) {
            // empty catch block
        }
        int height = 400;
        try {
            height = Integer.parseInt(FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.Height"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.tabHash = new HashMap();
        this.nameHash = new HashMap();
        this.schedule = new HashMap();
        this.setLayout(new BorderLayout());
        this.jTabbedPane = new JTabbedPane(1);
        this.add("Center", this.jTabbedPane);
        this.setPreferredSize(new Dimension(width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPresentable(OdsxPresentableElementInterface presentable) {
        this.removePresentable(presentable);
        if (!this.isVisible()) {
            Object object = this.SCHEDULE_LOCK;
            synchronized (object) {
                this.schedule.put(presentable, presentable);
            }
            return;
        }
        this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.Text.CreatingPanel")));
        presentable.addDataItemChangeListener(this);
        JTextArea jTextArea = null;
        PlotThread plotThread = null;
        RelThread relThread = null;
        try {
            boolean isMeasurementInstance = presentable instanceof OdsxInstanceElementInterface && presentable.getBaseName().compareToIgnoreCase("AoMeasurement") == 0;
            boolean isSubMatrixInstance = presentable instanceof OdsxInstanceElementInterface && presentable.getBaseName().compareToIgnoreCase("AoSubMatrix") == 0;
            boolean isColumn = presentable instanceof OdsxColumnInterface;
            boolean displayRelations = true;
            try {
                String value = FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.DisplayRelations");
                if (value.toLowerCase().compareTo("false") == 0) {
                    displayRelations = false;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            boolean displayPlot = true;
            if (isColumn) {
                try {
                    displayPlot = FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.DisplayColumnPlot", (boolean)true);
                    if (displayPlot) {
                        displayPlot = ((OdsxColumn)presentable).getCount() > 1;
                    }
                }
                catch (Throwable t) {
                    displayPlot = false;
                }
            } else {
                displayPlot = false;
            }
            SplitPanePropListener pcl = new SplitPanePropListener(displayPlot);
            JSplitPane hSplitPane = new JSplitPane();
            hSplitPane.setDividerSize(5);
            hSplitPane.setOrientation(0);
            this.nameHash.put(presentable, presentable.getName());
            this.tabHash.put(presentable, hSplitPane);
            JSplitPane vSplitPane = new JSplitPane();
            vSplitPane.setDividerSize(5);
            vSplitPane.setOrientation(1);
            hSplitPane.setBottomComponent(vSplitPane);
            jTextArea = new JTextArea();
            OdsxFilterInterface filter = presentable.getOdsxFilter();
            if (filter == null) {
                jTextArea.setForeground(Color.black);
            } else {
                jTextArea.setForeground(filter.getColor(presentable));
            }
            jTextArea.setEditable(false);
            JPanel panel = new JPanel(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            panel.add("Center", jScrollPane);
            JPanel buttonPane = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            buttonPane.setLayout(gbl);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(5, 5, 5, 5);
            Object[] menu = FwkServiceProvider.getInstance().lookup(OdsxTextPresentorMenuInterface.class);
            if (menu != null) {
                int size = menu.length;
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        OdsxTextPresentorMenuInterface m = (OdsxTextPresentorMenuInterface)menu[i];
                        m.setPresentableElement(presentable);
                        FwkCommandInterface[] cmds = m.getCommands();
                        int c = cmds.length;
                        for (int j = 0; j < c; ++j) {
                            this.addCommand(cmds[j]);
                        }
                    }
                }
            } else {
                FwkCommand cmd;
                FwkApplicationInterface[] layouters;
                FwkCommandInterface[] cmdArr = presentable.getCommands();
                if (cmdArr != null && cmdArr.length > 0) {
                    JButton but = new JButton(FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.Text.Properties"));
                    but.putClientProperty("Commands", cmdArr);
                    but.addActionListener(new ActionListener(){
                        JPopupMenu popup = null;

                        public void actionPerformed(ActionEvent ev) {
                            JButton but = (JButton)ev.getSource();
                            if (this.popup == null) {
                                this.popup = FwkGUIFactory.createPopupMenu((FwkCommandInterface[])((FwkCommandInterface[])but.getClientProperty("Commands")));
                            }
                            if (this.popup != null) {
                                this.popup.addPopupMenuListener((PopupMenuListener)FwkPopupMenuUnregisterListener.getInstance());
                                this.popup.show(but, 0, but.getHeight());
                            }
                        }
                    });
                    buttonPane.add((Component)but, gbc);
                    ++gbc.gridx;
                }
                if ((layouters = FwkApplicationBus.findMultipleApplications((String)"*", (DataFlavor[])FwkContainer.getDataFlavor((Class)P2DLayouterInterface.class))) != null && layouters.length != 0) {
                    cmd = new OdsxLayouterCommand((FwkControllerInterface)presentable);
                    buttonPane.add((Component)FwkGUIFactory.createButton((FwkCommandInterface)cmd, null), gbc);
                    ++gbc.gridx;
                }
                if (isMeasurementInstance || isSubMatrixInstance) {
                    cmd = new OdsxPublicValueMatrixCommand((FwkControllerInterface)presentable);
                    buttonPane.add((Component)FwkGUIFactory.createButton((FwkCommandInterface)cmd, null), gbc);
                    ++gbc.gridx;
                    cmd = new OdsxUnpublicValueMatrixCommand((FwkControllerInterface)presentable);
                    buttonPane.add((Component)FwkGUIFactory.createButton((FwkCommandInterface)cmd, null), gbc);
                    ++gbc.gridx;
                }
            }
            panel.add("South", buttonPane);
            hSplitPane.setTopComponent(panel);
            ApplicationRelation[] rel = null;
            if (displayRelations) {
                try {
                    rel = presentable.getRelations();
                }
                catch (Throwable tRel) {
                    // empty catch block
                }
            }
            if (rel != null) {
                JPanel p = new JPanel();
                p.setLayout(new BorderLayout());
                vSplitPane.setLeftComponent(p);
                relThread = new RelThread(p, presentable, rel);
            } else {
                vSplitPane.setLeftComponent(new JLabel(""));
            }
            if (displayPlot) {
                JPanel plotPanel = new JPanel();
                plotPanel.setLayout(new BorderLayout());
                vSplitPane.setRightComponent(plotPanel);
                plotThread = new PlotThread(plotPanel, presentable);
            } else {
                vSplitPane.setRightComponent(new JLabel(""));
            }
            this.jTabbedPane.add(presentable.getShortName(50), hSplitPane);
            int count = this.tabHash.size() - 1;
            if (filter != null) {
                this.jTabbedPane.setIconAt(count, (Icon)filter.getIcon(presentable));
            }
            if (filter != null) {
                this.jTabbedPane.setForegroundAt(count, filter.getColor(presentable));
            }
            this.jTabbedPane.setToolTipTextAt(count, presentable.getName());
            jTextArea.setSelectionStart(0);
            jTextArea.setSelectionEnd(0);
            this.jTabbedPane.setSelectedIndex(count);
            hSplitPane.setDividerLocation(hLastDividerLocation);
            if (displayPlot) {
                vSplitPane.setDividerLocation(vLastDividerLocation);
            } else {
                vSplitPane.setDividerLocation(0.99);
            }
            vSplitPane.addPropertyChangeListener(pcl);
            hSplitPane.addPropertyChangeListener(pcl);
        }
        catch (Throwable th) {
            System.out.println(this.getClass().getName() + ".addPresentable, th = " + th);
            FwkContainer.showErrorMessage((Container)((Object)this), null, null, (Throwable)th);
        }
        TextThread textThread = null;
        if (jTextArea != null) {
            textThread = new TextThread(jTextArea, presentable);
            this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)textThread, 2, FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.Text.CreatingText")));
        }
        if (relThread != null) {
            this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent(relThread, 2, FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.Text.CreatingRelationList")));
        }
        if (plotThread != null) {
            this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent(plotThread, 2, FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.Text.CreatingPlot")));
        }
        if (textThread != null) {
            textThread.start();
        }
        if (relThread != null) {
            relThread.start();
        }
        if (plotThread != null) {
            plotThread.start();
        }
        this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePresentable(OdsxPresentableElementInterface presentable) {
        Object object = this.SCHEDULE_LOCK;
        synchronized (object) {
            this.schedule.remove(presentable);
        }
        presentable.removeDataItemChangeListener(this);
        try {
            Object name = this.nameHash.remove(presentable);
            JSplitPane pane = null;
            if (name != null) {
                pane = (JSplitPane)this.tabHash.remove(presentable);
            }
            if (pane != null) {
                this.jTabbedPane.remove(pane);
            }
        }
        catch (Throwable th) {
            System.out.println(this.getClass().getName() + ".removePresentable, th = " + th);
        }
    }

    protected String getPresentationSpec() {
        if (this.presentationSpec == null) {
            String spec = FwkPropertyBus.getProperty((String)"OdsxTextPresentorPanel.Text.MaxValueCount", (String)null);
            spec = spec == null ? "All" : "[" + spec + "]";
            return spec;
        }
        return this.presentationSpec;
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            Thread t = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Vector<OdsxPresentableElementInterface> vec = new Vector<OdsxPresentableElementInterface>();
                    Object object = OdsxTextPresentorPanel.this.SCHEDULE_LOCK;
                    synchronized (object) {
                        Iterator it = OdsxTextPresentorPanel.this.schedule.keySet().iterator();
                        while (it.hasNext()) {
                            vec.add((OdsxPresentableElementInterface)it.next());
                        }
                    }
                    int size = vec.size();
                    for (int i = 0; i < size; ++i) {
                        OdsxTextPresentorPanel.this.addPresentable((OdsxPresentableElementInterface)vec.get(i));
                    }
                    OdsxTextPresentorPanel.this.schedule.clear();
                }
            });
            t.start();
        }
    }

    static {
        descriptor.setAuthor("Andreas Hofmann");
        descriptor.setBuild(version);
        descriptor.setDescription("ODS Text-Presentor Panel");
        descriptor.setTitleName("OdsxTextPresentorPanel.Text.Title");
        descriptor.setName(OdsxTextPresentorPanel.class.getName());
        descriptor.setCreationDate("$Date: 2007/06/28 06:50:10 $", null);
        descriptor.setIconKey("Icon.Text");
        hLastDividerLocation = 0.5;
        vLastDividerLocation = 0.5;
    }

    public class SplitPanePropListener
    implements PropertyChangeListener {
        boolean displayPlot;

        public SplitPanePropListener(boolean displayPlot) {
            this.displayPlot = displayPlot;
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().compareTo("dividerLocation") == 0) {
                JSplitPane sp = (JSplitPane)ev.getSource();
                Dimension dim = sp.getSize();
                if (sp.getOrientation() != 0) {
                    if (this.displayPlot) {
                        vLastDividerLocation = 1.0 * (double)sp.getDividerLocation() / (double)dim.width;
                    }
                } else {
                    hLastDividerLocation = 1.0 * (double)sp.getDividerLocation() / (double)dim.height;
                }
            }
        }
    }

    public class RelThread
    extends FwkThread {
        OdsxPresentableElementInterface presentable;
        JPanel panel;
        ApplicationRelation[] rel;
        boolean stopped = false;

        public RelThread(JPanel panel, OdsxPresentableElementInterface elem, ApplicationRelation[] rel) {
            this.presentable = elem;
            this.panel = panel;
            this.rel = rel;
            panel.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent ev) {
                    if (ev.getNewValue() == null) {
                        RelThread.this.stop();
                    }
                }
            });
        }

        public void stop() {
            super.stop();
            this.stopped = true;
        }

        public void run() {
            try {
                JLabel lab = new JLabel(FwkPropertyBus.getProperty((String)"OdsxTextPresentor.Text.RelationList"));
                this.panel.add("North", lab);
                OdsxFilterInterface odsFilter = this.presentable.getOdsxFilter();
                Vector<OdsxPresentableElement> elems = new Vector<OdsxPresentableElement>();
                Vector<ApplicationRelation> relations = new Vector<ApplicationRelation>();
                if (this.rel != null && this.rel.length > 0) {
                    int size = this.rel.length;
                    relations = new Vector();
                    if (this.presentable instanceof OdsxApplicationElementInterface) {
                        for (int i = 0; !this.stopped && i < size; ++i) {
                            OdsxApplicationElement ae = new OdsxApplicationElement(this.rel[i].getElem2());
                            if (odsFilter != null && !odsFilter.isVisible(ae)) continue;
                            ae.setOdsxFilter(odsFilter);
                            elems.add(ae);
                            relations.add(this.rel[i]);
                        }
                    } else {
                        OdsxInstanceElement ieElem = (OdsxInstanceElement)this.presentable;
                        ApplicationElement aeObj = ieElem.getApplicationElement();
                        AoSession aoSession = ieElem.getSession();
                        OdsxSelectHelper.NameId[] arr = null;
                        int aSize = this.rel.length;
                        ApplicationElement relAe = null;
                        T_LONGLONG aeId = aeObj.getId();
                        for (int i = 0; i < aSize; ++i) {
                            try {
                                ApplicationElement aeObj1 = this.rel[i].getElem1();
                                relAe = aeId.low == aeObj1.getId().low ? this.rel[i].getElem2() : aeObj1;
                                arr = OdsxSelectHelper.getRelated(ieElem.getInstanceElementId(), aeObj, this.rel[i], "*");
                                String type = relAe.getBaseElement().getType();
                                T_LONGLONG relAeId = relAe.getId();
                                int len = arr.length;
                                for (int count = 0; count < len; ++count) {
                                    OdsxInstanceElement elem = new OdsxInstanceElement(arr[count].id, arr[count].name, aoSession, relAe, relAeId, type, arr[count].version);
                                    if (odsFilter != null && !odsFilter.isVisible(elem)) continue;
                                    elem.setOdsxFilter(odsFilter);
                                    elems.add(elem);
                                    relations.add(this.rel[i]);
                                }
                                continue;
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!this.stopped) {
                    JList<Object> jList = new JList<Object>(relations.toArray());
                    jList.addMouseListener(new RelationMouseListener(elems, this.presentable));
                    jList.setCellRenderer(new CellRenderer(elems, relations, this.presentable));
                    jList.setVisibleRowCount(10);
                    jList.setSelectionBackground(Color.yellow);
                    jList.setBackground(this.panel.getBackground());
                    JScrollPane relScrollPane = new JScrollPane(jList);
                    relScrollPane.setAlignmentX(0.0f);
                    relScrollPane.setAlignmentY(0.0f);
                    this.panel.add("Center", relScrollPane);
                    this.panel.repaint();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            OdsxTextPresentorPanel.this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
        }
    }

    public class PlotThread
    extends FwkThread {
        OdsxPresentableElementInterface presentable;
        JPanel panel;
        P2DCanvas canvas = null;
        boolean stopped = false;

        public PlotThread(JPanel panel, OdsxPresentableElementInterface elem) {
            this.presentable = elem;
            this.panel = panel;
            panel.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent ev) {
                    if (ev.getNewValue() == null) {
                        PlotThread.this.stop();
                    }
                }
            });
        }

        public void stop() {
            super.stop();
            this.stopped = true;
            if (this.canvas != null) {
                this.canvas.release();
            }
        }

        public void run() {
            try {
                this.canvas = new P2DCanvas("Panel");
                this.canvas.setPreferredSize(new Dimension(400, 400));
                P2DPlot plot = new P2DPlot("Plot");
                plot.setBoundingBox((P2DBoundingBoxInterface)new P2DBoundingBox(50.0, 0.0, 400.0, 400.0));
                plot.setTitleComponent(this.presentable.getName());
                plot.getTitleComponent().setAttributor((P2DAttributorInterface)new OdsxPathAttributor());
                plot.setChannelComponent(this.presentable.getName());
                plot.getYAxisComponent().setTitle(this.presentable.getShortName() + "[" + ((OdsxColumn)this.presentable).getUnitString() + "]");
                plot.getChannelComponent().setName("Index - " + this.presentable.getShortName());
                plot.getChannelComponent().setColor(Color.red);
                this.canvas.addP2D((P2DContainerInterface)plot);
                if (!this.stopped) {
                    JScrollPane scrollPane = new JScrollPane((Component)this.canvas);
                    scrollPane.setAlignmentX(0.0f);
                    scrollPane.setAlignmentY(0.0f);
                    this.panel.add("Center", scrollPane);
                    this.panel.repaint();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            OdsxTextPresentorPanel.this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
        }
    }

    public class TextWriter
    extends Writer {
        JTextArea area;
        StringBuffer buffer;
        boolean stopped = false;

        public TextWriter(JTextArea area) {
            this.area = area;
            this.buffer = new StringBuffer();
        }

        public void close() throws IOException {
            this.flush();
        }

        public void flush() throws IOException {
            if (this.stopped) {
                throw new IOException();
            }
            this.area.append(this.buffer.toString());
            this.buffer.delete(0, this.buffer.length());
            this.area.repaint();
        }

        public void stop() {
            this.stopped = true;
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (off < 0) {
                off = 0;
            }
            if (!this.stopped) {
                this.buffer.append(new String(cbuf, off, len));
                if (this.buffer.length() > 5000) {
                    this.flush();
                    Thread.currentThread().setPriority(1);
                }
            } else {
                throw new IOException();
            }
        }
    }

    public class TextThread
    extends FwkThread {
        OdsxPresentableElementInterface elem;
        JTextArea area;
        TextWriter writer;

        public TextThread(JTextArea area, OdsxPresentableElementInterface elem) {
            this.area = area;
            this.writer = new TextWriter(area);
            area.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent ev) {
                    if (ev.getNewValue() == null) {
                        TextThread.this.stop();
                        TextThread.this.writer.stop();
                    }
                }
            });
            this.elem = elem;
            this.setPriority(1);
        }

        public void run() {
            try {
                this.elem.getPresentationString(this.writer, OdsxTextPresentorPanel.this.getPresentationSpec(), FwkContainer.getLocale(), this.elem.getOdsxFilter());
                this.writer.flush();
                this.writer.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            OdsxTextPresentorPanel.this.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
        }
    }

    class CellRenderer
    extends JPanel
    implements ListCellRenderer {
        OdsxPresentableElementInterface presentable;
        JLabel westLabel;
        JLabel centerLabel;
        Vector relations;
        Vector elems;

        public CellRenderer(Vector elems, Vector relations, OdsxPresentableElementInterface presentable) {
            this.setLayout(new BorderLayout());
            this.westLabel = new JLabel();
            this.westLabel.setBorder(BorderFactory.createBevelBorder(1));
            this.centerLabel = new JLabel();
            this.add("West", this.westLabel);
            this.add("Center", this.centerLabel);
            this.presentable = presentable;
            this.relations = relations;
            this.elems = elems;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ApplicationRelation rel = (ApplicationRelation)this.relations.get(index);
            String cardinality = "[0:0]";
            try {
                RelationRange range = rel.getRelationRange();
                RelationRange invRange = rel.getInverseRelationRange();
                cardinality = "[" + (invRange.max == -1 ? "n" : "" + invRange.max) + ":" + (range.max == -1 ? "m" : "" + range.max) + "]";
            }
            catch (Throwable tRelRange) {
                // empty catch block
            }
            String relName = "";
            try {
                relName = rel.getRelationName();
            }
            catch (Throwable tRelName) {
                // empty catch block
            }
            boolean setBrName = false;
            String brName = "";
            try {
                BaseRelation brRel = rel.getBaseRelation();
                if (brRel != null) {
                    brName = brRel.getRelationName();
                    setBrName = true;
                }
            }
            catch (Throwable tRelName) {
                // empty catch block
            }
            if (setBrName) {
                this.westLabel.setText(cardinality + " " + relName + " [" + brName + "]");
            } else {
                this.westLabel.setText(cardinality + " " + relName);
            }
            try {
                OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)this.elems.get(index);
                OdsxFilterInterface filter = this.presentable.getOdsxFilter();
                if (filter != null) {
                    this.westLabel.setIcon((Icon)filter.getIcon(elem));
                }
                int type = rel.getRelationType().value();
                int ship = rel.getRelationship().value();
                block4 : switch (type) {
                    case 0: {
                        switch (ship) {
                            case 0: {
                                this.westLabel.setIcon((Icon)FwkIconFile.getIcon((String)"Icon.RelFather"));
                                break block4;
                            }
                            case 1: {
                                this.westLabel.setIcon((Icon)FwkIconFile.getIcon((String)"Icon.RelChild"));
                                break block4;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (ship) {
                            case 3: {
                                this.westLabel.setIcon((Icon)FwkIconFile.getIcon((String)"Icon.RelFrom"));
                                break block4;
                            }
                            case 2: {
                                this.westLabel.setIcon((Icon)FwkIconFile.getIcon((String)"Icon.RelTo"));
                                break block4;
                            }
                        }
                        this.westLabel.setIcon((Icon)FwkIconFile.getIcon((String)"Icon.Info"));
                        break;
                    }
                }
                if (filter != null) {
                    this.centerLabel.setIcon((Icon)filter.getIcon(elem));
                    this.centerLabel.setForeground(filter.getColor(this.presentable));
                } else {
                    this.centerLabel.setForeground(Color.black);
                }
                this.centerLabel.setText(elem.getShortName(100));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (isSelected) {
                this.westLabel.setBackground(list.getSelectionBackground());
                this.westLabel.setOpaque(true);
                this.centerLabel.setBackground(list.getSelectionBackground());
                this.centerLabel.setOpaque(true);
            } else {
                this.westLabel.setBackground(list.getBackground());
                this.westLabel.setOpaque(false);
                this.centerLabel.setBackground(list.getBackground());
                this.centerLabel.setOpaque(false);
            }
            return this;
        }
    }

    class OdsxPath
    extends FwkItem
    implements OdsxPathInterface {
        String path;
        AoSession session;

        public OdsxPath(AoSession session, String path) {
            super(path);
            this.session = session;
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public AoSession getSession() {
            return this.session;
        }
    }

    class RelationMouseListener
    extends MouseAdapter {
        List arr;
        OdsxPresentableElementInterface parent;

        public RelationMouseListener(List rel, OdsxPresentableElementInterface presentable) {
            this.arr = rel;
            this.parent = presentable;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2 && e.getModifiers() == 16) {
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                try {
                    OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)this.arr.get(index);
                    if (OdsxTextPresentorPanel.this.odsPresentor != null) {
                        OdsxTextPresentorPanel.this.odsPresentor.publishPath(new OdsxPath(elem.getSession(), elem.getIdentificationString()));
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

