/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.OdsxChangeEvent;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.command.OdsxInstanceEditCommand;
import com.highqsoft.odsx.dialog.OdsxInstanceEditorPane;
import com.highqsoft.odsx.dialog.OdsxInstanceEditorPaneValue;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.awt.Component;
import java.awt.Container;
import java.util.EventObject;
import java.util.Iterator;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationElement;
import org.asam.ods.InstanceElement;
import org.asam.ods.NameValueUnit;

public class AddNewInstanceElementCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.2 $";

    public String getVersion() {
        return version;
    }

    public AddNewInstanceElementCommand(FwkControllerInterface controller) {
        super(controller);
        FwkContainer.addComponentProperties(((Object)((Object)this)).getClass());
        FwkContainer.addComponentProperties((Class)OdsxInstanceEditCommand.class);
        this.setTextKey("AddNewInstanceElementCommand.Text.NewRoot");
        this.setCommandName("NewRoot");
        this.setIconKey("Create");
    }

    public boolean execute(EventObject ev) {
        Container parent = FwkGUIFactory.getDialogParent((EventObject)ev);
        OdsxApplicationElementInterface aep = (OdsxApplicationElementInterface)this.getController();
        ApplicationElement aeObj = aep.getApplicationElement();
        AoSession session = aep.getSession();
        boolean transactionActivated = false;
        try {
            session.startTransaction();
            transactionActivated = true;
            String name = FwkPropertyBus.getProperty((String)"AddNewInstanceElementCommand.Text.New", (String)"unknown");
            InstanceElement ieObj = aeObj.createInstance(name);
            OdsxInstanceEditorPane iePane = new OdsxInstanceEditorPane(ieObj);
            OdsxInstanceEditorPaneValue ieVal = (OdsxInstanceEditorPaneValue)FwkDialogFactory.showDialog((Component)parent, (String)(FwkPropertyBus.getProperty((String)"OdsxInstanceEditCommand.Text.Edit") + ":" + name), (String)this.getIconKey(), (FwkDialogPaneInterface)iePane, (int)16);
            if (ieVal != null) {
                OdsxSessionInterface odsxSession = OdsxSessionFactory.getSessionObserver(session);
                if (odsxSession != null) {
                    odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, FwkPropertyBus.getProperty((String)"OdsxInstanceEditCommand.Text.SaveChanges")));
                }
                Iterator it = ieVal.getProperties();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    try {
                        if (!ieVal.isEditable(key)) continue;
                        NameValueUnit nvu = (NameValueUnit)ieVal.getProperty(key);
                        ieObj.setValue(nvu);
                    }
                    catch (Throwable t) {
                        FwkContainer.showErrorMessage((Container)parent, (String)"OdsxInstanceEditCommand.Error.WriteAttribute", (String)"OdsxInstanceEditCommand.Error.CannotWriteAttribute", (String)(key + ": " + OdsxHelper.nameValueUnitToString((NameValueUnit)ieVal.getProperty(key))));
                        t.printStackTrace();
                    }
                }
                try {
                    ieVal.applyRelationEditorsSettings();
                }
                catch (Throwable t) {
                    FwkContainer.showErrorMessage((Container)parent, (String)"OdsxInstanceEditCommand.Error.WriteRelation", (String)"OdsxInstanceEditCommand.Error.CannotWriteRelation", (Throwable)t);
                }
                try {
                    session.commitTransaction();
                    transactionActivated = false;
                    OdsxSessionFactory.fireOdsxChange(ieObj, OdsxChangeEvent.IEAttributeModified);
                }
                catch (AoException aoe) {
                    FwkContainer.showErrorMessage((Container)parent, (String)"Commit Transaction", (String)OdsxHelper.aoExceptionToString(aoe), (Throwable)aoe);
                }
                if (odsxSession != null) {
                    odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
                }
            }
            OdsxSessionFactory.fireOdsxChange(aeObj, OdsxChangeEvent.AEInstanceCreated);
            if (transactionActivated) {
                try {
                    session.abortTransaction();
                }
                catch (Throwable t) {}
            }
        }
        catch (AoException aoe) {
            try {
                session.abortTransaction();
            }
            catch (Throwable t) {
                // empty catch block
            }
            FwkContainer.showErrorMessage((Container)parent, (String)"Error.Occured", (String)OdsxHelper.aoExceptionToString(aoe), (Throwable)aoe);
        }
        return true;
    }
}

