/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.util.StringFormat;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.odsx.OdsxApplicationElementInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.ods.AoService;
import com.highqsoft.ods.AoServiceFactory;
import com.highqsoft.odsx.OdsxApplicationElement;
import com.highqsoft.odsx.OdsxInstanceElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.EventObject;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.asam.ods.AoException;
import org.asam.ods.AoFactory;
import org.asam.ods.InstanceElement;
import org.asam.ods.NameValueUnit;

public class OdsxATFFilterCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.8 $";
    static AtfSaveDialog atfDialog;
    static String atf_ascii;
    static String atf_block;
    static String atf_channel;
    static boolean has_atf_ascii;
    static boolean has_atf_block;
    static boolean has_atf_channel;
    static int serviceCount;

    public String getVersion() {
        return version;
    }

    public static boolean hasServices() {
        boolean ret = FwkPropertyBus.getProperty((String)"OdsxATFFilterCommand.ATF.Enabled", (boolean)false);
        if (ret) {
            ret = serviceCount != 0;
        }
        return ret;
    }

    public static boolean commandAvailableForSession(OdsxSessionInterface session) {
        boolean ret = false;
        if (session != null) {
            ret = session.getPlumName().equals("com.highqsoft.ods.athos.AoService");
        }
        return ret;
    }

    public OdsxATFFilterCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("OdsxATFFilter.Text.Create");
        this.setCommandName("CreateATF");
        this.setIconKey("Icon.ATF_Save");
    }

    protected String replaceFirstEscapeSeq(String in, String esc, String rep, boolean enclose) {
        String s1 = "";
        if (in.indexOf(esc) >= 0) {
            s1 = in.substring(0, in.indexOf(esc));
            if (rep.lastIndexOf(" ") >= 0 && enclose) {
                rep = "\"" + rep + "\"";
            }
            s1 = s1.concat(rep);
            s1 = s1.concat(in.substring(in.indexOf(esc) + esc.length(), in.length()));
            return s1;
        }
        return in;
    }

    private void exec_atf_command(String cmd) {
        ExecThread execThread = new ExecThread(cmd, atfDialog.verbose());
        execThread.run();
    }

    public boolean execute(EventObject ev) {
        boolean ret = false;
        Container parent = FwkGUIFactory.getDialogParent((EventObject)ev);
        if (serviceCount <= 0) {
            FwkContainer.showErrorMessage((Container)parent, (String)"NO ATF Service found!", (String)"Please define ATF services in the \nASCOBA_INI configuration file", (String)"The new service must have the types ATF_ASCII, ATF_BLOCK or ATF_CHANNEL.");
            return ret;
        }
        OdsxInstanceElement instance = null;
        OdsxPresentableElementInterface elem = null;
        try {
            elem = (OdsxPresentableElementInterface)this.getController();
        }
        catch (Throwable t) {
            return false;
        }
        if (elem != null) {
            if (atfDialog == null) {
                atfDialog = new AtfSaveDialog(parent, elem.getShortName());
            } else {
                atfDialog.rescanCurrentDirectory();
            }
            StringBuffer cmd = new StringBuffer();
            cmd.append("ascoba ");
            if (!atfDialog.createATFSaveDialog(elem.getShortName()) || !atfDialog.canWrite()) {
                return false;
            }
            cmd.append(atfDialog.getVerboseValue());
            if (elem instanceof OdsxSessionElementInterface) {
                cmd.append(" select \"*\" where {\"*\" ne 0} from");
                cmd.append(" \"" + elem.getShortName() + "\"");
            } else if (elem instanceof OdsxApplicationElementInterface) {
                cmd.append(" select \"");
                cmd.append(elem.getShortName());
                cmd.append("\" where {\"*\" ne 0} ");
                cmd.append(atfDialog.getWithRefValue());
                try {
                    cmd.append(" from \"" + ((OdsxApplicationElement)elem).getSession().getName() + "\"");
                }
                catch (AoException ex) {}
            } else if (elem instanceof OdsxInstanceElementInterface) {
                instance = (OdsxInstanceElement)elem;
                InstanceElement ie = instance.getInstanceElement();
                try {
                    NameValueUnit nvu = ie.getValueByBaseName("id");
                    cmd.append(" select \"");
                    cmd.append(ie.getApplicationElement().getName());
                    cmd.append("\" where {\"");
                    cmd.append(nvu.valName + "\" eq " + new Integer(nvu.value.u.longVal()).toString() + "} ");
                    cmd.append(atfDialog.getWithRefValue());
                    cmd.append(" from \"" + ie.getApplicationElement().getApplicationStructure().getSession().getName() + "\"");
                }
                catch (AoException ex) {
                    // empty catch block
                }
            }
            cmd.append(" to \"" + atfDialog.getDestinationServiceName());
            cmd.append("\" using \"" + atfDialog.getDestinationPathFile() + "\"");
            this.exec_atf_command(cmd.toString());
            return true;
        }
        return ret;
    }

    static {
        block11: {
            atfDialog = null;
            atf_ascii = null;
            atf_block = null;
            atf_channel = null;
            has_atf_ascii = false;
            has_atf_block = false;
            has_atf_channel = false;
            serviceCount = 0;
            if (FwkPropertyBus.getProperty((String)"OdsxATFFilterCommand.ATF.Enabled", (boolean)false)) {
                try {
                    String[] plugList = AoServiceFactory.listPlugableComponents();
                    String athosComponent = null;
                    for (int i = plugList.length - 1; i >= 0 && athosComponent == null; --i) {
                        if (plugList[i].toUpperCase().indexOf("ATHOS") == -1) continue;
                        athosComponent = plugList[i];
                    }
                    if (athosComponent == null) break block11;
                    AoService service = AoServiceFactory.newService(athosComponent, (String)"INIFILE=ASCOBA_INI");
                    String[] serviceList = null;
                    try {
                        serviceList = service.listServices("*");
                    }
                    catch (Throwable tServcies) {
                        serviceList = new String[]{};
                    }
                    AoFactory factory = null;
                    String type = null;
                    for (int i = serviceList.length - 1; i >= 0; --i) {
                        try {
                            factory = service.newFactory(serviceList[i], "");
                            type = factory.getType();
                            if (type == null || type.length() == 0 || !type.toUpperCase().startsWith("ATF")) continue;
                            if (type.compareToIgnoreCase("ATF-ASCII") == 0) {
                                atf_ascii = serviceList[i];
                                has_atf_ascii = true;
                                ++serviceCount;
                                continue;
                            }
                            if (type.compareToIgnoreCase("ATF-BLOCK") == 0) {
                                atf_block = serviceList[i];
                                has_atf_block = true;
                                ++serviceCount;
                                continue;
                            }
                            if (type.compareToIgnoreCase("ATF-CHANNEL") != 0) continue;
                            atf_channel = serviceList[i];
                            has_atf_channel = true;
                            ++serviceCount;
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public class ExecThread
    extends FwkThread {
        String cmd;
        boolean verbose;

        public ExecThread(String cmd, boolean verbose) {
            this.cmd = cmd;
            this.verbose = verbose;
        }

        public void run() {
            if (this.verbose) {
                System.out.println(this.cmd);
            }
            try {
                String line;
                Runtime r = Runtime.getRuntime();
                Process p = r.exec(this.cmd);
                BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader error = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = input.readLine()) != null) {
                    System.out.println("Info: " + line);
                }
                while ((line = error.readLine()) != null) {
                    System.out.println("Error: " + line);
                }
                p.waitFor();
                p.destroy();
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.out.println("ExecCommand are wrong");
            }
        }
    }

    public class AtfSaveDialog
    extends JDialog {
        private boolean withRef;
        private boolean verbose;
        private String desService;
        private String desPathFile;
        private String desPath;
        private JFileChooser fc;
        private JPanel mainPanel;
        JRadioButton normalrb;
        JRadioButton blockrb;
        JRadioButton channelrb;
        JCheckBox wrefcb;
        JCheckBox verbcb;
        int ret_val;

        public AtfSaveDialog(Container parent, String name) {
            super(JOptionPane.getFrameForComponent(parent), StringFormat.printf((String)FwkPropertyBus.getProperty((String)"OdsxATFFilter.Text.Chooser"), (String)name), true);
            this.normalrb = null;
            this.blockrb = null;
            this.channelrb = null;
            this.wrefcb = null;
            this.verbcb = null;
            this.withRef = FwkPropertyBus.getProperty((String)"OdsxATFFilter.ATF.WithRef", (boolean)true);
            this.verbose = FwkPropertyBus.getProperty((String)"OdsxATFFilter.ATF.Verbose", (boolean)false);
            this.desService = null;
            this.desPath = FwkPropertyBus.getProperty((String)"OdsxSessionFactory.ATF.Directory", (String)FwkContainer.getUserDirectory());
            this.fc = new JFileChooser(this.desPath);
            this.fc.setFileFilter((FileFilter)new FwkFileFilter("atf", "Save ATF"));
            this.mainPanel = new JPanel(new BorderLayout());
            JPanel panel = new JPanel(new BorderLayout());
            JPanel optionPanel = new JPanel(new BorderLayout());
            this.wrefcb = new JCheckBox(FwkPropertyBus.getProperty((String)"OdsxATFFilter.Text.WithReference"), this.withRef);
            optionPanel.add((Component)this.wrefcb, "North");
            this.verbcb = new JCheckBox(FwkPropertyBus.getProperty((String)"OdsxATFFilter.Text.Verbose"), this.verbose);
            optionPanel.add((Component)this.verbcb, "Center");
            panel.add((Component)optionPanel, "West");
            if (serviceCount > 0) {
                JPanel radioPanel = new JPanel(new GridLayout(0, 1));
                ButtonGroup g = new ButtonGroup();
                if (has_atf_ascii) {
                    this.normalrb = new JRadioButton(FwkPropertyBus.getProperty((String)"OdsxATFFilter.Text.NormalATF"));
                    this.normalrb.setSelected(this.desService == null || this.desService.compareTo(atf_ascii) == 0);
                    g.add(this.normalrb);
                    radioPanel.add(this.normalrb);
                }
                if (has_atf_block) {
                    this.blockrb = new JRadioButton(FwkPropertyBus.getProperty((String)"OdsxATFFilter.Text.BinBlock"));
                    this.blockrb.setSelected(this.desService != null && this.desService.compareTo(atf_block) == 0);
                    g.add(this.blockrb);
                    radioPanel.add(this.blockrb);
                }
                if (has_atf_channel) {
                    this.channelrb = new JRadioButton(FwkPropertyBus.getProperty((String)"OdsxATFFilter.Text.BinChannel"));
                    this.channelrb.setSelected(this.desService != null && this.desService.compareTo(atf_channel) == 0);
                    g.add(this.channelrb);
                    radioPanel.add(this.channelrb);
                }
                panel.add((Component)radioPanel, "Center");
            }
            this.mainPanel.add("Center", this.fc);
            this.mainPanel.add("South", panel);
            this.getContentPane().add(this.mainPanel);
            this.fc.setDialogType(1);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    AtfSaveDialog.this.ret_val = 1;
                }
            });
            this.fc.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    String cmd = ev.getActionCommand();
                    if (cmd.compareTo("ApproveSelection") == 0) {
                        AtfSaveDialog.this.ret_val = 0;
                        AtfSaveDialog.this.setVisible(false);
                    } else if (cmd.compareTo("CancelSelection") == 0) {
                        AtfSaveDialog.this.ret_val = 1;
                        AtfSaveDialog.this.setVisible(false);
                    }
                }
            });
            this.desPathFile = "";
            this.pack();
            this.setLocationRelativeTo(parent);
        }

        public void rescanCurrentDirectory() {
            File dir = this.fc.getCurrentDirectory();
            this.fc.changeToParentDirectory();
            this.fc.setCurrentDirectory(dir);
        }

        public boolean createATFSaveDialog(String name) {
            boolean ret = false;
            this.wrefcb.setSelected(this.withRef);
            this.verbcb.setSelected(this.verbose);
            if (this.desService != null) {
                if (this.normalrb != null) {
                    this.normalrb.setSelected(this.desService == null || this.desService.compareTo(atf_ascii) == 0);
                } else if (this.blockrb != null) {
                    this.blockrb.setSelected(this.desService != null && this.desService.compareTo(atf_block) == 0);
                } else if (this.channelrb != null) {
                    this.channelrb.setSelected(this.desService != null && this.desService.compareTo(atf_channel) == 0);
                }
            }
            this.ret_val = -1;
            this.fc.rescanCurrentDirectory();
            this.fc.setDialogTitle(StringFormat.printf((String)FwkPropertyBus.getProperty((String)"OdsxATFFilter.Text.Chooser"), (String)name));
            this.fc.setSelectedFile(new File(name.replace(' ', '_').replace('\\', '_').replace('/', '_') + ".atf"));
            this.setVisible(true);
            this.desService = null;
            if (this.ret_val == 0) {
                this.desPathFile = this.fc.getSelectedFile().getPath();
                if (!this.desPathFile.toUpperCase().endsWith(".ATF")) {
                    this.desPathFile = this.desPathFile.concat(".atf");
                }
                this.withRef = this.wrefcb.isSelected();
                this.verbose = this.verbcb.isSelected();
                if (serviceCount > 1) {
                    if (this.normalrb != null && this.normalrb.isSelected()) {
                        this.desService = atf_ascii;
                    } else if (this.blockrb != null && this.blockrb.isSelected()) {
                        this.desService = atf_block;
                    } else if (this.channelrb != null && this.channelrb.isSelected()) {
                        this.desService = atf_channel;
                    }
                } else if (has_atf_ascii) {
                    this.desService = atf_ascii;
                } else if (has_atf_block) {
                    this.desService = atf_block;
                } else if (has_atf_channel) {
                    this.desService = atf_channel;
                }
                ret = true;
            }
            return ret;
        }

        public String getWithRefValue() {
            if (this.withRef) {
                return "with reference";
            }
            return "";
        }

        public String getVerboseValue() {
            if (this.verbose) {
                return "verbose";
            }
            return "";
        }

        public boolean verbose() {
            return this.verbose;
        }

        public String getDestinationServiceName() {
            return this.desService;
        }

        public String getDestinationPathFile() {
            String ret = this.fc.getCurrentDirectory().getAbsolutePath() + File.separator + ((BasicFileChooserUI)this.fc.getUI()).getFileName();
            return ret;
        }

        public boolean canWrite() {
            return this.desService != null;
        }
    }
}

