/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionConnectInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.awt.Container;
import java.util.EventObject;

public class OdsxCloseSessionCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.5 $";

    public String getVersion() {
        return version;
    }

    public OdsxCloseSessionCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("Text.Disconnect");
        this.setCommandName("CloseSession");
        this.setIconKey("Icon.CloseSession");
    }

    public boolean execute(EventObject ev) {
        OdsxSessionConnectInterface sc = null;
        OdsxSessionInterface session = null;
        try {
            sc = (OdsxSessionConnectInterface)this.getController();
            session = (OdsxSessionInterface)this.getProperty("Session");
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(session), (String)FwkPropertyBus.getProperty((String)"Error.Occured"), null, (Throwable)t);
            return false;
        }
        try {
            sc.disconnectFromSession(session);
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(session), (String)FwkPropertyBus.getProperty((String)"Error.Occured"), (String)FwkPropertyBus.getProperty((String)"Error.Hint"), (Throwable)t);
            return false;
        }
        return true;
    }
}

