/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.OdsxApplicationElement;
import com.highqsoft.odsx.OdsxChangeEvent;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxMeasurementHelper;
import com.highqsoft.odsx.dialog.OdsxColumnAssignmentPaneValue;
import com.highqsoft.odsx.dialog.OdsxInstanceEditorPaneValue;
import com.highqsoft.odsx.dialog.OdsxMeasurementCreatePane;
import com.highqsoft.odsx.dialog.OdsxMeasurementCreatePaneValue;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.awt.Component;
import java.awt.Container;
import java.util.EventObject;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.InstanceElement;

public class OdsxCreateMeasurementCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.6 $";

    public String getVersion() {
        return version;
    }

    public OdsxCreateMeasurementCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("OdsxCreateMeasurementCommand.Text.CreateMeasurement");
        this.setCommandName("CreateMeasurement");
        this.setIconKey("Icon.Create");
    }

    public boolean execute(EventObject ev) {
        boolean ret = true;
        OdsxPresentableElementInterface elm = (OdsxPresentableElementInterface)this.getController();
        try {
            InstanceElement ie = (InstanceElement)elm.getValueAsObject();
            ApplicationStructure asObj = ie.getApplicationElement().getApplicationStructure();
            ApplicationElement meaObj = asObj.getElementsByBaseType("AoMeasurement")[0];
            OdsxApplicationElement used = new OdsxApplicationElement(meaObj);
            used.setOdsxFilter(elm.getOdsxFilter());
            OdsxMeasurementCreatePane pane = new OdsxMeasurementCreatePane(used);
            FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog((Component)FwkGUIFactory.getDialogParent((EventObject)ev), (String)FwkPropertyBus.getProperty((String)"OdsxCreateMeasurementCommand.Text.CreateMeasurement"), (String)this.getIconKey(), (FwkDialogPaneInterface)pane);
            if (val != null) {
                SaveThread saveThread = new SaveThread(elm, meaObj, (OdsxMeasurementCreatePaneValue)val);
                saveThread.start();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            ret = false;
        }
        return ret;
    }

    protected class SaveThread
    extends FwkThread {
        OdsxMeasurementCreatePaneValue createVal;
        OdsxPresentableElementInterface elm;
        ApplicationElement meaObj;

        public SaveThread(OdsxPresentableElementInterface elem, ApplicationElement meaObj, OdsxMeasurementCreatePaneValue val) {
            this.createVal = val;
            this.meaObj = meaObj;
            this.elm = elem;
        }

        public void run() {
            if (this.createVal != null) {
                AoSession session = this.elm.getSession();
                OdsxSessionInterface odsxSession = OdsxSessionFactory.getSessionObserver(session);
                if (odsxSession != null) {
                    odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, FwkPropertyBus.getProperty((String)"OdsxCreateMeasurementCommand.Status.CreatingMeasurement")));
                }
                try {
                    OdsxColumnAssignmentPaneValue assignmentValue = (OdsxColumnAssignmentPaneValue)this.createVal.getColumnAssignmentValue();
                    OdsxInstanceEditorPaneValue editorValue = (OdsxInstanceEditorPaneValue)this.createVal.getAttributeEditorValue();
                    InstanceElement ieObj = OdsxMeasurementHelper.saveMeasurement(this.elm.getIdentificationString(), (FwkDialogPaneValueInterface)editorValue, assignmentValue);
                    InstanceElement parent = OdsxHelper.getParent(ieObj);
                    if (parent == null) {
                        OdsxSessionFactory.fireOdsxChange(this.meaObj, OdsxChangeEvent.AEInstanceCreated);
                    } else {
                        OdsxSessionFactory.fireOdsxChange(this.meaObj, OdsxChangeEvent.AEInstanceCreated);
                        OdsxSessionFactory.fireOdsxChange(parent, OdsxChangeEvent.IEChildAdded);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(session), (String)FwkPropertyBus.getProperty((String)"OdsxCreateMeasurementCommand.Error.CannotSaveMeasurement"), (String)null, (String)null);
                }
                if (odsxSession != null) {
                    odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
                }
            }
        }
    }
}

