/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionElementInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.dialog.OdsxDebugLevelEditorPane;
import com.highqsoft.odsx.dialog.OdsxDebugLevelEditorPaneValue;
import java.awt.Component;
import java.awt.Container;
import java.util.EventObject;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;

public class OdsxDebugLevelEditorCommand
extends FwkCommand {
    protected static final String DEBUGLEVEL = "DEBUGLEVEL";
    protected static final String ODS_LOGFILE = "ODS_LOGFILE";
    public static final String version = "$Revision: 1.3 $";
    static OdsxDebugLevelEditorPane pane = null;

    public String getVersion() {
        return version;
    }

    public OdsxDebugLevelEditorCommand(FwkControllerInterface controller) {
        super(controller);
        FwkContainer.addComponentProperties(((Object)((Object)this)).getClass());
        this.setTextKey("OdsxDebugLevelEditorCommand.Text.DebugLevel");
        this.setCommandName("DebugLevel");
        this.setIconKey("Icon.Debug");
    }

    public boolean execute(EventObject ev) {
        OdsxDebugLevelEditorPaneValue val;
        OdsxSessionElementInterface odsxSession = null;
        try {
            odsxSession = (OdsxSessionElementInterface)this.getController();
        }
        catch (Throwable t) {
            // empty catch block
        }
        AoSession session = null;
        if (odsxSession != null) {
            session = odsxSession.getSession();
        }
        if (session == null) {
            new FwkException(-1073676289, "$RCSfile: OdsxDebugLevelEditorCommand.java,v $", version, "AH 2001-01-15 14:28", "There isn't a controller of type OdsxSessionElementInterface available.", (Object)this, null);
            return false;
        }
        Container parent = FwkGUIFactory.getDialogParent((EventObject)ev);
        OdsxDebugLevelEditorPaneValue selVal = new OdsxDebugLevelEditorPaneValue();
        try {
            String fName = OdsxHelper.nameValueToString(session.getContextByName(ODS_LOGFILE));
            selVal.setLogFile(fName);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            String sVal = OdsxHelper.nameValueToString(session.getContextByName(DEBUGLEVEL));
            selVal.setDebugLevel(Integer.parseInt(sVal));
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (pane == null) {
            pane = new OdsxDebugLevelEditorPane();
            pane.setSelectedValue((FwkDialogPaneValueInterface)selVal);
        }
        if ((val = (OdsxDebugLevelEditorPaneValue)FwkDialogFactory.showDialog((Component)parent, (String)FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorCommand.Title"), null, (FwkDialogPaneInterface)pane, (int)16)) != null) {
            if (val.getLogFile() != null) {
                try {
                    session.setContextString(ODS_LOGFILE, val.getLogFile());
                }
                catch (AoException aoe) {
                    FwkContainer.showErrorMessage((Container)parent, (String)"Error.Occured", (String)"", (String)OdsxHelper.aoExceptionToString(aoe));
                }
            }
            if (val.getDebugLevel() >= 0) {
                try {
                    session.setContextString(DEBUGLEVEL, "" + val.getDebugLevel());
                }
                catch (AoException aoe) {
                    FwkContainer.showErrorMessage((Container)parent, (String)"Error.Occured", (String)"", (String)OdsxHelper.aoExceptionToString(aoe));
                }
            }
        }
        return true;
    }
}

