/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.fwk.dialog.FwkConfirmDialog;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.fwk.util.StringUtilities;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.OdsxChangeEvent;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.awt.Container;
import java.util.EventObject;
import org.asam.ods.ApplicationElement;
import org.asam.ods.InstanceElement;

public class OdsxDeleteInstanceCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.7 $";

    public String getVersion() {
        return version;
    }

    public OdsxDeleteInstanceCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("Text.Delete");
        this.setCommandName("Delete");
        this.setIconKey("Icon.delete");
    }

    public boolean execute(EventObject ev) {
        OdsxInstanceElementInterface ie = (OdsxInstanceElementInterface)this.getController();
        FwkContainer.beep();
        FwkConfirmDialog dialog = new FwkConfirmDialog(ie.getShortName(), StringUtilities.split((String)FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Text.Message"), (String)"\n", (boolean)true));
        boolean really = dialog.showDialog(FwkGUIFactory.getDialogParent((EventObject)ev));
        if (really) {
            DeleteThread deleteThread = new DeleteThread(ie);
            deleteThread.start();
        }
        return true;
    }

    public static boolean deleteInstances(Container parent, OdsxInstanceElementInterface[] ieArr) {
        FwkContainer.beep();
        FwkConfirmDialog dialog = new FwkConfirmDialog(FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Text.DeleteInstances"), StringUtilities.split((String)FwkPropertyBus.getProperty((String)"OdsxDeleteInstancesCommand.Text.Message"), (String)"\n", (boolean)true));
        boolean really = dialog.showDialog(parent);
        if (really) {
            MultiDeleteThread deleteThread = new MultiDeleteThread(ieArr);
            deleteThread.start();
        }
        return true;
    }

    protected static class MultiDeleteThread
    extends FwkThread {
        OdsxInstanceElementInterface[] ie;

        public MultiDeleteThread(OdsxInstanceElementInterface[] ie) {
            this.ie = ie;
        }

        public void run() {
            int size = this.ie.length;
            for (int i = 0; i < size; ++i) {
                String message;
                String name = "";
                try {
                    name = this.ie[i].getShortName();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                OdsxSessionInterface odsxSession = OdsxSessionFactory.getSessionObserver(this.ie[i].getSession());
                if (odsxSession != null) {
                    message = name != null ? FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Text.DeleteInstance") + " " + name : FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Text.DeleteInstance");
                    odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, message));
                }
                try {
                    InstanceElement parent = OdsxHelper.getParent((InstanceElement)this.ie[i].getValueAsObject());
                    ApplicationElement ae = this.ie[i].getApplicationElement();
                    this.ie[i].delete(true);
                    if (parent == null) {
                        OdsxSessionFactory.fireOdsxChange(ae, OdsxChangeEvent.AEInstanceRemoved);
                    } else {
                        OdsxSessionFactory.fireOdsxChange(ae, OdsxChangeEvent.AEInstanceRemoved);
                        OdsxSessionFactory.fireOdsxChange(parent, OdsxChangeEvent.IEChildRemoved);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    message = name != null ? FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Error.CannotDeleteInstance") + " " + name : FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Error.CannotDeleteInstance");
                    FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.ie[i].getSession()), (String)message, (String)null, (Throwable)t);
                }
                if (odsxSession == null) continue;
                odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
            }
        }
    }

    protected class DeleteThread
    extends FwkThread {
        OdsxInstanceElementInterface ie;

        public DeleteThread(OdsxInstanceElementInterface ie) {
            this.ie = ie;
        }

        public void run() {
            String message;
            String name = "";
            try {
                name = this.ie.getShortName();
            }
            catch (Throwable t) {
                // empty catch block
            }
            OdsxSessionInterface odsxSession = OdsxSessionFactory.getSessionObserver(this.ie.getSession());
            if (odsxSession != null) {
                message = name != null ? FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Text.DeleteInstance") + " " + name : FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Text.DeleteInstance");
                odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, message));
            }
            try {
                InstanceElement parent = OdsxHelper.getParent((InstanceElement)this.ie.getValueAsObject());
                ApplicationElement ae = this.ie.getApplicationElement();
                this.ie.delete(true);
                if (parent == null) {
                    OdsxSessionFactory.fireOdsxChange(ae, OdsxChangeEvent.AEInstanceRemoved);
                } else {
                    OdsxSessionFactory.fireOdsxChange(ae, OdsxChangeEvent.AEInstanceRemoved);
                    OdsxSessionFactory.fireOdsxChange(parent, OdsxChangeEvent.IEChildAdded);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                message = name != null ? FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Error.CannotDeleteInstance") + " " + name : FwkPropertyBus.getProperty((String)"OdsxDeleteInstanceCommand.Error.CannotDeleteInstance");
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(this.ie.getSession()), (String)message, (String)null, (Throwable)t);
            }
            if (odsxSession != null) {
                odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
            }
        }
    }
}

