/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkThread;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPane;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.odsx.OdsxHelper;
import java.awt.Component;
import java.awt.Container;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.util.EventObject;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.AttrType;
import org.asam.ods.Column;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.Measurement;
import org.asam.ods.TS_ValueSeq;
import org.asam.ods.ValueMatrix;

public class OdsxDumpMeasurementCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.4 $";
    static FwkFileChooserDialogPaneValue value = null;

    public String getVersion() {
        return version;
    }

    public OdsxDumpMeasurementCommand(FwkControllerInterface controller) {
        super(controller);
        FwkContainer.addComponentProperties(((Object)((Object)this)).getClass());
        OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)controller;
        if (!elem.valueIsA(InstanceElement.class) || elem.getBaseName().compareToIgnoreCase("AoMeasurement") != 0) {
            throw new RuntimeException("Command is useful for InstanceElements only.");
        }
        this.setTextKey("OdsxDumpMeasurement.Text.CommandTitle");
        this.setIconKey("Icon.CSVDump");
        this.setCommandName("DumpMeasurement");
    }

    public boolean execute(EventObject ev) {
        block6: {
            OdsxPresentableElementInterface elem = (OdsxPresentableElementInterface)this.getController();
            InstanceElement ieObj = (InstanceElement)elem.getValueAsObject();
            if (elem.getBaseName().compareToIgnoreCase("AoMeasurement") == 0) {
                try {
                    Measurement meaIe = ieObj.upcastMeasurement();
                    ValueMatrix vm = meaIe.getValueMatrix();
                    if (value == null) {
                        File file;
                        value = new FwkFileChooserDialogPaneValue();
                        String curDir = FwkPropertyBus.getProperty((String)"OdsxDumpMeasurement.File.StartUpDirectory", (String)null);
                        if (curDir != null && (file = new File(curDir)).exists() && file.isDirectory()) {
                            value.setCurrentDirectory(curDir);
                        }
                    }
                    Container parent = FwkGUIFactory.getDialogParent((EventObject)ev);
                    FwkFileChooserDialogPane pane = new FwkFileChooserDialogPane(null, (FwkDialogPaneValueInterface)value);
                    FwkFileChooserDialogPaneValue val = (FwkFileChooserDialogPaneValue)FwkDialogFactory.showDialog((Component)parent, (String)FwkPropertyBus.getProperty((String)this.getTextKey()), (String)"", (FwkDialogPaneInterface)pane);
                    if (val != null) {
                        value = val;
                        String file = val.getSelectedPath();
                        WriterThread wThread = new WriterThread(ieObj, file, vm);
                        wThread.setPriority(1);
                        wThread.start();
                    }
                }
                catch (Throwable t) {
                    if (FwkContainer.getDebugLevel() <= 0) break block6;
                    t.printStackTrace();
                }
            }
        }
        return true;
    }

    public class WriterThread
    extends FwkThread {
        String file;
        ValueMatrix vm;
        InstanceElement ieObj;

        public WriterThread(InstanceElement ieObj, String file, ValueMatrix vm) {
            this.ieObj = ieObj;
            this.file = file;
            this.vm = vm;
        }

        public void run() {
            try {
                Column[] col = this.vm.getColumns("*");
                int colCount = col.length;
                int valCount = this.vm.getRowCount();
                FileOutputStream fos = new FileOutputStream(this.file);
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                BufferedWriter bw = new BufferedWriter(osw);
                this.dumpAttributes(bw, this.ieObj);
                this.dumpRelations(bw, this.ieObj, "AoUnitUnderTest");
                int pos = 0;
                int bufLength = 1000;
                Object[] values = new Object[colCount];
                StringBuffer sb = new StringBuffer();
                this.dumpColumnNames(bw, col);
                this.dumpColumnUnits(bw, col);
                String undef = FwkPropertyBus.getProperty((String)"OdsxDumpMeasurement.Text.Undefined", (String)"UNDEF");
                Object[] flags = new Object[colCount];
                while (pos < valCount) {
                    int i;
                    if (pos + bufLength > valCount) {
                        bufLength = valCount - pos;
                    }
                    block13: for (i = 0; i < colCount; ++i) {
                        TS_ValueSeq valueSeq = this.vm.getValueVector(col[i], pos, bufLength);
                        flags[i] = valueSeq.flag;
                        switch (valueSeq.u.discriminator().value()) {
                            case 15: {
                                values[i] = valueSeq.u.stringVal();
                                continue block13;
                            }
                            case 2: {
                                values[i] = valueSeq.u.shortVal();
                                continue block13;
                            }
                            case 3: {
                                values[i] = valueSeq.u.floatVal();
                                continue block13;
                            }
                            case 4: {
                                values[i] = valueSeq.u.booleanVal();
                                continue block13;
                            }
                            case 5: {
                                values[i] = valueSeq.u.byteVal();
                                continue block13;
                            }
                            case 6: {
                                values[i] = valueSeq.u.longVal();
                                continue block13;
                            }
                            case 7: {
                                values[i] = valueSeq.u.doubleVal();
                                continue block13;
                            }
                            case 10: {
                                values[i] = valueSeq.u.dateVal();
                                continue block13;
                            }
                            default: {
                                values[i] = null;
                            }
                        }
                    }
                    pos += bufLength;
                    for (i = 0; i < bufLength; ++i) {
                        for (int c = 0; c < colCount; ++c) {
                            if ((((short[])flags[c])[i] & 1) != 0) {
                                sb.append(Array.get(values[c], i));
                            } else {
                                sb.append(undef);
                            }
                            if (c + 1 < colCount) {
                                sb.append(", ");
                                continue;
                            }
                            sb.append("\n");
                            bw.write(sb.toString());
                        }
                    }
                }
                bw.flush();
                osw.close();
                bw.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void dumpAttributes(BufferedWriter bw, InstanceElement ieObj) {
            block3: {
                try {
                    String[] attrs = ieObj.listAttributes("*", AttrType.ALL);
                    StringBuffer sb = new StringBuffer();
                    String prefix = ieObj.getApplicationElement().getName();
                    int aCount = attrs.length;
                    for (int i = 0; i < aCount; ++i) {
                        sb.append(prefix).append(".").append(attrs[i]).append(" : ");
                        sb.append(OdsxHelper.nameValueUnitToString(ieObj.getValue(attrs[i])));
                        sb.append("\n");
                    }
                    bw.write(sb.toString());
                    bw.flush();
                }
                catch (Throwable t) {
                    if (FwkContainer.getDebugLevel() <= 0) break block3;
                    t.printStackTrace();
                }
            }
        }

        public void dumpRelations(BufferedWriter bw, InstanceElement ieObj, String baseType) {
            block5: {
                try {
                    ApplicationElement aeObj = ieObj.getApplicationElement();
                    ApplicationStructure asObj = aeObj.getApplicationStructure();
                    ApplicationElement[] aeUut = asObj.getElementsByBaseType(baseType);
                    for (int i = 0; i < aeUut.length; ++i) {
                        ApplicationRelation[] arObj = asObj.getRelations(aeObj, aeUut[i]);
                        for (int j = 0; j < arObj.length; ++j) {
                            InstanceElementIterator ieIt = ieObj.getRelatedInstancesByRelationship(arObj[j].getRelationship(), "*");
                            for (int itCount = ieIt.getCount(); itCount > 0; --itCount) {
                                this.dumpAttributes(bw, ieIt.nextOne());
                            }
                            ieIt.destroy();
                        }
                    }
                }
                catch (Throwable t) {
                    if (FwkContainer.getDebugLevel() <= 0) break block5;
                    t.printStackTrace();
                }
            }
        }

        public void dumpColumnNames(BufferedWriter bw, Column[] cols) {
            block3: {
                try {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < cols.length; ++i) {
                        sb.append(cols[i].getName());
                        if (i + 1 >= cols.length) continue;
                        sb.append(", ");
                    }
                    sb.append("\n");
                    bw.write(sb.toString());
                    bw.flush();
                }
                catch (Throwable t) {
                    if (FwkContainer.getDebugLevel() <= 0) break block3;
                    t.printStackTrace();
                }
            }
        }

        public void dumpColumnUnits(BufferedWriter bw, Column[] cols) {
            block3: {
                try {
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < cols.length; ++i) {
                        sb.append(cols[i].getUnit());
                        if (i + 1 >= cols.length) continue;
                        sb.append(", ");
                    }
                    sb.append("\n");
                    bw.write(sb.toString());
                    bw.flush();
                }
                catch (Throwable t) {
                    if (FwkContainer.getDebugLevel() <= 0) break block3;
                    t.printStackTrace();
                }
            }
        }
    }
}

