/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.command;

import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkExecuteStateEvent;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkGUIFactory;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkExecuteStateEventInterface;
import com.highqsoft.interfaces.odsx.OdsxInstanceElementInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.odsx.OdsxChangeEvent;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.dialog.OdsxInstanceEditorPane;
import com.highqsoft.odsx.dialog.OdsxInstanceEditorPaneValue;
import com.highqsoft.odsx.factory.OdsxSessionFactory;
import java.awt.Component;
import java.awt.Container;
import java.util.EventObject;
import java.util.Iterator;
import org.asam.ods.AoSession;
import org.asam.ods.InstanceElement;
import org.asam.ods.NameValueUnit;

public class OdsxInstanceEditCommand
extends FwkCommand {
    public static final String version = "$Revision: 1.8 $";

    public String getVersion() {
        return version;
    }

    public OdsxInstanceEditCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("Text.Edit");
        this.setCommandName("Edit");
    }

    public boolean execute(EventObject ev) {
        Container parent = FwkGUIFactory.getDialogParent((EventObject)ev);
        OdsxPresentableElementInterface elm = (OdsxPresentableElementInterface)this.getController();
        InstanceElement ieObj = ((OdsxInstanceElementInterface)this.getController()).getInstanceElement();
        OdsxInstanceEditorPane pane = new OdsxInstanceEditorPane(ieObj);
        OdsxInstanceEditorPaneValue val = (OdsxInstanceEditorPaneValue)FwkDialogFactory.showDialog((Component)parent, (String)(FwkPropertyBus.getProperty((String)"Text.Edit") + ":" + elm.getShortName()), (String)this.getIconKey(), (FwkDialogPaneInterface)pane, (int)16);
        if (val != null) {
            AoSession session = elm.getSession();
            OdsxSessionInterface odsxSession = OdsxSessionFactory.getSessionObserver(session);
            if (odsxSession != null) {
                odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 2, FwkPropertyBus.getProperty((String)"OdsxInstanceEditCommand.Text.SaveChanges")));
            }
            try {
                session.startTransaction();
            }
            catch (Throwable t) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(session), (String)"Start Transaction", null, (Throwable)t);
            }
            Iterator it = val.getProperties();
            while (it.hasNext()) {
                String key = (String)it.next();
                try {
                    if (!val.isEditable(key)) continue;
                    NameValueUnit nvu = (NameValueUnit)val.getProperty(key);
                    ieObj.setValue(nvu);
                }
                catch (Throwable t) {
                    FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(session), (String)"OdsxInstanceEditCommand.Error.WriteAttribute", (String)"OdsxInstanceEditCommand.Error.CannotWriteAttribute", (String)(key + ": " + OdsxHelper.nameValueUnitToString((NameValueUnit)val.getProperty(key))));
                    t.printStackTrace();
                }
            }
            try {
                val.applyRelationEditorsSettings();
            }
            catch (Throwable t) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(session), (String)"OdsxInstanceEditCommand.Error.WriteRelation", (String)"OdsxInstanceEditCommand.Error.CannotWriteRelation", (Throwable)t);
            }
            try {
                session.commitTransaction();
                OdsxSessionFactory.fireOdsxChange(ieObj, OdsxChangeEvent.IEAttributeModified);
            }
            catch (Throwable t) {
                FwkContainer.showErrorMessage((Container)OdsxSessionFactory.getDialogParent(session), (String)"Commit Transaction", null, (Throwable)t);
            }
            if (odsxSession != null) {
                odsxSession.fireExecuteStateEvent((FwkExecuteStateEventInterface)new FwkExecuteStateEvent((Object)this, 0));
            }
        }
        return true;
    }
}

