/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.command;

import com.highqsoft.fwk.FwkApplicationBus;
import com.highqsoft.fwk.FwkArray;
import com.highqsoft.fwk.FwkCommand;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.interfaces.fwk.FwkAppearanceInterface;
import com.highqsoft.interfaces.fwk.FwkApplicationInterface;
import com.highqsoft.interfaces.fwk.FwkArrayInterface;
import com.highqsoft.interfaces.fwk.FwkControllerInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.p2d.P2DComponentInterface;
import com.highqsoft.interfaces.p2d.P2DContainerInterface;
import com.highqsoft.interfaces.p2d.P2DLayoutableInterface;
import com.highqsoft.interfaces.p2d.P2DLayouterInterface;
import com.highqsoft.interfaces.p2d.P2DModelInterface;
import com.highqsoft.interfaces.p2d.P2DTextInterface;
import com.highqsoft.interfaces.p2d.P2DViewInterface;
import com.highqsoft.p2d.P2DText;
import com.highqsoft.p2d.P2DTextModel;
import com.highqsoft.p2d.P2DTextView;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.EventObject;

public class OdsxLayouterCommand
extends FwkCommand
implements P2DLayoutableInterface {
    public static final String version = "$Revision: 1.4 $";

    public String getVersion() {
        return version;
    }

    public OdsxLayouterCommand(FwkControllerInterface controller) {
        super(controller);
        this.setTextKey("Odsx.Text.ToLayouter");
        this.setCommandName("ToLayouter");
        this.setIconKey("Icon.Quasar");
    }

    public boolean execute(EventObject ev) {
        OdsxPresentableElementInterface presentable = null;
        try {
            presentable = (OdsxPresentableElementInterface)this.getController();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (presentable == null) {
            new FwkException(-1073676289, "$RCSfile: OdsxLayouterCommand.java,v $", version, "AH 2001-01-15 14:28", "There isn't a controller available.", (Object)this, null);
            return false;
        }
        FwkApplicationInterface[] layouters = FwkApplicationBus.findMultipleApplications((String)"*", (DataFlavor[])FwkContainer.getDataFlavor((Class)P2DLayouterInterface.class));
        if (layouters == null || layouters.length == 0) {
            return false;
        }
        P2DLayouterInterface layouter = (P2DLayouterInterface)layouters[0];
        layouter.addLayoutable((P2DLayoutableInterface)this);
        return true;
    }

    public P2DComponentInterface getTopLevelComponent() {
        OdsxPresentableElementInterface presentable = null;
        try {
            presentable = (OdsxPresentableElementInterface)this.getController();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (presentable == null) {
            new FwkException(-1073676289, "$RCSfile: OdsxLayouterCommand.java,v $", version, "AH 2001-01-15 14:28", "There isn't a controller available.", (Object)this, null);
            return null;
        }
        StringWriter writer = new StringWriter();
        try {
            presentable.getPresentationString(writer, "Header only", null, null);
        }
        catch (Throwable t) {
            // empty catch block
        }
        P2DText textComponent = new P2DText("Header " + presentable.getShortName());
        textComponent.setModel((P2DModelInterface)new TextModel());
        textComponent.setView((P2DViewInterface)new TextView());
        textComponent.setText(writer.toString());
        textComponent.setColor(presentable.getOdsxFilter().getColor(presentable));
        textComponent.setRatioFix(false);
        return textComponent;
    }

    public static class TextView
    extends P2DTextView {
        public void draw(P2DComponentInterface component, P2DContainerInterface container, Graphics2D g) {
            FwkArrayInterface arr = ((P2DTextInterface)component).getAttributedText();
            if (arr != null && arr.size() != 0) {
                LineBreakMeasurer measurer;
                AttributedCharacterIterator iter;
                AttributedString str;
                int size = arr.size();
                int curY = 0;
                float wrappingWidth = (float)component.getWidth();
                double height = component.getHeight();
                TextLayout layout = null;
                FontRenderContext frc = new FontRenderContext(null, true, true);
                int i = 0;
                float valueOffset = 0.0f;
                while (i < size && (double)curY <= height) {
                    str = (AttributedString)arr.get(i);
                    i += 2;
                    iter = str.getIterator();
                    measurer = new LineBreakMeasurer(iter, frc);
                    while (measurer.getPosition() < iter.getEndIndex() && (double)curY <= height) {
                        layout = measurer.nextLayout(wrappingWidth);
                        if ((double)(curY = (int)((float)curY + layout.getAscent())) <= height) {
                            layout.draw(g, 0.0f, curY);
                        }
                        valueOffset = Math.max(valueOffset, layout.getAdvance());
                        curY = (int)((float)curY + (layout.getDescent() + layout.getLeading()));
                    }
                }
                i = 1;
                curY = 0;
                valueOffset += 10.0f;
                while (i < size && (double)curY <= height) {
                    str = (AttributedString)arr.get(i);
                    i += 2;
                    iter = str.getIterator();
                    measurer = new LineBreakMeasurer(iter, frc);
                    while (measurer.getPosition() < iter.getEndIndex() && (double)curY <= height) {
                        layout = measurer.nextLayout(wrappingWidth);
                        if ((double)(curY = (int)((float)curY + layout.getAscent())) <= height) {
                            layout.draw(g, valueOffset, curY);
                        }
                        curY = (int)((float)curY + (layout.getDescent() + layout.getLeading()));
                    }
                }
            }
        }
    }

    public static class TextModel
    extends P2DTextModel {
        public FwkArrayInterface getAttributedText(P2DTextInterface component) {
            FwkArray ret = new FwkArray();
            if (this.text != null && this.attributor != null) {
                FwkAppearanceInterface ap = component.getAppearance();
                int size = this.text.size();
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        AttributedString as;
                        String line = (String)this.text.get(i);
                        int index = line.indexOf(9);
                        if (index > 0) {
                            as = new AttributedString(line.substring(0, index));
                            as.addAttribute(TextAttribute.FONT, ap.getFont());
                            as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                            as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                            ret.add((Object)as);
                            as = new AttributedString(line.substring(index + 1));
                            as.addAttribute(TextAttribute.FONT, ap.getFont());
                            as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                            ret.add((Object)as);
                            continue;
                        }
                        as = new AttributedString(" ");
                        as.addAttribute(TextAttribute.FONT, ap.getFont());
                        as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                        ret.add((Object)as);
                        if (line.length() != 0) {
                            as = line.startsWith("\t") ? (line.length() > 1 ? new AttributedString(line.substring(1)) : new AttributedString(" ")) : new AttributedString(line);
                            as.addAttribute(TextAttribute.FONT, ap.getFont());
                            as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                            ret.add((Object)as);
                            continue;
                        }
                        as = new AttributedString(" ");
                        as.addAttribute(TextAttribute.FONT, ap.getFont());
                        as.addAttribute(TextAttribute.FOREGROUND, ap.getColor());
                        ret.add((Object)as);
                    }
                }
            }
            return ret;
        }
    }
}

