/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.dialog;

import com.highqsoft.fwk.dialog.FwkDialogPaneValue;
import com.highqsoft.odsx.OdsxHelper;
import java.util.HashMap;
import java.util.Iterator;
import org.asam.ods.AoException;
import org.asam.ods.ApplicationAttribute;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.AttrType;
import org.asam.ods.DataType;
import org.asam.ods.InstanceElement;
import org.asam.ods.NameValueUnit;

public class OdsxAttributeEditorPaneValue
extends FwkDialogPaneValue
implements Cloneable {
    protected static final Object OBLIGATORY = new Object();
    protected static final Object UNIQUE = new Object();
    protected static final Object NOT_EDITABLE = new Object();
    protected static HashMap not_editable = new HashMap();
    HashMap attrs = new HashMap();
    HashMap obligatory = new HashMap();
    HashMap unique = new HashMap();

    public OdsxAttributeEditorPaneValue() {
        this((String)null);
    }

    public OdsxAttributeEditorPaneValue(String ident) {
        super(ident);
    }

    public OdsxAttributeEditorPaneValue(ApplicationElement ae) throws AoException {
        this(null, ae);
    }

    public OdsxAttributeEditorPaneValue(String ident, ApplicationElement ae) throws AoException {
        this(ident);
        this.fillFrom(ae);
    }

    public OdsxAttributeEditorPaneValue(InstanceElement ie) throws AoException {
        this(null, ie);
    }

    public OdsxAttributeEditorPaneValue(String ident, InstanceElement ie) throws AoException {
        this(ident);
        this.fillFrom(ie);
    }

    public int size() {
        return this.attrs.size();
    }

    public void setObligatory(String name, boolean flag) {
        if (flag) {
            this.obligatory.put(name, OBLIGATORY);
        } else {
            this.obligatory.remove(name);
        }
    }

    public boolean isObligatory(String name) {
        return this.obligatory.get(name) != null;
    }

    public void setUnique(String name, boolean flag) {
        if (flag) {
            this.unique.put(name, UNIQUE);
        } else {
            this.unique.remove(name);
        }
    }

    public boolean isUnique(String name) {
        return this.unique.get(name) != null;
    }

    public static boolean isEditable(String name) {
        return not_editable.get(name) == null;
    }

    public static boolean isEditable(ApplicationAttribute aa) {
        boolean ret = true;
        try {
            ret = OdsxAttributeEditorPaneValue.isEditable(aa.getBaseAttribute().getName().toUpperCase());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret;
    }

    public void add(NameValueUnit nvu) {
        this.attrs.put(nvu.valName, nvu);
    }

    public void add(ApplicationAttribute aa) throws AoException {
        if (OdsxAttributeEditorPaneValue.isEditable(aa)) {
            ApplicationStructure as = aa.getApplicationElement().getApplicationStructure();
            String unit = "";
            try {
                ApplicationElement[] elem = as.getElementsByBaseType("AoUnit");
                if (elem != null && elem.length != 0) {
                    InstanceElement ie = elem[0].getInstanceById(aa.getUnit());
                    unit = ie.getName();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            NameValueUnit nvu = OdsxHelper.createNameValueUnit(aa.getName(), aa.getDataType(), unit);
            this.attrs.put(nvu.valName, nvu);
            this.setObligatory(nvu.valName, aa.isObligatory());
            this.setUnique(nvu.valName, aa.isUnique());
        }
    }

    public void fillFrom(ApplicationElement ae) throws AoException {
        this.clear();
        ApplicationAttribute[] arr = ae.getAttributes("*");
        if (arr != null && arr.length != 0) {
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                this.add(arr[i]);
            }
        }
    }

    public void fillFrom(InstanceElement ie) throws AoException {
        this.clear();
        String[] list = ie.listAttributes("*", AttrType.ALL);
        ApplicationElement ae = ie.getApplicationElement();
        if (list != null && list.length != 0) {
            int size = list.length;
            for (int i = 0; i < size; ++i) {
                NameValueUnit nvu = ie.getValue(list[i]);
                ApplicationAttribute aa = null;
                try {
                    aa = ae.getAttributeByName(list[i]);
                    if (!OdsxAttributeEditorPaneValue.isEditable(aa)) continue;
                    this.attrs.put(nvu.valName, nvu);
                    this.setObligatory(nvu.valName, aa.isObligatory());
                    this.setUnique(nvu.valName, aa.isUnique());
                    continue;
                }
                catch (Throwable tt) {
                    // empty catch block
                }
            }
        }
    }

    public NameValueUnit get(String name) {
        return (NameValueUnit)this.attrs.get(name);
    }

    public String getValueAsString(String name) {
        NameValueUnit nvu = (NameValueUnit)this.attrs.get(name);
        String ret = null;
        if (nvu != null) {
            ret = OdsxHelper.ts_unionToString(nvu.value.u);
        }
        return ret;
    }

    public String getUnit(String name) {
        NameValueUnit nvu = (NameValueUnit)this.attrs.get(name);
        String ret = null;
        if (nvu != null) {
            ret = nvu.unit;
        }
        return ret;
    }

    public NameValueUnit remove(NameValueUnit nvu) {
        return (NameValueUnit)this.attrs.remove(nvu.valName);
    }

    public NameValueUnit remove(String name) {
        return (NameValueUnit)this.attrs.remove(name);
    }

    public void clear() {
        this.attrs.clear();
        this.obligatory.clear();
        this.unique.clear();
    }

    public Object clone() {
        OdsxAttributeEditorPaneValue ret = new OdsxAttributeEditorPaneValue(this.getIdent());
        Iterator it = this.getProperties();
        while (it.hasNext()) {
            String key = (String)it.next();
            ret.setProperty(key, this.attrs.get(key));
            ret.setObligatory(key, this.isObligatory(key));
            ret.setUnique(key, this.isUnique(key));
        }
        return ret;
    }

    public void setProperty(String propertyName, Object propertyValue) {
        if (propertyValue instanceof NameValueUnit) {
            this.attrs.put(propertyName, OdsxHelper.clone((NameValueUnit)propertyValue));
        }
    }

    public Iterator getProperties() {
        return this.attrs.keySet().iterator();
    }

    public Object getProperty(String propertyName) {
        return OdsxHelper.clone((NameValueUnit)this.attrs.get(propertyName));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName() + ":\n");
        Iterator it = this.getProperties();
        while (it.hasNext()) {
            String key = (String)it.next();
            NameValueUnit nvu = (NameValueUnit)this.attrs.get(key);
            buf.append("\t" + key + ": " + OdsxHelper.ts_unionToString(nvu.value.u) + " [" + nvu.unit + "]\n");
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        OdsxAttributeEditorPaneValue s = new OdsxAttributeEditorPaneValue();
        NameValueUnit nvu = OdsxHelper.createNameValueUnit("Datum", DataType.DT_DATE, "");
        s.add(nvu);
        System.out.println(s);
        System.exit(0);
    }

    static {
        not_editable.put("ID", NOT_EDITABLE);
        not_editable.put("NUMBER_OF_ROWS", NOT_EDITABLE);
    }
}

