/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.dialog;

import com.highqsoft.fwk.FwkColumnAccessProducer;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.factory.FwkInfoBusProducerFactory;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.fwk.util.FwkInfoBusItemList;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.fwk.FwkInfoBusImmediateAccessInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.odsx.dialog.OdsxColumnAssignmentPaneValue;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import org.asam.ods.AoException;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.NameValueUnit;

public class OdsxColumnAssignmentPane
extends FwkDialogPane {
    public static final String version = "$Revision: 1.4 $";
    public static final FwkIconInterface quantityIcon = FwkIconFile.getIcon((String)"Icon.AoQuantity");
    public static final FwkIconInterface upIcon = FwkIconFile.getIcon((String)"Icon.Up3DRed");
    public static final FwkIconInterface downIcon = FwkIconFile.getIcon((String)"Icon.Down3DRed");
    protected static String DEFAULT_COLUMN_FILTER = "*";
    protected static String DEFAULT_QUANTITY_FILTER = "*";
    public static final boolean INDEPENDENT_ENABLED = FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Enable.Indepedent", (boolean)false);
    protected static DataFlavor[] dataFlavor = FwkContainer.getDataFlavor((Class)FwkColumnAccessInterface.class);
    protected OdsxPresentableElementInterface elem;
    protected FwkInfoBusItemList columnList;
    protected JComboBox busList;
    protected JList quantityList;
    protected JTable assignmentTable;
    protected JButton addButton;
    protected JButton removeButton;
    protected JSplitPane splitPane;
    protected JTextField columnFilterField;
    protected JTextField quantityFilterField;
    protected JCheckBox indepCheck;
    protected JComboBox indepQuantity;
    protected JTextField offsetField;
    protected JTextField factorField;
    protected JTextField frequencyField;
    protected JPanel indepPanel;
    protected QuantityModel quantityModel;
    protected QuantityListRenderer quantityRenderer;
    protected OdsxColumnAssignmentPaneValue paneValue;
    protected String columnFilter;
    protected String quantityFilter;
    protected String busName = FwkDataBus.BUSNAME;
    protected ApplicationRelation aeRel;

    public String getVersion() {
        return version;
    }

    public OdsxColumnAssignmentPane(OdsxPresentableElementInterface elem) {
        this(null, elem);
    }

    public OdsxColumnAssignmentPane(String title, OdsxPresentableElementInterface elem) {
        this.elem = elem;
        if (title == null) {
            try {
                title = elem.getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.paneValue = new OdsxColumnAssignmentPaneValue(elem);
        this.columnFilter = DEFAULT_COLUMN_FILTER;
        this.quantityFilter = DEFAULT_QUANTITY_FILTER;
        this.createPane(title);
    }

    protected void createPane(String title) {
        InstanceElementIterator quantities;
        block12: {
            this.title = title;
            quantities = null;
            this.aeRel = null;
            try {
                if (this.elem == null) break block12;
                ApplicationStructure asObj = this.elem.getSession().getApplicationStructure();
                ApplicationElement aeObj = asObj.getElementsByBaseType("AoQuantity")[0];
                quantities = aeObj.getInstances(this.quantityFilter);
                try {
                    ApplicationRelation[] arr = aeObj.getAllRelations();
                    if (arr != null && arr.length != 0) {
                        int size = arr.length;
                        boolean stop = false;
                        int count = 0;
                        while (!stop && count < size) {
                            stop = arr[count++].getBaseRelation().getRelationName().compareTo("default_unit") == 0;
                        }
                        if (stop) {
                            this.aeRel = arr[count - 1];
                        }
                    }
                }
                catch (Throwable tUnit) {}
            }
            catch (AoException aoException) {
                if (aoException.errCode.value() != 42) {
                    FwkContainer.showErrorMessage((Container)((Object)this), (String)aoException.getMessage(), null, (Throwable)aoException);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.quantityModel = new QuantityModel(quantities);
        try {
            quantities.destroy();
        }
        catch (Throwable destroyT) {
            // empty catch block
        }
        String[] busNames = FwkInfoBusProducerFactory.inspect((DataFlavor)FwkContainer.getDataFlavor((Class)FwkColumnAccessInterface.class)[0]);
        this.busList = new JComboBox<String>(busNames);
        this.busList.setEditable(false);
        this.busList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                OdsxColumnAssignmentPane.this.updateLists();
            }
        });
        JPanel busNamePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 17;
        busNamePanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.BusName") + ":"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.anchor = 17;
        gbc.fill = 1;
        busNamePanel.add((Component)this.busList, gbc);
        this.columnList = new FwkInfoBusItemList();
        this.columnList.setSelectionMode(0);
        this.columnList.setInfoBusParams(this.busName, this.columnFilter, dataFlavor);
        this.columnList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OdsxColumnAssignmentPane.this.setButtonSensitivity();
                }
            }
        });
        JScrollPane columnScroll = new JScrollPane((Component)this.columnList);
        this.columnFilterField = new JTextField(this.columnFilter);
        this.columnFilterField.setToolTipText(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.ToolTip.Filter"));
        this.columnFilterField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                OdsxColumnAssignmentPane.this.updateLists();
            }
        });
        JPanel columnPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 100.0;
        gbc.anchor = 10;
        columnPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Channels") + ":"), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        columnPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Filter") + ":"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 1;
        columnPanel.add((Component)this.columnFilterField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        columnPanel.add((Component)columnScroll, gbc);
        this.quantityList = new JList();
        this.quantityList.setSelectionMode(0);
        this.quantityList.setModel(this.quantityModel);
        this.quantityRenderer = new QuantityListRenderer();
        this.quantityList.setCellRenderer(this.quantityRenderer);
        this.quantityList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OdsxColumnAssignmentPane.this.setButtonSensitivity();
                }
            }
        });
        JScrollPane quantityScroll = new JScrollPane(this.quantityList);
        this.quantityFilterField = new JTextField(this.quantityFilter);
        this.quantityFilterField.setToolTipText(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.ToolTip.Filter"));
        this.quantityFilterField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                OdsxColumnAssignmentPane.this.updateLists();
            }
        });
        JPanel quantityPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 100.0;
        gbc.anchor = 10;
        quantityPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Quantities")), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        quantityPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Filter") + ":"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 1;
        quantityPanel.add((Component)this.quantityFilterField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        quantityPanel.add((Component)quantityScroll, gbc);
        this.splitPane = new JSplitPane(1, columnPanel, quantityPanel);
        this.assignmentTable = new JTable(this.paneValue);
        this.assignmentTable.setSelectionMode(0);
        this.assignmentTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OdsxColumnAssignmentPane.this.setButtonSensitivity();
                }
            }
        });
        JTableHeader header = this.assignmentTable.getTableHeader();
        header.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    JTableHeader header = (JTableHeader)e.getSource();
                    int columnNumber = header.columnAtPoint(new Point(e.getX(), e.getY()));
                    if (SwingUtilities.isRightMouseButton(e)) {
                        OdsxColumnAssignmentPane.this.paneValue.setComparable(-(columnNumber + 1));
                    } else {
                        OdsxColumnAssignmentPane.this.paneValue.setComparable(columnNumber + 1);
                    }
                }
            }
        });
        header.setToolTipText(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.ToolTip.UseMouseButtonToSort"));
        this.addButton = new JButton((Icon)downIcon);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                OdsxColumnAssignmentPane.this.addAssignment();
            }
        });
        this.addButton.setToolTipText(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.ToolTip.AddButton"));
        this.removeButton = new JButton((Icon)upIcon);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                OdsxColumnAssignmentPane.this.paneValue.remove(OdsxColumnAssignmentPane.this.assignmentTable.getSelectedRow());
            }
        });
        this.removeButton.setToolTipText(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.ToolTip.RemoveButton"));
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 8;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)busNamePanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 8;
        gbc.gridheight = 4;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        panel.add((Component)this.splitPane, gbc);
        gbc.gridx = 3;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        panel.add((Component)this.addButton, gbc);
        gbc.gridx = 4;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        panel.add((Component)this.removeButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 8;
        gbc.gridheight = 4;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        JScrollPane tableScrollPane = new JScrollPane(this.assignmentTable);
        panel.add((Component)tableScrollPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6 + gbc.gridheight;
        gbc.gridwidth = 8;
        gbc.gridheight = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        panel.add((Component)this.createIndepPanel(this.quantityModel, this.quantityRenderer), gbc);
        JScrollPane scroller = new JScrollPane(panel);
        this.add(scroller);
        this.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent e) {
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
                OdsxColumnAssignmentPane.this.splitPane.setDividerLocation(0.5);
            }

            public void componentShown(ComponentEvent e) {
            }
        });
        Dimension size = this.assignmentTable.getPreferredSize();
        if (size.height < 100) {
            tableScrollPane.setPreferredSize(new Dimension(size.width + 30, 100));
        }
        this.columnFilterField.requestFocus();
        this.setButtonSensitivity();
    }

    public JPanel createIndepPanel(ComboBoxModel model, ListCellRenderer renderer) {
        this.indepCheck = new JCheckBox(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.CreateIndependentChannel"));
        this.indepCheck.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean selected = OdsxColumnAssignmentPane.this.indepCheck.isSelected();
                this.setSensitivity(OdsxColumnAssignmentPane.this.indepPanel, selected);
            }

            protected void setSensitivity(Component component, boolean flag) {
                component.setEnabled(flag);
                if (component instanceof Container) {
                    Component[] all = ((Container)component).getComponents();
                    int size = all.length;
                    for (int i = 0; i < size; ++i) {
                        this.setSensitivity(all[i], flag);
                    }
                }
            }
        });
        this.indepQuantity = new JComboBox();
        this.indepQuantity.setEditable(false);
        this.indepQuantity.setModel(model);
        this.indepQuantity.setRenderer(renderer);
        this.indepPanel = new JPanel(new GridBagLayout());
        this.offsetField = new JTextField("0", 10);
        this.offsetField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    OdsxColumnAssignmentPane.this.factorField.requestFocus();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.factorField = new JTextField("1", 10);
        this.factorField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String sVal = OdsxColumnAssignmentPane.this.factorField.getText();
                float fVal = 0.0f;
                try {
                    fVal = Float.parseFloat(sVal);
                    fVal = 1.0f / fVal;
                    if (!Float.isNaN(fVal) && !Float.isInfinite(fVal)) {
                        OdsxColumnAssignmentPane.this.frequencyField.setText("" + fVal);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (e.getKeyCode() == 10) {
                    OdsxColumnAssignmentPane.this.frequencyField.requestFocus();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        this.frequencyField = new JTextField("1", 10);
        this.frequencyField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String sVal = OdsxColumnAssignmentPane.this.frequencyField.getText();
                float fVal = 0.0f;
                try {
                    fVal = Float.parseFloat(sVal);
                    fVal = 1.0f / fVal;
                    if (!Float.isNaN(fVal) && !Float.isInfinite(fVal)) {
                        OdsxColumnAssignmentPane.this.factorField.setText("" + fVal);
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (e.getKeyCode() == 10) {
                    OdsxColumnAssignmentPane.this.indepQuantity.requestFocus();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
        JLabel factorLabel = new JLabel(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Factor") + ":");
        JLabel frequencyLabel = new JLabel(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Frequency") + ":");
        JPanel inputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        inputPanel.add((Component)factorLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        gbc.anchor = 13;
        inputPanel.add((Component)this.factorField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        inputPanel.add((Component)frequencyLabel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        gbc.anchor = 13;
        inputPanel.add((Component)this.frequencyField, gbc);
        JPanel ret = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.indepPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Quantity") + ":"), gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.indepPanel.add((Component)this.indepQuantity, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.indepPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Offset") + ":"), gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.indepPanel.add((Component)this.offsetField, gbc);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.gridheight = 2;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        this.indepPanel.add((Component)inputPanel, gbc);
        gbc.gridwidth = 1;
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        ret.add((Component)this.indepCheck, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.fill = 13;
        gbc.anchor = 17;
        ret.add((Component)this.indepPanel, gbc);
        this.indepCheck.setSelected(false);
        return ret;
    }

    protected void setButtonSensitivity() {
        this.addButton.setEnabled(this.columnList.getSelectedIndex() >= 0 && this.quantityList.getSelectedIndex() >= 0);
        this.removeButton.setEnabled(this.assignmentTable.getSelectedRow() >= 0);
    }

    protected void updateLists() {
        String columnCurFilter = this.columnFilterField.getText().trim();
        String quantityCurFilter = this.quantityFilterField.getText().trim();
        String infoBusName = (String)this.busList.getSelectedItem();
        if (quantityCurFilter.compareTo(this.quantityFilter) != 0) {
            this.quantityFilter = quantityCurFilter;
            InstanceElementIterator quantities = null;
            try {
                if (this.elem != null) {
                    ApplicationStructure asObj = this.elem.getSession().getApplicationStructure();
                    ApplicationElement aeObj = asObj.getElementsByBaseType("AoQuantity")[0];
                    quantities = aeObj.getInstances(this.quantityFilter);
                }
            }
            catch (AoException aoException) {
                if (aoException.errCode.value() != 42) {
                    FwkContainer.showErrorMessage((Container)((Object)this), (String)aoException.getMessage(), null, (Throwable)aoException);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.quantityModel.setQuantities(quantities);
            try {
                quantities.destroy();
            }
            catch (Throwable destroyT) {
                // empty catch block
            }
        }
        if (columnCurFilter.compareTo(this.columnFilter) != 0 || infoBusName.compareTo(this.busName) != 0) {
            this.busName = infoBusName;
            this.columnFilter = columnCurFilter;
            this.columnList.setInfoBusParams(this.busName, this.columnFilter, dataFlavor);
        }
        this.setButtonSensitivity();
    }

    protected void addAssignment() {
        try {
            FwkColumnAccessInterface col;
            String quantityName;
            FwkInfoBusImmediateAccessInterface item = this.columnList.getSelectedItem(this.columnList.getSelectedIndex());
            String channelName = item.getName();
            InstanceElement ieObj = (InstanceElement)this.quantityList.getSelectedValue();
            String columnName = quantityName = ieObj.getName();
            try {
                NameValueUnit nvu = ieObj.getValueByBaseName("default_mq_name");
                columnName = nvu.value.u.stringVal();
            }
            catch (Throwable tAttr) {
                // empty catch block
            }
            String unitString = null;
            if (this.aeRel != null) {
                try {
                    InstanceElementIterator it = ieObj.getRelatedInstances(this.aeRel, "*");
                    InstanceElement unitIe = it.nextOne();
                    it.destroy();
                    unitString = unitIe.getName();
                }
                catch (Throwable tUnit) {
                    // empty catch block
                }
            }
            if (unitString == null && (col = (FwkColumnAccessInterface)FwkColumnAccessProducer.getInstance().findDataItem(channelName)) != null) {
                unitString = col.getUnitString();
            }
            this.paneValue.add(this.columnList.getInfoBusName(), channelName, quantityName, columnName, unitString, false);
        }
        catch (Throwable t) {
            FwkContainer.showErrorMessage((Container)((Object)this), (String)t.getMessage(), null, (Throwable)t);
        }
        int index = this.columnList.getSelectedIndex();
        if (index >= 0) {
            this.columnList.removeSelectionInterval(index, index);
        }
        if ((index = this.quantityList.getSelectedIndex()) >= 0) {
            this.quantityList.removeSelectionInterval(index, index);
        }
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        this.paneValue.setImplicitCreation(false);
        if (this.indepCheck.isSelected()) {
            double factor;
            try {
                this.paneValue.setOffset(Double.parseDouble(this.offsetField.getText()));
            }
            catch (Throwable tOffset) {
                JOptionPane.showMessageDialog((Component)((Object)this), FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.FactorError"), FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.FormatError"), 2);
                throw new FwkException(-1073676289, "$RCSfile: OdsxColumnAssignmentPane.java,v $", "$Revision", "AH 2000-10-22 09:24", "wrong number format for offset value: " + tOffset.getMessage(), (Object)this, tOffset);
            }
            try {
                factor = Double.parseDouble(this.factorField.getText());
            }
            catch (Throwable tFactor) {
                try {
                    factor = 1.0 / Double.parseDouble(this.factorField.getText());
                    if (Double.isNaN(factor)) {
                        JOptionPane.showMessageDialog((Component)((Object)this), FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.FreuqencyError"), FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.FormatError"), 2);
                        throw new FwkException(-1073676289, "$RCSfile: OdsxColumnAssignmentPane.java,v $", "$Revision", "AH 2000-10-22 09:25", "wrong number format for factor value.", (Object)this, null);
                    }
                }
                catch (Throwable tFrequency) {
                    JOptionPane.showMessageDialog((Component)((Object)this), FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.FreuqencyError"), FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.FormatError"), 2);
                    throw new FwkException(-1073676289, "$RCSfile: OdsxColumnAssignmentPane.java,v $", "$Revision", "AH 2000-10-22 09:25", "wrong number format for offset value: " + tFrequency.getMessage(), (Object)this, tFrequency);
                }
            }
            Object selQuantity = this.quantityModel.getSelectedItem();
            if (selQuantity == null) {
                JOptionPane.showMessageDialog((Component)((Object)this), FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.NoQuantity"), FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.QuantityError"), 2);
                throw new FwkException(-1073676289, "$RCSfile: OdsxColumnAssignmentPane.java,v $", "$Revision", "AH 2000-10-22 09:25", "No Quantity for independent channel.", (Object)this, null);
            }
            this.paneValue.setFactor(factor);
            this.paneValue.setQuantity(this.quantityRenderer.getName(selQuantity));
            this.paneValue.setUnitString(this.quantityRenderer.getUnit(selQuantity));
            try {
                this.paneValue.setQuantity(((InstanceElement)selQuantity).getName());
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.paneValue.setImplicitCreation(true);
        }
        return this.paneValue;
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
    }

    public boolean isAllowedToConsume(EventObject e) {
        return !this.columnFilterField.hasFocus() && !this.quantityFilterField.hasFocus() && !this.frequencyField.hasFocus() && !this.factorField.hasFocus();
    }

    public static void main(String[] args) {
        FwkContainer.initialize((String[])args);
        OdsxColumnAssignmentPane pane = new OdsxColumnAssignmentPane("title", null);
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, (String)"OdsxColumnAssignmentPane - Test", (String)"", (FwkDialogPaneInterface)pane);
        if (val != null) {
            System.out.println("FwkDialogPaneValueSupport Properties:");
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
        } else {
            System.out.println("No value returned from OdsxColumnAssignmentPane.");
        }
        System.exit(0);
    }

    static {
        FwkContainer.addComponentProperties((Class)OdsxColumnAssignmentPane.class);
        DEFAULT_COLUMN_FILTER = FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Column.Filter", (String)"*");
        DEFAULT_QUANTITY_FILTER = FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Quantity.Filter", (String)"*");
    }

    class QuantityListRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        HashMap map = new HashMap();
        HashMap unitMap = new HashMap();

        public String getName(Object key) {
            return (String)this.map.get(key);
        }

        public String getUnit(Object key) {
            return (String)this.unitMap.get(key);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String name;
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            InstanceElement ie = (InstanceElement)value;
            String unitString = (String)this.unitMap.get(value);
            if (unitString == null && OdsxColumnAssignmentPane.this.aeRel != null) {
                try {
                    InstanceElementIterator it = ie.getRelatedInstances(OdsxColumnAssignmentPane.this.aeRel, "*");
                    InstanceElement unitIe = it.nextOne();
                    unitString = unitIe.getName();
                    this.unitMap.put(value, unitString);
                    it.destroy();
                }
                catch (Throwable tUnit) {
                    // empty catch block
                }
            }
            if ((name = (String)this.map.get(value)) == null) {
                try {
                    name = ie.getName();
                    this.map.put(value, name);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (name != null) {
                if (unitString != null) {
                    name = name + "[" + unitString + "]";
                }
            } else if (unitString != null) {
                name = "[" + unitString + "]";
            }
            this.setText(name);
            this.setIcon((Icon)quantityIcon);
            return this;
        }
    }

    class QuantityModel
    extends AbstractListModel
    implements ComboBoxModel,
    Comparator {
        Object[] cache;
        int index;

        public QuantityModel(InstanceElementIterator quantities) {
            try {
                int size = quantities.getCount();
                quantities.reset();
                this.cache = quantities.nextN(size);
                Arrays.sort(this.cache, this);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.index = -1;
        }

        public void setQuantities(InstanceElementIterator quantities) {
            Object selected = this.getSelectedItem();
            try {
                int size = quantities.getCount();
                quantities.reset();
                this.cache = quantities.nextN(size);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.setSelectedItem(selected);
            this.fireContentsChanged(this, 0, this.getSize());
        }

        public int getSize() {
            return this.cache.length;
        }

        public Object getElementAt(int index) {
            return this.cache[index];
        }

        public Object getSelectedItem() {
            if (this.index != -1) {
                return this.getElementAt(this.index);
            }
            return null;
        }

        public void setSelectedItem(Object anItem) {
            int count;
            this.index = -1;
            int size = this.cache.length;
            boolean stop = false;
            for (count = 0; !stop && count < size; ++count) {
                stop = this.cache[count].equals(anItem);
            }
            if (stop) {
                this.index = count - 1;
            }
        }

        public int compare(Object o1, Object o2) {
            int ret = 0;
            try {
                InstanceElement ie1 = (InstanceElement)o1;
                InstanceElement ie2 = (InstanceElement)o2;
                ret = ie1.getName().compareTo(ie2.getName());
            }
            catch (Throwable t) {
                // empty catch block
            }
            return ret;
        }
    }
}

