/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.dialog;

import com.highqsoft.fwk.FwkColumnAccessProducer;
import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDataBus;
import com.highqsoft.fwk.FwkDataItemConsumer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPaneValue;
import com.highqsoft.interfaces.fwk.FwkColumnAccessInterface;
import com.highqsoft.interfaces.odsx.OdsxColumnAssignmentInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.odsx.dialog.OdsxColumnAssignmentPane;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.asam.ods.AoSession;
import org.asam.ods.DataType;

public class OdsxColumnAssignmentPaneValue
extends FwkDialogPaneValue
implements OdsxColumnAssignmentInterface,
TableModel {
    public static final int CHANNEL = 1;
    public static final int BUSNAME = 2;
    public static final int QUANTITY = 3;
    public static final int COLUMN = 4;
    public static final int FLAG = 5;
    protected static final int COLCOUNT = 4;
    protected static final int INCREMENT = 32;
    protected static final String[] colNames = new String[5];
    OdsxPresentableElementInterface elem;
    int sortedBy = 1;
    int count = 0;
    Assignment[] array;
    ArrayList listeners;
    double offset = Double.NaN;
    double factor = Double.NaN;
    boolean implicitCreation = false;
    String quantity = null;
    String unitString = null;

    public OdsxColumnAssignmentPaneValue(OdsxPresentableElementInterface elem) {
        this(null, elem);
    }

    public OdsxColumnAssignmentPaneValue(String ident, OdsxPresentableElementInterface elem) {
        this.elem = elem;
        this.array = new Assignment[32];
        this.listeners = new ArrayList();
        this.setIdent(ident);
    }

    public Assignment add(String infoBusName, String channelName, String quantityName, String odsColumnName, String unitString, boolean independent) {
        Assignment a = new Assignment(infoBusName, channelName, quantityName, odsColumnName, unitString, independent);
        if (this.count >= this.array.length) {
            Assignment[] tmp = new Assignment[this.count + 32];
            System.arraycopy(this.array, 0, tmp, 0, this.array.length);
            this.array = tmp;
        }
        this.array[this.count++] = a;
        if (this.count > 1) {
            Arrays.sort(this.array, 0, this.count);
        }
        TableModelEvent e = new TableModelEvent(this);
        this.fireTabelChanged(e);
        return a;
    }

    public Assignment add(String channelName, String quantityName) {
        return this.add(null, channelName, quantityName, null, null, false);
    }

    public Assignment add(String channelName, String quantityName, String odsColumnName) {
        return this.add(null, channelName, quantityName, odsColumnName, null, false);
    }

    public Assignment add(String infoBusName, String channelName, String quantityName, String odsColumnName) {
        return this.add(infoBusName, channelName, quantityName, odsColumnName, null, false);
    }

    public AoSession getSession() {
        return this.elem.getSession();
    }

    public int size() {
        return this.count;
    }

    public int[] getColumnSizes() {
        int len = this.size();
        int[] ret = null;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            FwkColumnAccessInterface col = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(this.getChannelName(i) + "@" + this.getInfoBusName(i));
            if (col == null || col.getCount() == 0) continue;
            if (ret == null) {
                ret = new int[]{col.getCount()};
                count = 1;
                continue;
            }
            int newLen = col.getCount();
            boolean found = false;
            count = ret.length;
            for (int j = 0; !found && j < count; ++j) {
                found = ret[j] == newLen;
            }
            if (found) continue;
            int[] tmp = new int[count + 1];
            System.arraycopy(ret, 0, tmp, 0, count++);
            tmp[count - 1] = newLen;
            ret = tmp;
        }
        return ret;
    }

    public Assignment get(int index) {
        if (index >= 0 && index < this.count) {
            return this.array[index];
        }
        return null;
    }

    public String getOdsColumnName(int index) {
        Assignment a = this.get(index);
        if (a != null) {
            return a.odsColumnName;
        }
        return "";
    }

    public String getChannelName(int index) {
        Assignment a = this.get(index);
        if (a != null) {
            return a.channelName;
        }
        return "";
    }

    public FwkColumnAccessInterface getChannel(int index) {
        FwkColumnAccessInterface ret = (FwkColumnAccessInterface)FwkDataItemConsumer.getInstance().findDataItem(this.getChannelName(index) + "@" + this.getInfoBusName(index));
        return ret;
    }

    public String getInfoBusName(int index) {
        Assignment a = this.get(index);
        if (a != null) {
            return a.infoBusName;
        }
        return "";
    }

    public String getQuantityName(int index) {
        Assignment a = this.get(index);
        if (a != null) {
            return a.quantityName;
        }
        return "";
    }

    public String getUnitString(int index) {
        Assignment a = this.get(index);
        if (a != null) {
            return a.unitString;
        }
        return "";
    }

    public DataType getOdsColumnDataType(int index) {
        return DataType.DT_FLOAT;
    }

    public boolean getIndependent(int index) {
        Assignment a = this.get(index);
        if (a != null) {
            return a.independent;
        }
        return false;
    }

    public Assignment remove(int index) {
        Assignment a = this.get(index);
        if (a != null) {
            Assignment[] tmp = new Assignment[this.array.length];
            if (index == 0) {
                System.arraycopy(this.array, 1, tmp, 0, this.array.length - 1);
            } else if (index == this.count - 1) {
                System.arraycopy(this.array, 0, tmp, 0, this.array.length - 1);
            } else {
                System.arraycopy(this.array, 0, tmp, 0, index);
                System.arraycopy(this.array, index + 1, tmp, index, this.array.length - index - 1);
            }
            this.array = tmp;
            --this.count;
            TableModelEvent e = new TableModelEvent(this);
            this.fireTabelChanged(e);
            return a;
        }
        return null;
    }

    public Assignment remove(Assignment assignment) {
        int index = Arrays.binarySearch(this.array, assignment);
        return this.remove(index);
    }

    public Assignment[] getAssignments() {
        Assignment[] ret = new Assignment[this.count];
        System.arraycopy(this.array, 0, ret, 0, this.count);
        return ret;
    }

    public void setComparable(int val) {
        int absVal = Math.abs(val);
        if (absVal >= 1 && absVal <= 4) {
            this.sortedBy = val;
            if (this.count > 1) {
                Arrays.sort(this.array, 0, this.count);
            }
            TableModelEvent e = new TableModelEvent(this);
            this.fireTabelChanged(e);
        }
    }

    public int getCompareable(int val) {
        return this.sortedBy;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setFactor(double factor) {
        this.factor = factor;
    }

    public double getFactor() {
        return this.factor;
    }

    public void setImplicitCreation(boolean flag) {
        this.implicitCreation = flag;
    }

    public boolean getImplicitCreation() {
        return this.implicitCreation && !Double.isNaN(this.factor) && !Double.isInfinite(this.factor) && !Double.isNaN(this.offset) && !Double.isInfinite(this.offset) && this.quantity != null && this.quantity.length() != 0;
    }

    public void setQuantity(String name) {
        this.quantity = name;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public DataType getOdsColumnDataType() {
        return DataType.DT_LONG;
    }

    public void setUnitString(String unit) {
        this.unitString = unit;
    }

    public String getUnitString() {
        return this.unitString;
    }

    public int getRowCount() {
        return this.size();
    }

    public int getColumnCount() {
        if (OdsxColumnAssignmentPane.INDEPENDENT_ENABLED) {
            return 5;
        }
        return 4;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < 4) {
            return String.class;
        }
        return Boolean.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object ret = null;
        Assignment a = this.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                ret = a.channelName;
                break;
            }
            case 1: {
                ret = a.infoBusName;
                break;
            }
            case 2: {
                if (a.unitString == null) {
                    ret = a.quantityName;
                    break;
                }
                ret = a.quantityName + "[" + a.unitString + "]";
                break;
            }
            case 3: {
                ret = a.odsColumnName;
                break;
            }
            default: {
                ret = new Boolean(a.independent);
            }
        }
        return ret;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Assignment a = this.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                a.channelName = (String)aValue;
                break;
            }
            case 1: {
                a.infoBusName = (String)aValue;
                break;
            }
            case 2: {
                a.quantityName = (String)aValue;
                break;
            }
            case 3: {
                a.odsColumnName = (String)aValue;
                break;
            }
            default: {
                a.independent = (Boolean)aValue;
            }
        }
    }

    public String getColumnName(int columnIndex) {
        return colNames[columnIndex];
    }

    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireTabelChanged(TableModelEvent e) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                TableModelListener l = (TableModelListener)this.listeners.get(i);
                l.tableChanged(e);
            }
        }
    }

    public static void main(String[] args) {
        OdsxColumnAssignmentPaneValue s = new OdsxColumnAssignmentPaneValue(null);
        Iterator iterator = s.getProperties();
        System.out.println("FwkDialogPaneValueSupport Properties:");
        while (iterator.hasNext()) {
            Object key = iterator.next();
            System.out.println("Key: " + key + " / value:" + s.getProperty(key.toString()));
        }
    }

    static {
        FwkContainer.addComponentProperties((Class)OdsxColumnAssignmentPane.class);
        OdsxColumnAssignmentPaneValue.colNames[0] = FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Channel");
        OdsxColumnAssignmentPaneValue.colNames[1] = FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.BusName");
        OdsxColumnAssignmentPaneValue.colNames[2] = FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Quantity");
        OdsxColumnAssignmentPaneValue.colNames[3] = FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Column");
        OdsxColumnAssignmentPaneValue.colNames[4] = FwkPropertyBus.getProperty((String)"OdsxColumnAssignmentPane.Text.Independent");
    }

    public class Assignment
    implements Comparable {
        String channelName;
        String quantityName;
        String odsColumnName;
        String unitString;
        String infoBusName;
        boolean independent;

        public Assignment(String infoBusName, String channelName, String quantityName, String odsColumnName, String unitString, boolean independent) {
            this.infoBusName = infoBusName == null ? FwkDataBus.BUSNAME : infoBusName;
            this.channelName = channelName;
            this.quantityName = quantityName;
            this.odsColumnName = odsColumnName;
            this.odsColumnName = odsColumnName == null ? quantityName : odsColumnName;
            if (unitString == null) {
                FwkColumnAccessInterface col = (FwkColumnAccessInterface)FwkColumnAccessProducer.getInstance().findDataItem(channelName);
                if (col != null) {
                    unitString = col.getUnitString();
                }
            } else {
                this.unitString = unitString;
            }
            this.independent = independent;
        }

        public int compareTo(Object obj) {
            Assignment a = (Assignment)obj;
            if (OdsxColumnAssignmentPaneValue.this.sortedBy > 0) {
                switch (OdsxColumnAssignmentPaneValue.this.sortedBy) {
                    case 4: {
                        return this.odsColumnName.compareTo(a.odsColumnName);
                    }
                    case 2: {
                        return this.infoBusName.compareTo(a.infoBusName);
                    }
                    case 3: {
                        return this.quantityName.compareTo(a.quantityName);
                    }
                }
                return this.channelName.compareTo(a.channelName);
            }
            switch (-OdsxColumnAssignmentPaneValue.this.sortedBy) {
                case 4: {
                    return a.odsColumnName.compareTo(this.odsColumnName);
                }
                case 2: {
                    return a.infoBusName.compareTo(this.infoBusName);
                }
                case 3: {
                    return a.quantityName.compareTo(this.quantityName);
                }
            }
            return a.channelName.compareTo(this.channelName);
        }

        public String toString() {
            return this.channelName + "@" + this.infoBusName + " " + this.quantityName + "[" + this.unitString + "] " + this.odsColumnName + " " + this.independent;
        }
    }
}

