/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.odsx.dialog.OdsxDebugLevelEditorPaneValue;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OdsxDebugLevelEditorPane
extends FwkDialogPane {
    public static final String version = "$Revision: 1.1 $";
    static JFileChooser fileChooser;
    protected JTextField fileField = null;
    protected JButton browse = null;
    protected JComboBox debugLevelBox = null;
    protected JCheckBox lfChecker;
    protected JCheckBox dlChecker;

    public String getVersion() {
        return version;
    }

    public OdsxDebugLevelEditorPane() {
        this.createPane(FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorPane.Title"));
    }

    protected void createPane(String title) {
        this.title = title;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.lfChecker = new JCheckBox(FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorPane.Text.Takeover"));
        this.lfChecker.setSelected(true);
        this.dlChecker = new JCheckBox(FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorPane.Text.Takeover"));
        this.dlChecker.setSelected(true);
        JLabel fileLabel = new JLabel(FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorPane.Text.Filename"));
        JLabel levelLabel = new JLabel(FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorPane.Text.DebugLevel"));
        this.fileField = new JTextField();
        this.browse = new JButton(FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorPane.Text.Browse"));
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (fileChooser == null) {
                    fileChooser = new JFileChooser();
                    fileChooser.setFileSelectionMode(0);
                    fileChooser.setMultiSelectionEnabled(false);
                }
                if (fileChooser.showSaveDialog((Component)((Object)OdsxDebugLevelEditorPane.this)) == 0) {
                    File f = fileChooser.getSelectedFile();
                    OdsxDebugLevelEditorPane.this.fileField.setText(f.toString());
                }
            }
        });
        this.debugLevelBox = new JComboBox<String>(new String[]{FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorPane.Text.Off"), FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorPane.Text.Middle"), FwkPropertyBus.getProperty((String)"OdsxDebugLevelEditorPane.Text.High")});
        this.add(fileLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 100.0;
        this.add(this.fileField, gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        this.add(this.browse, gbc);
        ++gbc.gridx;
        this.add(this.lfChecker, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add(levelLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 100.0;
        this.add(this.debugLevelBox, gbc);
        ++gbc.gridx;
        this.add(new JPanel(), gbc);
        ++gbc.gridx;
        this.add(this.dlChecker, gbc);
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        if (this.fileField != null) {
            String file = null;
            if (this.lfChecker.isSelected() && (file = this.fileField.getText().trim()).length() == 0) {
                file = null;
            }
            int dl = -1;
            if (this.dlChecker.isSelected()) {
                dl = this.debugLevelBox.getSelectedIndex() * 5;
            }
            return new OdsxDebugLevelEditorPaneValue(this.title, file, dl);
        }
        return new OdsxDebugLevelEditorPaneValue(this.title, null, 0);
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        if (this.getComponentCount() == 0 && this.fileField != null) {
            OdsxDebugLevelEditorPaneValue dlVal = (OdsxDebugLevelEditorPaneValue)value;
            String file = dlVal.getLogFile();
            this.lfChecker.setSelected(file != null);
            if (file == null) {
                this.fileField.setText("");
            } else {
                if (fileChooser != null) {
                    fileChooser.setSelectedFile(new File(file));
                }
                this.fileField.setText(file);
            }
            int idx = 0;
            this.dlChecker.setSelected(dlVal.getDebugLevel() >= 0);
            idx = dlVal.getDebugLevel() >= 0 ? dlVal.getDebugLevel() / 5 : -1 * dlVal.getDebugLevel() / 5;
            if (idx < 0) {
                idx = 0;
            }
            if (idx > 2) {
                idx = 2;
            }
            this.debugLevelBox.setSelectedIndex(idx);
        }
    }

    static {
        FwkContainer.addComponentProperties((Class)OdsxDebugLevelEditorPane.class);
        fileChooser = null;
    }
}

