/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkPropertyGroup;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPane;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.util.FileUtilities;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkPropertyGroupInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.odsx.OdsxFilter;
import com.highqsoft.odsx.dialog.OdsxFilterEditorPaneValue;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class OdsxFilterEditorPane
extends FwkDialogPane {
    public static final String version = "$Revision: 1.5 $";
    protected static final String TREE_CARD = "TreeCard";
    protected static final String NEW_CARD = "NewCard";
    protected static final Color VISIBLE_ENABLED_COLOR = Color.green.darker().darker();
    protected static final Color VISIBLE_COLOR = Color.blue;
    protected static final Color ENABLED_COLOR = Color.red.darker();
    protected static final Color DEFAULT_COLOR = Color.magenta;
    protected static final Color INVERSE_COLOR = Color.yellow;
    protected static final Color SELECTION_BG_COLOR = Color.blue;
    FwkFileChooserDialogPane fileChooser = null;
    protected CardLayout cardLayout;
    protected JPanel treePanel;
    protected JTree tree;
    protected JButton deleteButton;
    protected JButton newButton;
    JPopupMenu filePopup;
    protected JLabel newLabel;
    protected JTextField nameTextField;
    protected JTextField valueTextField;
    protected JTextArea errorMessage;
    protected JCheckBox visibleCheck;
    protected JCheckBox enableCheck;
    protected OdsxFilterInterface initialValue;
    protected FilterToggleCellRenderer toggleRenderer;
    protected FilterTreeModel filterTreeModel;
    protected boolean inverse = true;
    protected boolean elementsAdded = false;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public String getVersion() {
        return version;
    }

    public OdsxFilterEditorPane() {
        this(null);
    }

    public OdsxFilterEditorPane(String title) {
        super(title);
        FwkContainer.addComponentProperties(((Object)((Object)this)).getClass());
        this.initialValue = null;
        this.setHelpID(((Object)((Object)this)).getClass().getName());
    }

    protected void createPane() {
        if (this.initialValue != null && this.treePanel == null) {
            this.cardLayout = new CardLayout();
            this.setLayout(this.cardLayout);
            JPanel panel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            panel.setLayout(gbl);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.treePanel = this.createTreePanel();
            JCheckBox inverseButton = new JCheckBox(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Inverse"));
            inverseButton.setSelected(this.inverse);
            inverseButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    int state = e.getStateChange();
                    if (state == 2 || state == 1) {
                        TreePath path = OdsxFilterEditorPane.this.tree.getSelectionPath();
                        OdsxFilterEditorPane.this.inverse = !OdsxFilterEditorPane.this.inverse;
                        OdsxFilterEditorPane.this.filterTreeModel.fireTreeStructureChanged();
                        OdsxFilterEditorPane.this.tree.repaint();
                        OdsxFilterEditorPane.this.tree.scrollPathToVisible(path);
                    }
                }
            });
            this.deleteButton = new JButton(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Delete"));
            this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    OdsxFilterEditorPane.this.deleteEntries();
                }
            });
            this.newButton = new JButton(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.New"));
            this.newButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    OdsxFilterEditorPane.this.newEntry();
                }
            });
            this.filePopup = new JPopupMenu();
            JMenuItem saveButton = new JMenuItem(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Save"));
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    OdsxFilterEditorPane.this.save();
                }
            });
            this.filePopup.add(saveButton);
            JMenuItem saveAsButton = new JMenuItem(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.SaveAs"));
            saveAsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    OdsxFilterEditorPane.this.saveAs();
                }
            });
            this.filePopup.add(saveAsButton);
            JMenuItem loadButton = new JMenuItem(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Load"));
            loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    OdsxFilterEditorPane.this.load(false);
                }
            });
            this.filePopup.add(loadButton);
            JMenuItem overloadButton = new JMenuItem(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Overload"));
            overloadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    OdsxFilterEditorPane.this.load(true);
                }
            });
            this.filePopup.add(overloadButton);
            JButton fileButton = new JButton(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.File"));
            fileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    JButton but = (JButton)ev.getSource();
                    if (OdsxFilterEditorPane.this.filePopup != null) {
                        OdsxFilterEditorPane.this.filePopup.show(but, 0, but.getHeight());
                    }
                }
            });
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 10;
            panel.add((Component)inverseButton, gbc);
            gbc.gridx = 1;
            panel.add((Component)this.deleteButton, gbc);
            gbc.gridx = 2;
            panel.add((Component)this.newButton, gbc);
            gbc.gridx = 3;
            panel.add((Component)fileButton, gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 4;
            gbc.gridheight = 4;
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.fill = 1;
            gbc.anchor = 10;
            panel.add((Component)this.treePanel, gbc);
            JPanel colorPanel = new JPanel(new GridBagLayout());
            gbc.gridx = 0;
            gbc.gridy = 7;
            gbc.gridwidth = 4;
            gbc.gridheight = 1;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 10;
            JLabel legende = new JLabel(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.ColorMap"));
            legende.setHorizontalAlignment(0);
            colorPanel.add((Component)legende, gbc);
            gbc.gridx = 0;
            gbc.gridy = 8;
            gbc.gridwidth = 2;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 10;
            JPanel colPanel = new JPanel(new BorderLayout());
            colPanel.setBackground(VISIBLE_ENABLED_COLOR);
            JLabel label = new JLabel(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Visible&Enabled"));
            label.setHorizontalAlignment(0);
            label.setForeground(Color.yellow.darker());
            colPanel.add("Center", label);
            colorPanel.add((Component)colPanel, gbc);
            gbc.gridx = 2;
            colPanel = new JPanel(new BorderLayout());
            colPanel.setBackground(VISIBLE_COLOR);
            label.setForeground(Color.yellow.darker());
            label = new JLabel(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Visible&Disabled"));
            label.setHorizontalAlignment(0);
            colPanel.add("Center", label);
            colPanel.add("Center", label);
            colorPanel.add((Component)colPanel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 9;
            colPanel = new JPanel(new BorderLayout());
            colPanel.setBackground(ENABLED_COLOR);
            label.setForeground(Color.yellow.darker());
            label = new JLabel(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Invisible&Enabled"));
            label.setHorizontalAlignment(0);
            colPanel.add("Center", label);
            colPanel.add("Center", label);
            colorPanel.add((Component)colPanel, gbc);
            gbc.gridx = 2;
            colPanel = new JPanel(new BorderLayout());
            colPanel.setBackground(DEFAULT_COLOR);
            label = new JLabel(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Invisble&Disabled"));
            label.setHorizontalAlignment(0);
            colPanel.add("Center", label);
            colPanel.add("Center", label);
            colorPanel.add((Component)colPanel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 7;
            gbc.gridwidth = 4;
            gbc.gridheight = 3;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 10;
            panel.add((Component)colorPanel, gbc);
            this.add(panel, TREE_CARD);
            panel = new JPanel();
            gbl = new GridBagLayout();
            gbc = new GridBagConstraints();
            panel.setLayout(gbl);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            this.newLabel = new JLabel();
            JLabel nameLabel = new JLabel(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Name") + ":");
            JLabel valueLabel = new JLabel(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Value") + ":");
            this.nameTextField = new JTextField();
            this.valueTextField = new JTextField();
            this.visibleCheck = new JCheckBox(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Visible"));
            this.enableCheck = new JCheckBox(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Enabled"));
            JButton addButton = new JButton(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Add"));
            addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    OdsxFilterEditorPane.this.addEntry();
                }
            });
            JButton cancelButton = new JButton(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Back"));
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    OdsxFilterEditorPane.this.filterTreeModel.fireTreeStructureChanged();
                    OdsxFilterEditorPane.this.cardLayout.show((Container)((Object)OdsxFilterEditorPane.this), OdsxFilterEditorPane.TREE_CARD);
                    OdsxFilterEditorPane.this.elementsAdded = false;
                }
            });
            this.errorMessage = new JTextArea(5, 10);
            this.errorMessage.setEditable(false);
            this.errorMessage.setLineWrap(true);
            this.errorMessage.setBackground(panel.getBackground());
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 4;
            gbc.weightx = 100.0;
            gbc.weighty = 1000.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            panel.add((Component)new JPanel(), gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 4;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 10;
            panel.add((Component)this.newLabel, gbc);
            JPanel inputPanel = new JPanel(new GridBagLayout());
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            inputPanel.add((Component)nameLabel, gbc);
            gbc.gridx = 2;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            inputPanel.add((Component)this.nameTextField, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            inputPanel.add((Component)valueLabel, gbc);
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            inputPanel.add((Component)this.valueTextField, gbc);
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 4;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            panel.add((Component)inputPanel, gbc);
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.gridwidth = 2;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            panel.add((Component)this.visibleCheck, gbc);
            gbc.gridx = 2;
            gbc.gridy = 4;
            gbc.gridwidth = 2;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            panel.add((Component)this.enableCheck, gbc);
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.gridwidth = 2;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            panel.add((Component)addButton, gbc);
            gbc.gridx = 2;
            gbc.gridy = 5;
            gbc.gridwidth = 2;
            gbc.weightx = 100.0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.anchor = 17;
            panel.add((Component)cancelButton, gbc);
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.gridwidth = 4;
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            panel.add((Component)this.errorMessage, gbc);
            gbc.gridx = 1;
            gbc.gridy = 7;
            gbc.gridwidth = 2;
            gbc.weightx = 100.0;
            gbc.weighty = 1000.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            panel.add((Component)new JPanel(), gbc);
            this.add(panel, NEW_CARD);
            this.cardLayout.show((Container)((Object)this), TREE_CARD);
        } else {
            this.filterTreeModel = new FilterTreeModel();
            this.tree.setModel(this.filterTreeModel);
        }
    }

    protected JPanel createTreePanel() {
        if (this.treePanel == null) {
            this.treePanel = new JPanel(new BorderLayout());
        } else {
            this.treePanel.removeAll();
            this.treePanel.setLayout(new BorderLayout());
        }
        this.tree = new JTree();
        this.filterTreeModel = new FilterTreeModel();
        this.tree.setModel(this.filterTreeModel);
        this.tree.setCellRenderer(new FilterCellRenderer());
        this.tree.setCellEditor(new FilterCellEditor());
        this.tree.setEditable(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.toggleRenderer = new FilterToggleCellRenderer();
        this.tree.setBackground(this.getBackground());
        JScrollPane scroller = new JScrollPane(this.tree);
        this.treePanel.add("Center", scroller);
        return this.treePanel;
    }

    public void deleteEntries() {
        TreePath[] arr = this.tree.getSelectionPaths();
        int[] index = this.tree.getSelectionRows();
        FilterTreeNode parent = null;
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            this.tree.removeSelectionInterval(index[i], index[i]);
            Object[] elems = arr[i].getPath();
            FilterTreeNode theNode = (FilterTreeNode)elems[elems.length - 1];
            parent = theNode.parent;
            parent.group.remove((Object)theNode.filterValue.name);
        }
        if (size > 0) {
            this.filterTreeModel.fireTreeStructureChanged();
        }
    }

    public void newEntry() {
        Container top = this.getTopLevelAncestor();
        JRootPane root = null;
        if (top instanceof JDialog) {
            root = ((JDialog)top).getRootPane();
        } else if (top instanceof JFrame) {
            root = ((JFrame)top).getRootPane();
        }
        if (root != null) {
            root.setDefaultButton(null);
        }
        this.errorMessage.setText("");
        FilterTreeNode theNode = (FilterTreeNode)this.tree.getLastSelectedPathComponent();
        this.newLabel.setText(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.NewElementFor") + " " + FwkPropertyBus.getProperty((String)("OdsxFilterEditor.Text." + theNode.filterValue.invName)));
        this.cardLayout.show((Container)((Object)this), NEW_CARD);
        this.nameTextField.requestFocus();
    }

    public void addEntry() {
        String name = this.nameTextField.getText().trim();
        String value = this.valueTextField.getText().trim();
        if (name.length() > 0 && value.length() > 0) {
            FilterTreeNode theNode = (FilterTreeNode)this.tree.getLastSelectedPathComponent();
            FwkPropertyGroup newGroup = new FwkPropertyGroup();
            newGroup.setName(name);
            newGroup.put((Object)this.initialValue.nameKey(), (Object)name);
            newGroup.put((Object)this.initialValue.valueKey(), (Object)value);
            newGroup.put((Object)this.initialValue.visibleKey(), (Object)("" + this.visibleCheck.isSelected()));
            newGroup.put((Object)this.initialValue.enableKey(), (Object)("" + this.enableCheck.isSelected()));
            theNode.group.put((Object)name, (Object)newGroup);
            this.elementsAdded = true;
        } else {
            this.errorMessage.append(FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Error.TextField") + "\n");
        }
    }

    public void save() {
        FwkPropertyGroupInterface group = this.initialValue.getPropertyGroup();
        if (!group.save(group.getName())) {
            FwkContainer.showErrorMessage((Container)((Object)this), (String)FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Error.CannotSave"), (String)group.getName(), (Throwable)null);
        }
    }

    public void saveAs() {
        FwkDialogPaneValueInterface val;
        FwkPropertyGroupInterface group = this.initialValue.getPropertyGroup();
        File file = FileUtilities.getFile((String)group.getName());
        if (this.fileChooser == null) {
            FwkFileChooserDialogPaneValue value = new FwkFileChooserDialogPaneValue();
            value.setSelectedPath(file.getPath());
            this.fileChooser = new FwkFileChooserDialogPane(null, (FwkDialogPaneValueInterface)value);
        }
        if ((val = FwkDialogFactory.showDialog((Component)((Object)this), (String)FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.SaveAs"), (String)"SaveAs", (FwkDialogPaneInterface)this.fileChooser)) != null) {
            String outFile = (String)val.getProperty("SelectedPath");
            if (!group.save(outFile)) {
                FwkContainer.showErrorMessage((Container)((Object)this), (String)FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Error.CannotSave"), (String)group.getName(), (Throwable)null);
            } else {
                group.setName(outFile);
            }
        }
    }

    public void load(boolean overload) {
        FwkDialogPaneValueInterface val;
        FwkPropertyGroupInterface group = this.initialValue.getPropertyGroup();
        File file = FileUtilities.getFile((String)group.getName());
        if (this.fileChooser == null) {
            FwkFileChooserDialogPaneValue value = new FwkFileChooserDialogPaneValue();
            value.setSelectedPath(file.getPath());
            this.fileChooser = new FwkFileChooserDialogPane(null, (FwkDialogPaneValueInterface)value);
        }
        if ((val = FwkDialogFactory.showDialog((Component)((Object)this), (String)FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Text.Load"), (String)"Load", (FwkDialogPaneInterface)this.fileChooser)) != null) {
            String outFile = (String)val.getProperty("SelectedPath");
            if (!overload) {
                group.clear();
            }
            if (!group.load(outFile)) {
                FwkContainer.showErrorMessage((Container)((Object)this), (String)FwkPropertyBus.getProperty((String)"OdsxFilterEditor.Error.CannotLoad"), (String)group.getName(), (Throwable)null);
            } else {
                group.setName(outFile);
                this.filterTreeModel.fireTreeStructureChanged();
            }
        }
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        if (this.initialValue != null) {
            return new OdsxFilterEditorPaneValue((OdsxFilterInterface)this.initialValue.clone());
        }
        return new OdsxFilterEditorPaneValue(new OdsxFilter());
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        OdsxFilterEditorPaneValue paneValue = (OdsxFilterEditorPaneValue)value;
        this.initialValue = (OdsxFilterInterface)paneValue.getOdsxFilter().clone();
        this.createPane();
    }

    public static void main(String[] args) {
        FwkContainer.initialize((String[])args);
        OdsxFilter filter = new OdsxFilter();
        OdsxFilterEditorPaneValue initial = new OdsxFilterEditorPaneValue(filter);
        OdsxFilterEditorPane pane = new OdsxFilterEditorPane("title");
        pane.setSelectedValue((FwkDialogPaneValueInterface)initial);
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, (String)"OdsxFilterEditorPane - Test", (String)"", (FwkDialogPaneInterface)pane);
        System.out.println(val);
        System.exit(0);
    }

    protected class FilterCellEditor
    extends JTextField
    implements TreeCellEditor {
        protected FilterTreeNode theNode;
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        protected boolean cancelled = false;
        protected boolean isEditable = false;

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.theNode = null;
            if (!OdsxFilterEditorPane.this.inverse) {
                if (leaf && OdsxFilterEditorPane.this.initialValue.isEditable(((FilterTreeNode)value).parent.getFilterPath() + "." + OdsxFilterEditorPane.this.initialValue.valueKey())) {
                    this.theNode = (FilterTreeNode)value;
                    this.setText(this.theNode.getName());
                }
            } else {
                this.theNode = (FilterTreeNode)value;
                if (this.theNode.group != null && OdsxFilterEditorPane.this.initialValue.isEditable(this.theNode.getFilterPath() + "." + OdsxFilterEditorPane.this.initialValue.valueKey())) {
                    String prop = this.theNode.group.getProperty(OdsxFilterEditorPane.this.initialValue.valueKey());
                    if (prop != null) {
                        this.theNode = (FilterTreeNode)value;
                        this.setText(prop);
                    } else {
                        this.theNode = null;
                    }
                } else {
                    this.theNode = null;
                }
            }
            boolean bl = this.isEditable = this.theNode != null;
            if (this.isEditable) {
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        FilterCellEditor.this.fireEditingStopped();
                    }
                });
            }
            this.setColumns(this.getText().length());
            return this;
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = OdsxFilterEditorPane.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
        }

        public void cancelCellEditing() {
            this.cancelled = true;
        }

        public Object getCellEditorValue() {
            if (!this.cancelled) {
                String text = this.getText().trim();
                if (!OdsxFilterEditorPane.this.inverse) {
                    try {
                        this.theNode.parent.group.setProperty(OdsxFilterEditorPane.this.initialValue.valueKey(), text);
                    }
                    catch (Throwable throwable) {}
                } else {
                    this.theNode.group.setProperty(OdsxFilterEditorPane.this.initialValue.valueKey(), text);
                }
                this.theNode.filterValue = new FilterChild(OdsxFilterEditorPane.this.initialValue.valueKey(), text);
                OdsxFilterEditorPane.this.filterTreeModel.fireTreeStructureChanged();
            }
            return this.theNode;
        }

        public boolean isCellEditable(EventObject anEvent) {
            boolean ret = this.isEditable && anEvent != null && ((MouseEvent)anEvent).getClickCount() >= 2;
            Container top = this.getTopLevelAncestor();
            JRootPane root = null;
            if (top instanceof JDialog) {
                root = ((JDialog)top).getRootPane();
            } else if (top instanceof JFrame) {
                root = ((JFrame)top).getRootPane();
            }
            if (root != null) {
                root.setDefaultButton(null);
            }
            return ret;
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = OdsxFilterEditorPane.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return this.isCellEditable(anEvent);
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        protected void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? OdsxFilterEditorPane.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
        }

        protected void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$javax$swing$event$CellEditorListener == null ? OdsxFilterEditorPane.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
        }
    }

    public class FilterToggleCellRenderer
    extends JCheckBox
    implements TreeCellRenderer {
        FilterTreeNode theNode;

        public synchronized Component getTreeCellRendererComponent(JTree tree, Object currNode, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.theNode = (FilterTreeNode)currNode;
            FilterTreeNode parent = (FilterTreeNode)this.theNode.getParent();
            this.setText(FwkPropertyBus.getProperty((String)("OdsxFilterEditor.Text." + this.theNode.getName()), (String)this.theNode.getName()));
            selected = tree.isPathSelected(new TreePath(new Object[]{this.theNode.parent.parent.parent, this.theNode.parent.parent, this.theNode.parent, this.theNode}));
            if (selected) {
                parent.group.setProperty(this.theNode.getName(), !parent.group.getProperty(this.theNode.getName(), true));
                tree.repaint();
            }
            this.setSelected(parent.group.getProperty(this.theNode.getName(), true));
            tree.removeSelectionInterval(row, row);
            return this;
        }
    }

    public class FilterCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        public FilterCellRenderer() {
            this.setBackgroundSelectionColor(Color.orange);
            this.setBackgroundNonSelectionColor(this.getBackground());
        }

        public synchronized Component getTreeCellRendererComponent(JTree tree, Object currNode, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            FilterTreeNode theNode = (FilterTreeNode)currNode;
            String name = theNode.getName();
            if (theNode.parent != null && theNode.parent.equals(OdsxFilterEditorPane.this.filterTreeModel.root)) {
                name = FwkPropertyBus.getProperty((String)("OdsxFilterEditor.Text." + name), (String)name);
            }
            boolean visible = true;
            boolean enabled = true;
            if (OdsxFilterEditorPane.this.initialValue.visibleKey().compareTo(theNode.filterValue.name) == 0 || OdsxFilterEditorPane.this.initialValue.enableKey().compareTo(theNode.filterValue.name) == 0) {
                return OdsxFilterEditorPane.this.toggleRenderer.getTreeCellRendererComponent(tree, currNode, selected, expanded, leaf, row, hasFocus);
            }
            if (theNode.group == null) {
                this.setText(name);
            } else {
                this.setText(name);
                visible = theNode.group.getProperty(OdsxFilterEditorPane.this.initialValue.visibleKey(), visible);
                enabled = theNode.group.getProperty(OdsxFilterEditorPane.this.initialValue.enableKey(), enabled);
            }
            if (!selected) {
                this.setBackground(OdsxFilterEditorPane.this.treePanel.getBackground());
                if (visible && enabled) {
                    this.setForeground(VISIBLE_ENABLED_COLOR);
                } else if (visible) {
                    this.setForeground(VISIBLE_COLOR);
                } else if (enabled) {
                    this.setForeground(ENABLED_COLOR);
                } else {
                    this.setForeground(DEFAULT_COLOR);
                }
                if (tree.getSelectionCount() == 0) {
                    OdsxFilterEditorPane.this.newButton.setEnabled(false);
                    OdsxFilterEditorPane.this.deleteButton.setEnabled(false);
                    tree.getSelectionModel().setSelectionMode(1);
                }
            } else {
                this.setBackground(SELECTION_BG_COLOR);
                this.setForeground(INVERSE_COLOR);
                if (theNode == OdsxFilterEditorPane.this.filterTreeModel.root) {
                    OdsxFilterEditorPane.this.newButton.setEnabled(false);
                    OdsxFilterEditorPane.this.deleteButton.setEnabled(false);
                } else {
                    OdsxFilterEditorPane.this.newButton.setEnabled(theNode.parent == OdsxFilterEditorPane.this.filterTreeModel.root);
                    if (theNode.parent != null) {
                        OdsxFilterEditorPane.this.deleteButton.setEnabled(theNode.parent.parent == OdsxFilterEditorPane.this.filterTreeModel.root);
                    } else {
                        OdsxFilterEditorPane.this.deleteButton.setEnabled(false);
                    }
                }
            }
            if (OdsxFilterEditorPane.this.deleteButton.isEnabled()) {
                tree.getSelectionModel().setSelectionMode(4);
            } else {
                tree.getSelectionModel().setSelectionMode(1);
            }
            return this;
        }
    }

    public class FilterChild
    implements Comparable {
        String name;
        String invName;

        public FilterChild(String name, String invName) {
            this.name = name;
            this.invName = invName;
        }

        public String getName() {
            if (!OdsxFilterEditorPane.this.inverse) {
                return this.name;
            }
            return this.invName;
        }

        public int compareTo(Object obj) {
            if (!OdsxFilterEditorPane.this.inverse) {
                return this.name.compareTo(((FilterChild)obj).name);
            }
            return this.invName.compareTo(((FilterChild)obj).invName);
        }

        public String toString() {
            if (!OdsxFilterEditorPane.this.inverse) {
                return this.name + " -> " + this.invName;
            }
            return this.invName + " -> " + this.name;
        }
    }

    protected class FilterTreeNode
    implements TreeNode {
        protected FilterTreeNode parent;
        protected FwkPropertyGroupInterface group;
        protected FilterChild[] children;
        protected FilterChild filterValue;
        protected String value = null;

        public FilterTreeNode(TreeNode parent, FwkPropertyGroupInterface group) {
            this.group = group;
            this.parent = (FilterTreeNode)parent;
            this.refill();
        }

        public FilterTreeNode(TreeNode parent, String value) {
            this.parent = (FilterTreeNode)parent;
            this.children = null;
            this.group = null;
            this.value = value;
            this.refill();
        }

        protected void refill() {
            this.children = null;
            if (this.group != null) {
                String invKey;
                String key;
                Enumeration e = this.group.groupNames();
                Vector<FilterChild> vec = new Vector<FilterChild>();
                while (e.hasMoreElements()) {
                    key = (String)e.nextElement();
                    if (key == null) continue;
                    Object obj = this.group.get((Object)key);
                    if (obj instanceof FwkPropertyGroupInterface) {
                        invKey = ((FwkPropertyGroupInterface)obj).getProperty(OdsxFilterEditorPane.this.initialValue.valueKey());
                        if (invKey == null) {
                            invKey = key;
                        }
                        vec.add(new FilterChild(key, invKey));
                        continue;
                    }
                    if (key.compareTo(OdsxFilterEditorPane.this.initialValue.enableKey()) != 0 && key.compareTo(OdsxFilterEditorPane.this.initialValue.visibleKey()) != 0 && key.compareTo(OdsxFilterEditorPane.this.initialValue.valueKey()) != 0) continue;
                    invKey = key.compareTo(OdsxFilterEditorPane.this.initialValue.valueKey()) == 0 ? this.group.getName() : key;
                    vec.add(new FilterChild(key, invKey));
                }
                this.children = new FilterChild[vec.size()];
                this.children = vec.toArray(this.children);
                Arrays.sort(this.children);
                key = this.group.getName();
                invKey = this.group.getProperty(OdsxFilterEditorPane.this.initialValue.valueKey());
                if (invKey == null) {
                    invKey = this.group.getName().replace('.', '_');
                }
                this.filterValue = new FilterChild(key, invKey);
            } else {
                String invKey;
                String key;
                this.children = null;
                if (this.value.compareTo(OdsxFilterEditorPane.this.initialValue.valueKey()) == 0) {
                    key = this.parent.group.getProperty(this.value);
                    invKey = this.parent.group.getName();
                } else {
                    invKey = key = this.value;
                }
                this.filterValue = new FilterChild(key, invKey);
            }
        }

        public String getName() {
            return this.filterValue.getName();
        }

        public String getKey() {
            return this.filterValue.name;
        }

        public String toString() {
            return this.filterValue.toString();
        }

        public Enumeration children() {
            Enumeration ret = null;
            if (this.group != null) {
                ret = new Enumeration(){
                    int count = 0;

                    public boolean hasMoreElements() {
                        return this.count < FilterTreeNode.this.children.length;
                    }

                    public Object nextElement() {
                        return FilterTreeNode.this.getChildAt(this.count++);
                    }
                };
            }
            return ret;
        }

        public boolean getAllowsChildren() {
            return this.group != null;
        }

        public TreeNode getChildAt(int childIndex) {
            FilterTreeNode ret = null;
            if (this.group != null) {
                FwkPropertyGroupInterface newGroup = this.group.getGroup(this.children[childIndex].name);
                ret = newGroup != null ? new FilterTreeNode((TreeNode)this, newGroup) : new FilterTreeNode((TreeNode)this, this.children[childIndex].name);
            }
            return ret;
        }

        public int getChildCount() {
            int ret = 0;
            if (this.group != null) {
                ret = this.children.length;
            }
            return ret;
        }

        public int getIndex(TreeNode node) {
            int ret = Arrays.binarySearch(this.children, ((FilterTreeNode)node).filterValue);
            if (ret < 0) {
                this.refill();
                FilterTreeNode parent = this.parent;
                while (parent != null) {
                    parent.refill();
                    parent = parent.parent;
                }
                ret = Arrays.binarySearch(this.children, ((FilterTreeNode)node).filterValue);
                if (ret < 0) {
                    ret = 0;
                }
            }
            return ret;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return this.group == null || this.children.length == 0;
        }

        public String getFilterPath() {
            if (this.parent != null && !this.parent.equals(OdsxFilterEditorPane.this.filterTreeModel.root)) {
                return this.parent.getFilterPath() + "." + this.getKey();
            }
            return this.getKey();
        }

        public TreePath getTreePath() {
            FilterTreeNode p = this.parent;
            int count = 1;
            while (p != null) {
                ++count;
                p = p.parent;
            }
            Object[] obj = new Object[count];
            p = this.parent;
            obj[--count] = this;
            while (p != null) {
                obj[--count] = p;
                p = p.parent;
            }
            return new TreePath(obj);
        }

        public boolean isEditable() {
            return false;
        }
    }

    protected class FilterTreeModel
    implements TreeModel {
        Vector listeners = new Vector();
        FilterTreeNode root;

        public FilterTreeModel() {
            this.root = new FilterTreeNode(null, OdsxFilterEditorPane.this.initialValue.getPropertyGroup());
        }

        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }

        public Object getChild(Object parent, int index) {
            return ((FilterTreeNode)parent).getChildAt(index);
        }

        public int getChildCount(Object parent) {
            return ((FilterTreeNode)parent).getChildCount();
        }

        public int getIndexOfChild(Object parent, Object child) {
            return ((FilterTreeNode)parent).getIndex((TreeNode)child);
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object node) {
            return ((FilterTreeNode)node).isLeaf();
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public void fireTreeStructureChanged() {
            FilterTreeNode child;
            Enumeration children = this.root.children();
            while (children.hasMoreElements()) {
                child = (FilterTreeNode)children.nextElement();
                child.refill();
            }
            children = this.root.children();
            while (children.hasMoreElements()) {
                child = (FilterTreeNode)children.nextElement();
                TreeModelEvent ev = new TreeModelEvent((Object)this.root, new TreePath(new Object[]{this.root, child}));
                int size = this.listeners.size();
                for (int i = 0; i < size; ++i) {
                    TreeModelListener l = (TreeModelListener)this.listeners.get(i);
                    l.treeStructureChanged(ev);
                }
            }
            OdsxFilterEditorPane.this.newButton.setEnabled(false);
            OdsxFilterEditorPane.this.deleteButton.setEnabled(false);
        }
    }
}

