/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.dialog.FwkToggleDialogPane;
import com.highqsoft.fwk.dialog.FwkToggleDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.fwk.util.CheckList;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.dialog.OdsxAttributeEditorPane;
import com.highqsoft.odsx.dialog.OdsxAttributeEditorPaneValue;
import com.highqsoft.odsx.dialog.OdsxInstanceCreatePaneValue;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationElement;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.NameValueUnit;
import org.asam.ods.Relationship;

public class OdsxInstanceCreatePane
extends FwkDialogPane {
    public static final String version = "$Revision: 1.3 $";
    public static final String APPLICATIONELEMENTS = "ApplicationElements";
    public static final String APPLICATIONRELATIONS = "ApplicationRelations";
    public static final String INSTANCEPARENT = "InstanceParent";
    public static final String ATTRIBUTEEDITOR = "AttributeEditor";
    public static final String ERRORPANEL = "ErrorPanel";
    public static final String WORKINGPANEL = "WorkingPanel";
    public static HashMap baseTypeSelectable;
    protected AoSession session;
    protected JTextArea errorArea;
    protected JPanel mainPanel;
    protected JPanel cardPanel;
    protected CardLayout cardLayout;
    protected JButton next;
    protected JButton prev;
    protected int panelCounter;
    protected Vector panelNames;
    protected Vector labelText;
    protected JLabel description;
    JTextField parentFilter;
    JTextField instanceParentFilter;
    JRadioButton displayAoAny;
    FwkToggleDialogPane applicationElementPanel;
    FwkToggleDialogPane applicationRelationPanel;
    OdsxAttributeEditorPane attributeEditorPanel;
    CheckList instanceParent;
    String[] parentIds;

    public String getVersion() {
        return version;
    }

    public OdsxInstanceCreatePane(AoSession session) {
        this(null, session);
    }

    public OdsxInstanceCreatePane(String title, AoSession session) {
        this.session = session;
        if (title == null) {
            try {
                title = session.getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.createPane(title);
    }

    protected boolean isTypeSelectable(String type) {
        return baseTypeSelectable.get(type) == null;
    }

    protected void createPane(String title) {
        JPanel filterPanel;
        FwkToggleDialogPaneValue ini;
        JScrollPane scroll;
        JPanel subPanel;
        this.setLayout(new CardLayout());
        JPanel errorPanel = new JPanel();
        JLabel errorLabel = new JLabel(FwkPropertyBus.getProperty((String)"Error.Occured") + ".");
        errorPanel.add("North", errorLabel);
        this.errorArea = new JTextArea();
        this.errorArea.setEditable(false);
        this.errorArea.setBackground(this.getBackground());
        this.errorArea.setFont(errorLabel.getFont());
        errorPanel.add("Center", this.errorArea);
        JButton submit = new JButton(FwkPropertyBus.getProperty((String)"Text.Continue"));
        submit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CardLayout layout = (CardLayout)OdsxInstanceCreatePane.this.getLayout();
                layout.show((Container)((Object)OdsxInstanceCreatePane.this), OdsxInstanceCreatePane.WORKINGPANEL);
            }
        });
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        errorPanel.setLayout(gbl);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 0;
        gbc.anchor = 10;
        errorPanel.add((Component)errorLabel, gbc);
        gbc.gridy = 1;
        errorPanel.add((Component)this.errorArea, gbc);
        gbc.gridy = 2;
        errorPanel.add((Component)submit, gbc);
        JPanel workingPanel = new JPanel();
        workingPanel.setLayout(new BorderLayout());
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel();
        this.cardPanel.setLayout(this.cardLayout);
        workingPanel.add("Center", this.cardPanel);
        this.prev = new JButton(FwkPropertyBus.getProperty((String)"Text.Back"));
        this.prev.addActionListener(new BackButtonListener());
        this.prev.setEnabled(false);
        this.next = new JButton(FwkPropertyBus.getProperty((String)"Text.Continue"));
        this.next.addActionListener(new ContinueButtonListener());
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        JPanel buttonPanel = new JPanel(gbl);
        workingPanel.add("South", buttonPanel);
        this.description = new JLabel();
        this.description.setHorizontalAlignment(0);
        workingPanel.add("North", this.description);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        buttonPanel.add((Component)this.prev, gbc);
        gbc.gridx = 2;
        gbc.anchor = 13;
        buttonPanel.add((Component)this.next, gbc);
        this.panelCounter = 0;
        this.panelNames = new Vector();
        this.labelText = new Vector();
        try {
            subPanel = new JPanel(new BorderLayout());
            this.applicationElementPanel = new FwkToggleDialogPane();
            scroll = new JScrollPane((Component)this.applicationElementPanel);
            this.applicationElementPanel.setExclusive(true);
            ini = new FwkToggleDialogPaneValue();
            ApplicationElement[] elems = this.session.getApplicationStructure().getElements("*");
            int size = elems.length;
            Object[] names = new String[size];
            HashMap<Object, ApplicationElement> elemMap = new HashMap<Object, ApplicationElement>();
            for (int i = 0; i < size; ++i) {
                names[i] = elems[i].getName();
                elemMap.put(names[i], elems[i]);
            }
            Arrays.sort(names);
            for (int i = 0; i < size; ++i) {
                ApplicationElement elem = (ApplicationElement)elemMap.get(names[i]);
                String type = elem.getBaseElement().getType();
                if (!this.isTypeSelectable(type.toUpperCase())) continue;
                ini.add((String)names[i], elem.getBaseElement().getType(), i == 0);
            }
            this.applicationElementPanel.setSelectedValue((FwkDialogPaneValueInterface)ini);
            this.displayAoAny = new JRadioButton(FwkPropertyBus.getProperty((String)"OdsxInstanceCreatePane.Text.DisplayAoAny"));
            this.displayAoAny.setSelected(false);
            subPanel.add("Center", scroll);
            subPanel.add("South", this.displayAoAny);
            this.cardPanel.add((Component)subPanel, APPLICATIONELEMENTS);
            this.panelNames.add(APPLICATIONELEMENTS);
            this.labelText.add("Bitte selektieren Sie ein ApplicationsElement");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            subPanel = new JPanel(new BorderLayout());
            this.applicationRelationPanel = new FwkToggleDialogPane();
            scroll = new JScrollPane((Component)this.applicationRelationPanel);
            this.applicationRelationPanel.setExclusive(true);
            ini = new FwkToggleDialogPaneValue();
            this.applicationRelationPanel.setSelectedValue((FwkDialogPaneValueInterface)ini);
            subPanel.add("Center", scroll);
            filterPanel = new JPanel(new BorderLayout());
            filterPanel.setBorder(BorderFactory.createBevelBorder(1));
            JLabel filterLabel = new JLabel(FwkPropertyBus.getProperty((String)"Text.InstanceFilter") + ":");
            this.parentFilter = new JTextField("*");
            filterPanel.add("West", filterLabel);
            filterPanel.add("Center", this.parentFilter);
            subPanel.add("South", filterPanel);
            this.cardPanel.add((Component)subPanel, APPLICATIONRELATIONS);
            this.panelNames.add(APPLICATIONRELATIONS);
            this.labelText.add("Bitte selektieren Sie das ApplicationsElement f\u00fcr den Vorg\u00e4nger-Knoten.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            subPanel = new JPanel(new BorderLayout());
            JPanel parentPanel = new JPanel(new BorderLayout());
            this.instanceParent = new CheckList();
            JScrollPane scroll2 = new JScrollPane((Component)this.instanceParent);
            this.instanceParent.setSelectionMode(0);
            parentPanel.add("Center", scroll2);
            subPanel.add("Center", parentPanel);
            filterPanel = new JPanel(new BorderLayout());
            filterPanel.setBorder(BorderFactory.createBevelBorder(1));
            JLabel filterLabel = new JLabel(FwkPropertyBus.getProperty((String)"Text.InstanceFilter") + ":");
            this.instanceParentFilter = new JTextField("*");
            JButton apply = new JButton(FwkPropertyBus.getProperty((String)"Text.Apply"));
            apply.setDefaultCapable(true);
            apply.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    String filter = OdsxInstanceCreatePane.this.instanceParentFilter.getText().trim();
                    if (filter.length() == 0) {
                        filter = "*";
                    }
                    OdsxInstanceCreatePane.this.instanceParentFilter.setText(filter);
                    OdsxInstanceCreatePane.this.parentFilter.setText(filter);
                    OdsxInstanceCreatePane.this.updateInstanceParents();
                }
            });
            filterPanel.add("West", filterLabel);
            filterPanel.add("Center", this.instanceParentFilter);
            filterPanel.add("East", apply);
            subPanel.add("South", filterPanel);
            this.cardPanel.add((Component)subPanel, INSTANCEPARENT);
            this.panelNames.add(INSTANCEPARENT);
            this.labelText.add("Bitte selektieren Sie einen Vorg\u00e4nger-Knoten.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            subPanel = new JPanel(new BorderLayout());
            this.attributeEditorPanel = new OdsxAttributeEditorPane();
            scroll = new JScrollPane((Component)((Object)this.attributeEditorPanel));
            subPanel.add("Center", scroll);
            this.cardPanel.add((Component)subPanel, ATTRIBUTEEDITOR);
            this.panelNames.add(ATTRIBUTEEDITOR);
            this.labelText.add("Bitte geben Sie die Attribute ein.");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.cardLayout.show(this.cardPanel, (String)this.panelNames.get(this.panelCounter));
        this.description.setText((String)this.labelText.get(this.panelCounter));
        this.add(errorPanel, ERRORPANEL);
        this.add(workingPanel, WORKINGPANEL);
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show((Container)((Object)this), WORKINGPANEL);
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        OdsxInstanceCreatePaneValue ret = new OdsxInstanceCreatePaneValue(this.getIdent(), this.session);
        return ret;
    }

    public void buttonCreated(int id, JButton button) {
        if (button != null) {
            switch (id) {
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 2: {
                    button.addActionListener(new OKButtonListener());
                    break;
                }
                case 3: {
                    button.addActionListener(new ResetButtonListener());
                    break;
                }
            }
        }
    }

    protected void updateApplicationRelations() {
        FwkToggleDialogPaneValue ini = new FwkToggleDialogPaneValue();
        try {
            String applicationElement = this.getApplicationElementName();
            ApplicationElement[] elems = this.session.getApplicationStructure().getElementByName(applicationElement).getRelatedElementsByRelationship(Relationship.FATHER);
            int size = elems.length;
            if (size == 0) {
                try {
                    elems = this.session.getApplicationStructure().getElementsByBaseType("AoEnvironment");
                }
                catch (Throwable environmentNotFound) {
                    // empty catch block
                }
                size = elems.length;
            }
            Object[] names = new String[size];
            HashMap<Object, ApplicationElement> elemMap = new HashMap<Object, ApplicationElement>();
            for (int i = 0; i < size; ++i) {
                names[i] = elems[i].getName();
                elemMap.put(names[i], elems[i]);
            }
            Arrays.sort(names);
            for (int i = 0; i < size; ++i) {
                ApplicationElement elem = (ApplicationElement)elemMap.get(names[i]);
                ini.add((String)names[i], elem.getBaseElement().getType(), i == 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.applicationRelationPanel.setSelectedValue((FwkDialogPaneValueInterface)ini);
    }

    protected void updateInstanceParents() {
        String filter = this.parentFilter.getText().trim();
        if (filter.length() == 0) {
            filter = "*";
        }
        this.instanceParentFilter.setText(filter);
        this.parentFilter.setText(filter);
        Object[] names = new String[]{};
        try {
            NameValueUnit nvu;
            InstanceElement instance;
            int count;
            ApplicationElement elem = this.session.getApplicationStructure().getElementByName(this.getParentApplicationElementName());
            InstanceElementIterator it = elem.getInstances(filter);
            int size = it.getCount();
            names = new String[size];
            this.parentIds = new String[size];
            HashMap<Object, InstanceElement> map = new HashMap<Object, InstanceElement>();
            for (count = 0; count < size; ++count) {
                String iName;
                instance = it.nextOne();
                try {
                    iName = instance.getName().trim();
                }
                catch (Throwable tName) {
                    iName = "???";
                }
                if (iName.length() == 0) {
                    iName = "???";
                }
                try {
                    nvu = instance.getValueByBaseName("version");
                    names[count] = iName + ";" + OdsxHelper.ts_unionToString(nvu.value.u);
                }
                catch (Throwable tNVU) {
                    names[count] = iName;
                }
                map.put(names[count], instance);
            }
            Arrays.sort(names);
            for (count = 0; count < size; ++count) {
                instance = (InstanceElement)map.get(names[count]);
                try {
                    nvu = instance.getValueByBaseName("id");
                    this.parentIds[count] = OdsxHelper.ts_unionToString(nvu.value.u);
                    continue;
                }
                catch (Throwable tNVU) {
                    this.parentIds[count] = "-1";
                }
            }
            map.clear();
            it.destroy();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.instanceParent.setListData(names);
        this.instanceParent.setSelectedIndex(0);
    }

    protected void updateAttributeEditor() {
        OdsxAttributeEditorPaneValue ini = new OdsxAttributeEditorPaneValue();
        try {
            String applicationElement = this.getApplicationElementName();
            ApplicationElement elem = this.session.getApplicationStructure().getElementByName(applicationElement);
            ini.fillFrom(elem);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.attributeEditorPanel.setSelectedValue((FwkDialogPaneValueInterface)ini);
    }

    protected boolean checkCurrentPanel() {
        boolean ret = true;
        String name = (String)this.panelNames.get(this.panelCounter);
        if (name.compareTo(APPLICATIONELEMENTS) == 0) {
            if (this.getApplicationElementName() == null) {
                ret = false;
                this.errorArea.setText("Bitte w\u00e4hlen Sie zun\u00e4chst das ApplicationsElement \nf\u00fcr das zu erzeugende InstanceElement.");
                CardLayout layout = (CardLayout)this.getLayout();
                layout.show((Container)((Object)this), ERRORPANEL);
            }
        } else if (name.compareTo(APPLICATIONRELATIONS) == 0 && this.getParentApplicationElementName() == null) {
            ret = false;
            this.errorArea.setText("Bitte w\u00e4hlen Sie zun\u00e4chst das ApplicationsElement f\u00fcr den Knoten aus, \nindem das InstanceElement erzeugt werden soll.");
            CardLayout layout = (CardLayout)this.getLayout();
            layout.show((Container)((Object)this), ERRORPANEL);
        }
        return ret;
    }

    public String getApplicationElementName() {
        try {
            FwkToggleDialogPaneValue val = (FwkToggleDialogPaneValue)this.applicationElementPanel.getSelectedValue();
            String[] ret = val.get();
            if (ret.length > 0) {
                return ret[0];
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getParentApplicationElementName() {
        try {
            FwkToggleDialogPaneValue val = (FwkToggleDialogPaneValue)this.applicationRelationPanel.getSelectedValue();
            String[] ret = val.get();
            if (ret.length > 0) {
                return ret[0];
            }
            ApplicationElement[] elem = this.session.getApplicationStructure().getElementsByBaseType("AoEnvironment");
            if (elem.length == 0) {
                return null;
            }
            return elem[0].getName();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
    }

    public static void main(String[] args) {
        FwkContainer.initialize((String[])args);
        OdsxInstanceCreatePane pane = new OdsxInstanceCreatePane("title", null);
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, (String)"OdsxInstanceCreatePane - Test", (String)"", (FwkDialogPaneInterface)pane);
        if (val != null) {
            System.out.println("FwkDialogPaneValueSupport Properties:");
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
        } else {
            System.out.println("No value returned from OdsxInstanceCreatePane.");
        }
    }

    static {
        Object marker = new Object();
        baseTypeSelectable = new HashMap();
        baseTypeSelectable.put("AOANY", marker);
    }

    public class ResetButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    public class OKButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
        }
    }

    public class ContinueButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            if (OdsxInstanceCreatePane.this.checkCurrentPanel()) {
                ++OdsxInstanceCreatePane.this.panelCounter;
                if (OdsxInstanceCreatePane.this.panelCounter == OdsxInstanceCreatePane.this.panelNames.size() - 1) {
                    OdsxInstanceCreatePane.this.next.setEnabled(false);
                }
                OdsxInstanceCreatePane.this.prev.setEnabled(true);
                try {
                    String name = (String)OdsxInstanceCreatePane.this.panelNames.get(OdsxInstanceCreatePane.this.panelCounter);
                    if (name.compareTo(OdsxInstanceCreatePane.APPLICATIONRELATIONS) == 0) {
                        OdsxInstanceCreatePane.this.updateApplicationRelations();
                    } else if (name.compareTo(OdsxInstanceCreatePane.INSTANCEPARENT) == 0) {
                        OdsxInstanceCreatePane.this.updateInstanceParents();
                    } else if (name.compareTo(OdsxInstanceCreatePane.ATTRIBUTEEDITOR) == 0) {
                        OdsxInstanceCreatePane.this.updateAttributeEditor();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                OdsxInstanceCreatePane.this.cardLayout.show(OdsxInstanceCreatePane.this.cardPanel, (String)OdsxInstanceCreatePane.this.panelNames.get(OdsxInstanceCreatePane.this.panelCounter));
                OdsxInstanceCreatePane.this.description.setText((String)OdsxInstanceCreatePane.this.labelText.get(OdsxInstanceCreatePane.this.panelCounter));
            }
        }
    }

    public class BackButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            --OdsxInstanceCreatePane.this.panelCounter;
            if (OdsxInstanceCreatePane.this.panelCounter == 0) {
                OdsxInstanceCreatePane.this.prev.setEnabled(false);
            }
            OdsxInstanceCreatePane.this.next.setEnabled(true);
            String name = (String)OdsxInstanceCreatePane.this.panelNames.get(OdsxInstanceCreatePane.this.panelCounter);
            if (name.compareTo(OdsxInstanceCreatePane.APPLICATIONRELATIONS) == 0) {
                String filter = OdsxInstanceCreatePane.this.instanceParentFilter.getText().trim();
                if (filter.length() == 0) {
                    filter = "*";
                }
                OdsxInstanceCreatePane.this.instanceParentFilter.setText(filter);
                OdsxInstanceCreatePane.this.parentFilter.setText(filter);
            }
            OdsxInstanceCreatePane.this.cardLayout.show(OdsxInstanceCreatePane.this.cardPanel, (String)OdsxInstanceCreatePane.this.panelNames.get(OdsxInstanceCreatePane.this.panelCounter));
            OdsxInstanceCreatePane.this.description.setText((String)OdsxInstanceCreatePane.this.labelText.get(OdsxInstanceCreatePane.this.panelCounter));
        }
    }
}

