/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.dialog;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.dialog.FwkDialogPane;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.odsx.OdsxFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxGUIInterface;
import com.highqsoft.interfaces.odsx.OdsxPresentableElementInterface;
import com.highqsoft.interfaces.odsx.OdsxRelationEditorInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.dialog.OdsxInstanceEditorPaneValue;
import com.highqsoft.odsx.gui.OdsxDT_ENUMEditor;
import com.highqsoft.odsx.gui.OdsxRelationEditor;
import com.highqsoft.odsx.gui.UnhandledRelationException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.asam.ods.AoException;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.InstanceElement;
import org.asam.ods.NameValueUnit;
import org.asam.ods.TS_Union;

public class OdsxInstanceEditorPane
extends FwkDialogPane {
    private static final int INSETS = 5;
    public static final String version = "$Revision: 1.12 $";
    static final HashMap editorClasses = new HashMap();
    static final boolean deLang;
    OdsxInstanceEditorPaneValue initialValue = null;
    HashMap widgets;
    HashMap validChecks;
    OdsxFilterInterface odsxFilter;
    Vector relEditors;

    public String getVersion() {
        return version;
    }

    public OdsxInstanceEditorPane(OdsxPresentableElementInterface elem) {
        this(null, elem);
    }

    public OdsxInstanceEditorPane(String title, OdsxPresentableElementInterface elem) {
        this(title, elem, false);
    }

    public OdsxInstanceEditorPane(String title, OdsxPresentableElementInterface elem, boolean baseAttrsOnly) {
        if (elem != null) {
            Object obj = elem.getValueAsObject();
            this.odsxFilter = elem.getOdsxFilter();
            if (obj instanceof InstanceElement) {
                InstanceElement ie = (InstanceElement)obj;
                this.initialValue = new OdsxInstanceEditorPaneValue(title, ie, baseAttrsOnly);
                try {
                    if (title == null) {
                        title = ie.getName();
                    }
                }
                catch (Throwable t) {}
            } else {
                ApplicationElement ae = (ApplicationElement)obj;
                this.initialValue = new OdsxInstanceEditorPaneValue(title, ae, baseAttrsOnly);
                try {
                    if (title == null) {
                        title = ae.getName();
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        this.createPane(title);
    }

    public OdsxInstanceEditorPane(InstanceElement ie) {
        this(null, ie);
    }

    public OdsxInstanceEditorPane(String title, InstanceElement ie) {
        this(title, ie, false);
    }

    public OdsxInstanceEditorPane(String title, InstanceElement ie, boolean baseAttrsOnly) {
        this.initialValue = new OdsxInstanceEditorPaneValue(title, ie, baseAttrsOnly);
        if (title == null) {
            try {
                title = ie.getName();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.odsxFilter = null;
        this.createPane(title);
    }

    public OdsxInstanceEditorPane(ApplicationElement ae) {
        this(null, ae);
    }

    public OdsxInstanceEditorPane(String title, ApplicationElement ae) {
        this(title, ae, false);
    }

    public OdsxInstanceEditorPane(String title, ApplicationElement ae, boolean baseAttrsOnly) {
        this.initialValue = new OdsxInstanceEditorPaneValue(title, ae, baseAttrsOnly);
        if (title == null) {
            try {
                title = ae.getName();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.odsxFilter = null;
        this.createPane(title);
    }

    protected void createPane(String title) {
        if (this.getComponentCount() == 0) {
            this.title = title;
            this.relEditors = new Vector();
            JLabel[] labels = null;
            JLabel[] units = null;
            JLabel[] datatypes = null;
            Component[] inputs = null;
            JCheckBox[] valids = null;
            String[] names = null;
            int count = 0;
            int size = 0;
            if (this.initialValue != null) {
                size = this.initialValue.size();
            }
            JPanel subPanel = new JPanel();
            JScrollPane scroller = new JScrollPane(subPanel);
            this.widgets = new HashMap();
            this.validChecks = new HashMap();
            GridBagLayout gbl = new GridBagLayout();
            GridBagConstraints gbc = new GridBagConstraints();
            subPanel.setLayout(gbl);
            try {
                if (size > 0) {
                    Iterator it = this.initialValue.getProperties();
                    labels = new JLabel[size];
                    units = new JLabel[size];
                    datatypes = new JLabel[size];
                    inputs = new Component[size];
                    valids = new JCheckBox[size];
                    names = new String[size];
                    for (int i = 0; i < size; ++i) {
                        inputs[i] = null;
                        try {
                            String key = (String)it.next();
                            NameValueUnit nvu = (NameValueUnit)this.initialValue.getProperty(key);
                            names[i] = nvu.valName;
                            TS_Union ts = nvu.value.u;
                            valids[i] = new JCheckBox();
                            valids[i].setSelected((nvu.value.flag & 1) != 0);
                            String type = OdsxHelper.datatypeToString(ts.discriminator());
                            if (ts.discriminator().value() != 30) {
                                try {
                                    Class<?> clazz = Class.forName((String)editorClasses.get(type));
                                    inputs[i] = (JComponent)clazz.newInstance();
                                    if (!this.initialValue.isEditable(key)) {
                                        valids[i].setEnabled(false);
                                        inputs[i].setEnabled(false);
                                        inputs[i].setBackground(subPanel.getBackground());
                                        valids[i].setBackground(subPanel.getBackground());
                                    } else {
                                        valids[i].setEnabled(true);
                                        inputs[i].setEnabled(true);
                                    }
                                    ((OdsxGUIInterface)((Object)inputs[i])).setTS_Union(ts);
                                }
                                catch (Throwable t) {
                                    this.initialValue.setEditable(key, false);
                                }
                            } else {
                                try {
                                    if (this.initialValue.isInstanceElement()) {
                                        inputs[i] = new OdsxDT_ENUMEditor(this.initialValue.getInstanceElement(), nvu.valName);
                                        inputs[i].setBackground(subPanel.getBackground());
                                        valids[i].setBackground(subPanel.getBackground());
                                        ((OdsxGUIInterface)((Object)inputs[i])).setTS_Union(ts);
                                    } else {
                                        this.initialValue.setEditable(key, false);
                                    }
                                }
                                catch (Throwable t) {
                                    this.initialValue.setEditable(key, false);
                                }
                            }
                            if (inputs[i] == null) continue;
                            labels[i] = this.odsxFilter != null ? new JLabel(this.odsxFilter.getTranslatedKey(nvu.valName, nvu.valName) + ":") : new JLabel(nvu.valName + ":");
                            units[i] = nvu.unit != null && nvu.unit.length() != 0 ? new JLabel("[" + nvu.unit + "]") : new JLabel("");
                            datatypes[i] = new JLabel(OdsxHelper.datatypeToString(ts.discriminator()));
                            ++count;
                            inputs[i].addKeyListener(new ActionKeyListener(names[i]));
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                if (count > 0) {
                    int i;
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    gbc.gridwidth = 1;
                    gbc.gridheight = 1;
                    gbc.insets = new Insets(5, 5, 5, 5);
                    gbc.gridx = 1;
                    gbc.gridwidth = 4;
                    gbc.weightx = 0.0;
                    gbc.weighty = 0.0;
                    gbc.fill = 0;
                    gbc.anchor = 17;
                    subPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Text.AttributeName")), gbc);
                    gbc.gridx = 5;
                    gbc.gridwidth = 4;
                    gbc.weightx = 100.0;
                    gbc.weighty = 100.0;
                    gbc.fill = 2;
                    gbc.anchor = 10;
                    subPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Text.AttributeValue")), gbc);
                    gbc.gridx = 9;
                    gbc.gridwidth = 1;
                    gbc.weightx = 0.0;
                    gbc.weighty = 0.0;
                    gbc.fill = 2;
                    gbc.anchor = 10;
                    subPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Text.Valid")), gbc);
                    gbc.gridx = 11;
                    gbc.gridwidth = 0;
                    gbc.fill = 0;
                    gbc.anchor = 17;
                    gbc.weightx = 0.0;
                    gbc.weighty = 0.0;
                    subPanel.add((Component)new JLabel(FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Text.DataType")), gbc);
                    count = 0;
                    for (int i2 = 0; i2 < size; ++i2) {
                        if (inputs[i2] == null) continue;
                        this.validChecks.put(names[i2], valids[i2]);
                        this.widgets.put(names[i2], inputs[i2]);
                        gbc.gridx = 1;
                        gbc.gridy = 1 + count++;
                        gbc.gridwidth = 4;
                        gbc.weightx = 0.0;
                        gbc.weighty = 0.0;
                        gbc.fill = 0;
                        gbc.anchor = 17;
                        subPanel.add((Component)labels[i2], gbc);
                        gbc.gridx = 5;
                        gbc.gridwidth = 4;
                        gbc.weightx = 100.0;
                        gbc.weighty = 100.0;
                        gbc.fill = 2;
                        gbc.anchor = 10;
                        subPanel.add(inputs[i2], gbc);
                        gbc.gridx = 9;
                        gbc.gridwidth = 1;
                        gbc.weightx = 0.0;
                        gbc.weighty = 0.0;
                        gbc.fill = 2;
                        gbc.anchor = 10;
                        subPanel.add((Component)valids[i2], gbc);
                        gbc.gridx = 10;
                        gbc.gridwidth = 1;
                        gbc.fill = 0;
                        gbc.anchor = 17;
                        gbc.weightx = 0.0;
                        gbc.weighty = 0.0;
                        subPanel.add((Component)units[i2], gbc);
                        gbc.gridx = 11;
                        gbc.gridwidth = 0;
                        gbc.fill = 0;
                        gbc.anchor = 17;
                        gbc.weightx = 0.0;
                        gbc.weighty = 0.0;
                        subPanel.add((Component)datatypes[i2], gbc);
                    }
                    InstanceElement ieObj = this.getInstanceElement();
                    ApplicationElement aeObj = this.getApplicationElement();
                    ApplicationRelation[] relArr = aeObj.getAllRelations();
                    size = relArr.length;
                    ButtonGroup buttonGroup = null;
                    int[] fatherArr = new int[relArr.length];
                    int fCount = 0;
                    for (i = 0; i < size; ++i) {
                        int ship;
                        if (relArr[i].getRelationType().value() != 0 || (ship = relArr[i].getRelationship().value()) != 1 && ship != 0) continue;
                        fatherArr[fCount++] = i;
                    }
                    if (fCount > 2) {
                        buttonGroup = new ButtonGroup();
                    }
                    if (fCount > 0) {
                        for (int i3 = 0; i3 < fCount; ++i3) {
                            ApplicationRelation arel = relArr[fatherArr[i3]];
                            relArr[fatherArr[i3]] = relArr[i3];
                            relArr[i3] = arel;
                        }
                    }
                    size = relArr.length;
                    for (i = 0; i < size; ++i) {
                        try {
                            OdsxRelationEditor editor = new OdsxRelationEditor(ieObj, aeObj, relArr[i], buttonGroup);
                            JLabel lab = new JLabel(relArr[i].getRelationName() + ":");
                            JLabel typeLabel = editor.getTypeLabel();
                            ApplicationElement relAeObj = editor.getRelatedApplicationElement();
                            String relName = relAeObj.getName();
                            gbc.gridx = 1;
                            gbc.gridy = 1 + count++;
                            gbc.gridwidth = 4;
                            gbc.weightx = 0.0;
                            gbc.weighty = 0.0;
                            gbc.fill = 0;
                            gbc.anchor = 17;
                            subPanel.add((Component)lab, gbc);
                            gbc.gridx = 5;
                            gbc.gridwidth = 4;
                            gbc.weightx = 100.0;
                            gbc.weighty = 100.0;
                            gbc.fill = 2;
                            gbc.anchor = 10;
                            subPanel.add((Component)editor, gbc);
                            gbc.gridx = 9;
                            gbc.gridwidth = 1;
                            gbc.weightx = 0.0;
                            gbc.weighty = 0.0;
                            gbc.fill = 2;
                            gbc.anchor = 10;
                            subPanel.add((Component)typeLabel, gbc);
                            gbc.gridx = 10;
                            gbc.gridwidth = 0;
                            gbc.fill = 0;
                            gbc.anchor = 17;
                            gbc.weightx = 0.0;
                            gbc.weighty = 0.0;
                            subPanel.add((Component)new JLabel(relName), gbc);
                            this.relEditors.add(editor);
                            continue;
                        }
                        catch (UnhandledRelationException ure) {
                            if (FwkContainer.getDebugLevel() <= 0) continue;
                            System.out.println(((Object)((Object)this)).getClass().getName() + ".createPane() -> " + ure.getClass().getName() + " " + ure.getMessage() + " " + i);
                        }
                    }
                    gbc.fill = 1;
                    gbc.weightx = 1000.0;
                    gbc.weighty = 1000.0;
                    ++gbc.gridy;
                    gbc.gridx = 0;
                    subPanel.add((Component)new JPanel(), gbc);
                    this.setLayout(new GridBagLayout());
                    gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    gbc.weightx = 100.0;
                    gbc.weighty = 100.0;
                    gbc.fill = 1;
                    gbc.anchor = 11;
                    this.add(scroller, gbc);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.fillInputs();
            OdsxRelationEditorInterface[] arr = this.relEditors.toArray(new OdsxRelationEditorInterface[this.relEditors.size()]);
            this.initialValue.setRelationEditors(arr);
            if (inputs.length > 0) {
                Dimension dim = inputs[0].getPreferredSize();
                scroller.getVerticalScrollBar().setUnitIncrement(dim.height + 10);
                scroller.getHorizontalScrollBar().setUnitIncrement(dim.height + 10);
            } else {
                scroller.getVerticalScrollBar().setUnitIncrement(20);
                scroller.getHorizontalScrollBar().setUnitIncrement(20);
            }
        }
    }

    protected void fillInputs() {
        Iterator it = this.widgets.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            OdsxGUIInterface c = (OdsxGUIInterface)this.widgets.get(name);
            try {
                NameValueUnit nvu = (NameValueUnit)this.initialValue.getProperty(name);
                c.setTS_Union(nvu.value.u);
            }
            catch (Throwable t) {}
        }
    }

    protected void readInputs() {
        Iterator it = this.widgets.keySet().iterator();
        try {
            while (it.hasNext()) {
                String name = (String)it.next();
                OdsxGUIInterface c = (OdsxGUIInterface)this.widgets.get(name);
                JCheckBox flag = (JCheckBox)this.validChecks.get(name);
                TS_Union union = c.getTS_Union();
                if (union == null) continue;
                NameValueUnit nvu = (NameValueUnit)this.initialValue.getProperty(name);
                nvu.value.u = union;
                nvu.value.flag = flag.isSelected() ? (short)15 : (short)0;
                this.initialValue.setProperty(name, nvu);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public FwkDialogPaneValueInterface getSelectedValue() {
        this.readInputs();
        return this.initialValue;
    }

    public InstanceElement getInstanceElement() {
        return this.initialValue.getInstanceElement();
    }

    public ApplicationElement getApplicationElement() {
        ApplicationElement ret = this.initialValue.getApplicationElement();
        if (ret == null) {
            try {
                ret = this.getInstanceElement().getApplicationElement();
            }
            catch (AoException aoException) {
                // empty catch block
            }
        }
        return ret;
    }

    public void buttonCreated(int id, JButton button) {
        if (button != null) {
            switch (id) {
                case 1: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 2: {
                    button.addActionListener(new OKButtonListener());
                    break;
                }
                case 3: {
                    button.addActionListener(new ResetButtonListener());
                    break;
                }
            }
        }
    }

    public void setSelectedValue(FwkDialogPaneValueInterface value) {
        if (this.getComponentCount() == 0) {
            this.initialValue = (OdsxInstanceEditorPaneValue)value;
            this.setPreferredSize(null);
            this.createPane(this.title);
        }
    }

    public static void main(String[] args) {
        FwkContainer.initialize((String[])args);
        OdsxInstanceEditorPane pane = new OdsxInstanceEditorPane("title", (ApplicationElement)null);
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog(null, (String)"OdsxInstanceEditorPane - Test", (String)"", (FwkDialogPaneInterface)pane);
        if (val != null) {
            System.out.println("FwkDialogPaneValueSupport Properties:");
            Iterator it = val.getProperties();
            if (it != null) {
                while (it.hasNext()) {
                    Object key = it.next();
                    System.out.println("Key: " + key + " / value:" + val.getProperty(key.toString()));
                }
            }
        } else {
            System.out.println("No value returned from OdsxInstanceEditorPane.");
        }
    }

    static {
        FwkContainer.addComponentProperties((Class)OdsxInstanceEditorPane.class);
        Locale locale = FwkContainer.getLocale();
        deLang = locale.getLanguage().compareTo("de") == 0;
        editorClasses.put("DT_UNKNOWN", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_UNKNOWN", (String)"com.highqsoft.odsx.gui.OdsxDT_UNKNOWNEditor"));
        editorClasses.put("DT_STRING", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_STRING", (String)"com.highqsoft.odsx.gui.OdsxDT_STRINGEditor"));
        editorClasses.put("DT_SHORT", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_SHORT", (String)"com.highqsoft.odsx.gui.OdsxDT_SHORTEditor"));
        editorClasses.put("DT_FLOAT", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_FLOAT", (String)"com.highqsoft.odsx.gui.OdsxDT_FLOATEditor"));
        editorClasses.put("DT_BOOLEAN", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_BOOLEAN", (String)"com.highqsoft.odsx.gui.OdsxDT_BOOLEANEditor"));
        editorClasses.put("DT_BYTE", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_BYTE", (String)"com.highqsoft.odsx.gui.OdsxDT_BYTEEditor"));
        editorClasses.put("DT_LONG", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_LONG", (String)"com.highqsoft.odsx.gui.OdsxDT_LONGEditor"));
        editorClasses.put("DT_DOUBLE", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_DOUBLE", (String)"com.highqsoft.odsx.gui.OdsxDT_DOUBLEEditor"));
        editorClasses.put("DT_LONGLONG", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_LONGLONG", (String)"com.highqsoft.odsx.gui.OdsxDT_LONGLONGEditor"));
        editorClasses.put("DT_DATE", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_DATE", (String)"com.highqsoft.odsx.gui.OdsxDT_DATEEditor"));
        editorClasses.put("DT_BYTESTR", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_BYTESTR", (String)"com.highqsoft.odsx.gui.OdsxDT_BYTESTREditor"));
        editorClasses.put("DT_BLOB", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_BLOB", (String)"com.highqsoft.odsx.gui.OdsxDT_BLOBEditor"));
        editorClasses.put("DT_COMPLEX", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_COMPLEX", (String)"com.highqsoft.odsx.gui.OdsxDT_COMPLEXEditor"));
        editorClasses.put("DT_DCOMPLEX", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_DCOMPLEX", (String)"com.highqsoft.odsx.gui.OdsxDT_DCOMPLEXEditor"));
        editorClasses.put("DS_STRING", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_STRING", (String)"com.highqsoft.odsx.gui.OdsxDS_STRINGEditor"));
        editorClasses.put("DS_SHORT", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_SHORT", (String)"com.highqsoft.odsx.gui.OdsxDS_SHORTEditor"));
        editorClasses.put("DS_FLOAT", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_FLOAT", (String)"com.highqsoft.odsx.gui.OdsxDS_FLOATEditor"));
        editorClasses.put("DS_BOOLEAN", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_BOOLEAN", (String)"com.highqsoft.odsx.gui.OdsxDS_BOOLEANEditor"));
        editorClasses.put("DS_BYTE", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_BYTE", (String)"com.highqsoft.odsx.gui.OdsxDS_BYTEEditor"));
        editorClasses.put("DS_LONG", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_LONG", (String)"com.highqsoft.odsx.gui.OdsxDS_LONGEditor"));
        editorClasses.put("DS_DOUBLE", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_DOUBLE", (String)"com.highqsoft.odsx.gui.OdsxDS_DOUBLEEditor"));
        editorClasses.put("DS_LONGLONG", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_LONGLONG", (String)"com.highqsoft.odsx.gui.OdsxDS_LONGLONGEditor"));
        editorClasses.put("DS_COMPLEX", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_COMPLEX", (String)"com.highqsoft.odsx.gui.OdsxDS_COMPLEXEditor"));
        editorClasses.put("DS_DCOMPLEX", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_DCOMPLEX", (String)"com.highqsoft.odsx.gui.OdsxDS_DCOMPLEXEditor"));
        editorClasses.put("DS_DATE", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_DATE", (String)"com.highqsoft.odsx.gui.OdsxDS_DATEEditor"));
        editorClasses.put("DS_BYTESTR", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_BYTESTR", (String)"com.highqsoft.odsx.gui.OdsxEditor"));
        editorClasses.put("DT_EXTERNALREFERENCE", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DT_EXTERNALREFERENCE", (String)"com.highqsoft.odsx.gui.OdsxDT_EXTERNALREFERENCEEditor"));
        editorClasses.put("DS_EXTERNALREFERENCE", FwkPropertyBus.getProperty((String)"OdsxInstanceEditorPane.Class.DS_EXTERNALREFERENCE", (String)"com.highqsoft.odsx.gui.OdsxDS_EXTERNALREFERENCEEditor"));
    }

    protected class ActionKeyListener
    implements KeyListener {
        String name;

        public ActionKeyListener(String name) {
            this.name = name;
        }

        public void keyPressed(KeyEvent e) {
            if (!e.isActionKey()) {
                ((JCheckBox)OdsxInstanceEditorPane.this.validChecks.get(this.name)).setSelected(true);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }
    }

    public class ResetButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            Iterator it = OdsxInstanceEditorPane.this.widgets.keySet().iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                OdsxGUIInterface c = (OdsxGUIInterface)OdsxInstanceEditorPane.this.widgets.get(name);
                c.reset();
            }
            if (OdsxInstanceEditorPane.this.relEditors != null) {
                int size = OdsxInstanceEditorPane.this.relEditors.size();
                for (int i = 0; i < size; ++i) {
                    OdsxRelationEditorInterface editor = (OdsxRelationEditorInterface)OdsxInstanceEditorPane.this.relEditors.get(i);
                    editor.reset();
                }
            }
        }
    }

    public class OKButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            OdsxInstanceEditorPane.this.readInputs();
        }
    }
}

