/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.factory;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkDescription;
import com.highqsoft.fwk.FwkException;
import com.highqsoft.fwk.FwkFileFilter;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.FwkSortedArray;
import com.highqsoft.fwk.dialog.FwkAuthenticationDialogPane;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPane;
import com.highqsoft.fwk.dialog.FwkFileChooserDialogPaneValue;
import com.highqsoft.fwk.factory.FwkDialogFactory;
import com.highqsoft.interfaces.fwk.FwkDialogPaneInterface;
import com.highqsoft.interfaces.fwk.FwkDialogPaneValueInterface;
import com.highqsoft.interfaces.fwk.FwkFileFilterInterface;
import com.highqsoft.interfaces.odsx.OdsxChangeListenerInterface;
import com.highqsoft.interfaces.odsx.OdsxSessionInterface;
import com.highqsoft.ods.AoService;
import com.highqsoft.ods.AoServiceFactory;
import com.highqsoft.ods.corba.Tools;
import com.highqsoft.odsx.OdsxChangeEvent;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxRelChangeEvent;
import com.highqsoft.odsx.factory.UserAbortSelectionException;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.asam.ods.AoException;
import org.asam.ods.AoFactory;
import org.asam.ods.AoSession;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationStructure;
import org.asam.ods.InstanceElement;
import org.omg.CORBA.SystemException;

public class OdsxSessionFactory
extends FwkDescription {
    protected static final String PREFS_LASTATFFILE = "atfdir";
    protected static final String PREFS_LASTXMLATFFILE = "xmlatfdir";
    public static final String version = "$Revision: 1.29 $";
    HashMap plumMap = new HashMap();
    HashMap serviceMap = new HashMap();
    HashMap sessionMap = new HashMap();
    HashMap observerMap = new HashMap();
    EventListenerList listeners;
    HashMap listenerMap = new HashMap();
    HashMap dialogParentMap = new HashMap();
    protected static OdsxSessionFactory instance;
    static FwkFileChooserDialogPane atfFilePane;
    static FwkFileChooserDialogPane xatfFilePane;

    public String getVersion() {
        return version;
    }

    private OdsxSessionFactory() {
        this.listeners = new EventListenerList();
    }

    protected static OdsxSessionFactory getInstance() {
        if (instance == null) {
            instance = new OdsxSessionFactory();
        }
        return instance;
    }

    protected HashMap getAuthMap(AoFactory factory) {
        HashMap ret = null;
        Iterator it = this.sessionMap.keySet().iterator();
        while (ret == null && it.hasNext()) {
            Object key = it.next();
            if (key == null || !key.equals(factory)) continue;
            ret = (HashMap)this.sessionMap.get(key);
        }
        return ret;
    }

    public static void close(OdsxSessionInterface observer) throws AoException {
        OdsxSessionFactory.getInstance().closeImpl(observer);
    }

    protected void closeImpl(OdsxSessionInterface observer) throws AoException {
        AoSession aoSession = (AoSession)this.observerMap.remove(observer);
        if (aoSession != null) {
            boolean found = false;
            Object key = null;
            Iterator it = this.observerMap.keySet().iterator();
            while (!found && it.hasNext()) {
                found = this.observerMap.get(it.next()).equals(aoSession);
            }
            if (!found) {
                String observerIdent = OdsxSessionFactory.getObserverIdent(observer);
                this.dialogParentMap.remove(observerIdent);
                AoFactory factory = this.getFactoryImpl(observer);
                HashMap authMap = this.getAuthMap(factory);
                if (authMap != null && (aoSession = (AoSession)authMap.get(observer.getAuthentication())) != null) {
                    OdsxSessionFactory.fireOdsxChange(aoSession, OdsxChangeEvent.DBWillClose);
                    this.listenerMap.remove(aoSession);
                    it = this.listenerMap.keySet().iterator();
                    Object list = null;
                    while (it.hasNext() && list == null) {
                        key = it.next();
                        if (!aoSession.equals(key)) continue;
                        list = this.listenerMap.get(key);
                    }
                    if (key != null) {
                        this.listenerMap.remove(key);
                    }
                    authMap.remove(observer.getAuthentication());
                    aoSession.close();
                    if (authMap.size() == 0) {
                        HashMap optionMap;
                        found = false;
                        it = this.sessionMap.keySet().iterator();
                        key = null;
                        while (!found && it.hasNext()) {
                            key = it.next();
                            if (!factory.equals(key)) continue;
                            found = true;
                        }
                        if (found && key != null) {
                            this.sessionMap.remove(key);
                        }
                        if ((optionMap = (HashMap)this.serviceMap.get(observerIdent)) != null) {
                            optionMap.remove(observer.getSessionOptions());
                            if (optionMap.size() == 0) {
                                this.serviceMap.remove(observerIdent);
                            }
                        }
                    }
                }
            }
        }
    }

    public static AoService getService(OdsxSessionInterface observer) throws AoException {
        return OdsxSessionFactory.getInstance().getServiceImpl(observer);
    }

    protected AoService getServiceImpl(OdsxSessionInterface observer) throws AoException {
        AoService service;
        HashMap<String, AoService> optionMap = (HashMap<String, AoService>)this.plumMap.get(observer.getPlumName());
        if (optionMap == null) {
            optionMap = new HashMap<String, AoService>();
            this.plumMap.put(observer.getPlumName(), optionMap);
        }
        if ((service = (AoService)optionMap.get(observer.getServiceOptions())) == null && (service = AoServiceFactory.newService((String)observer.getPlumName(), (String)observer.getServiceOptions())) != null) {
            optionMap.put(observer.getServiceOptions(), service);
        }
        return service;
    }

    public static AoFactory getFactory(OdsxSessionInterface observer) throws AoException {
        return OdsxSessionFactory.getInstance().getFactoryImpl(observer);
    }

    protected AoFactory getFactoryImpl(OdsxSessionInterface observer) throws AoException {
        AoFactory aoFactory;
        HashMap<String, AoFactory> optionMap = (HashMap<String, AoFactory>)this.serviceMap.get(OdsxSessionFactory.getObserverIdent(observer));
        if (optionMap == null) {
            optionMap = new HashMap<String, AoFactory>();
            this.serviceMap.put(OdsxSessionFactory.getObserverIdent(observer), optionMap);
        }
        if ((aoFactory = (AoFactory)optionMap.get(observer.getSessionOptions())) == null) {
            try {
                AoService aoService = OdsxSessionFactory.getService(observer);
                aoFactory = aoService.newFactory(observer.getServiceName(), observer.getSessionOptions());
                aoFactory.getType();
                optionMap.put(observer.getSessionOptions(), aoFactory);
            }
            catch (FwkException fwke) {
                throw fwke;
            }
            catch (SystemException re) {
                StringBuffer param = new StringBuffer();
                param.append("\n************************************************************\n");
                param.append("This error may be throws by two known problems:\n");
                param.append("1.) ASAM ODS server _was_ already registered at the Name Service.\n");
                param.append("    But it seems that the Name Service is running and the server is down.\n");
                param.append("    Problem: The Name Service returns an invalid CORBA reference to the client.\n");
                param.append("    Solution: Reset the ORB and restart the ASAM ODS server.\n");
                param.append("2.) Avalon handles service names case blind. It registers the name \n");
                param.append("    of the service given at startup via the ServiceName parameter at the Name Service.\n");
                param.append("    It is an indicator for that kind of problem, if you are able to connect the service using the AsamCommander.\n");
                param.append("    Problem: The request of the client for a factory is case sensitive.\n");
                param.append("    Solution: Be sure that the ASAM ODS server register the same case sensitive name\n");
                param.append("              at the Name Service as the client is reuqested.\n");
                param.append("plum name:       \n    " + observer.getPlumName()).append("\n");
                param.append("service name:    \n    " + observer.getServiceName()).append("\n");
                param.append("service options: \n    " + observer.getServiceOptions()).append("\n");
                param.append("session options: \n    " + observer.getSessionOptions()).append("\n");
                param.append("authentication:  \n    " + observer.getAuthentication()).append("\n");
                param.append(Tools.describe((SystemException)re));
                param.append("**************************************************************\n");
                throw new FwkException(-1073741820, "$RCSfile: OdsxSessionFactory.java,v $", version, "AH 2005-07-20 13:34", param.toString(), (Object)OdsxSessionFactory.getInstance(), (Throwable)re);
            }
            catch (AoException aoe) {
                StringBuffer param = new StringBuffer("\n************************************************************\n");
                param.append("plum name:       \n    " + observer.getPlumName()).append("\n");
                param.append("service name:    \n    " + observer.getServiceName()).append("\n");
                param.append("service options: \n    " + observer.getServiceOptions()).append("\n");
                param.append("session options: \n    " + observer.getSessionOptions()).append("\n");
                param.append("authentication:  \n    " + observer.getAuthentication()).append("\n");
                param.append(OdsxHelper.aoExceptionToString(aoe));
                param.append("************************************************************").append("\n");
                new FwkException(-1073741820, "$RCSfile: OdsxSessionFactory.java,v $", version, "AH 2003-01-13 16:24", param.toString(), (Object)OdsxSessionFactory.getInstance(), (Throwable)aoe);
                OdsxSessionFactory.close(observer);
                aoe.printStackTrace();
                throw aoe;
            }
        }
        return aoFactory;
    }

    public static OdsxSessionInterface getSessionObserver(AoSession session) {
        return OdsxSessionFactory.getInstance().getSessionObserverImpl(session);
    }

    protected OdsxSessionInterface getSessionObserverImpl(AoSession session) {
        OdsxSessionInterface ret = null;
        if (session != null && this.observerMap != null && this.observerMap.size() > 0) {
            Iterator it = this.observerMap.keySet().iterator();
            Object key = null;
            while (ret == null && it.hasNext()) {
                key = it.next();
                if (key == null || !this.observerMap.get(key).equals(session)) continue;
                ret = key;
            }
        }
        return ret;
    }

    public static AoSession getCheckedSession(OdsxSessionInterface observer) throws AoException {
        return OdsxSessionFactory.getInstance().getCheckedSessionImpl(observer);
    }

    protected AoSession getCheckedSessionImpl(OdsxSessionInterface observer) throws AoException {
        AoFactory factory;
        AoSession aoSession = this.getSessionImpl(observer);
        if (aoSession != null && (factory = this.getFactoryImpl(observer)) != null) {
            try {
                aoSession.getType();
            }
            catch (Throwable t) {
                HashMap authMap = this.getAuthMap(factory);
                authMap.remove(observer.getAuthentication());
                aoSession = this.getSessionImpl(observer);
            }
        }
        return aoSession;
    }

    public static AoSession getSession(OdsxSessionInterface observer) throws AoException {
        return OdsxSessionFactory.getInstance().getSessionImpl(observer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AoSession getSessionImpl(OdsxSessionInterface observer) throws AoException {
        AoFactory factory;
        AoSession aoSession = (AoSession)this.observerMap.get(observer);
        if (aoSession == null && (factory = this.getFactoryImpl(observer)) != null) {
            String type;
            HashMap<String, AoSession> authMap = this.getAuthMap(factory);
            if (authMap == null) {
                authMap = new HashMap<String, AoSession>();
                this.sessionMap.put(factory, authMap);
            }
            if ((aoSession = (AoSession)authMap.get(observer.getAuthentication())) == null && this.askForPassword(authMap, observer, type = factory.getType()) && (aoSession = (AoSession)authMap.get(observer.getAuthentication())) == null) {
                if (type.toUpperCase().startsWith("ATF-") && !FwkContainer.isBatchMode()) {
                    String filename = this.getATFFilename(OdsxSessionFactory.getDialogParent(observer));
                    if (filename == null) throw new UserAbortSelectionException();
                    String option = "FILENAME=" + filename + ", " + observer.getAuthentication();
                    aoSession = factory.newSession(this.prepareOption(option));
                    if (aoSession != null) {
                        observer.setAuthentication(option);
                        File f = new File(filename);
                        observer.setSessionName(f.getName());
                        authMap.put(option, aoSession);
                    }
                } else if (type.toUpperCase().startsWith("XATF-") && !FwkContainer.isBatchMode()) {
                    String filename = this.getXATFFilename(OdsxSessionFactory.getDialogParent(observer));
                    if (filename == null) throw new UserAbortSelectionException();
                    String option = "FILENAME=" + filename + ", " + observer.getAuthentication();
                    aoSession = factory.newSession(this.prepareOption(option));
                    if (aoSession != null) {
                        observer.setAuthentication(option);
                        File f = new File(filename);
                        observer.setSessionName(f.getName());
                        authMap.put(option, aoSession);
                    }
                } else {
                    aoSession = factory.newSession(this.prepareOption(observer.getAuthentication()));
                    if (aoSession != null) {
                        authMap.put(observer.getAuthentication(), aoSession);
                    }
                }
                if (aoSession != null) {
                    this.observerMap.put(observer, aoSession);
                    OdsxSessionFactory.fireOdsxChange(aoSession, OdsxChangeEvent.DBWasOpened);
                }
            }
        }
        if (FwkContainer.getDebugLevel() <= 0) return aoSession;
        System.out.println("Authentication " + observer.getAuthentication());
        System.out.println("ServiceOptions " + observer.getServiceOptions());
        System.out.println("SessionOptions " + observer.getSessionOptions());
        return aoSession;
    }

    protected String prepareOption(String option) {
        StringBuffer ret = new StringBuffer();
        String[] arr = option.split("[,=]");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                if (i % 2 != 0) {
                    String value = arr[i].trim();
                    if (value.length() > 2 && value.charAt(0) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    ret.append("=").append(value);
                    continue;
                }
                ret.append(", ").append(arr[i].trim());
                continue;
            }
            ret.append(arr[i].trim());
        }
        return ret.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean askForPassword(HashMap authMap, OdsxSessionInterface observer, String serviceType) {
        Iterator it;
        String username = null;
        String password = null;
        boolean ret = false;
        boolean isATF = (serviceType = serviceType.toUpperCase()).matches(".*ATF.*");
        boolean askForPassword = !isATF && FwkPropertyBus.getProperty((String)"Odsx.NewSession.AskForPassword", (boolean)true) && !FwkContainer.isBatchMode();
        HashMap entries = new HashMap();
        FwkSortedArray arr = new FwkSortedArray();
        if (!askForPassword) return true;
        arr = OdsxSessionFactory.getOptionMap(observer.getAuthentication(), entries);
        askForPassword = entries.get("PASSWORD") == null || entries.get("USER") == null;
        if (askForPassword && (it = authMap.keySet().iterator()).hasNext()) {
            HashMap otherEntries = new HashMap();
            OdsxSessionFactory.getOptionMap((String)it.next(), otherEntries);
            if (otherEntries.get("PASSWORD") != null && otherEntries.get("USER") != null) {
                arr.add((Comparable)((Object)"PASSWORD"));
                entries.put("PASSWORD", otherEntries.get("PASSWORD"));
                arr.add((Comparable)((Object)"USER"));
                entries.put("USER", otherEntries.get("USER"));
                askForPassword = false;
                observer.setAuthentication(OdsxSessionFactory.normalizeOptionString(arr, entries));
                ret = true;
            }
        }
        if (!FwkContainer.isBatchMode() && askForPassword) {
            FwkAuthenticationDialogPane pane = new FwkAuthenticationDialogPane("Fwk", FwkPropertyBus.getProperty((String)"Odsx.NewSession.Username", (String)FwkContainer.getUserName()), FwkPropertyBus.getProperty((String)"Odsx.NewSession.Password", (String)""));
            FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog((Component)OdsxSessionFactory.getDialogParent(observer), (String)(FwkPropertyBus.getProperty((String)"Odsx.NewSession.AuthenticationDialog.Text.Title") + " " + observer.getServiceName()), (String)"FwkAuthenticationDialog.Icon", (FwkDialogPaneInterface)pane);
            if (val == null) return false;
            username = (String)val.getProperty("Username");
            password = (String)val.getProperty("Password");
        } else {
            password = (String)entries.get("PASSWORD");
            username = (String)entries.get("USER");
            if (username == null) {
                username = "";
            }
            if (password == null) {
                password = "";
            }
            ret = true;
        }
        entries.remove("USER");
        entries.remove("PASSWORD");
        if (username == null) {
            username = FwkPropertyBus.getProperty((String)"Odsx.NewSession.Username", (String)null);
        }
        if (password == null) {
            password = FwkPropertyBus.getProperty((String)"Odsx.NewSession.Password", (String)null);
        }
        if (username != null && password != null) {
            if (username != null && username.length() != 0) {
                entries.put("USER", username);
            }
            if (password != null && password.length() != 0) {
                entries.put("PASSWORD", password);
            }
        }
        it = entries.keySet().iterator();
        StringBuffer buf = new StringBuffer();
        int count = 0;
        while (it.hasNext()) {
            String value;
            String key = (String)it.next();
            if (count > 0) {
                buf.append(", ");
            }
            if ((value = (String)entries.get(key)).matches(".*\\s.*")) {
                value = "\"" + value + "\"";
            }
            buf.append(key).append("=").append(value);
            ++count;
        }
        observer.setAuthentication(OdsxSessionFactory.normalizeOptionString(buf.toString()));
        return true;
    }

    public static void addOdsxChangeListener(OdsxChangeListenerInterface listener) {
        OdsxSessionFactory.getInstance().addOdsxChangeListenerImpl(listener);
    }

    protected void addOdsxChangeListenerImpl(OdsxChangeListenerInterface listener) {
        if (listener != null) {
            this.listeners.add(OdsxChangeListenerInterface.class, listener);
        }
    }

    public static void addOdsxChangeListener(AoSession aoSession, OdsxChangeListenerInterface listener) {
        OdsxSessionFactory.getInstance().addOdsxChangeListenerImpl(aoSession, listener);
    }

    protected void addOdsxChangeListenerImpl(AoSession aoSession, OdsxChangeListenerInterface listener) {
        if (listener != null) {
            if (aoSession != null) {
                Iterator it = this.listenerMap.keySet().iterator();
                EventListenerList list = null;
                while (it.hasNext() && list == null) {
                    Object key = it.next();
                    if (!aoSession.equals(key)) continue;
                    list = (EventListenerList)this.listenerMap.get(key);
                }
                if (list == null) {
                    list = new EventListenerList();
                    this.listenerMap.put(aoSession, list);
                }
                list.add(OdsxChangeListenerInterface.class, listener);
            } else {
                this.listeners.add(OdsxChangeListenerInterface.class, listener);
            }
        }
    }

    public static void removeOdsxChangeListener(OdsxChangeListenerInterface listener) {
        OdsxSessionFactory.removeOdsxChangeListener(listener);
    }

    protected void removeOdsxChangeListenerImpl(OdsxChangeListenerInterface listener) {
        this.listeners.remove(OdsxChangeListenerInterface.class, listener);
    }

    public static void removeOdsxChangeListener(AoSession aoSession, OdsxChangeListenerInterface listener) {
        OdsxSessionFactory.getInstance().removeOdsxChangeListenerImpl(aoSession, listener);
    }

    protected void removeOdsxChangeListenerImpl(AoSession aoSession, OdsxChangeListenerInterface listener) {
        if (aoSession != null && listener != null) {
            Iterator it = this.listenerMap.keySet().iterator();
            EventListenerList list = null;
            Object key = null;
            while (it.hasNext() && list == null) {
                key = it.next();
                if (!aoSession.equals(key)) continue;
                list = (EventListenerList)this.listenerMap.get(key);
            }
            if (list != null) {
                if (list.getListenerCount(OdsxChangeListenerInterface.class) > 1) {
                    list.remove(OdsxChangeListenerInterface.class, listener);
                } else if (key != null) {
                    this.listenerMap.remove(key);
                }
            }
        }
    }

    public static void fireOdsxChange(AoSession aoSession, OdsxChangeEvent ev) {
        OdsxSessionFactory.getInstance().fireOdsxChangeImpl(aoSession, ev);
    }

    protected void fireOdsxChangeImpl(AoSession aoSession, OdsxChangeEvent ev) {
        int size;
        EventListener[] arr = this.listeners.getListeners(OdsxChangeListenerInterface.class);
        if (arr != null && arr.length != 0) {
            size = arr.length;
            for (int i = 0; i < size; ++i) {
                try {
                    ((OdsxChangeListenerInterface)arr[i]).odsChanged(ev);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        Iterator it = this.listenerMap.keySet().iterator();
        EventListenerList list = null;
        while (it.hasNext() && list == null) {
            Object key = it.next();
            if (!aoSession.equals(key)) continue;
            list = (EventListenerList)this.listenerMap.get(key);
        }
        if (list != null && (arr = list.getListeners(OdsxChangeListenerInterface.class)) != null && arr.length != 0) {
            size = arr.length;
            for (int i = 0; i < size; ++i) {
                try {
                    ((OdsxChangeListenerInterface)arr[i]).odsChanged(ev);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static void fireOdsxChange(AoSession aoSession, OdsxChangeEvent.OdsxDBEventModifier modifier) {
        OdsxSessionFactory.getInstance().fireOdsxChangeImpl(aoSession, new OdsxChangeEvent(aoSession, modifier));
    }

    public static void fireOdsxChange(InstanceElement instanceElement, OdsxChangeEvent.OdsxIEEventModifier modifier) {
        try {
            AoSession aoSession = instanceElement.getApplicationElement().getApplicationStructure().getSession();
            OdsxSessionFactory.fireOdsxChange(aoSession, new OdsxChangeEvent(instanceElement, modifier));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fireOdsxChange(ApplicationStructure applicationStructure, OdsxChangeEvent.OdsxASEventModifier modifier) {
        try {
            AoSession aoSession = applicationStructure.getSession();
            OdsxSessionFactory.fireOdsxChange(aoSession, new OdsxChangeEvent(applicationStructure, modifier));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fireOdsxChange(ApplicationElement applicationElement, OdsxChangeEvent.OdsxAEEventModifier modifier) {
        try {
            AoSession aoSession = applicationElement.getApplicationStructure().getSession();
            OdsxSessionFactory.fireOdsxChange(aoSession, new OdsxChangeEvent(applicationElement, modifier));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fireOdsxChange(InstanceElement instElem1, InstanceElement instElem2, OdsxChangeEvent.OdsxRelEventModifier modifier) {
        try {
            AoSession aoSession = instElem1.getApplicationElement().getApplicationStructure().getSession();
            OdsxSessionFactory.fireOdsxChange(aoSession, new OdsxRelChangeEvent(instElem1, instElem2, modifier));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static FwkSortedArray getOptionMap(String options, HashMap entries) {
        return OdsxSessionFactory.getOptionMap(options, entries, true);
    }

    public static FwkSortedArray getOptionMap(String options, HashMap entries, boolean upper) {
        FwkSortedArray ret = new FwkSortedArray();
        if (options.length() > 0) {
            String lastKey = null;
            String lastValue = null;
            String[] arr = options.split(",");
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                String value;
                String key;
                int idx = arr[i].indexOf(61);
                if (idx > 0) {
                    key = arr[i].substring(0, idx).trim();
                    if (upper) {
                        key = key.toUpperCase();
                    }
                    value = arr[i].substring(idx + 1);
                    entries.put(key, value);
                    ret.add((Comparable)((Object)key));
                    lastKey = key;
                    lastValue = value;
                    continue;
                }
                if (lastKey != null) {
                    key = lastKey;
                    value = lastValue + "," + arr[i];
                    entries.put(key, value);
                    lastKey = key;
                    lastValue = value;
                    continue;
                }
                throw new RuntimeException("Keywords must not contain any colon ','");
            }
        }
        return ret;
    }

    public static String normalizeOptionString(String options) {
        return OdsxSessionFactory.normalizeOptionString(options, true);
    }

    public static String normalizeOptionString(String options, boolean upper) {
        HashMap entries = new HashMap();
        FwkSortedArray arr = OdsxSessionFactory.getOptionMap(options, entries, upper);
        return OdsxSessionFactory.normalizeOptionString(arr, entries);
    }

    public static String normalizeOptionString(FwkSortedArray arr, HashMap entries) {
        int size = arr.size();
        String ret = "";
        for (int i = 0; i < size; ++i) {
            ret = i == 0 ? arr.get(i) + "=" + entries.get(arr.get(i)) : ret + ", " + arr.get(i) + "=" + entries.get(arr.get(i));
        }
        return ret;
    }

    protected String getATFFilename(Container root) {
        if (atfFilePane == null) {
            FwkFileFilter atfFileFilter = new FwkFileFilter();
            atfFileFilter.addExtension("atf");
            atfFileFilter.setDescription("ATF Files");
            FwkFileFilter allFileFilter = new FwkFileFilter();
            allFileFilter.setPattern(".*");
            allFileFilter.setDescription("All Files");
            FwkFileChooserDialogPaneValue atfFileDialogValue = new FwkFileChooserDialogPaneValue();
            atfFileDialogValue.setFileFilter((FwkFileFilterInterface)allFileFilter);
            atfFileDialogValue.setFileFilter((FwkFileFilterInterface)atfFileFilter);
            String path = null;
            try {
                Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
                path = prefs.get(PREFS_LASTATFFILE, null);
                if (path != null) {
                    atfFileDialogValue.setSelectedPath(path);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (path == null && (path = FwkPropertyBus.getProperty((String)"OdsxSessionFactory.ATF.Directory", (String)FwkContainer.getUserDirectory())) != null && path.length() != 0) {
                atfFileDialogValue.setCurrentDirectory(path);
            }
            atfFilePane = new FwkFileChooserDialogPane(null, (FwkDialogPaneValueInterface)atfFileDialogValue);
        }
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog((Component)root, (String)FwkPropertyBus.getProperty((String)"Odsx.Title.ATFFileOpenDialog"), (String)"", (FwkDialogPaneInterface)atfFilePane);
        String ret = null;
        if (val != null) {
            ret = (String)val.getProperty("SelectedPath");
            try {
                if (ret != null) {
                    Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
                    prefs.put(PREFS_LASTATFFILE, ret);
                }
            }
            catch (Throwable prefT) {
                // empty catch block
            }
        }
        return ret;
    }

    protected String getXATFFilename(Container root) {
        if (xatfFilePane == null) {
            FwkFileFilter atfFileFilter = new FwkFileFilter();
            atfFileFilter.addExtension("xml");
            atfFileFilter.addExtension("xatf");
            atfFileFilter.addExtension("atfx");
            atfFileFilter.setDescription("XML ATF Files");
            FwkFileFilter allFileFilter = new FwkFileFilter();
            allFileFilter.setPattern(".*");
            allFileFilter.setDescription("All Files");
            FwkFileChooserDialogPaneValue atfFileDialogValue = new FwkFileChooserDialogPaneValue();
            atfFileDialogValue.setFileFilter((FwkFileFilterInterface)allFileFilter);
            atfFileDialogValue.setFileFilter((FwkFileFilterInterface)atfFileFilter);
            String path = null;
            try {
                Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
                path = prefs.get(PREFS_LASTXMLATFFILE, null);
                if (path != null) {
                    atfFileDialogValue.setSelectedPath(path);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (path == null && (path = FwkPropertyBus.getProperty((String)"OdsxSessionFactory.XATF.Directory", (String)FwkContainer.getUserDirectory())) != null && path.length() != 0) {
                atfFileDialogValue.setCurrentDirectory(path);
            }
            xatfFilePane = new FwkFileChooserDialogPane(null, (FwkDialogPaneValueInterface)atfFileDialogValue);
        }
        FwkDialogPaneValueInterface val = FwkDialogFactory.showDialog((Component)root, (String)FwkPropertyBus.getProperty((String)"Odsx.Title.XATFFileOpenDialog"), (String)"", (FwkDialogPaneInterface)xatfFilePane);
        String ret = null;
        if (val != null) {
            ret = (String)val.getProperty("SelectedPath");
            try {
                if (ret != null) {
                    Preferences prefs = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
                    prefs.put(PREFS_LASTXMLATFFILE, ret);
                }
            }
            catch (Throwable prefT) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String getObserverIdent(OdsxSessionInterface observer) {
        String ret = observer != null ? observer.getPlumName() + "[" + observer.getServiceName() + "]" : "" + observer;
        return ret;
    }

    public static Container getDialogParent(AoSession session) {
        return OdsxSessionFactory.getInstance().getDialogParentImpl(session);
    }

    public Container getDialogParentImpl(AoSession session) {
        return this.getDialogParentImpl(this.getSessionObserverImpl(session));
    }

    public static Container getDialogParent(OdsxSessionInterface observer) {
        return OdsxSessionFactory.getInstance().getDialogParentImpl(observer);
    }

    public Container getDialogParentImpl(OdsxSessionInterface observer) {
        return (Container)this.dialogParentMap.get(OdsxSessionFactory.getObserverIdent(observer));
    }

    public static void setDialogParent(OdsxSessionInterface observer, Container dialogParent) {
        OdsxSessionFactory.getInstance().setDialogParentImpl(observer, dialogParent);
    }

    public Container setDialogParentImpl(OdsxSessionInterface observer, Container dialogParent) {
        return this.dialogParentMap.put(OdsxSessionFactory.getObserverIdent(observer), dialogParent);
    }

    public static void main(String[] args) {
        FwkContainer.initialize((String[])args);
        FwkContainer.openFrame((String)"com.highqsoft.asamcommander.AsamCommander");
    }

    static {
        atfFilePane = null;
        xatfFilePane = null;
    }
}

