/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.gui;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.fwk.FwkIconInterface;
import com.highqsoft.interfaces.odsx.OdsxGUIInterface;
import com.highqsoft.odsx.gui.OdsxSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.asam.ods.TS_Union;

public class OdsxDS_STRINGEditor
extends JPanel
implements OdsxGUIInterface {
    public static int WIDTH = FwkPropertyBus.getProperty((String)"OdsxStringEditor.Width", (int)30);
    public static int ROWS = FwkPropertyBus.getProperty((String)"OdsxStringEditor.List.Rows", (int)3);
    String[] initialText;
    JList list;

    public OdsxDS_STRINGEditor() {
        this(WIDTH, ROWS);
    }

    public OdsxDS_STRINGEditor(int width, int rows) {
        FwkContainer.addComponentProperties((Class)OdsxSelector.class);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 100.0;
        gbc.weighty = 100.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.list = new JList();
        this.initialText = new String[0];
        this.setText(this.initialText);
        if (rows < 1) {
            rows = ROWS;
        }
        this.setRows(rows);
        gbc.insets = new Insets(0, 0, 0, 5);
        gbc.fill = 1;
        gbc.gridheight = rows;
        this.add((Component)new JScrollPane(this.list), gbc);
        JButton edit = new JButton(FwkPropertyBus.getProperty((String)"Text.Edit"));
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.fill = 0;
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridheight = 1;
        gbc.gridy = 1;
        this.add((Component)edit, gbc);
        edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                Container parent = OdsxDS_STRINGEditor.this.getTopLevelAncestor();
                ListEditor editor = null;
                editor = parent instanceof Dialog ? new ListEditor((Dialog)parent, OdsxDS_STRINGEditor.this.getText()) : new ListEditor((Frame)parent, OdsxDS_STRINGEditor.this.getText());
                editor.setTitle(FwkPropertyBus.getProperty((String)"OdsxStringEditor.ListEditor.Title"));
                editor.setVisible(true);
                if (!editor.wasCancelled()) {
                    OdsxDS_STRINGEditor.this.list.setListData(editor.getTextArray());
                }
            }
        });
    }

    public void setRows(int rows) {
        int oldVal = this.list.getVisibleRowCount();
        if (rows < 0) {
            throw new IllegalArgumentException("rows less than one.");
        }
        if (rows != oldVal) {
            this.list.setVisibleRowCount(rows);
        }
    }

    public void setTS_Union(TS_Union value) throws Exception {
        this.initialText = value.stringSeq();
        if (this.initialText == null) {
            this.initialText = new String[0];
        }
        this.setText(this.initialText);
    }

    public void setText(String[] arr) {
        this.list.setListData(arr);
    }

    public String[] getText() {
        ListModel model = this.list.getModel();
        int size = model.getSize();
        String[] ret = new String[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = model.getElementAt(i).toString();
        }
        return ret;
    }

    public void reset() {
        this.setText(this.initialText);
    }

    public TS_Union getTS_Union() throws Exception {
        TS_Union ret = new TS_Union();
        ret.stringSeq(this.getText());
        return ret;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        OdsxDS_STRINGEditor gui = new OdsxDS_STRINGEditor();
        try {
            TS_Union val = gui.getTS_Union();
            val.stringSeq(new String[]{"Andreas Hofmann", "Limburger Stra\u00dfe 39a", "OstFriesland"});
            gui.setTS_Union(val);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        frame.getContentPane().add(gui);
        frame.pack();
        frame.setVisible(true);
    }

    public class EditorListModel
    extends AbstractListModel {
        String[] arr;

        public EditorListModel(String[] arr) {
            this.arr = arr;
        }

        public Object getElementAt(int index) {
            return this.arr[index];
        }

        public String[] getTextArray() {
            return this.arr;
        }

        public boolean up(int index) {
            boolean ret = false;
            if (index > 0 && index < this.arr.length) {
                ret = true;
                String tmp = this.arr[index];
                this.arr[index] = this.arr[index - 1];
                this.arr[index - 1] = tmp;
            }
            return ret;
        }

        public boolean down(int index) {
            boolean ret = false;
            if (index >= 0 && index < this.arr.length - 1) {
                ret = true;
                String tmp = this.arr[index];
                this.arr[index] = this.arr[index + 1];
                this.arr[index + 1] = tmp;
            }
            return ret;
        }

        public int getSize() {
            return this.arr.length;
        }

        public void add(String elem) {
            String[] tmp = new String[this.arr.length + 1];
            System.arraycopy(this.arr, 0, tmp, 0, this.arr.length);
            tmp[tmp.length - 1] = elem;
            this.arr = tmp;
            this.fireIntervalAdded(this, this.arr.length - 1, this.arr.length - 1);
        }

        public void remove(int index) {
            if (this.arr.length > 1) {
                String[] tmp = new String[this.arr.length - 1];
                if (index == 0) {
                    System.arraycopy(this.arr, 1, tmp, 0, tmp.length);
                } else if (index == this.arr.length - 1) {
                    System.arraycopy(this.arr, 0, tmp, 0, tmp.length);
                } else {
                    System.arraycopy(this.arr, 0, tmp, 0, index);
                    System.arraycopy(this.arr, index + 1, tmp, index, this.arr.length - index - 1);
                }
                this.arr = tmp;
                this.fireIntervalRemoved(this, index, index);
            } else {
                this.arr = new String[0];
            }
        }

        public void change(String elem, int index) {
            if (index >= 0 && index < this.arr.length) {
                this.arr[index] = elem;
                this.fireContentsChanged(this, index, index);
            }
        }
    }

    public class ListEditor
    extends JDialog {
        JTextField textField;
        EditorListModel model;
        JList list;
        boolean wasCancelled;

        public ListEditor(Frame parent, String[] val) {
            super(parent, true);
            this.wasCancelled = false;
            this.init(val);
        }

        public ListEditor(Dialog parent, String[] val) {
            super(parent, true);
            this.wasCancelled = false;
            this.init(val);
        }

        public String[] getTextArray() {
            return this.model.getTextArray();
        }

        public boolean wasCancelled() {
            return this.wasCancelled;
        }

        protected void init(String[] val) {
            this.model = new EditorListModel(val);
            this.list = new JList();
            this.list.setModel(this.model);
            this.list.setSelectionMode(0);
            this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    Object o = ListEditor.this.list.getSelectedValue();
                    if (o != null) {
                        ListEditor.this.textField.setText(o.toString());
                    } else {
                        ListEditor.this.textField.setText("");
                    }
                }
            });
            this.textField = new JTextField();
            JButton change = new JButton(FwkPropertyBus.getProperty((String)"Text.Change"));
            change.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    String text;
                    if (ListEditor.this.list.getSelectedIndex() >= 0 && (text = ListEditor.this.textField.getText()).length() > 0) {
                        ListEditor.this.model.change(text, ListEditor.this.list.getSelectedIndex());
                        ListEditor.this.list.setSelectedIndex(ListEditor.this.model.getSize());
                    }
                }
            });
            JButton add = new JButton(FwkPropertyBus.getProperty((String)"Text.New"));
            add.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    String text = ListEditor.this.textField.getText();
                    ListEditor.this.model.add(text);
                    ListEditor.this.list.setSelectedIndex(ListEditor.this.model.getSize() - 1);
                }
            });
            JButton remove = new JButton(FwkPropertyBus.getProperty((String)"Text.Remove"));
            remove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ListEditor.this.model.remove(ListEditor.this.list.getSelectedIndex());
                    ListEditor.this.list.setSelectedIndex(-1);
                }
            });
            FwkIconInterface icon = FwkIconFile.getIcon((String)"Up");
            JButton up = icon != null ? new JButton((Icon)icon) : new JButton(FwkPropertyBus.getProperty((String)"Text.Up"));
            up.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    if (ListEditor.this.model.up(ListEditor.this.list.getSelectedIndex())) {
                        ListEditor.this.list.setSelectedIndex(ListEditor.this.list.getSelectedIndex() - 1);
                    }
                }
            });
            icon = FwkIconFile.getIcon((String)"Down");
            JButton down = icon != null ? new JButton((Icon)icon) : new JButton(FwkPropertyBus.getProperty((String)"Text.Down"));
            down.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    if (ListEditor.this.model.down(ListEditor.this.list.getSelectedIndex())) {
                        ListEditor.this.list.setSelectedIndex(ListEditor.this.list.getSelectedIndex() + 1);
                    }
                }
            });
            JButton ok = new JButton(FwkPropertyBus.getProperty((String)"Text.Ok"));
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ListEditor.this.setVisible(false);
                }
            });
            JButton cancel = new JButton(FwkPropertyBus.getProperty((String)"Text.Cancel"));
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ListEditor.this.wasCancelled = true;
                    ListEditor.this.setVisible(false);
                }
            });
            JPanel panel = new JPanel(new BorderLayout());
            JPanel butPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.fill = 1;
            butPanel.add((Component)new JPanel(), gbc);
            ++gbc.gridy;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            butPanel.add((Component)up, gbc);
            ++gbc.gridy;
            butPanel.add((Component)down, gbc);
            ++gbc.gridy;
            butPanel.add((Component)remove, gbc);
            ++gbc.gridy;
            butPanel.add((Component)add, gbc);
            ++gbc.gridy;
            butPanel.add((Component)change, gbc);
            ++gbc.gridy;
            butPanel.add((Component)cancel, gbc);
            ++gbc.gridy;
            butPanel.add((Component)ok, gbc);
            ++gbc.gridy;
            panel.add("East", butPanel);
            JPanel listPanel = new JPanel(new GridBagLayout());
            gbc.fill = 1;
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.weightx = 100.0;
            gbc.weighty = 100.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridheight = 4;
            JScrollPane pane = new JScrollPane(this.list);
            pane.setPreferredSize(new Dimension(300, 100));
            listPanel.add((Component)pane, gbc);
            gbc.gridy += gbc.gridheight;
            gbc.gridheight = 1;
            gbc.weighty = 1.0;
            listPanel.add((Component)this.textField, gbc);
            panel.add("Center", listPanel);
            this.getContentPane().add(panel);
            this.pack();
            this.setLocationRelativeTo(OdsxDS_STRINGEditor.this);
        }
    }
}

