/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.gui;

import com.highqsoft.interfaces.odsx.OdsxGUIInterface;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.asam.ods.TS_Union;

public class OdsxDT_BYTEEditor
extends JTextField
implements OdsxGUIInterface {
    static final int DEC = 10;
    static final int OCT = 8;
    static final int BIN = 2;
    static final int HEX = 16;
    JPopupMenu popup;
    String initialText = "0";
    int inputType = 10;

    public OdsxDT_BYTEEditor() {
        this.setText(this.initialText);
        this.addMouseListener(new TypeMouseListener());
        this.popup = new JPopupMenu();
        ButtonGroup bg = new ButtonGroup();
        TypeActionListener listener = new TypeActionListener();
        JRadioButton binary = new JRadioButton("binary");
        binary.setActionCommand("2");
        binary.setSelected(this.inputType == 2);
        binary.addActionListener(listener);
        bg.add(binary);
        this.popup.add(binary);
        JRadioButton octal = new JRadioButton("octal");
        octal.setActionCommand("8");
        octal.setSelected(this.inputType == 8);
        octal.addActionListener(listener);
        bg.add(octal);
        this.popup.add(octal);
        JRadioButton decimal = new JRadioButton("decimal");
        decimal.setActionCommand("10");
        decimal.setSelected(this.inputType == 10);
        decimal.addActionListener(listener);
        bg.add(decimal);
        this.popup.add(decimal);
        JRadioButton hexadecimal = new JRadioButton("hex");
        hexadecimal.setActionCommand("16");
        hexadecimal.setSelected(this.inputType == 16);
        hexadecimal.addActionListener(listener);
        bg.add(hexadecimal);
        this.popup.add(hexadecimal);
    }

    public void setTS_Union(TS_Union value) throws Exception {
        this.initialText = Integer.toString(value.byteVal(), this.inputType);
        if (this.initialText == null) {
            this.initialText = "0";
        }
        this.setText(this.initialText);
    }

    public TS_Union getTS_Union() throws Exception {
        TS_Union ret = new TS_Union();
        ret.byteVal(this.getByteValue());
        return ret;
    }

    public void reset() {
        this.setText(this.initialText);
    }

    protected byte getByteValue() {
        String val = this.getText();
        val = val == null ? "" : val.trim();
        byte ret = 0;
        ret = (byte)Long.parseLong(val, this.inputType);
        return ret;
    }

    protected void setInputType(int radix) {
        byte val = this.getByteValue();
        this.inputType = radix;
        this.setText("" + Integer.toString(val, radix));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        OdsxDT_BYTEEditor gui = new OdsxDT_BYTEEditor();
        try {
            TS_Union val = gui.getTS_Union();
            val.byteVal((byte)100);
            gui.setTS_Union(val);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        frame.pack();
        frame.getContentPane().add(gui);
        frame.setVisible(true);
    }

    protected class TypeMouseListener
    extends MouseAdapter {
        protected TypeMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                OdsxDT_BYTEEditor.this.popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    protected class TypeActionListener
    implements ActionListener {
        protected TypeActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            OdsxDT_BYTEEditor.this.setInputType(Integer.parseInt(e.getActionCommand()));
        }
    }
}

