/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.gui;

import com.highqsoft.interfaces.odsx.OdsxGUIInterface;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.asam.ods.TS_Union;
import org.asam.ods.T_LONGLONG;

public class OdsxDT_LONGLONGEditor
extends JTextField
implements OdsxGUIInterface {
    static final int DEC = 10;
    static final int OCT = 8;
    static final int BIN = 2;
    static final int HEX = 16;
    JPopupMenu popup;
    String initialText = "0";
    int inputType = 10;

    public OdsxDT_LONGLONGEditor() {
        this.setText(this.initialText);
        this.addMouseListener(new TypeMouseListener());
        this.popup = new JPopupMenu();
        ButtonGroup bg = new ButtonGroup();
        TypeActionListener listener = new TypeActionListener();
        JRadioButton binary = new JRadioButton("binary");
        binary.setActionCommand("2");
        binary.setSelected(this.inputType == 2);
        binary.addActionListener(listener);
        bg.add(binary);
        this.popup.add(binary);
        JRadioButton octal = new JRadioButton("octal");
        octal.setActionCommand("8");
        octal.setSelected(this.inputType == 8);
        octal.addActionListener(listener);
        bg.add(octal);
        this.popup.add(octal);
        JRadioButton decimal = new JRadioButton("decimal");
        decimal.setActionCommand("10");
        decimal.setSelected(this.inputType == 10);
        decimal.addActionListener(listener);
        bg.add(decimal);
        this.popup.add(decimal);
        JRadioButton hexadecimal = new JRadioButton("hex");
        hexadecimal.setActionCommand("16");
        hexadecimal.setSelected(this.inputType == 16);
        hexadecimal.addActionListener(listener);
        bg.add(hexadecimal);
        this.popup.add(hexadecimal);
    }

    public void setTS_Union(TS_Union value) throws Exception {
        T_LONGLONG val = value.longlongVal();
        long llVal = val.low;
        if (val.high != 0) {
            llVal = val.high;
            llVal <<= 32;
            llVal += (long)val.low;
        }
        this.initialText = Long.toString(llVal, this.inputType);
        if (this.initialText == null) {
            this.initialText = "0";
        }
        this.setText(this.initialText);
    }

    public void reset() {
        this.setText(this.initialText);
    }

    public TS_Union getTS_Union() throws Exception {
        long val = this.getLongValue();
        T_LONGLONG llVal = new T_LONGLONG();
        llVal.low = (int)val;
        llVal.high = (int)(val >> 32);
        TS_Union ret = new TS_Union();
        ret.longlongVal(llVal);
        return ret;
    }

    protected long getLongValue() {
        String val = this.getText();
        val = val == null ? "" : val.trim();
        long ret = 0L;
        ret = Long.parseLong(val, this.inputType);
        return ret;
    }

    protected void setInputType(int radix) {
        long val = this.getLongValue();
        this.inputType = radix;
        this.setText("" + Long.toString(val, radix));
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        OdsxDT_LONGLONGEditor gui = new OdsxDT_LONGLONGEditor();
        try {
            TS_Union val = gui.getTS_Union();
            T_LONGLONG llval = new T_LONGLONG();
            llval.low = 10;
            llval.high = 20;
            val.longlongVal(llval);
            gui.setTS_Union(val);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        frame.pack();
        frame.getContentPane().add(gui);
        frame.setVisible(true);
    }

    protected class TypeMouseListener
    extends MouseAdapter {
        protected TypeMouseListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
                OdsxDT_LONGLONGEditor.this.popup.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }

    protected class TypeActionListener
    implements ActionListener {
        protected TypeActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            OdsxDT_LONGLONGEditor.this.setInputType(Integer.parseInt(e.getActionCommand()));
        }
    }
}

