/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.gui;

import com.highqsoft.interfaces.odsx.OdsxRelationEditorInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxSelectHelper;
import com.highqsoft.odsx.gui.OdsxRelationEditor;
import com.highqsoft.odsx.gui.OdsxSelector;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.asam.ods.AoException;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.InstanceElement;
import org.asam.ods.InstanceElementIterator;
import org.asam.ods.T_LONGLONG;

public class OdsxFatherRelationEditor
extends JPanel
implements OdsxRelationEditorInterface,
OdsxSelector {
    JComboBox box;
    JToggleButton checker;
    int parentIdx;
    boolean valueChanged = false;
    InstanceElement parent;
    ApplicationElement relAeObj;
    ApplicationElement aeObj;
    ApplicationRelation aeRel;
    InstanceElement ieObj;
    int relationHandle;
    JLabel iconLabel;

    public OdsxFatherRelationEditor(InstanceElement ieObj, ApplicationElement aeObj, ApplicationRelation aeRel, int relationHandle, JLabel iconLabel, ButtonGroup buttonGroup) throws AoException {
        super(new BorderLayout());
        this.ieObj = ieObj;
        this.aeObj = aeObj;
        this.aeRel = aeRel;
        this.relationHandle = relationHandle;
        this.iconLabel = iconLabel;
        this.valueChanged = false;
        if (buttonGroup != null) {
            this.checker = new JRadioButton();
            buttonGroup.add(this.checker);
        } else {
            this.checker = new JCheckBox();
        }
        this.checker.setSelected(true);
        this.checker.setEnabled(buttonGroup != null);
        this.checker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                OdsxFatherRelationEditor.this.valueChanged = true;
            }
        });
        this.box = new JComboBox();
        this.add("Center", this.box);
        T_LONGLONG aeId = aeObj.getId();
        this.relAeObj = aeRel.getElem1();
        T_LONGLONG parentId = this.relAeObj.getId();
        if (parentId.low == aeId.low && parentId.high == aeId.high) {
            this.relAeObj = aeRel.getElem2();
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JLabel blinker = new JLabel(OdsxRelationEditor.BALLS[1]);
                blinker.setPreferredSize(OdsxFatherRelationEditor.this.checker.getPreferredSize());
                OdsxFatherRelationEditor.this.add("West", blinker);
                JComboBox<OdsxSelectHelper.NameId> comboBox = null;
                try {
                    OdsxSelectHelper.NameId[] ieArr = OdsxSelectHelper.getInstanceIds(OdsxFatherRelationEditor.this.relAeObj, "*", true);
                    comboBox = new JComboBox<OdsxSelectHelper.NameId>(ieArr);
                    OdsxFatherRelationEditor.this.add("Center", OdsxFatherRelationEditor.this.box);
                    int size = ieArr.length;
                    OdsxFatherRelationEditor.this.parentIdx = -1;
                    if (OdsxFatherRelationEditor.this.ieObj != null) {
                        OdsxFatherRelationEditor.this.parent = OdsxHelper.getParent(OdsxFatherRelationEditor.this.ieObj);
                        if (OdsxFatherRelationEditor.this.parent != null) {
                            T_LONGLONG parentId = OdsxFatherRelationEditor.this.parent.getId();
                            for (int i = 0; i < size; ++i) {
                                if (parentId.low != ieArr[i].id.low || parentId.high != ieArr[i].id.high) continue;
                                OdsxFatherRelationEditor.this.parentIdx = i;
                            }
                        }
                    }
                }
                catch (AoException aoe) {
                    System.err.println(OdsxHelper.aoExceptionToString(aoe));
                    aoe.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (comboBox != null) {
                    OdsxFatherRelationEditor.this.remove(OdsxFatherRelationEditor.this.box);
                    OdsxFatherRelationEditor.this.box = comboBox;
                    OdsxFatherRelationEditor.this.add("Center", OdsxFatherRelationEditor.this.box);
                } else {
                    OdsxFatherRelationEditor.this.box.setEnabled(false);
                }
                if (OdsxFatherRelationEditor.this.parentIdx >= 0) {
                    OdsxFatherRelationEditor.this.box.setSelectedIndex(OdsxFatherRelationEditor.this.parentIdx);
                }
                OdsxFatherRelationEditor.this.remove(blinker);
                OdsxFatherRelationEditor.this.add("West", OdsxFatherRelationEditor.this.checker);
                OdsxFatherRelationEditor.this.revalidate();
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    public boolean hasChanges() {
        return this.valueChanged || this.parentIdx != this.box.getSelectedIndex();
    }

    public void reset() {
        if (this.hasChanges()) {
            this.box.setSelectedIndex(this.parentIdx);
        }
    }

    public T_LONGLONG[] getSelectedIds() {
        OdsxSelectHelper.NameId nameId;
        T_LONGLONG[] ret = new T_LONGLONG[]{};
        if (this.relationHandle == 0 && (nameId = (OdsxSelectHelper.NameId)this.box.getSelectedItem()) != null) {
            ret = new T_LONGLONG[]{nameId.id};
        }
        return ret;
    }

    public void applySettings() throws Exception {
        if (this.hasChanges()) {
            if (this.checker.isSelected()) {
                T_LONGLONG[] ids = this.getSelectedIds();
                if (ids.length > 0 && this.relationHandle == 0) {
                    try {
                        if (this.parent != null) {
                            this.ieObj.removeRelation(this.aeRel, this.parent);
                        }
                        InstanceElement newParent = this.relAeObj.getInstanceById(ids[0]);
                        this.ieObj.createRelation(this.aeRel, newParent);
                        this.parent = newParent;
                    }
                    catch (AoException aoe) {
                        throw new Exception(OdsxHelper.aoExceptionToString(aoe) + " [" + this.aeRel.getRelationName() + "]", aoe);
                    }
                }
            } else {
                InstanceElementIterator it = this.ieObj.getRelatedInstances(this.aeRel, "*");
                int count = it.getCount();
                if (count > 0) {
                    for (int i = 0; i < count; ++i) {
                        this.ieObj.removeRelation(this.aeRel, it.nextOne());
                    }
                }
            }
        }
    }

    public ApplicationElement getApplicationElement() {
        return this.aeObj;
    }

    public InstanceElement getInstanceElement() {
        return this.ieObj;
    }

    public ApplicationElement getRelatedApplicationElement() {
        return this.relAeObj;
    }

    public ApplicationRelation getRelation() {
        return this.aeRel;
    }

    public JLabel getTypeLabel() {
        return this.iconLabel;
    }
}

