/*
 * Decompiled with CFR 0.152.
 */
package com.highqsoft.odsx.gui;

import com.highqsoft.fwk.FwkContainer;
import com.highqsoft.fwk.FwkPropertyBus;
import com.highqsoft.fwk.images.FwkIconFile;
import com.highqsoft.interfaces.odsx.OdsxRelationEditorInterface;
import com.highqsoft.odsx.OdsxHelper;
import com.highqsoft.odsx.OdsxSelectHelper;
import com.highqsoft.odsx.gui.OdsxRelationEditor;
import com.highqsoft.odsx.gui.OdsxSelector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.asam.ods.AoException;
import org.asam.ods.AoSession;
import org.asam.ods.ApplElemAccess;
import org.asam.ods.ApplicationElement;
import org.asam.ods.ApplicationRelation;
import org.asam.ods.ElemId;
import org.asam.ods.InstanceElement;
import org.asam.ods.SetType;
import org.asam.ods.T_LONGLONG;

public class OdsxMultiRelationEditor
extends JPanel
implements OdsxRelationEditorInterface,
OdsxSelector {
    static Icon LEFT_ARROW = new ImageIcon(FwkIconFile.getIcon((String)"Left3DRed").getImage());
    static Icon RIGHT_ARROW = new ImageIcon(FwkIconFile.getIcon((String)"Right3DRed").getImage());
    static final int LIST_VIEW_COUNT = 5;
    JPanel iconPanel;
    CardLayout iconLayout;
    JList setElem;
    JList availElem;
    JPanel listPanel;
    JCheckBox checker;
    Thread thread;
    boolean ready;
    JButton leftArrow = new JButton(LEFT_ARROW);
    JButton rightArrow = new JButton(RIGHT_ARROW);
    OdsxSelectHelper.NameId[] availArr;
    OdsxSelectHelper.NameId[] orgSetArr;
    OdsxSelectHelper.NameId[] setArr;
    ApplicationElement relAeObj;
    ApplicationElement aeObj;
    ApplicationRelation aeRel;
    InstanceElement ieObj;
    int relationHandle;
    JLabel iconLabel;

    public OdsxMultiRelationEditor(InstanceElement ieObj, ApplicationElement aeObj, ApplicationRelation aeRel, int relationHandle, JLabel iconLabel) throws AoException {
        super(new BorderLayout());
        this.ieObj = ieObj;
        this.aeObj = aeObj;
        this.aeRel = aeRel;
        this.relationHandle = relationHandle;
        this.iconLabel = iconLabel;
        this.iconLayout = new CardLayout();
        this.iconPanel = new JPanel(this.iconLayout);
        this.ready = false;
        this.checker = new JCheckBox();
        this.checker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (OdsxMultiRelationEditor.this.ready) {
                    OdsxMultiRelationEditor.this.listPanel.setEnabled(OdsxMultiRelationEditor.this.checker.isSelected());
                } else {
                    OdsxMultiRelationEditor.this.listPanel.setEnabled(false);
                }
            }
        });
        JLabel blinker = new JLabel(OdsxRelationEditor.BALLS[1]);
        blinker.setPreferredSize(this.checker.getPreferredSize());
        JButton loadButton = new JButton(OdsxRelationEditor.LOAD);
        loadButton.setToolTipText(FwkPropertyBus.getProperty((String)"OdsxRelationEditor.Text.Load"));
        loadButton.setBorder(null);
        loadButton.setPreferredSize(this.checker.getPreferredSize());
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                OdsxMultiRelationEditor.this.iconLayout.show(OdsxMultiRelationEditor.this.iconPanel, "BLINKER");
                OdsxMultiRelationEditor.this.thread.start();
            }
        });
        this.iconPanel.add((Component)this.checker, "CHECKER");
        this.iconPanel.add((Component)blinker, "BLINKER");
        this.iconPanel.add((Component)loadButton, "LOAD");
        this.iconLayout.show(this.iconPanel, "LOAD");
        this.add("West", this.iconPanel);
        T_LONGLONG aeId = aeObj.getId();
        this.relAeObj = aeRel.getElem1();
        T_LONGLONG infoId = this.relAeObj.getId();
        if (infoId.low == aeId.low && infoId.high == aeId.high) {
            this.relAeObj = aeRel.getElem2();
        }
        this.listPanel = new ListPanel();
        this.add("Center", this.listPanel);
        this.reset();
    }

    public boolean hasChanges() {
        boolean ret;
        boolean bl = ret = this.setArr.length != this.orgSetArr.length && this.checker.isSelected();
        if (!ret) {
            for (int i = 0; !ret && i < this.orgSetArr.length; ++i) {
                ret = this.setArr[i].id.low != this.orgSetArr[i].id.low || this.setArr[i].id.high != this.orgSetArr[i].id.high;
            }
        }
        return ret;
    }

    public void reset() {
        this.thread = new Thread(new Reset());
        this.thread.setPriority(1);
        this.iconLayout.show(this.iconPanel, "BLINKER");
        this.thread.start();
    }

    public T_LONGLONG[] getSelectedIds() {
        T_LONGLONG[] ret = new T_LONGLONG[this.setArr.length];
        for (int i = 0; i < this.setArr.length; ++i) {
            ret[i] = this.setArr[i].id;
        }
        return ret;
    }

    public void applySettings() throws Exception {
        if (this.hasChanges()) {
            try {
                int i;
                T_LONGLONG[] ids;
                AoSession aoSession = this.aeObj.getApplicationStructure().getSession();
                ApplElemAccess aea = aoSession.getApplElemAccess();
                ElemId elem = new ElemId(this.aeObj.getId(), this.ieObj.getId());
                String relName = this.aeRel.getRelationName();
                int size = this.orgSetArr.length;
                if (size > 0) {
                    ids = new T_LONGLONG[size];
                    for (i = 0; i < size; ++i) {
                        ids[i] = this.orgSetArr[i].id;
                    }
                    aea.setRelInst(elem, relName, ids, SetType.REMOVE);
                }
                if ((size = this.setArr.length) > 0) {
                    ids = new T_LONGLONG[size];
                    for (i = 0; i < size; ++i) {
                        ids[i] = this.setArr[i].id;
                    }
                    aea.setRelInst(elem, relName, ids, SetType.APPEND);
                }
            }
            catch (AoException aoe) {
                FwkContainer.showErrorMessage((Container)this, (String)"Error.Occured", (String)OdsxHelper.aoExceptionToString(aoe), (Throwable)aoe);
            }
        }
    }

    public ApplicationElement getApplicationElement() {
        return this.aeObj;
    }

    public InstanceElement getInstanceElement() {
        return this.ieObj;
    }

    public ApplicationElement getRelatedApplicationElement() {
        return this.relAeObj;
    }

    public ApplicationRelation getRelation() {
        return this.aeRel;
    }

    public JLabel getTypeLabel() {
        return this.iconLabel;
    }

    protected class Reset
    implements Runnable {
        protected Reset() {
        }

        public void run() {
            try {
                OdsxMultiRelationEditor.this.availArr = OdsxSelectHelper.getInstanceIds(OdsxMultiRelationEditor.this.relAeObj, "*", true);
                T_LONGLONG iid = OdsxMultiRelationEditor.this.ieObj.getId();
                OdsxMultiRelationEditor.this.setArr = OdsxSelectHelper.getRelated(iid, OdsxMultiRelationEditor.this.aeObj, OdsxMultiRelationEditor.this.aeRel, "*", false);
                OdsxMultiRelationEditor.this.orgSetArr = new OdsxSelectHelper.NameId[OdsxMultiRelationEditor.this.setArr.length];
                int size = OdsxMultiRelationEditor.this.setArr.length;
                if (size > 0) {
                    for (int i = 0; i < size; ++i) {
                        OdsxMultiRelationEditor.this.orgSetArr[i] = new OdsxSelectHelper.NameId(OdsxMultiRelationEditor.this.setArr[i].name, OdsxMultiRelationEditor.this.setArr[i].version, OdsxMultiRelationEditor.this.setArr[i].id);
                        int idx = Arrays.binarySearch(OdsxMultiRelationEditor.this.availArr, OdsxMultiRelationEditor.this.setArr[i]);
                        if (idx < 0) continue;
                        OdsxMultiRelationEditor.this.availArr[idx].name = "";
                    }
                    Arrays.sort(OdsxMultiRelationEditor.this.availArr);
                    OdsxSelectHelper.NameId[] tmp = new OdsxSelectHelper.NameId[OdsxMultiRelationEditor.this.availArr.length - size];
                    System.arraycopy(OdsxMultiRelationEditor.this.availArr, size, tmp, 0, OdsxMultiRelationEditor.this.availArr.length - size);
                    OdsxMultiRelationEditor.this.availArr = tmp;
                }
                OdsxMultiRelationEditor.this.availElem.setListData(OdsxMultiRelationEditor.this.availArr);
                OdsxMultiRelationEditor.this.setElem.setListData(OdsxMultiRelationEditor.this.setArr);
            }
            catch (AoException aoe) {
                System.err.println(aoe.reason);
                aoe.printStackTrace();
                OdsxMultiRelationEditor.this.orgSetArr = new OdsxSelectHelper.NameId[0];
                OdsxMultiRelationEditor.this.setArr = new OdsxSelectHelper.NameId[0];
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            OdsxMultiRelationEditor.this.listPanel.setEnabled(true);
            OdsxMultiRelationEditor.this.checker.setSelected(true);
            OdsxMultiRelationEditor.this.iconLayout.show(OdsxMultiRelationEditor.this.iconPanel, "CHECKER");
            OdsxMultiRelationEditor.this.revalidate();
        }
    }

    protected class ListPanel
    extends JPanel {
        public ListPanel() {
            super(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(5, 5, 5, 5);
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            OdsxMultiRelationEditor.this.setElem = new JList();
            OdsxMultiRelationEditor.this.setElem.setVisibleRowCount(5);
            JScrollPane setScroller = new JScrollPane(OdsxMultiRelationEditor.this.setElem);
            OdsxMultiRelationEditor.this.availElem = new JList();
            OdsxMultiRelationEditor.this.availElem.setVisibleRowCount(5);
            JScrollPane availScroller = new JScrollPane(OdsxMultiRelationEditor.this.availElem);
            OdsxMultiRelationEditor.this.leftArrow = new JButton(LEFT_ARROW);
            OdsxMultiRelationEditor.this.leftArrow.setEnabled(false);
            OdsxMultiRelationEditor.this.rightArrow = new JButton(RIGHT_ARROW);
            OdsxMultiRelationEditor.this.rightArrow.setEnabled(false);
            gbc.gridheight = 4;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 50.0;
            gbc.weighty = 50.0;
            this.add((Component)setScroller, gbc);
            gbc.fill = 3;
            ++gbc.gridx;
            gbc.gridheight = 1;
            gbc.gridy = 0;
            gbc.weightx = 50.0;
            gbc.weighty = 50.0;
            this.add((Component)new JPanel(), gbc);
            ++gbc.gridy;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.add((Component)OdsxMultiRelationEditor.this.leftArrow, gbc);
            ++gbc.gridy;
            this.add((Component)OdsxMultiRelationEditor.this.rightArrow, gbc);
            ++gbc.gridy;
            gbc.weightx = 50.0;
            gbc.weighty = 50.0;
            this.add((Component)new JPanel(), gbc);
            gbc.fill = 1;
            gbc.gridheight = 4;
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.weightx = 50.0;
            gbc.weighty = 50.0;
            this.add((Component)availScroller, gbc);
            OdsxMultiRelationEditor.this.setElem.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.rightArrow.setEnabled(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setElem.getSelectedIndices().length > 0);
                }
            });
            OdsxMultiRelationEditor.this.availElem.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.leftArrow.setEnabled(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availElem.getSelectedIndices().length > 0);
                }
            });
            OdsxMultiRelationEditor.this.leftArrow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int[] index = ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availElem.getSelectedIndices();
                    OdsxSelectHelper.NameId[] clone = new OdsxSelectHelper.NameId[index.length];
                    for (int i = 0; i < index.length; ++i) {
                        clone[i] = new OdsxSelectHelper.NameId(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr[index[i]].name, ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr[index[i]].version, ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr[index[i]].id);
                        ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr[index[i]].name = "";
                    }
                    Arrays.sort(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr);
                    OdsxSelectHelper.NameId[] tmp = new OdsxSelectHelper.NameId[((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr.length - index.length];
                    System.arraycopy(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr, index.length, tmp, 0, tmp.length);
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr = tmp;
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availElem.setListData(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr);
                    tmp = new OdsxSelectHelper.NameId[((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr.length + clone.length];
                    System.arraycopy(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr, 0, tmp, 0, ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr.length);
                    System.arraycopy(clone, 0, tmp, ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr.length, clone.length);
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr = tmp;
                    Arrays.sort(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr);
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setElem.setListData(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr);
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availElem.updateUI();
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setElem.updateUI();
                }
            });
            OdsxMultiRelationEditor.this.rightArrow.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    int[] index = ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setElem.getSelectedIndices();
                    OdsxSelectHelper.NameId[] clone = new OdsxSelectHelper.NameId[index.length];
                    for (int i = 0; i < index.length; ++i) {
                        clone[i] = new OdsxSelectHelper.NameId(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr[index[i]].name, ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr[index[i]].version, ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr[index[i]].id);
                        ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr[index[i]].name = "";
                    }
                    Arrays.sort(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr);
                    OdsxSelectHelper.NameId[] tmp = new OdsxSelectHelper.NameId[((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr.length - index.length];
                    System.arraycopy(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr, index.length, tmp, 0, tmp.length);
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr = tmp;
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setElem.setListData(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setArr);
                    tmp = new OdsxSelectHelper.NameId[((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr.length + clone.length];
                    System.arraycopy(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr, 0, tmp, 0, ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr.length);
                    System.arraycopy(clone, 0, tmp, ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr.length, clone.length);
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr = tmp;
                    Arrays.sort(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr);
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availElem.setListData(((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availArr);
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.availElem.updateUI();
                    ((ListPanel)ListPanel.this).OdsxMultiRelationEditor.this.setElem.updateUI();
                }
            });
        }
    }
}

